/*
 * $Id: Two_Level_Branch_Predictor_allocation.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/include/Two_Level_Branch_Predictor.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace two_level_branch_predictor {

#undef  FUNCTION
#define FUNCTION "Two_Level_Branch_Predictor::allocation"
  void Two_Level_Branch_Predictor::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Two_Level_Branch_Predictor,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Two_Level_Branch_Predictor"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("predict",IN,WEST,_("Predict direction interface"),_param->_nb_inst_predict);

      ALLOC1_VALACK_IN ( in_PREDICT_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_PREDICT_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_PREDICT_ADDRESS      ,"ADDRESS"      ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_OUT(out_PREDICT_DIRECTION    ,"DIRECTION"    ,Tcontrol_t,1                    );
      ALLOC1_SIGNAL_OUT(out_PREDICT_HISTORY      ,"HISTORY"      ,Thistory_t,_param->_size_history);
      if (_param->_update_on_prediction)
        {
      ALLOC1_SIGNAL_IN ( in_PREDICT_DIRECTION_VAL,"DIRECTION_VAL",Tcontrol_t,1                    );
      ALLOC1_SIGNAL_IN ( in_PREDICT_DIRECTION    ,"DIRECTION"    ,Tcontrol_t,1                    );
        }
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("update",IN,WEST,_("Update direction interface"),_param->_nb_inst_update);

      ALLOC1_VALACK_IN ( in_UPDATE_VAL           ,VAL);
      ALLOC1_VALACK_OUT(out_UPDATE_ACK           ,ACK);
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS       ,"ADDRESS"      ,Taddress_t,_param->_size_address);
      ALLOC1_SIGNAL_IN ( in_UPDATE_HISTORY       ,"HISTORY"      ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_IN ( in_UPDATE_DIRECTION     ,"DIRECTION"    ,Tcontrol_t,1                    );
      if (_param->_update_on_prediction)
      ALLOC1_SIGNAL_IN ( in_UPDATE_MISS          ,"MISS"         ,Tcontrol_t,1                    );
    }

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
        if (_param->_have_bht)
          {
        ALLOC1(reg_BHT                       ,Thistory_t,_param->_bht_nb_shifter);

        for (uint32_t i=0; i<_param->_bht_nb_shifter; ++i)
          reg_BHT [i] = 0;
          }

        if (_param->_have_pht)
          {
        ALLOC2(reg_PHT                       ,Thistory_t,_param->_pht_nb_bank,_param->_pht_size_bank);

        for (uint32_t i=0; i<_param->_pht_nb_bank; ++i)
          for (uint32_t j=0; j<_param->_pht_size_bank; ++j)
            reg_PHT [i][j] = 0;
          }


        ALLOC1(internal_PREDICT_ACK          ,Tcontrol_t,_param->_nb_inst_predict);
        if (_param->_update_on_prediction)
          {
        if (_param->_have_bht)
        ALLOC1(internal_PREDICT_BHT_NUM_REG  ,Thistory_t,_param->_nb_inst_predict);
        if (_param->_have_pht)
          {
        ALLOC1(internal_PREDICT_PHT_NUM_BANK ,Thistory_t,_param->_nb_inst_predict);
        ALLOC1(internal_PREDICT_PHT_NUM_REG  ,Thistory_t,_param->_nb_inst_predict);
          }
          }
        ALLOC1(internal_UPDATE_ACK           ,Tcontrol_t,_param->_nb_inst_update );
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Two_Level_Branch_Predictor,FUNCTION);
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
