/*
 * $Id: Front_end_allocation.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/include/Front_end.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {



#undef  FUNCTION
#define FUNCTION "Front_end::allocation"
  void Front_end::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_begin(Front_end,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Front_end"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("icache_req",OUT, WEST, _("Instruction cache request."),_param->_nb_context);

      ALLOC1_VALACK_OUT (out_ICACHE_REQ_VAL                   ,VAL);
      ALLOC1_VALACK_IN  ( in_ICACHE_REQ_ACK                   ,ACK);
//    ALLOC1_SIGNAL_OUT (out_ICACHE_REQ_THREAD_ID             ,"thread_id"        ,Tcontext_t           ,_param->_size_context_id           );
      ALLOC1_SIGNAL_OUT (out_ICACHE_REQ_PACKET_ID             ,"packet_id"        ,Tpacket_t            ,_param->_size_ifetch_queue_ptr     );
      ALLOC1_SIGNAL_OUT (out_ICACHE_REQ_ADDRESS               ,"address"          ,Ticache_instruction_t,_param->_size_instruction_address              );
      ALLOC1_SIGNAL_OUT (out_ICACHE_REQ_TYPE                  ,"type"             ,Ticache_type_t       ,_param->_size_icache_type          );
    }

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("icache_rsp",IN , WEST, _("Instruction cache respons."),_param->_nb_context);

      ALLOC1_VALACK_IN  ( in_ICACHE_RSP_VAL                   ,VAL);
      ALLOC1_VALACK_OUT (out_ICACHE_RSP_ACK                   ,ACK);
//    ALLOC1_SIGNAL_IN  ( in_ICACHE_RSP_THREAD_ID             ,"thread_id"        ,Tcontext_t           ,_param->_size_context_id           );
      ALLOC1_SIGNAL_IN  ( in_ICACHE_RSP_PACKET_ID             ,"packet_id"        ,Tpacket_t            ,_param->_size_ifetch_queue_ptr     );
      ALLOC1_SIGNAL_IN  ( in_ICACHE_RSP_ERROR                 ,"error"            ,Ticache_error_t      ,_param->_size_icache_error         );
    }
    {
      ALLOC2_INTERFACE("icache_rsp",IN , WEST, "Instruction cache respons.",_param->_nb_context,_param->_nb_inst_fetch[it1]);

      _ALLOC2_SIGNAL_IN ( in_ICACHE_RSP_INSTRUCTION           ,"instruction"      ,Ticache_instruction_t,_param->_size_instruction ,_param->_nb_context,_param->_nb_inst_fetch[it1]);
    }


    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("decod",OUT,EAST,_("Decoded instruction, send to ooo_engine"),_param->_sum_inst_decod);

      ALLOC1_VALACK_OUT (out_DECOD_VAL                        , VAL);
      ALLOC1_VALACK_IN  ( in_DECOD_ACK                        , ACK);
      ALLOC1_SIGNAL_OUT (out_DECOD_CONTEXT_ID                 ,"CONTEXT_ID"       ,Tcontext_t           ,_param->_size_context_id            );
      ALLOC1_SIGNAL_OUT (out_DECOD_DEPTH                      ,"DEPTH"            ,Tdepth_t             ,_param->_size_depth                 );
      ALLOC1_SIGNAL_OUT (out_DECOD_TYPE                       ,"TYPE"             ,Ttype_t              ,_param->_size_type                  );
      ALLOC1_SIGNAL_OUT (out_DECOD_OPERATION                  ,"OPERATION"        ,Toperation_t         ,_param->_size_operation             );
      ALLOC1_SIGNAL_OUT (out_DECOD_NO_EXECUTE                 ,"NO_EXECUTE"       ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_IS_DELAY_SLOT              ,"IS_DELAY_SLOT"    ,Tcontrol_t           ,1                                   );
#ifdef DEBUG
      ALLOC1_SIGNAL_OUT (out_DECOD_ADDRESS                    ,"ADDRESS"          ,Tgeneral_data_t      ,_param->_size_instruction_address   );
#endif
      ALLOC1_SIGNAL_OUT (out_DECOD_ADDRESS_NEXT               ,"ADDRESS_NEXT"     ,Tgeneral_data_t      ,_param->_size_instruction_address   );
      ALLOC1_SIGNAL_OUT (out_DECOD_HAS_IMMEDIAT               ,"HAS_IMMEDIAT"     ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_IMMEDIAT                   ,"IMMEDIAT"         ,Tgeneral_data_t      ,_param->_size_general_data          );
      ALLOC1_SIGNAL_OUT (out_DECOD_READ_RA                    ,"READ_RA"          ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_NUM_REG_RA                 ,"NUM_REG_RA"       ,Tgeneral_address_t   ,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT (out_DECOD_READ_RB                    ,"READ_RB"          ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_NUM_REG_RB                 ,"NUM_REG_RB"       ,Tgeneral_address_t   ,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT (out_DECOD_READ_RC                    ,"READ_RC"          ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_NUM_REG_RC                 ,"NUM_REG_RC"       ,Tspecial_address_t   ,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT (out_DECOD_WRITE_RD                   ,"WRITE_RD"         ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_NUM_REG_RD                 ,"NUM_REG_RD"       ,Tgeneral_address_t   ,_param->_size_general_register_logic);
      ALLOC1_SIGNAL_OUT (out_DECOD_WRITE_RE                   ,"WRITE_RE"         ,Tcontrol_t           ,1                                   );
      ALLOC1_SIGNAL_OUT (out_DECOD_NUM_REG_RE                 ,"NUM_REG_RE"       ,Tspecial_address_t   ,_param->_size_special_register_logic);
      ALLOC1_SIGNAL_OUT (out_DECOD_EXCEPTION_USE              ,"EXCEPTION_USE"    ,Texception_t         ,_param->_size_exception_use         );
      ALLOC1_SIGNAL_OUT (out_DECOD_EXCEPTION                  ,"EXCEPTION"        ,Texception_t         ,_param->_size_exception             );
    }
    
    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("branch_complete",IN,EAST,_("Branch commit"),_param->_nb_inst_branch_complete);

      ALLOC1_VALACK_IN  ( in_BRANCH_COMPLETE_VAL              , VAL);
      ALLOC1_VALACK_OUT (out_BRANCH_COMPLETE_ACK              , ACK);
      ALLOC1_SIGNAL_IN  ( in_BRANCH_COMPLETE_CONTEXT_ID       ,"CONTEXT_ID"       ,Tcontext_t           ,_param->_size_context_id);
      ALLOC1_SIGNAL_IN  ( in_BRANCH_COMPLETE_DEPTH            ,"DEPTH"            ,Tdepth_t             ,_param->_size_depth     );
      ALLOC1_SIGNAL_IN  ( in_BRANCH_COMPLETE_ADDRESS          ,"ADDRESS"          ,Taddress_t           ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN  ( in_BRANCH_COMPLETE_NO_SEQUENCE      ,"NO_SEQUENCE"      ,Tcontrol_t           ,1                       );
      ALLOC1_SIGNAL_OUT (out_BRANCH_COMPLETE_MISS_PREDICTION  ,"MISS_PREDICTION"  ,Tcontrol_t           ,1                       );
    }

   // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC_INTERFACE("commit_event",IN,EAST,_("Out Of Order engine have an event"));

      ALLOC_VALACK_IN   ( in_COMMIT_EVENT_VAL                 , VAL);
      ALLOC_VALACK_OUT  (out_COMMIT_EVENT_ACK                 , ACK);
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_CONTEXT_ID          ,"CONTEXT_ID"       ,Tcontext_t           ,_param->_size_context_id);
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_DEPTH               ,"DEPTH"            ,Tdepth_t             ,_param->_size_depth     );
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_TYPE                ,"TYPE"             ,Tevent_type_t        ,_param->_size_event_type);
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_IS_DELAY_SLOT       ,"IS_DELAY_SLOT"    ,Tcontrol_t           ,1                       );
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_ADDRESS             ,"ADDRESS"          ,Taddress_t           ,_param->_size_instruction_address   );
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_ADDRESS_EPCR_VAL    ,"ADDRESS_EPCR_VAL" ,Tcontrol_t           ,1                       );
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_ADDRESS_EPCR        ,"ADDRESS_EPCR"     ,Taddress_t           ,_param->_size_instruction_address   );
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_ADDRESS_EEAR_VAL    ,"ADDRESS_EEAR_VAL" ,Tcontrol_t           ,1                       );
      ALLOC_SIGNAL_IN   ( in_COMMIT_EVENT_ADDRESS_EEAR        ,"ADDRESS_EEAR"     ,Tgeneral_data_t      ,_param->_size_general_data          );
    }

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("event",OUT,EAST,_("Event interface"),_param->_nb_context);

      ALLOC1_VALACK_OUT (out_EVENT_VAL                        , VAL);
      ALLOC1_VALACK_IN  ( in_EVENT_ACK                        , ACK);
      ALLOC1_SIGNAL_OUT (out_EVENT_ADDRESS                    ,"ADDRESS"          ,Taddress_t           ,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT (out_EVENT_ADDRESS_NEXT               ,"ADDRESS_NEXT"     ,Taddress_t           ,_param->_size_instruction_address); 
      ALLOC1_SIGNAL_OUT (out_EVENT_ADDRESS_NEXT_VAL           ,"ADDRESS_NEXT_VAL" ,Tcontrol_t           ,1                    );
      ALLOC1_SIGNAL_OUT (out_EVENT_IS_DS_TAKE                 ,"IS_DS_TAKE"       ,Tcontrol_t           ,1                    );
    }

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("spr_event",OUT,EAST,_("Event interface with the special registerFile"),_param->_nb_context);

      ALLOC1_VALACK_OUT (out_SPR_EVENT_VAL                    , VAL);
      ALLOC1_VALACK_IN  ( in_SPR_EVENT_ACK                    , ACK);
      ALLOC1_SIGNAL_OUT (out_SPR_EVENT_EPCR                   ,"EPCR"             ,Tspr_t               ,_param->_size_spr);
      ALLOC1_SIGNAL_OUT (out_SPR_EVENT_EEAR_WEN               ,"EEAR_WEN"         ,Tcontrol_t           ,1                );
      ALLOC1_SIGNAL_OUT (out_SPR_EVENT_EEAR                   ,"EEAR"             ,Tspr_t               ,_param->_size_spr);
      ALLOC1_SIGNAL_OUT (out_SPR_EVENT_SR_DSX                 ,"SR_DSX"           ,Tcontrol_t           ,1                );
      ALLOC1_SIGNAL_OUT (out_SPR_EVENT_SR_TO_ESR              ,"SR_TO_ESR"        ,Tcontrol_t           ,1                );
    }                                                                                   

    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("nb_inst",IN,EAST,_("Instruction number"),_param->_nb_context);

      ALLOC1_SIGNAL_IN  ( in_NB_INST_COMMIT_ALL               ,"COMMIT_ALL"       ,Tcounter_t           ,_param->_size_nb_inst_commit);
      ALLOC1_SIGNAL_IN  ( in_NB_INST_COMMIT_MEM               ,"COMMIT_MEM"       ,Tcounter_t           ,_param->_size_nb_inst_commit);
      ALLOC1_SIGNAL_OUT (out_NB_INST_DECOD_ALL                ,"DECOD_ALL"        ,Tcounter_t           ,_param->_size_nb_inst_decod );
    }

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("depth",OUT,EAST,_("Interface depth"),_param->_nb_context);

      ALLOC1_SIGNAL_OUT (out_DEPTH_MIN                        ,"MIN"              ,Tdepth_t             ,_param->_size_depth);
      ALLOC1_SIGNAL_OUT (out_DEPTH_MAX                        ,"MAX"              ,Tdepth_t             ,_param->_size_depth);
      ALLOC1_SIGNAL_OUT (out_DEPTH_FULL                       ,"FULL"             ,Tcontrol_t           ,1);
    }

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
    {
      ALLOC1_INTERFACE("spr",IN,EAST,_("Interface with the special registerFile"),_param->_nb_context);
      
      ALLOC1_SIGNAL_IN  ( in_SPR_SR_IEE                       ,"SR_IEE"           ,Tcontrol_t           ,1);
      ALLOC1_SIGNAL_IN  ( in_SPR_SR_EPH                       ,"SR_EPH"           ,Tcontrol_t           ,1);
    }

    // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("interrupt",IN,NORTH,_("Interrupt Exception"),_param->_nb_context);

      ALLOC1_SIGNAL_IN  ( in_INTERRUPT_ENABLE                 ,"ENABLE"           ,Tcontrol_t           ,1);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string name;

    _component_ifetch_unit = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::Ifetch_unit * [_param->_nb_context];
    
    for (uint32_t i=0; i<_param->_nb_context; ++i)
    {
      name = _name+"_ifetch_unit_"+toString(i);
      log_printf(TRACE,Front_end,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_ifetch_unit [i] = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::Ifetch_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_ifetch_unit [i]
	 ,_usage);
      
      _component->set_component (_component_ifetch_unit [i]->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_prediction_unit";
      log_printf(TRACE,Front_end,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_prediction_unit = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::Prediction_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_prediction_unit
	 ,_usage);
      
      _component->set_component (_component_prediction_unit->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    _component_decod_unit = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::Decod_unit * [_param->_nb_decod_unit];
    
    for (uint32_t i=0; i<_param->_nb_decod_unit; ++i)
    {
      name = _name+"_decod_unit_"+toString(i);
      log_printf(TRACE,Front_end,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_decod_unit [i] = new morpheo::behavioural::core::multi_front_end::front_end::decod_unit::Decod_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_decod_unit [i]
	 ,_usage);
      
      _component->set_component (_component_decod_unit [i]->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_context_state";
      log_printf(TRACE,Front_end,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_context_state = new morpheo::behavioural::core::multi_front_end::front_end::context_state::Context_State
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_context_state
	 ,_usage);
      
      _component->set_component (_component_context_state->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_glue";
      log_printf(TRACE,Front_end,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_glue = new morpheo::behavioural::core::multi_front_end::front_end::front_end_glue::Front_end_Glue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_glue
	 ,_usage);
      
      _component->set_component (_component_glue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;

    // ===================================================================
    // =====[ ifetch_unit ]===============================================
    // ===================================================================
    for (uint32_t i=0; i<_param->_nb_context; ++i)
    {
      src = _name+"_ifetch_unit_"+toString(i);
      log_printf(TRACE,Front_end,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"icache_req",
				   dest,"icache_req_"+toString(i));
#endif

        PORT_MAP(_component,src ,"out_ICACHE_REQ_VAL"      ,dest,"out_ICACHE_REQ_"+toString(i)+"_VAL"      );
        PORT_MAP(_component,src , "in_ICACHE_REQ_ACK"      ,dest, "in_ICACHE_REQ_"+toString(i)+"_ACK"      );
      //PORT_MAP(_component,src ,"out_ICACHE_REQ_THREAD_ID",dest,"out_ICACHE_REQ_"+toString(i)+"_THREAD_ID");
        if (_param->_have_port_ifetch_queue_ptr)
        PORT_MAP(_component,src ,"out_ICACHE_REQ_PACKET_ID",dest,"out_ICACHE_REQ_"+toString(i)+"_PACKET_ID");
        PORT_MAP(_component,src ,"out_ICACHE_REQ_ADDRESS"  ,dest,"out_ICACHE_REQ_"+toString(i)+"_ADDRESS"  );
        PORT_MAP(_component,src ,"out_ICACHE_REQ_TYPE"     ,dest,"out_ICACHE_REQ_"+toString(i)+"_TYPE"     );
      }

      // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"icache_rsp",
				   dest,"icache_rsp_"+toString(i));
#endif

        PORT_MAP(_component,src , "in_ICACHE_RSP_VAL"        ,dest, "in_ICACHE_RSP_"+toString(i)+"_VAL"        );
        PORT_MAP(_component,src ,"out_ICACHE_RSP_ACK"        ,dest,"out_ICACHE_RSP_"+toString(i)+"_ACK"        );
//      PORT_MAP(_component,src , "in_ICACHE_RSP_THREAD_ID"  ,dest, "in_ICACHE_RSP_"+toString(i)+"_THREAD_ID"  );
        if (_param->_have_port_ifetch_queue_ptr)
        PORT_MAP(_component,src , "in_ICACHE_RSP_PACKET_ID"  ,dest, "in_ICACHE_RSP_"+toString(i)+"_PACKET_ID"  );
        PORT_MAP(_component,src , "in_ICACHE_RSP_ERROR"      ,dest, "in_ICACHE_RSP_"+toString(i)+"_ERROR"      );

        for (uint32_t j=0; j<_param->_nb_inst_fetch [i]; ++j)
          {
#ifdef POSITION
            _component->interface_map (src ,"icache_rsp_"+toString(j),
                                       dest,"icache_rsp_"+toString(i)+"_"+toString(j));
#endif
            
            PORT_MAP(_component,src , "in_ICACHE_RSP_"+toString(j)+"_INSTRUCTION",dest, "in_ICACHE_RSP_"+toString(i)+"_"+toString(j)+"_INSTRUCTION");
          }
      }

      // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name+"_prediction_unit";
#ifdef POSITION
	_component->interface_map (src ,"predict"
				   dest,"predict_"+toString(i));
#endif
        
        COMPONENT_MAP(_component,src ,"out_PREDICT_VAL"                        ,dest, "in_PREDICT_"+toString(i)+"_VAL"                        );
        COMPONENT_MAP(_component,src , "in_PREDICT_ACK"                        ,dest,"out_PREDICT_"+toString(i)+"_ACK"                        );
        COMPONENT_MAP(_component,src ,"out_PREDICT_PC_PREVIOUS"                ,dest, "in_PREDICT_"+toString(i)+"_PC_PREVIOUS"                );
        COMPONENT_MAP(_component,src ,"out_PREDICT_PC_CURRENT"                 ,dest, "in_PREDICT_"+toString(i)+"_PC_CURRENT"                 );
        COMPONENT_MAP(_component,src ,"out_PREDICT_PC_CURRENT_IS_DS_TAKE"      ,dest, "in_PREDICT_"+toString(i)+"_PC_CURRENT_IS_DS_TAKE"      );
        COMPONENT_MAP(_component,src , "in_PREDICT_PC_NEXT"                    ,dest,"out_PREDICT_"+toString(i)+"_PC_NEXT"                    );
        COMPONENT_MAP(_component,src , "in_PREDICT_PC_NEXT_IS_DS_TAKE"         ,dest,"out_PREDICT_"+toString(i)+"_PC_NEXT_IS_DS_TAKE"         );
        if (_param->_have_port_inst_ifetch_ptr)
        COMPONENT_MAP(_component,src , "in_PREDICT_INST_IFETCH_PTR"            ,dest,"out_PREDICT_"+toString(i)+"_INST_IFETCH_PTR"            );
        COMPONENT_MAP(_component,src , "in_PREDICT_BRANCH_STATE"               ,dest,"out_PREDICT_"+toString(i)+"_BRANCH_STATE"               );
        if (_param->_have_port_depth)
        COMPONENT_MAP(_component,src , "in_PREDICT_BRANCH_UPDATE_PREDICTION_ID",dest,"out_PREDICT_"+toString(i)+"_BRANCH_UPDATE_PREDICTION_ID");
        
        for (uint32_t j=0; j<_param->_nb_inst_fetch[i]; ++j)
          {
#ifdef POSITION
            _component->interface_map (src ,"predict_"+toString(j)
                                       dest,"predict_"+toString(i)+"_"+toString(j));
#endif
            
            COMPONENT_MAP(_component,src , "in_PREDICT_"+toString(j)+                "_INSTRUCTION_ENABLE",
                                     dest,"out_PREDICT_"+toString(i)+"_"+toString(j)+"_INSTRUCTION_ENABLE");
          }
      }

      // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        uint32_t num_decod_unit = _param->_link_context_to_decod_unit[i];
        uint32_t num_context;

        for (num_context=0; num_context<_param->_decod_unit_nb_context[num_decod_unit]; num_context ++)
          if (_param->_translate_context_id_from_decod_unit [num_decod_unit][num_context] == i)
            break;

        dest = _name+"_decod_unit_"+toString(num_decod_unit);
#ifdef POSITION
	_component->interface_map (src ,"decod"
				   dest,"ifetch_"+toString(num_context));
#endif
        
        ////out_DECOD_CONTEXT_ID

        COMPONENT_MAP(_component,src ,"out_DECOD_ADDRESS"                    ,dest, "in_IFETCH_"+toString(num_context)+"_ADDRESS"                    );
        if (_param->_have_port_inst_ifetch_ptr)
        COMPONENT_MAP(_component,src ,"out_DECOD_INST_IFETCH_PTR"            ,dest, "in_IFETCH_"+toString(num_context)+"_INST_IFETCH_PTR"            );
        COMPONENT_MAP(_component,src ,"out_DECOD_BRANCH_STATE"               ,dest, "in_IFETCH_"+toString(num_context)+"_BRANCH_STATE"               );
        if (_param->_have_port_depth)
        COMPONENT_MAP(_component,src ,"out_DECOD_BRANCH_UPDATE_PREDICTION_ID",dest, "in_IFETCH_"+toString(num_context)+"_BRANCH_UPDATE_PREDICTION_ID");
        COMPONENT_MAP(_component,src ,"out_DECOD_EXCEPTION"                  ,dest, "in_IFETCH_"+toString(num_context)+"_EXCEPTION"                  );

        for (uint32_t j=0; j<_param->_nb_inst_fetch [i];++j)
          {
            dest = _name+"_decod_unit_"+toString(num_decod_unit);
#ifdef POSITION
            _component->interface_map (src ,"decod_"+toString(j)
                                       dest,"ifetch_"+toString(num_context)+"_"+toString(j));
#endif
        
            COMPONENT_MAP(_component,src ,"out_DECOD_" +toString(j)+                          "_VAL"        ,
                                     dest, "in_IFETCH_"+toString(num_context)+"_"+toString(j)+"_VAL"        );
            COMPONENT_MAP(_component,src , "in_DECOD_" +toString(j)+                          "_ACK"        ,
                                     dest,"out_IFETCH_"+toString(num_context)+"_"+toString(j)+"_ACK"        );
            COMPONENT_MAP(_component,src ,"out_DECOD_" +toString(j)+                          "_INSTRUCTION",
                                     dest, "in_IFETCH_"+toString(num_context)+"_"+toString(j)+"_INSTRUCTION");
          }
      }

      // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name+"_glue";
#ifdef POSITION
        _component->interface_map (src ,"event",
                                   dest,"event_"+toString(i));
#endif

        COMPONENT_MAP(_component,src , "in_EVENT_VAL"             ,
                                 dest,"out_EVENT_"+toString(i)+"_IFETCH_UNIT_VAL"             );
        COMPONENT_MAP(_component,src ,"out_EVENT_ACK"             ,
                                 dest, "in_EVENT_"+toString(i)+"_IFETCH_UNIT_ACK"             );
        COMPONENT_MAP(_component,src , "in_EVENT_ADDRESS"         ,
                                 dest,"out_EVENT_"+toString(i)+"_IFETCH_UNIT_ADDRESS"         );
        COMPONENT_MAP(_component,src , "in_EVENT_ADDRESS_NEXT"    ,
                                 dest,"out_EVENT_"+toString(i)+"_IFETCH_UNIT_ADDRESS_NEXT"    );
        COMPONENT_MAP(_component,src , "in_EVENT_ADDRESS_NEXT_VAL",
                                 dest,"out_EVENT_"+toString(i)+"_IFETCH_UNIT_ADDRESS_NEXT_VAL");
        COMPONENT_MAP(_component,src , "in_EVENT_IS_DS_TAKE"      ,
                                 dest,"out_EVENT_"+toString(i)+"_IFETCH_UNIT_IS_DS_TAKE"      );
      }
    }

    // ===================================================================
    // =====[ prediction_unit ]===========================================
    // ===================================================================
    {
      src = _name+"_prediction_unit";
      log_printf(TRACE,Front_end,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_PREDICT_VAL                         - component_ifetch_unit
      //  out_PREDICT_ACK                         - component_ifetch_unit
      //   in_PREDICT_PC_PREVIOUS                 - component_ifetch_unit
      //   in_PREDICT_PC_CURRENT                  - component_ifetch_unit
      //   in_PREDICT_PC_CURRENT_IS_DS_TAKE       - component_ifetch_unit
      //  out_PREDICT_PC_NEXT                     - component_ifetch_unit
      //  out_PREDICT_PC_NEXT_IS_DS_TAKE          - component_ifetch_unit
      //  out_PREDICT_INSTRUCTION_ENABLE          - component_ifetch_unit
      //  out_PREDICT_INST_IFETCH_PTR             - component_ifetch_unit
      //  out_PREDICT_BRANCH_STATE                - component_ifetch_unit
      //  out_PREDICT_BRANCH_UPDATE_PREDICTION_ID - component_ifetch_unit

      // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_DECOD_VAL                           - component_decod_unit
      //  out_DECOD_ACK                           - component_decod_unit
      //   in_DECOD_CONTEXT_ID                    - component_decod_unit
      //   in_DECOD_MATCH_INST_IFETCH_PTR         - component_decod_unit
      //   in_DECOD_BRANCH_STATE                  - component_decod_unit
      //   in_DECOD_BRANCH_UPDATE_PREDICTION_ID   - component_decod_unit
      //   in_DECOD_BRANCH_CONDITION              - component_decod_unit
      //   in_DECOD_BRANCH_DIRECTION              - component_decod_unit
      //   in_DECOD_ADDRESS_SRC                   - component_decod_unit
      //   in_DECOD_ADDRESS_DEST                  - component_decod_unit

      // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"branch_complete_"+toString(i),
                                     dest,"branch_complete_"+toString(i));
#endif

          COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+                "_VAL"            ,
                                   dest,"out_BRANCH_COMPLETE_"+toString(i)+"_PREDICTION_UNIT_VAL"            );
          COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+                "_ACK"            ,
                                   dest, "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTION_UNIT_ACK"            );
          COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+                "_MISS_PREDICTION",
                                   dest, "in_BRANCH_COMPLETE_"+toString(i)+"_PREDICTION_UNIT_MISS_PREDICTION");

          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"branch_complete_"+toString(i),
                                     dest,"branch_complete_"+toString(i));
#endif

          if (_param->_have_port_context_id)
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID",
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID");
          if (_param->_have_port_depth)
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"     ,
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"     );
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"   ,
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"   );
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_NO_SEQUENCE",
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_NO_SEQUENCE");

//           dest = _name+"_context_state";
// #ifdef POSITION
//           _component->interface_map (src ,"branch_complete_"+toString(i),
//                                      dest,"branch_complete_"+toString(i));
// #endif

//           COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_TAKE"        ,
//                                    dest, "in_BRANCH_COMPLETE_"+toString(i)+"_TAKE"        );
//           COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_SRC" ,
//                                    dest, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_SRC" );
//           COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_DEST",
//                                    dest, "in_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS_DEST");
        }

      // ~~~~~[ Interface : "branch_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name+"_context_state";
#ifdef POSITION
          _component->interface_map (src ,"branch_event_"+toString(i),
                                     dest,"branch_event_"+toString(i));
#endif

          COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_VAL"             ,
                                   dest, "in_BRANCH_EVENT_"+toString(i)+"_VAL"             );
          COMPONENT_MAP(_component,src , "in_BRANCH_EVENT_"+toString(i)+"_ACK"             ,
                                   dest,"out_BRANCH_EVENT_"+toString(i)+"_ACK"             );
//        COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_CONTEXT_ID"      ,
//                                 dest, "in_BRANCH_EVENT_"+toString(i)+"_CONTEXT_ID"      );
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_DEPTH"           ,
                                   dest, "in_BRANCH_EVENT_"+toString(i)+"_DEPTH"           );
//        COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_MISS_PREDICTION" ,
//                                 dest, "in_BRANCH_EVENT_"+toString(i)+"_MISS_PREDICTION" );
          COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_SRC"     ,
                                   dest, "in_BRANCH_EVENT_"+toString(i)+"_ADDRESS_SRC"     );
          COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST_VAL",
                                   dest, "in_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST_VAL");
          COMPONENT_MAP(_component,src ,"out_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST"    ,
                                   dest, "in_BRANCH_EVENT_"+toString(i)+"_ADDRESS_DEST"    );
        }

      // ~~~~~[ Interface : "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"event_"+toString(i),
                                     dest,"event_"+toString(i));
#endif
          COMPONENT_MAP(_component,src , "in_EVENT_"+toString(i)+                "_VAL"  ,
                                   dest,"out_EVENT_"+toString(i)+"_PREDICTION_UNIT_VAL"  );
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+                "_ACK"  ,
                                   dest, "in_EVENT_"+toString(i)+"_PREDICTION_UNIT_ACK"  );
          COMPONENT_MAP(_component,src , "in_EVENT_"+toString(i)+                "_TYPE" ,
                                   dest,"out_EVENT_"+toString(i)+"_PREDICTION_UNIT_TYPE" );
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src , "in_EVENT_"+toString(i)+                "_DEPTH",
                                   dest,"out_EVENT_"+toString(i)+"_PREDICTION_UNIT_DEPTH");
        }

      // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"depth_"+toString(i),
                                     dest,"depth_"+toString(i));
#endif

          COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+                "_VAL",
                                   dest, "in_DEPTH_"+toString(i)+"_PREDICTION_UNIT_VAL");
          if (_param->_have_port_depth)
            {
          COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+                "_CURRENT",
                                   dest, "in_DEPTH_"+toString(i)+"_PREDICTION_UNIT_CURRENT");
          COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+                "_MIN"    ,
                                   dest, "in_DEPTH_"+toString(i)+"_PREDICTION_UNIT_MIN"    );
          COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+                "_MAX"    ,
                                   dest, "in_DEPTH_"+toString(i)+"_PREDICTION_UNIT_MAX"    );
            }
          COMPONENT_MAP(_component,src ,"out_DEPTH_"+toString(i)+                "_FULL"   ,
                                   dest, "in_DEPTH_"+toString(i)+"_PREDICTION_UNIT_FULL"   );
        }
    }

    // ===================================================================
    // =====[ decod_unit ]================================================
    // ===================================================================
    {
      uint32_t x=0;
    for (uint32_t i=0; i<_param->_nb_decod_unit; ++i)
    {
      src = _name+"_decod_unit_"+toString(i);
      log_printf(TRACE,Front_end,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "ifetch" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_IFETCH_VAL                         - component_ifetch_unit
      //  out_IFETCH_ACK                         - component_ifetch_unit
      //   in_IFETCH_INSTRUCTION                 - component_ifetch_unit
      //   in_IFETCH_CONTEXT_ID                  - component_ifetch_unit
      //   in_IFETCH_ADDRESS                     - component_ifetch_unit
      //// in_IFETCH_ADDRESS_NEXT                - component_ifetch_unit
      //   in_IFETCH_INST_IFETCH_PTR             - component_ifetch_unit
      //   in_IFETCH_BRANCH_STATE                - component_ifetch_unit
      //   in_IFETCH_BRANCH_UPDATE_PREDICTION_ID - component_ifetch_unit
      //   in_IFETCH_EXCEPTION                   - component_ifetch_unit

      for (uint32_t j=0; j<_param->_decod_unit_nb_context[i]; ++j)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"ifetch_"+toString(j),
                                     dest,"ifetch_"+toString(i)+"_"+toString(j));
#endif
      
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src , "in_IFETCH_"+toString(j)                           +"_CONTEXT_ID",
                                   dest,"out_IFETCH_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_CONTEXT_ID");
        }

      // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t j=0; j<_param->_nb_inst_decod [i]; ++j)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"decod_"+toString(j),
                                     dest,"decod_"+toString(x));
#endif

          
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_VAL"          ,
                              dest,"out_DECOD_"+toString(x)+"_VAL"          );
          PORT_MAP(_component,src , "in_DECOD_"+toString(j)+"_ACK"          ,
                              dest, "in_DECOD_"+toString(x)+"_ACK"          );
          if (_param->_have_port_depth)
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_DEPTH"        ,
                              dest,"out_DECOD_"+toString(x)+"_DEPTH"        );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_TYPE"         ,
                              dest,"out_DECOD_"+toString(x)+"_TYPE"         );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_OPERATION"    ,
                              dest,"out_DECOD_"+toString(x)+"_OPERATION"    );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_NO_EXECUTE"   ,
                              dest,"out_DECOD_"+toString(x)+"_NO_EXECUTE"   );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_IS_DELAY_SLOT",
                              dest,"out_DECOD_"+toString(x)+"_IS_DELAY_SLOT");
#ifdef DEBUG
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_ADDRESS"      ,
                              dest,"out_DECOD_"+toString(x)+"_ADDRESS"      );
#endif
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_ADDRESS_NEXT" ,
                              dest,"out_DECOD_"+toString(x)+"_ADDRESS_NEXT" );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_HAS_IMMEDIAT" ,
                              dest,"out_DECOD_"+toString(x)+"_HAS_IMMEDIAT" );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_IMMEDIAT"     ,
                              dest,"out_DECOD_"+toString(x)+"_IMMEDIAT"     );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_READ_RA"      ,
                              dest,"out_DECOD_"+toString(x)+"_READ_RA"      );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_NUM_REG_RA"   ,
                              dest,"out_DECOD_"+toString(x)+"_NUM_REG_RA"   );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_READ_RB"      ,
                              dest,"out_DECOD_"+toString(x)+"_READ_RB"      );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_NUM_REG_RB"   ,
                              dest,"out_DECOD_"+toString(x)+"_NUM_REG_RB"   );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_READ_RC"      ,
                              dest,"out_DECOD_"+toString(x)+"_READ_RC"      );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_NUM_REG_RC"   ,
                              dest,"out_DECOD_"+toString(x)+"_NUM_REG_RC"   );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_WRITE_RD"     ,
                              dest,"out_DECOD_"+toString(x)+"_WRITE_RD"     );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_NUM_REG_RD"   ,
                              dest,"out_DECOD_"+toString(x)+"_NUM_REG_RD"   );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_WRITE_RE"     ,
                              dest,"out_DECOD_"+toString(x)+"_WRITE_RE"     );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_NUM_REG_RE"   ,
                              dest,"out_DECOD_"+toString(x)+"_NUM_REG_RE"   );
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_EXCEPTION_USE",
                              dest,"out_DECOD_"+toString(x)+"_EXCEPTION_USE");
          PORT_MAP(_component,src ,"out_DECOD_"+toString(j)+"_EXCEPTION"    ,
                              dest,"out_DECOD_"+toString(x)+"_EXCEPTION"    );

          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"decod_"+toString(j),
                                     dest,"decod_"+toString(i)+"_"+toString(j));
#endif

          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src ,"out_DECOD_"+toString(j)+                           "_CONTEXT_ID"   ,
                                   dest, "in_DECOD_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_CONTEXT_ID"   );

          x++;
        }
      
      // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t j=0; j<_param->_nb_inst_decod[i]; ++j)
        {
          dest = _name+"_prediction_unit";
#ifdef POSITION
          _component->interface_map (src ,"predict_"+toString(j),
                                     dest,"decod_"+toString(i)+"_"+toString(j));
#endif

          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_VAL"                        ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_VAL"                        );
          COMPONENT_MAP(_component,src , "in_PREDICT_"+toString(j)+                "_ACK"                        ,
                                   dest,"out_DECOD_"  +toString(i)+"_"+toString(j)+"_ACK"                        );
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_CONTEXT_ID"                 ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_CONTEXT_ID"                 );
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_MATCH_INST_IFETCH_PTR"      ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_MATCH_INST_IFETCH_PTR"      );
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_BRANCH_STATE"               ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_BRANCH_STATE"               );
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_BRANCH_UPDATE_PREDICTION_ID",
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_BRANCH_UPDATE_PREDICTION_ID");
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_BRANCH_CONDITION"           ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_BRANCH_CONDITION"           );
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_BRANCH_DIRECTION"           ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_BRANCH_DIRECTION"           );
//        COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_BRANCH_STACK_WRITE"         ,
//                                 dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_BRANCH_STACK_WRITE"         );
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_ADDRESS_SRC"                ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_ADDRESS_SRC"                );
          COMPONENT_MAP(_component,src ,"out_PREDICT_"+toString(j)+                "_ADDRESS_DEST"               ,
                                   dest, "in_DECOD_"  +toString(i)+"_"+toString(j)+"_ADDRESS_DEST"               );
          COMPONENT_MAP(_component,src , "in_PREDICT_"+toString(j)+                "_CAN_CONTINUE"               ,
                                   dest,"out_DECOD_"  +toString(i)+"_"+toString(j)+"_CAN_CONTINUE"               );

        }

      // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t j=0; j<_param->_decod_unit_nb_context[i]; ++j)
        {
 //           uint32_t y=(_param->_translate_context_id_from_decod_unit[i])[j];

          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"depth_"+toString(j),
                                     dest,"depth_"+toString(j));
#endif

          if (_param->_have_port_depth)
            {
          COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(j)+                           "_MIN",
                                   dest,"out_DEPTH_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_MIN");
          COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(j)+                           "_MAX",
                                   dest,"out_DEPTH_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_MAX");
            } 
          COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(j)+                           "_FULL",
                                   dest,"out_DEPTH_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_FULL");
         
        }

      // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t j=0; j<_param->_decod_unit_nb_context[i]; ++j)
        {
          uint32_t y=(_param->_translate_context_id_from_decod_unit[i])[j];

          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"nb_inst_"+toString(j),
                                     dest,"nb_inst_"+toString(y));
#endif

          COMPONENT_MAP(_component,src ,"out_NB_INST_"+toString(j)+           "_DECOD_ALL",
                                   dest, "in_NB_INST_"+toString(y)+"_DECOD_UNIT_DECOD_ALL");
        }

      // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t j=0; j<_param->_decod_unit_nb_context[i]; ++j)
        {
          uint32_t y=(_param->_translate_context_id_from_decod_unit[i])[j];
          
          dest = _name+"_context_state";
#ifdef POSITION
          _component->interface_map (src ,"context_"+toString(j),
                                     dest,"context_"+toString(y));
#endif

          COMPONENT_MAP(_component,src , "in_CONTEXT_"+toString(j)+"_DECOD_ENABLE",
                                   dest,"out_CONTEXT_"+toString(y)+"_DECOD_ENABLE");

          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"context_"+toString(j),
                                     dest,"context_"+toString(i)+"_"+toString(j));
#endif

          COMPONENT_MAP(_component,src , "in_CONTEXT_"+toString(j)+                           "_DEPTH_VAL",
                                   dest,"out_CONTEXT_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_DEPTH_VAL");
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src , "in_CONTEXT_"+toString(j)+                           "_DEPTH",
                                   dest,"out_CONTEXT_"+toString(i)+"_"+toString(j)+"_DECOD_UNIT_DEPTH");
        }

										     
      // ~~~~~[ Interface : "context_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name+"_context_state";
#ifdef POSITION
        _component->interface_map (src ,"context_event",
                                   dest,"decod_event_"+toString(i));
#endif
     
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_VAL"          ,dest, "in_DECOD_EVENT_"+toString(i)+"_VAL"          );
        COMPONENT_MAP(_component,src , "in_CONTEXT_EVENT_ACK"          ,dest,"out_DECOD_EVENT_"+toString(i)+"_ACK"          );
        if (_param->_have_port_context_id)
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_CONTEXT_ID"   ,dest, "in_DECOD_EVENT_"+toString(i)+"_CONTEXT_ID"   );
        if (_param->_have_port_depth)
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_DEPTH"        ,dest, "in_DECOD_EVENT_"+toString(i)+"_DEPTH"        );
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_TYPE"         ,dest, "in_DECOD_EVENT_"+toString(i)+"_TYPE"         );
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_IS_DELAY_SLOT",dest, "in_DECOD_EVENT_"+toString(i)+"_IS_DELAY_SLOT");
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_ADDRESS"      ,dest, "in_DECOD_EVENT_"+toString(i)+"_ADDRESS"      );
        COMPONENT_MAP(_component,src ,"out_CONTEXT_EVENT_ADDRESS_EPCR" ,dest, "in_DECOD_EVENT_"+toString(i)+"_ADDRESS_EPCR" );
      }
    }
    }

    // ===================================================================
    // =====[ context_state ]=============================================
    // ===================================================================
    {
      src = _name+"_context_state";
      log_printf(TRACE,Front_end,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

    // ~~~~~[ Interface : "decod_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_DECOD_EVENT_VAL                    - component_decod_unit
      //  out_DECOD_EVENT_ACK                    - component_decod_unit
      //   in_DECOD_EVENT_CONTEXT_ID             - component_decod_unit
      //   in_DECOD_EVENT_DEPTH                  - component_decod_unit
      //   in_DECOD_EVENT_TYPE                   - component_decod_unit
      //   in_DECOD_EVENT_IS_DELAY_SLOT          - component_decod_unit
      //   in_DECOD_EVENT_ADDRESS                - component_decod_unit
      //   in_DECOD_EVENT_ADDRESS_EPCR           - component_decod_unit

      // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"commit_event",
                                   dest,"commit_event");
#endif
        
        PORT_MAP(_component,src , "in_COMMIT_EVENT_VAL"             ,
                            dest, "in_COMMIT_EVENT_VAL"             );
        PORT_MAP(_component,src ,"out_COMMIT_EVENT_ACK"             ,
                            dest,"out_COMMIT_EVENT_ACK"             );
        if (_param->_have_port_context_id)
        PORT_MAP(_component,src , "in_COMMIT_EVENT_CONTEXT_ID"      ,
                            dest, "in_COMMIT_EVENT_CONTEXT_ID"      );
        if (_param->_have_port_depth)
        PORT_MAP(_component,src , "in_COMMIT_EVENT_DEPTH"           ,
                            dest, "in_COMMIT_EVENT_DEPTH"           );
        PORT_MAP(_component,src , "in_COMMIT_EVENT_TYPE"            ,
                            dest, "in_COMMIT_EVENT_TYPE"            );
        PORT_MAP(_component,src , "in_COMMIT_EVENT_IS_DELAY_SLOT"   ,
                            dest, "in_COMMIT_EVENT_IS_DELAY_SLOT"   );
        PORT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS"         ,
                            dest, "in_COMMIT_EVENT_ADDRESS"         );
        PORT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EPCR_VAL",
                            dest, "in_COMMIT_EVENT_ADDRESS_EPCR_VAL");
        PORT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EPCR"    ,
                            dest, "in_COMMIT_EVENT_ADDRESS_EPCR"    );
        PORT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EEAR_VAL",
                            dest, "in_COMMIT_EVENT_ADDRESS_EEAR_VAL");
        PORT_MAP(_component,src , "in_COMMIT_EVENT_ADDRESS_EEAR"    ,
                            dest, "in_COMMIT_EVENT_ADDRESS_EEAR"    );
      }

      // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"branch_complete_"+toString(i),
                                     dest,"branch_complete_"+toString(i));
#endif

          COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+              "_VAL"            ,
                                   dest,"out_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_STATE_VAL"            );
          COMPONENT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+              "_ACK"            ,
                                   dest, "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_STATE_ACK"            );
          COMPONENT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+              "_MISS_PREDICTION",
                                   dest,"out_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_STATE_MISS_PREDICTION");

          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"branch_complete_"+toString(i),
                                     dest,"branch_complete_"+toString(i));
#endif

          if (_param->_have_port_context_id)
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID",
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID");
          if (_param->_have_port_depth)
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"     ,
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"     );

          //   in_BRANCH_COMPLETE_TAKE               - component_prediction_unit
          //   in_BRANCH_COMPLETE_ADDRESS_SRC        - component_prediction_unit
          //   in_BRANCH_COMPLETE_ADDRESS_DEST       - component_prediction_unit
      }

      // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"nb_inst_"+toString(i),
                                     dest,"nb_inst_"+toString(i));
#endif
          
          PORT_MAP(_component,src , "in_NB_INST_"+toString(i)+"_COMMIT_ALL",
                              dest, "in_NB_INST_"+toString(i)+"_COMMIT_ALL");
          PORT_MAP(_component,src , "in_NB_INST_"+toString(i)+"_COMMIT_MEM",
                              dest, "in_NB_INST_"+toString(i)+"_COMMIT_MEM");

          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"nb_inst_"+toString(i),
                                     dest,"nb_inst_"+toString(i));
#endif
          
          COMPONENT_MAP(_component,src , "in_NB_INST_"+toString(i)+              "_DECOD_ALL",
                                   dest,"out_NB_INST_"+toString(i)+"_CONTEXT_STATE_DECOD_ALL");
      }

      // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"event_"+toString(i),
                                     dest,"event_"+toString(i));
#endif

          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_VAL"    ,
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_VAL"    );
          COMPONENT_MAP(_component,src , "in_EVENT_"+toString(i)+              "_ACK"    ,
                                   dest,"out_EVENT_"+toString(i)+"_CONTEXT_STATE_ACK"    );
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_ADDRESS",
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_ADDRESS");
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_ADDRESS_NEXT"    ,
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_ADDRESS_NEXT"    ); 
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_ADDRESS_NEXT_VAL",
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_ADDRESS_NEXT_VAL");
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_IS_DS_TAKE"      ,
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_IS_DS_TAKE"      );
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_TYPE"            ,
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_TYPE"            );
          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src ,"out_EVENT_"+toString(i)+              "_DEPTH"           ,
                                   dest, "in_EVENT_"+toString(i)+"_CONTEXT_STATE_DEPTH"           );
        }

      // ~~~~~[ Interface "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"spr_event_"+toString(i),
                                     dest,"spr_event_"+toString(i));
#endif

          PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_VAL"      ,
                              dest,"out_SPR_EVENT_"+toString(i)+"_VAL"      );
          PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_ACK"      ,
                              dest, "in_SPR_EVENT_"+toString(i)+"_ACK"      );
          PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_EPCR"     ,
                              dest,"out_SPR_EVENT_"+toString(i)+"_EPCR"     );
          PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_EEAR"     ,
                              dest,"out_SPR_EVENT_"+toString(i)+"_EEAR"     );
          PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_EEAR_WEN" ,
                              dest,"out_SPR_EVENT_"+toString(i)+"_EEAR_WEN" );
          PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_SR_DSX"   ,
                              dest,"out_SPR_EVENT_"+toString(i)+"_SR_DSX"   );
          PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_SR_TO_ESR",
                              dest,"out_SPR_EVENT_"+toString(i)+"_SR_TO_ESR");
        }

      // ~~~~~[ Interface : "context" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //  out_CONTEXT_DECOD_ENABLE               - component_decod_unit

      // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name+"_glue";
#ifdef POSITION
          _component->interface_map (src ,"depth_"+toString(i),
                                     dest,"depth_"+toString(i));
#endif

          if (_param->_have_port_depth)
          COMPONENT_MAP(_component,src , "in_DEPTH_"+toString(i)+              "_MIN",
                                   dest,"out_DEPTH_"+toString(i)+"_CONTEXT_STATE_MIN");
        }

      // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"spr_"+toString(i),
                                     dest,"spr_"+toString(i));
#endif
          
          PORT_MAP(_component,src , "in_SPR_"+toString(i)+"_SR_IEE",
                              dest, "in_SPR_"+toString(i)+"_SR_IEE");
          PORT_MAP(_component,src , "in_SPR_"+toString(i)+"_SR_EPH",
                              dest, "in_SPR_"+toString(i)+"_SR_EPH");
        }

      // ~~~~~[ Interface : "interrupt" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"interrupt_"+toString(i),
                                     dest,"interrupt_"+toString(i));
#endif
          
          PORT_MAP(_component,src , "in_INTERRUPT_"+toString(i)+"_ENABLE",
                              dest, "in_INTERRUPT_"+toString(i)+"_ENABLE");
        }

    }
    
    // ===================================================================
    // =====[ glue ]======================================================
    // ===================================================================
    {
      src = _name+"_glue";
      log_printf(TRACE,Front_end,FUNCTION,_("Instance : %s"),src.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }
      
      // ~~~~~[ Interface : "ifetch" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      // out_IFETCH_DECOD_UNIT_CONTEXT_ID                       - component_decod_unit
      
      // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      uint32_t x=0;
      for (uint32_t i=0; i<_param->_nb_decod_unit; ++i)
        for (uint32_t j=0; j<_param->_nb_inst_decod[i];++j)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"decod_"+toString(i)+"_"+toString(j),
                                       dest,"decod_"+toString(x));
#endif
            
            if (_param->_have_port_context_id)
            PORT_MAP(_component,src ,"out_DECOD_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID",
                                dest,"out_DECOD_"+toString(x)+                "_CONTEXT_ID");
            x++;
          }
      //  in_DECOD_DECOD_UNIT_CONTEXT_ID                        - component_decod_unit
    
      // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_branch_complete; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"branch_complete_"+toString(i),
                                     dest,"branch_complete_"+toString(i));
#endif

          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"            ,
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_VAL"            );
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"            ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_ACK"            );
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_MISS_PREDICTION",
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_MISS_PREDICTION");
        }
      
      //  out_BRANCH_COMPLETE_PREDICTION_UNIT_VAL               - component_prediction_unit
      //   in_BRANCH_COMPLETE_PREDICTION_UNIT_ACK               - component_prediction_unit
      //   in_BRANCH_COMPLETE_PREDICTION_UNIT_MISS_PREDICTION   - component_prediction_unit
      //  out_BRANCH_COMPLETE_CONTEXT_STATE_VAL                 - component_context_state
      //   in_BRANCH_COMPLETE_CONTEXT_STATE_ACK                 - component_context_state
      //  out_BRANCH_COMPLETE_CONTEXT_STATE_MISS_PREDICTION     - component_context_state

      // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"event_"+toString(i),
                                     dest,"event_"+toString(i));
#endif

          PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_VAL"             ,
                              dest,"out_EVENT_"+toString(i)+"_VAL"             );
          PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_ACK"             ,
                              dest, "in_EVENT_"+toString(i)+"_ACK"             );
          PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_ADDRESS"         ,
                              dest,"out_EVENT_"+toString(i)+"_ADDRESS"         );
          PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_ADDRESS_NEXT"    ,
                              dest,"out_EVENT_"+toString(i)+"_ADDRESS_NEXT"    );
          PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_ADDRESS_NEXT_VAL",
                              dest,"out_EVENT_"+toString(i)+"_ADDRESS_NEXT_VAL");
          PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_IS_DS_TAKE"      ,
                              dest,"out_EVENT_"+toString(i)+"_IS_DS_TAKE"      );
        }

      //  out_EVENT_IFETCH_UNIT_VAL                             - component_ifetch_unit
      //   in_EVENT_IFETCH_UNIT_ACK                             - component_ifetch_unit
      //  out_EVENT_IFETCH_UNIT_ADDRESS                         - component_ifetch_unit
      //  out_EVENT_IFETCH_UNIT_ADDRESS_NEXT                    - component_ifetch_unit
      //  out_EVENT_IFETCH_UNIT_ADDRESS_NEXT_VAL                - component_ifetch_unit
      //   in_EVENT_IFETCH_UNIT_IS_DS_TAKE                      - component_ifetch_unit
      //  out_EVENT_PREDICTION_UNIT_VAL                         - component_prediction_unit
      //   in_EVENT_PREDICTION_UNIT_ACK                         - component_prediction_unit
      //  out_EVENT_PREDICTION_UNIT_TYPE                        - component_prediction_unit
      //  out_EVENT_PREDICTION_UNIT_DEPTH                       - component_prediction_unit
      //   in_EVENT_CONTEXT_STATE_VAL                           - component_context_state
      //  out_EVENT_CONTEXT_STATE_ACK                           - component_context_state
      //   in_EVENT_CONTEXT_STATE_ADDRESS                       - component_context_state
      //   in_EVENT_CONTEXT_STATE_ADDRESS_NEXT                  - component_context_state
      //   in_EVENT_CONTEXT_STATE_ADDRESS_NEXT_VAL              - component_context_state
      //   in_EVENT_CONTEXT_STATE_IS_DS_TAKE                    - component_context_state
      //   in_EVENT_CONTEXT_STATE_TYPE                          - component_context_state
      //   in_EVENT_CONTEXT_STATE_DEPTH                         - component_context_state

      // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	      
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"depth_"+toString(i),
                                     dest,"depth_"+toString(i));
#endif

          if (_param->_have_port_depth)
            {
          PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_MIN",
                              dest,"out_DEPTH_"+toString(i)+"_MIN");
          PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_MAX",
                              dest,"out_DEPTH_"+toString(i)+"_MAX");
            }
          PORT_MAP(_component,src ,"out_DEPTH_"+toString(i)+"_FULL",
                              dest,"out_DEPTH_"+toString(i)+"_FULL");
        }
      
      //   in_DEPTH_PREDICTION_UNIT_VAL                         - component_prediction_unit
      //   in_DEPTH_PREDICTION_UNIT_CURRENT                     - component_prediction_unit
      //   in_DEPTH_PREDICTION_UNIT_MIN                         - component_prediction_unit
      //   in_DEPTH_PREDICTION_UNIT_MAX                         - component_prediction_unit
      //   in_DEPTH_PREDICTION_UNIT_FULL                        - component_prediction_unit
      //  out_DEPTH_DECOD_UNIT_MIN                              - component_decod_unit
      //  out_DEPTH_DECOD_UNIT_MAX                              - component_decod_unit
      //  out_DEPTH_DECOD_UNIT_FULL                             - component_decod_unit
      //  out_DEPTH_CONTEXT_STATE_MIN                           - component_context_state
      
      // ~~~~~[ Interface : "context"" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //  out_CONTEXT_DECOD_UNIT_DEPTH_VAL                      - component_decod_unit
      //  out_CONTEXT_DECOD_UNIT_DEPTH                          - component_decod_unit

      // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_context; ++i)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"nb_inst_"+toString(i),
                                     dest,"nb_inst_"+toString(i));
#endif
          
          PORT_MAP(_component,src ,"out_NB_INST_"+toString(i)+"_DECOD_ALL",
                              dest,"out_NB_INST_"+toString(i)+"_DECOD_ALL");

      //   in_NB_INST_DECOD_UNIT_DECOD_ALL                      - component_decod_unit
      //  out_NB_INST_CONTEXT_STATE_DECOD_ALL                   - component_context_state
        }
    }
    
    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_Front_end == true
    _component->test_map(false);
#endif

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

     log_end(Front_end,FUNCTION);
  };

}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
