#ifdef SYSTEMC
/*
 * $Id: Issue_queue_function_in_order_genMoore.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::function_in_order_genMoore"
  void Issue_queue::function_in_order_genMoore (void)
  {
    log_begin(Issue_queue,FUNCTION);
    log_function(Issue_queue,FUNCTION,_name.c_str());

    // ===================================================================
    // =====[ REEXECUTE_UNIT ]============================================
    // ===================================================================
    // Same implementation in in-order and out-of-order

    // ===================================================================
    // =====[ ISSUE_IN ]==================================================
    // ===================================================================
    {
      // init
      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
        for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
          internal_ISSUE_IN_ACK [i][j] = false;

      std::list<generic::priority::select_t> * select_in = _priority_in ->select(); // same select for all issue
      std::list<generic::priority::select_t>::iterator it=select_in ->begin();

      uint32_t num_bank = reg_NUM_BANK_TAIL;
      uint32_t nb_insert = 0;
      while ((it!=select_in ->end()) and  
             (_issue_queue[num_bank].size() != _param->_size_bank) and // test if can accept an data
             (nb_insert < _param->_nb_bank)
             )
        {
          // Get num interface
          uint32_t num_rename_unit = it->grp;
          uint32_t num_inst_rename = it->elt;
          
          log_printf(TRACE,Issue_queue,FUNCTION,"  * ISSUE_IN [%d][%d]",num_rename_unit,num_inst_rename);
          
          // find
          internal_ISSUE_IN_ACK [num_rename_unit][num_inst_rename] = true;

          // update pointer
          ++it;
          num_bank = (num_bank+1)%_param->_nb_bank;
          nb_insert ++;
        }
      
      for (uint32_t i=0; i<_param->_nb_rename_unit; i++)
        for (uint32_t j=0; j<_param->_nb_inst_rename[i]; j++)
          PORT_WRITE(out_ISSUE_IN_ACK [i][j],internal_ISSUE_IN_ACK [i][j]);
    }

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
