/*
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

/*
** Copyright (C) 2008 Analog Devices, Inc.
**
************************************************************************************
**
** This include file contains a list of macro "defines" to enable the programmer
** to use symbolic names for BF539 peripherals.
**
************************************************************************************
** System MMR Register Map
************************************************************************************/

#ifndef _CDEF_BF539_H
#define _CDEF_BF539_H

/* include all Core registers and bit definitions */
#include <defBF539.h>

/* include core specific register pointer definitions */
#include <cdef_LPBlackfin.h>

/* include built-in mneumonic macros */
#include <ccblkfn.h>

#ifndef _PTR_TO_VOL_VOID_PTR
#ifndef _USE_LEGACY_CDEF_BEHAVIOUR
#define _PTR_TO_VOL_VOID_PTR (void * volatile *)
#else
#define _PTR_TO_VOL_VOID_PTR (volatile void **)
#endif
#endif

/* Clock/Regulator Control */
#define pPLL_CTL 		((volatile unsigned short *)PLL_CTL)
#define pPLL_DIV 		((volatile unsigned short *)PLL_DIV)
#define pVR_CTL 		((volatile unsigned short *)VR_CTL)
#define pPLL_STAT 		((volatile unsigned short *)PLL_STAT)
#define pPLL_LOCKCNT 	((volatile unsigned short *)PLL_LOCKCNT)
#define pCHIPID			((volatile unsigned long *)CHIPID)


/* System Interrupt Controllers */
#define pSWRST 			((volatile unsigned short *)SWRST)
#define pSYSCR 			((volatile unsigned short *)SYSCR)
#define	pSIC_RVECT		((void * volatile *)SIC_RVECT)

#define pSIC_IMASK0 		((volatile unsigned long *)SIC_IMASK0)
#define pSIC_IMASK1				((volatile unsigned long  *)SIC_IMASK1)

#define pSIC_ISR0 		((volatile unsigned long *)SIC_ISR0)
#define pSIC_ISR1 				((volatile unsigned long  *)SIC_ISR1)

#define pSIC_IWR0 		((volatile unsigned long *)SIC_IWR0)
#define pSIC_IWR1 				((volatile unsigned long  *)SIC_IWR1)

#define pSIC_IAR0 		((volatile unsigned long *)SIC_IAR0)
#define pSIC_IAR1 		((volatile unsigned long *)SIC_IAR1)
#define pSIC_IAR2 		((volatile unsigned long *)SIC_IAR2)
#define pSIC_IAR3 				((volatile unsigned long  *)SIC_IAR3)
#define pSIC_IAR4 				((volatile unsigned long  *)SIC_IAR4)
#define pSIC_IAR5 				((volatile unsigned long  *)SIC_IAR5)
#define pSIC_IAR6 				((volatile unsigned long  *)SIC_IAR6)


/* Watchdog Timer */
#define pWDOG_CTL 		((volatile unsigned short *)WDOG_CTL)
#define pWDOG_CNT 		((volatile unsigned long *)WDOG_CNT)
#define pWDOG_STAT 		((volatile unsigned long *)WDOG_STAT)


/* Real Time Clock */
#define pRTC_STAT 		((volatile unsigned long *)RTC_STAT)
#define pRTC_ICTL 		((volatile unsigned short *)RTC_ICTL)
#define pRTC_ISTAT 		((volatile unsigned short *)RTC_ISTAT)
#define pRTC_SWCNT 		((volatile unsigned short *)RTC_SWCNT)
#define pRTC_ALARM 		((volatile unsigned long *)RTC_ALARM)
#define pRTC_FAST 		((volatile unsigned short *)RTC_FAST)
#define pRTC_PREN 		((volatile unsigned short *)RTC_PREN)


/* UART0 Controller */
#define pUART0_THR 		((volatile unsigned short *)UART0_THR)
#define pUART0_RBR 		((volatile unsigned short *)UART0_RBR)
#define pUART0_DLL 		((volatile unsigned short *)UART0_DLL)
#define pUART0_IER 		((volatile unsigned short *)UART0_IER)
#define pUART0_DLH 		((volatile unsigned short *)UART0_DLH)
#define pUART0_IIR 		((volatile unsigned short *)UART0_IIR)
#define pUART0_LCR 		((volatile unsigned short *)UART0_LCR)
#define pUART0_MCR 		((volatile unsigned short *)UART0_MCR)
#define pUART0_LSR 		((volatile unsigned short *)UART0_LSR)
/* #define UART0_MSR */
#define pUART0_SCR 		((volatile unsigned short *)UART0_SCR)
#define pUART0_GCTL 		((volatile unsigned short *)UART0_GCTL)


/* UART1 Controller							*/
#define pUART1_THR 			((volatile unsigned short *)UART1_THR)
#define pUART1_RBR 			((volatile unsigned short *)UART1_RBR)
#define pUART1_DLL 			((volatile unsigned short *)UART1_DLL)
#define pUART1_IER 			((volatile unsigned short *)UART1_IER)
#define pUART1_DLH 			((volatile unsigned short *)UART1_DLH)
#define pUART1_IIR 			((volatile unsigned short *)UART1_IIR)
#define pUART1_LCR 			((volatile unsigned short *)UART1_LCR)
#define pUART1_MCR 			((volatile unsigned short *)UART1_MCR)
#define pUART1_LSR 			((volatile unsigned short *)UART1_LSR)
#define pUART1_SCR 			((volatile unsigned short *)UART1_SCR)
#define pUART1_GCTL 		((volatile unsigned short *)UART1_GCTL)


/* UART2 Controller						*/
#define pUART2_THR 			((volatile unsigned short *)UART2_THR)
#define pUART2_RBR 			((volatile unsigned short *)UART2_RBR)
#define pUART2_DLL 			((volatile unsigned short *)UART2_DLL)
#define pUART2_IER 			((volatile unsigned short *)UART2_IER)
#define pUART2_DLH 			((volatile unsigned short *)UART2_DLH)
#define pUART2_IIR 			((volatile unsigned short *)UART2_IIR)
#define pUART2_LCR 			((volatile unsigned short *)UART2_LCR)
#define pUART2_MCR 			((volatile unsigned short *)UART2_MCR)
#define pUART2_LSR 			((volatile unsigned short *)UART2_LSR)
#define pUART2_SCR 			((volatile unsigned short *)UART2_SCR)
#define pUART2_GCTL 		((volatile unsigned short *)UART2_GCTL)


/* SPI0 Controller */
#define pSPI0_CTL 		((volatile unsigned short *)SPI0_CTL)
#define pSPI0_FLG 		((volatile unsigned short *)SPI0_FLG)
#define pSPI0_STAT 		((volatile unsigned short *)SPI0_STAT)
#define pSPI0_TDBR 		((volatile unsigned short *)SPI0_TDBR)
#define pSPI0_RDBR 		((volatile unsigned short *)SPI0_RDBR)
#define pSPI0_BAUD 		((volatile unsigned short *)SPI0_BAUD)
#define pSPI0_SHADOW 	((volatile unsigned short *)SPI0_SHADOW)


/* SPI1 Controller					*/
#define pSPI1_CTL 			((volatile unsigned short *)SPI1_CTL)
#define pSPI1_FLG 			((volatile unsigned short *)SPI1_FLG)
#define pSPI1_STAT 			((volatile unsigned short *)SPI1_STAT)
#define pSPI1_TDBR 			((volatile unsigned short *)SPI1_TDBR)
#define pSPI1_RDBR 			((volatile unsigned short *)SPI1_RDBR)
#define pSPI1_BAUD 			((volatile unsigned short *)SPI1_BAUD)
#define pSPI1_SHADOW 		((volatile unsigned short *)SPI1_SHADOW)


/* SPI2 Controller								*/
#define pSPI2_CTL 			((volatile unsigned short *)SPI2_CTL)
#define pSPI2_FLG 			((volatile unsigned short *)SPI2_FLG)
#define pSPI2_STAT 			((volatile unsigned short *)SPI2_STAT)
#define pSPI2_TDBR 			((volatile unsigned short *)SPI2_TDBR)
#define pSPI2_RDBR 			((volatile unsigned short *)SPI2_RDBR)
#define pSPI2_BAUD 			((volatile unsigned short *)SPI2_BAUD)
#define pSPI2_SHADOW 		((volatile unsigned short *)SPI2_SHADOW)


/* TIMER 0, 1, 2 Registers */
#define pTIMER0_CONFIG 	((volatile unsigned short *)TIMER0_CONFIG)
#define pTIMER0_COUNTER ((volatile unsigned long *)TIMER0_COUNTER)
#define pTIMER0_PERIOD 	((volatile unsigned long *)TIMER0_PERIOD)
#define pTIMER0_WIDTH 	((volatile unsigned long *)TIMER0_WIDTH)

#define pTIMER1_CONFIG 	((volatile unsigned short *)TIMER1_CONFIG)
#define pTIMER1_COUNTER ((volatile unsigned long *)TIMER1_COUNTER)
#define pTIMER1_PERIOD 	((volatile unsigned long *)TIMER1_PERIOD)
#define pTIMER1_WIDTH 	((volatile unsigned long *)TIMER1_WIDTH)

#define pTIMER2_CONFIG 	((volatile unsigned short *)TIMER2_CONFIG)
#define pTIMER2_COUNTER ((volatile unsigned long *)TIMER2_COUNTER)
#define pTIMER2_PERIOD 	((volatile unsigned long *)TIMER2_PERIOD)
#define pTIMER2_WIDTH 	((volatile unsigned long *)TIMER2_WIDTH)

#define pTIMER_ENABLE 	((volatile unsigned short *)TIMER_ENABLE)
#define pTIMER_DISABLE 	((volatile unsigned short *)TIMER_DISABLE)
#define pTIMER_STATUS 	((volatile unsigned short *)TIMER_STATUS)


/* Two-Wire Interface 0						*/
#define pTWI0_CLKDIV		((volatile unsigned short *)TWI0_CLKDIV)
#define pTWI0_CONTROL		((volatile unsigned short *)TWI0_CONTROL)
#define pTWI0_SLAVE_CTRL	((volatile unsigned short *)TWI0_SLAVE_CTRL)
#define pTWI0_SLAVE_STAT	((volatile unsigned short *)TWI0_SLAVE_STAT)
#define pTWI0_SLAVE_ADDR	((volatile unsigned short *)TWI0_SLAVE_ADDR)
#define pTWI0_MASTER_CTRL	((volatile unsigned short *)TWI0_MASTER_CTRL)
#define pTWI0_MASTER_STAT	((volatile unsigned short *)TWI0_MASTER_STAT)
#define pTWI0_MASTER_ADDR	((volatile unsigned short *)TWI0_MASTER_ADDR)
#define pTWI0_INT_STAT		((volatile unsigned short *)TWI0_INT_STAT)
#define pTWI0_INT_MASK		((volatile unsigned short *)TWI0_INT_MASK)
#define pTWI0_FIFO_CTRL		((volatile unsigned short *)TWI0_FIFO_CTRL)
#define pTWI0_FIFO_STAT		((volatile unsigned short *)TWI0_FIFO_STAT)
#define pTWI0_XMT_DATA8		((volatile unsigned short *)TWI0_XMT_DATA8)
#define pTWI0_XMT_DATA16	((volatile unsigned short *)TWI0_XMT_DATA16)
#define pTWI0_RCV_DATA8		((volatile unsigned short *)TWI0_RCV_DATA8)
#define pTWI0_RCV_DATA16	((volatile unsigned short *)TWI0_RCV_DATA16)


/* Two-Wire Interface 1						*/
#define pTWI1_CLKDIV		((volatile unsigned short *)TWI1_CLKDIV)
#define pTWI1_CONTROL		((volatile unsigned short *)TWI1_CONTROL)
#define pTWI1_SLAVE_CTRL	((volatile unsigned short *)TWI1_SLAVE_CTRL)
#define pTWI1_SLAVE_STAT	((volatile unsigned short *)TWI1_SLAVE_STAT)
#define pTWI1_SLAVE_ADDR	((volatile unsigned short *)TWI1_SLAVE_ADDR)
#define pTWI1_MASTER_CTRL	((volatile unsigned short *)TWI1_MASTER_CTRL)
#define pTWI1_MASTER_STAT	((volatile unsigned short *)TWI1_MASTER_STAT)
#define pTWI1_MASTER_ADDR	((volatile unsigned short *)TWI1_MASTER_ADDR)
#define pTWI1_INT_STAT		((volatile unsigned short *)TWI1_INT_STAT)
#define pTWI1_INT_MASK		((volatile unsigned short *)TWI1_INT_MASK)
#define pTWI1_FIFO_CTRL		((volatile unsigned short *)TWI1_FIFO_CTRL)
#define pTWI1_FIFO_STAT		((volatile unsigned short *)TWI1_FIFO_STAT)
#define pTWI1_XMT_DATA8		((volatile unsigned short *)TWI1_XMT_DATA8)
#define pTWI1_XMT_DATA16	((volatile unsigned short *)TWI1_XMT_DATA16)
#define pTWI1_RCV_DATA8		((volatile unsigned short *)TWI1_RCV_DATA8)
#define pTWI1_RCV_DATA16	((volatile unsigned short *)TWI1_RCV_DATA16)


/* General Purpose I/O */
/* Flag I/O (FIO_) */
#define pFIO_FLAG_D 	((volatile unsigned short *)FIO_FLAG_D)
#define pFIO_FLAG_C 	((volatile unsigned short *)FIO_FLAG_C)
#define pFIO_FLAG_S 	((volatile unsigned short *)FIO_FLAG_S)
#define pFIO_FLAG_T 	((volatile unsigned short *)FIO_FLAG_T)
#define pFIO_MASKA_D 	((volatile unsigned short *)FIO_MASKA_D)
#define pFIO_MASKA_C 	((volatile unsigned short *)FIO_MASKA_C)
#define pFIO_MASKA_S 	((volatile unsigned short *)FIO_MASKA_S)
#define pFIO_MASKA_T 	((volatile unsigned short *)FIO_MASKA_T)
#define pFIO_MASKB_D 	((volatile unsigned short *)FIO_MASKB_D)
#define pFIO_MASKB_C 	((volatile unsigned short *)FIO_MASKB_C)
#define pFIO_MASKB_S 	((volatile unsigned short *)FIO_MASKB_S)
#define pFIO_MASKB_T 	((volatile unsigned short *)FIO_MASKB_T)
#define pFIO_DIR 		((volatile unsigned short *)FIO_DIR)
#define pFIO_POLAR 		((volatile unsigned short *)FIO_POLAR)
#define pFIO_EDGE 		((volatile unsigned short *)FIO_EDGE)
#define pFIO_BOTH 		((volatile unsigned short *)FIO_BOTH)
#define pFIO_INEN 		((volatile unsigned short *)FIO_INEN)

/* GPIO Registers  (Port C/D/E)						*/
#define pGPIO_C_CNFG			((volatile unsigned short *)GPIO_C_CNFG)
#define pGPIO_D_CNFG			((volatile unsigned short *)GPIO_D_CNFG)
#define pGPIO_E_CNFG			((volatile unsigned short *)GPIO_E_CNFG)

#define pGPIO_C_D				((volatile unsigned short *)GPIO_C_D)
#define pGPIO_D_D				((volatile unsigned short *)GPIO_D_D)
#define pGPIO_E_D				((volatile unsigned short *)GPIO_E_D)

#define pGPIO_C_C				((volatile unsigned short *)GPIO_C_C)
#define pGPIO_D_C				((volatile unsigned short *)GPIO_D_C)
#define pGPIO_E_C				((volatile unsigned short *)GPIO_E_C)

#define pGPIO_C_S				((volatile unsigned short *)GPIO_C_S)
#define pGPIO_D_S				((volatile unsigned short *)GPIO_D_S)
#define pGPIO_E_S				((volatile unsigned short *)GPIO_E_S)

#define pGPIO_C_T				((volatile unsigned short *)GPIO_C_T)
#define pGPIO_D_T				((volatile unsigned short *)GPIO_D_T)
#define pGPIO_E_T				((volatile unsigned short *)GPIO_E_T)

#define pGPIO_C_DIR				((volatile unsigned short *)GPIO_C_DIR)
#define pGPIO_D_DIR				((volatile unsigned short *)GPIO_D_DIR)
#define pGPIO_E_DIR				((volatile unsigned short *)GPIO_E_DIR)

#define pGPIO_C_INEN			((volatile unsigned short *)GPIO_C_INEN)
#define pGPIO_D_INEN			((volatile unsigned short *)GPIO_D_INEN)
#define pGPIO_E_INEN			((volatile unsigned short *)GPIO_E_INEN)

/* Deprecate old macros */
#define pGPIO_C_DAT pGPIO_C_D
#define pGPIO_D_DAT pGPIO_D_D
#define pGPIO_E_DAT pGPIO_E_D

#define pGPIO_C_CLR pGPIO_C_C
#define pGPIO_D_CLR pGPIO_D_C
#define pGPIO_E_CLR pGPIO_E_C

#define pGPIO_C_SET pGPIO_C_S
#define pGPIO_D_SET pGPIO_D_S
#define pGPIO_E_SET pGPIO_E_S

#define pGPIO_C_TGL pGPIO_C_T
#define pGPIO_D_TGL pGPIO_D_T
#define pGPIO_E_TGL pGPIO_E_T

/* SPORT0 Controller */
#define pSPORT0_TCR1 	((volatile unsigned short *)SPORT0_TCR1)
#define pSPORT0_TCR2 	((volatile unsigned short *)SPORT0_TCR2)
#define pSPORT0_TCLKDIV ((volatile unsigned short *)SPORT0_TCLKDIV)
#define pSPORT0_TFSDIV 	((volatile unsigned short *)SPORT0_TFSDIV)
#define pSPORT0_TX 		((volatile long *)SPORT0_TX)
#define pSPORT0_RX 		((volatile long *)SPORT0_RX)
#define pSPORT0_TX32	((volatile long *)SPORT0_TX)
#define pSPORT0_RX32 	((volatile long *)SPORT0_RX)
#define pSPORT0_TX16 	((volatile unsigned short *)SPORT0_TX)
#define pSPORT0_RX16 	((volatile unsigned short *)SPORT0_RX)
#define pSPORT0_RCR1 	((volatile unsigned short *)SPORT0_RCR1)
#define pSPORT0_RCR2 	((volatile unsigned short *)SPORT0_RCR2)
#define pSPORT0_RCLKDIV ((volatile unsigned short *)SPORT0_RCLKDIV)
#define pSPORT0_RFSDIV 	((volatile unsigned short *)SPORT0_RFSDIV)
#define pSPORT0_STAT 	((volatile unsigned short *)SPORT0_STAT)
#define pSPORT0_CHNL 	((volatile unsigned short *)SPORT0_CHNL)
#define pSPORT0_MCMC1 	((volatile unsigned short *)SPORT0_MCMC1)
#define pSPORT0_MCMC2 	((volatile unsigned short *)SPORT0_MCMC2)
#define pSPORT0_MTCS0 	((volatile unsigned long *)SPORT0_MTCS0)
#define pSPORT0_MTCS1 	((volatile unsigned long *)SPORT0_MTCS1)
#define pSPORT0_MTCS2 	((volatile unsigned long *)SPORT0_MTCS2)
#define pSPORT0_MTCS3 	((volatile unsigned long *)SPORT0_MTCS3)
#define pSPORT0_MRCS0 	((volatile unsigned long *)SPORT0_MRCS0)
#define pSPORT0_MRCS1 	((volatile unsigned long *)SPORT0_MRCS1)
#define pSPORT0_MRCS2 	((volatile unsigned long *)SPORT0_MRCS2)
#define pSPORT0_MRCS3 	((volatile unsigned long *)SPORT0_MRCS3)


/* SPORT1 Controller */
#define pSPORT1_TCR1 	((volatile unsigned short *)SPORT1_TCR1)
#define pSPORT1_TCR2 	((volatile unsigned short *)SPORT1_TCR2)
#define pSPORT1_TCLKDIV ((volatile unsigned short *)SPORT1_TCLKDIV)
#define pSPORT1_TFSDIV 	((volatile unsigned short *)SPORT1_TFSDIV)
#define pSPORT1_TX 		((volatile long *)SPORT1_TX)
#define pSPORT1_RX 		((volatile long *)SPORT1_RX)
#define pSPORT1_TX32 	((volatile long *)SPORT1_TX)
#define pSPORT1_RX32 	((volatile long *)SPORT1_RX)
#define pSPORT1_TX16 	((volatile unsigned short *)SPORT1_TX)
#define pSPORT1_RX16 	((volatile unsigned short *)SPORT1_RX)
#define pSPORT1_RCR1 	((volatile unsigned short *)SPORT1_RCR1)
#define pSPORT1_RCR2 	((volatile unsigned short *)SPORT1_RCR2)
#define pSPORT1_RCLKDIV ((volatile unsigned short *)SPORT1_RCLKDIV)
#define pSPORT1_RFSDIV 	((volatile unsigned short *)SPORT1_RFSDIV)
#define pSPORT1_STAT 	((volatile unsigned short *)SPORT1_STAT)
#define pSPORT1_CHNL 	((volatile unsigned short *)SPORT1_CHNL)
#define pSPORT1_MCMC1 	((volatile unsigned short *)SPORT1_MCMC1)
#define pSPORT1_MCMC2 	((volatile unsigned short *)SPORT1_MCMC2)
#define pSPORT1_MTCS0 	((volatile unsigned long *)SPORT1_MTCS0)
#define pSPORT1_MTCS1 	((volatile unsigned long *)SPORT1_MTCS1)
#define pSPORT1_MTCS2 	((volatile unsigned long *)SPORT1_MTCS2)
#define pSPORT1_MTCS3 	((volatile unsigned long *)SPORT1_MTCS3)
#define pSPORT1_MRCS0 	((volatile unsigned long *)SPORT1_MRCS0)
#define pSPORT1_MRCS1 	((volatile unsigned long *)SPORT1_MRCS1)
#define pSPORT1_MRCS2 	((volatile unsigned long *)SPORT1_MRCS2)
#define pSPORT1_MRCS3 	((volatile unsigned long *)SPORT1_MRCS3)


/* SPORT2 Controller					*/
#define pSPORT2_TCR1 		((volatile unsigned short *)SPORT2_TCR1)
#define pSPORT2_TCR2 		((volatile unsigned short *)SPORT2_TCR2)
#define pSPORT2_TCLKDIV 	((volatile unsigned short *)SPORT2_TCLKDIV)
#define pSPORT2_TFSDIV 		((volatile unsigned short *)SPORT2_TFSDIV)
#define pSPORT2_TX 			((volatile unsigned long  *)SPORT2_TX)
#define pSPORT2_RX 			((volatile unsigned long  *)SPORT2_RX)
#define pSPORT2_TX32 		((volatile unsigned long  *)SPORT2_TX)
#define pSPORT2_RX32 		((volatile unsigned long  *)SPORT2_RX)
#define pSPORT2_TX16 		((volatile unsigned short *)SPORT2_TX)
#define pSPORT2_RX16 		((volatile unsigned short *)SPORT2_RX)
#define pSPORT2_RCR1 		((volatile unsigned short *)SPORT2_RCR1)
#define pSPORT2_RCR2 		((volatile unsigned short *)SPORT2_RCR2)
#define pSPORT2_RCLKDIV 	((volatile unsigned short *)SPORT2_RCLKDIV)
#define pSPORT2_RFSDIV 		((volatile unsigned short *)SPORT2_RFSDIV)
#define pSPORT2_STAT 		((volatile unsigned short *)SPORT2_STAT)
#define pSPORT2_CHNL 		((volatile unsigned short *)SPORT2_CHNL)
#define pSPORT2_MCMC1 		((volatile unsigned short *)SPORT2_MCMC1)
#define pSPORT2_MCMC2 		((volatile unsigned short *)SPORT2_MCMC2)
#define pSPORT2_MTCS0 		((volatile unsigned long  *)SPORT2_MTCS0)
#define pSPORT2_MTCS1 		((volatile unsigned long  *)SPORT2_MTCS1)
#define pSPORT2_MTCS2 		((volatile unsigned long  *)SPORT2_MTCS2)
#define pSPORT2_MTCS3 		((volatile unsigned long  *)SPORT2_MTCS3)
#define pSPORT2_MRCS0 		((volatile unsigned long  *)SPORT2_MRCS0)
#define pSPORT2_MRCS1 		((volatile unsigned long  *)SPORT2_MRCS1)
#define pSPORT2_MRCS2 		((volatile unsigned long  *)SPORT2_MRCS2)
#define pSPORT2_MRCS3 		((volatile unsigned long  *)SPORT2_MRCS3)


/* SPORT3 Controller						*/
#define pSPORT3_TCR1 		((volatile unsigned short *)SPORT3_TCR1)
#define pSPORT3_TCR2 		((volatile unsigned short *)SPORT3_TCR2)
#define pSPORT3_TCLKDIV 	((volatile unsigned short *)SPORT3_TCLKDIV)
#define pSPORT3_TFSDIV 		((volatile unsigned short *)SPORT3_TFSDIV)
#define pSPORT3_TX 			((volatile unsigned long  *)SPORT3_TX)
#define pSPORT3_RX 			((volatile unsigned long  *)SPORT3_RX)
#define pSPORT3_TX32 		((volatile unsigned long  *)SPORT3_TX)
#define pSPORT3_RX32 		((volatile unsigned long  *)SPORT3_RX)
#define pSPORT3_TX16 		((volatile unsigned short *)SPORT3_TX)
#define pSPORT3_RX16 		((volatile unsigned short *)SPORT3_RX)
#define pSPORT3_RCR1 		((volatile unsigned short *)SPORT3_RCR1)
#define pSPORT3_RCR2 		((volatile unsigned short *)SPORT3_RCR2)
#define pSPORT3_RCLKDIV 	((volatile unsigned short *)SPORT3_RCLKDIV)
#define pSPORT3_RFSDIV 		((volatile unsigned short *)SPORT3_RFSDIV)
#define pSPORT3_STAT 		((volatile unsigned short *)SPORT3_STAT)
#define pSPORT3_CHNL 		((volatile unsigned short *)SPORT3_CHNL)
#define pSPORT3_MCMC1 		((volatile unsigned short *)SPORT3_MCMC1)
#define pSPORT3_MCMC2 		((volatile unsigned short *)SPORT3_MCMC2)
#define pSPORT3_MTCS0 		((volatile unsigned long  *)SPORT3_MTCS0)
#define pSPORT3_MTCS1 		((volatile unsigned long  *)SPORT3_MTCS1)
#define pSPORT3_MTCS2 		((volatile unsigned long  *)SPORT3_MTCS2)
#define pSPORT3_MTCS3 		((volatile unsigned long  *)SPORT3_MTCS3)
#define pSPORT3_MRCS0 		((volatile unsigned long  *)SPORT3_MRCS0)
#define pSPORT3_MRCS1 		((volatile unsigned long  *)SPORT3_MRCS1)
#define pSPORT3_MRCS2 		((volatile unsigned long  *)SPORT3_MRCS2)
#define pSPORT3_MRCS3 		((volatile unsigned long  *)SPORT3_MRCS3)


/* External Bus Interface Unit */
/* Aysnchronous Memory Controller */
#define pEBIU_AMGCTL 	((volatile unsigned short *)EBIU_AMGCTL)
#define pEBIU_AMBCTL0 	((volatile unsigned long *)EBIU_AMBCTL0)
#define pEBIU_AMBCTL1 	((volatile unsigned long *)EBIU_AMBCTL1)

/* SDRAM Controller */
#define pEBIU_SDGCTL 	((volatile unsigned long *)EBIU_SDGCTL)
#define pEBIU_SDBCTL 	((volatile unsigned short *)EBIU_SDBCTL)
#define pEBIU_SDRRC 	((volatile unsigned short *)EBIU_SDRRC)
#define pEBIU_SDSTAT 	((volatile unsigned short *)EBIU_SDSTAT)


/* DMA Controller 0 Traffic controls */
#define pDMAC0_TC_PER 	((volatile unsigned short *)DMAC0_TC_PER)
#define pDMAC0_TC_CNT 	((volatile unsigned short *)DMAC0_TC_CNT)

/* Alternate deprecated register names (below) provided for backwards code compatibility */
#define pDMA0_TCPER 		((volatile unsigned short *)DMA0_TCPER)
#define pDMA0_TCCNT 		((volatile unsigned short *)DMA0_TCCNT)


/* DMA Controller 0 */
#define pDMA0_CONFIG 			((volatile unsigned short *)DMA0_CONFIG)
#define pDMA0_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA0_NEXT_DESC_PTR)
#define pDMA0_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA0_START_ADDR)
#define pDMA0_X_COUNT 			((volatile unsigned short *)DMA0_X_COUNT)
#define pDMA0_Y_COUNT 			((volatile unsigned short *)DMA0_Y_COUNT)
#define pDMA0_X_MODIFY 			((volatile signed short *)DMA0_X_MODIFY)
#define pDMA0_Y_MODIFY 			((volatile signed short *)DMA0_Y_MODIFY)
#define pDMA0_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA0_CURR_DESC_PTR)
#define pDMA0_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA0_CURR_ADDR)
#define pDMA0_CURR_X_COUNT 		((volatile unsigned short *)DMA0_CURR_X_COUNT)
#define pDMA0_CURR_Y_COUNT 		((volatile unsigned short *)DMA0_CURR_Y_COUNT)
#define pDMA0_IRQ_STATUS 		((volatile unsigned short *)DMA0_IRQ_STATUS)
#define pDMA0_PERIPHERAL_MAP 	((volatile unsigned short *)DMA0_PERIPHERAL_MAP)

#define pDMA1_CONFIG 			((volatile unsigned short *)DMA1_CONFIG)
#define pDMA1_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA1_NEXT_DESC_PTR)
#define pDMA1_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA1_START_ADDR)
#define pDMA1_X_COUNT 			((volatile unsigned short *)DMA1_X_COUNT)
#define pDMA1_Y_COUNT 			((volatile unsigned short *)DMA1_Y_COUNT)
#define pDMA1_X_MODIFY 			((volatile signed short *)DMA1_X_MODIFY)
#define pDMA1_Y_MODIFY 			((volatile signed short *)DMA1_Y_MODIFY)
#define pDMA1_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA1_CURR_DESC_PTR)
#define pDMA1_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA1_CURR_ADDR)
#define pDMA1_CURR_X_COUNT 		((volatile unsigned short *)DMA1_CURR_X_COUNT)
#define pDMA1_CURR_Y_COUNT 		((volatile unsigned short *)DMA1_CURR_Y_COUNT)
#define pDMA1_IRQ_STATUS 		((volatile unsigned short *)DMA1_IRQ_STATUS)
#define pDMA1_PERIPHERAL_MAP 	((volatile unsigned short *)DMA1_PERIPHERAL_MAP)

#define pDMA2_CONFIG 			((volatile unsigned short *)DMA2_CONFIG)
#define pDMA2_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA2_NEXT_DESC_PTR)
#define pDMA2_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA2_START_ADDR)
#define pDMA2_X_COUNT 			((volatile unsigned short *)DMA2_X_COUNT)
#define pDMA2_Y_COUNT 			((volatile unsigned short *)DMA2_Y_COUNT)
#define pDMA2_X_MODIFY 			((volatile signed short *)DMA2_X_MODIFY)
#define pDMA2_Y_MODIFY 			((volatile signed short *)DMA2_Y_MODIFY)
#define pDMA2_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA2_CURR_DESC_PTR)
#define pDMA2_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA2_CURR_ADDR)
#define pDMA2_CURR_X_COUNT 		((volatile unsigned short *)DMA2_CURR_X_COUNT)
#define pDMA2_CURR_Y_COUNT 		((volatile unsigned short *)DMA2_CURR_Y_COUNT)
#define pDMA2_IRQ_STATUS 		((volatile unsigned short *)DMA2_IRQ_STATUS)
#define pDMA2_PERIPHERAL_MAP 	((volatile unsigned short *)DMA2_PERIPHERAL_MAP)

#define pDMA3_CONFIG 			((volatile unsigned short *)DMA3_CONFIG)
#define pDMA3_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA3_NEXT_DESC_PTR)
#define pDMA3_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA3_START_ADDR)
#define pDMA3_X_COUNT 			((volatile unsigned short *)DMA3_X_COUNT)
#define pDMA3_Y_COUNT 			((volatile unsigned short *)DMA3_Y_COUNT)
#define pDMA3_X_MODIFY 			((volatile signed short *)DMA3_X_MODIFY)
#define pDMA3_Y_MODIFY 			((volatile signed short *)DMA3_Y_MODIFY)
#define pDMA3_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA3_CURR_DESC_PTR)
#define pDMA3_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA3_CURR_ADDR)
#define pDMA3_CURR_X_COUNT 		((volatile unsigned short *)DMA3_CURR_X_COUNT)
#define pDMA3_CURR_Y_COUNT 		((volatile unsigned short *)DMA3_CURR_Y_COUNT)
#define pDMA3_IRQ_STATUS 		((volatile unsigned short *)DMA3_IRQ_STATUS)
#define pDMA3_PERIPHERAL_MAP 	((volatile unsigned short *)DMA3_PERIPHERAL_MAP)

#define pDMA4_CONFIG 			((volatile unsigned short *)DMA4_CONFIG)
#define pDMA4_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA4_NEXT_DESC_PTR)
#define pDMA4_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA4_START_ADDR)
#define pDMA4_X_COUNT 			((volatile unsigned short *)DMA4_X_COUNT)
#define pDMA4_Y_COUNT 			((volatile unsigned short *)DMA4_Y_COUNT)
#define pDMA4_X_MODIFY 			((volatile signed short *)DMA4_X_MODIFY)
#define pDMA4_Y_MODIFY 			((volatile signed short *)DMA4_Y_MODIFY)
#define pDMA4_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA4_CURR_DESC_PTR)
#define pDMA4_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA4_CURR_ADDR)
#define pDMA4_CURR_X_COUNT 		((volatile unsigned short *)DMA4_CURR_X_COUNT)
#define pDMA4_CURR_Y_COUNT 		((volatile unsigned short *)DMA4_CURR_Y_COUNT)
#define pDMA4_IRQ_STATUS 		((volatile unsigned short *)DMA4_IRQ_STATUS)
#define pDMA4_PERIPHERAL_MAP 	((volatile unsigned short *)DMA4_PERIPHERAL_MAP)

#define pDMA5_CONFIG 			((volatile unsigned short *)DMA5_CONFIG)
#define pDMA5_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA5_NEXT_DESC_PTR)
#define pDMA5_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA5_START_ADDR)
#define pDMA5_X_COUNT 			((volatile unsigned short *)DMA5_X_COUNT)
#define pDMA5_Y_COUNT 			((volatile unsigned short *)DMA5_Y_COUNT)
#define pDMA5_X_MODIFY 			((volatile signed short *)DMA5_X_MODIFY)
#define pDMA5_Y_MODIFY 			((volatile signed short *)DMA5_Y_MODIFY)
#define pDMA5_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA5_CURR_DESC_PTR)
#define pDMA5_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA5_CURR_ADDR)
#define pDMA5_CURR_X_COUNT 		((volatile unsigned short *)DMA5_CURR_X_COUNT)
#define pDMA5_CURR_Y_COUNT 		((volatile unsigned short *)DMA5_CURR_Y_COUNT)
#define pDMA5_IRQ_STATUS 		((volatile unsigned short *)DMA5_IRQ_STATUS)
#define pDMA5_PERIPHERAL_MAP 	((volatile unsigned short *)DMA5_PERIPHERAL_MAP)

#define pDMA6_CONFIG 			((volatile unsigned short *)DMA6_CONFIG)
#define pDMA6_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA6_NEXT_DESC_PTR)
#define pDMA6_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA6_START_ADDR)
#define pDMA6_X_COUNT 			((volatile unsigned short *)DMA6_X_COUNT)
#define pDMA6_Y_COUNT 			((volatile unsigned short *)DMA6_Y_COUNT)
#define pDMA6_X_MODIFY 			((volatile signed short *)DMA6_X_MODIFY)
#define pDMA6_Y_MODIFY 			((volatile signed short *)DMA6_Y_MODIFY)
#define pDMA6_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA6_CURR_DESC_PTR)
#define pDMA6_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA6_CURR_ADDR)
#define pDMA6_CURR_X_COUNT 		((volatile unsigned short *)DMA6_CURR_X_COUNT)
#define pDMA6_CURR_Y_COUNT 		((volatile unsigned short *)DMA6_CURR_Y_COUNT)
#define pDMA6_IRQ_STATUS 		((volatile unsigned short *)DMA6_IRQ_STATUS)
#define pDMA6_PERIPHERAL_MAP 	((volatile unsigned short *)DMA6_PERIPHERAL_MAP)

#define pDMA7_CONFIG 			((volatile unsigned short *)DMA7_CONFIG)
#define pDMA7_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA7_NEXT_DESC_PTR)
#define pDMA7_START_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA7_START_ADDR)
#define pDMA7_X_COUNT 			((volatile unsigned short *)DMA7_X_COUNT)
#define pDMA7_Y_COUNT 			((volatile unsigned short *)DMA7_Y_COUNT)
#define pDMA7_X_MODIFY 			((volatile signed short *)DMA7_X_MODIFY)
#define pDMA7_Y_MODIFY 			((volatile signed short *)DMA7_Y_MODIFY)
#define pDMA7_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR DMA7_CURR_DESC_PTR)
#define pDMA7_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR DMA7_CURR_ADDR)
#define pDMA7_CURR_X_COUNT 		((volatile unsigned short *)DMA7_CURR_X_COUNT)
#define pDMA7_CURR_Y_COUNT 		((volatile unsigned short *)DMA7_CURR_Y_COUNT)
#define pDMA7_IRQ_STATUS 		((volatile unsigned short *)DMA7_IRQ_STATUS)
#define pDMA7_PERIPHERAL_MAP 	((volatile unsigned short *)DMA7_PERIPHERAL_MAP)

#define pMDMA0_D1_CONFIG 		((volatile unsigned short *)MDMA0_D1_CONFIG)
#define pMDMA0_D1_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_D1_NEXT_DESC_PTR)
#define pMDMA0_D1_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA0_D1_START_ADDR)
#define pMDMA0_D1_X_COUNT 		((volatile unsigned short *)MDMA0_D1_X_COUNT)
#define pMDMA0_D1_Y_COUNT 		((volatile unsigned short *)MDMA0_D1_Y_COUNT)
#define pMDMA0_D1_X_MODIFY 		((volatile signed short *)MDMA0_D1_X_MODIFY)
#define pMDMA0_D1_Y_MODIFY 		((volatile signed short *)MDMA0_D1_Y_MODIFY)
#define pMDMA0_D1_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_D1_CURR_DESC_PTR)
#define pMDMA0_D1_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR MDMA0_D1_CURR_ADDR)
#define pMDMA0_D1_CURR_X_COUNT 	((volatile unsigned short *)MDMA0_D1_CURR_X_COUNT)
#define pMDMA0_D1_CURR_Y_COUNT 	((volatile unsigned short *)MDMA0_D1_CURR_Y_COUNT)
#define pMDMA0_D1_IRQ_STATUS 	((volatile unsigned short *)MDMA0_D1_IRQ_STATUS)
#define pMDMA0_D1_PERIPHERAL_MAP ((volatile unsigned short *)MDMA0_D1_PERIPHERAL_MAP)

#define pMDMA0_S1_CONFIG 		((volatile unsigned short *)MDMA0_S1_CONFIG)
#define pMDMA0_S1_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_S1_NEXT_DESC_PTR)
#define pMDMA0_S1_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA0_S1_START_ADDR)
#define pMDMA0_S1_X_COUNT 		((volatile unsigned short *)MDMA0_S1_X_COUNT)
#define pMDMA0_S1_Y_COUNT 		((volatile unsigned short *)MDMA0_S1_Y_COUNT)
#define pMDMA0_S1_X_MODIFY 		((volatile signed short *)MDMA0_S1_X_MODIFY)
#define pMDMA0_S1_Y_MODIFY 		((volatile signed short *)MDMA0_S1_Y_MODIFY)
#define pMDMA0_S1_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_S1_CURR_DESC_PTR)
#define pMDMA0_S1_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR MDMA0_S1_CURR_ADDR)
#define pMDMA0_S1_CURR_X_COUNT 	((volatile unsigned short *)MDMA0_S1_CURR_X_COUNT)
#define pMDMA0_S1_CURR_Y_COUNT 	((volatile unsigned short *)MDMA0_S1_CURR_Y_COUNT)
#define pMDMA0_S1_IRQ_STATUS 	((volatile unsigned short *)MDMA0_S1_IRQ_STATUS)
#define pMDMA0_S1_PERIPHERAL_MAP ((volatile unsigned short *)MDMA0_S1_PERIPHERAL_MAP)

#define pMDMA0_D0_CONFIG 		((volatile unsigned short *)MDMA0_D0_CONFIG)
#define pMDMA0_D0_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_D0_NEXT_DESC_PTR)
#define pMDMA0_D0_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA0_D0_START_ADDR)
#define pMDMA0_D0_X_COUNT 		((volatile unsigned short *)MDMA0_D0_X_COUNT)
#define pMDMA0_D0_Y_COUNT 		((volatile unsigned short *)MDMA0_D0_Y_COUNT)
#define pMDMA0_D0_X_MODIFY 		((volatile signed short *)MDMA0_D0_X_MODIFY)
#define pMDMA0_D0_Y_MODIFY 		((volatile signed short *)MDMA0_D0_Y_MODIFY)
#define pMDMA0_D0_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_D0_CURR_DESC_PTR)
#define pMDMA0_D0_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR MDMA0_D0_CURR_ADDR)
#define pMDMA0_D0_CURR_X_COUNT 	((volatile unsigned short *)MDMA0_D0_CURR_X_COUNT)
#define pMDMA0_D0_CURR_Y_COUNT 	((volatile unsigned short *)MDMA0_D0_CURR_Y_COUNT)
#define pMDMA0_D0_IRQ_STATUS 	((volatile unsigned short *)MDMA0_D0_IRQ_STATUS)
#define pMDMA0_D0_PERIPHERAL_MAP ((volatile unsigned short *)MDMA0_D0_PERIPHERAL_MAP)

#define pMDMA0_S0_CONFIG 		((volatile unsigned short *)MDMA0_S0_CONFIG)
#define pMDMA0_S0_NEXT_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_S0_NEXT_DESC_PTR)
#define pMDMA0_S0_START_ADDR 	(_PTR_TO_VOL_VOID_PTR MDMA0_S0_START_ADDR)
#define pMDMA0_S0_X_COUNT 		((volatile unsigned short *)MDMA0_S0_X_COUNT)
#define pMDMA0_S0_Y_COUNT 		((volatile unsigned short *)MDMA0_S0_Y_COUNT)
#define pMDMA0_S0_X_MODIFY 		((volatile signed short *)MDMA0_S0_X_MODIFY)
#define pMDMA0_S0_Y_MODIFY 		((volatile signed short *)MDMA0_S0_Y_MODIFY)
#define pMDMA0_S0_CURR_DESC_PTR 	(_PTR_TO_VOL_VOID_PTR MDMA0_S0_CURR_DESC_PTR)
#define pMDMA0_S0_CURR_ADDR 		(_PTR_TO_VOL_VOID_PTR MDMA0_S0_CURR_ADDR)
#define pMDMA0_S0_CURR_X_COUNT 	((volatile unsigned short *)MDMA0_S0_CURR_X_COUNT)
#define pMDMA0_S0_CURR_Y_COUNT 	((volatile unsigned short *)MDMA0_S0_CURR_Y_COUNT)
#define pMDMA0_S0_IRQ_STATUS 	((volatile unsigned short *)MDMA0_S0_IRQ_STATUS)
#define pMDMA0_S0_PERIPHERAL_MAP ((volatile unsigned short *)MDMA0_S0_PERIPHERAL_MAP)


/* DMA Controller 1 Traffic Control Registers											*/
#define	pDMAC1_TC_PER				((volatile unsigned short *)DMAC1_TC_PER)
#define	pDMAC1_TC_CNT				((volatile unsigned short *)DMAC1_TC_CNT)

/* Alternate deprecated register names (below) provided for backwards code compatibility */
#define pDMA1_TCPER					pDMA1_TCPER	/* Traffic Control Periods Register			*/
#define pDMA1_TCCNT					pDMA1_TCCNT	/* Traffic Control Current Counts Register	*/

/* DMA Controller 1 						*/
#define pDMA8_NEXT_DESC_PTR 		((void * volatile *)DMA8_NEXT_DESC_PTR)
#define pDMA8_START_ADDR 			((void * volatile *)DMA8_START_ADDR)
#define pDMA8_CONFIG 				((volatile unsigned short *)DMA8_CONFIG)
#define pDMA8_X_COUNT 				((volatile unsigned short *)DMA8_X_COUNT)
#define pDMA8_X_MODIFY 				((volatile signed   short *)DMA8_X_MODIFY)
#define pDMA8_Y_COUNT 				((volatile unsigned short *)DMA8_Y_COUNT)
#define pDMA8_Y_MODIFY 				((volatile signed   short *)DMA8_Y_MODIFY)
#define pDMA8_CURR_DESC_PTR 		((void * volatile *)DMA8_CURR_DESC_PTR)
#define pDMA8_CURR_ADDR 			((void * volatile *)DMA8_CURR_ADDR)
#define pDMA8_IRQ_STATUS 			((volatile unsigned short *)DMA8_IRQ_STATUS)
#define pDMA8_PERIPHERAL_MAP 		((volatile unsigned short *)DMA8_PERIPHERAL_MAP)
#define pDMA8_CURR_X_COUNT 			((volatile unsigned short *)DMA8_CURR_X_COUNT)
#define pDMA8_CURR_Y_COUNT 			((volatile unsigned short *)DMA8_CURR_Y_COUNT)

#define pDMA9_NEXT_DESC_PTR 		((void * volatile *)DMA9_NEXT_DESC_PTR)
#define pDMA9_START_ADDR 			((void * volatile *)DMA9_START_ADDR)
#define pDMA9_CONFIG 				((volatile unsigned short *)DMA9_CONFIG)
#define pDMA9_X_COUNT 				((volatile unsigned short *)DMA9_X_COUNT)
#define pDMA9_X_MODIFY 				((volatile signed   short *)DMA9_X_MODIFY)
#define pDMA9_Y_COUNT 				((volatile unsigned short *)DMA9_Y_COUNT)
#define pDMA9_Y_MODIFY 				((volatile signed   short *)DMA9_Y_MODIFY)
#define pDMA9_CURR_DESC_PTR 		((void * volatile *)DMA9_CURR_DESC_PTR)
#define pDMA9_CURR_ADDR 			((void * volatile *)DMA9_CURR_ADDR)
#define pDMA9_IRQ_STATUS 			((volatile unsigned short *)DMA9_IRQ_STATUS)
#define pDMA9_PERIPHERAL_MAP 		((volatile unsigned short *)DMA9_PERIPHERAL_MAP)
#define pDMA9_CURR_X_COUNT 			((volatile unsigned short *)DMA9_CURR_X_COUNT)
#define pDMA9_CURR_Y_COUNT 			((volatile unsigned short *)DMA9_CURR_Y_COUNT)

#define pDMA10_NEXT_DESC_PTR 		((void * volatile *)DMA10_NEXT_DESC_PTR)
#define pDMA10_START_ADDR 			((void * volatile *)DMA10_START_ADDR)
#define pDMA10_CONFIG 				((volatile unsigned short *)DMA10_CONFIG)
#define pDMA10_X_COUNT 				((volatile unsigned short *)DMA10_X_COUNT)
#define pDMA10_X_MODIFY 			((volatile signed   short *)DMA10_X_MODIFY)
#define pDMA10_Y_COUNT 				((volatile unsigned short *)DMA10_Y_COUNT)
#define pDMA10_Y_MODIFY 			((volatile signed   short *)DMA10_Y_MODIFY)
#define pDMA10_CURR_DESC_PTR 		((void * volatile *)DMA10_CURR_DESC_PTR)
#define pDMA10_CURR_ADDR 			((void * volatile *)DMA10_CURR_ADDR)
#define pDMA10_IRQ_STATUS 			((volatile unsigned short *)DMA10_IRQ_STATUS)
#define pDMA10_PERIPHERAL_MAP 		((volatile unsigned short *)DMA10_PERIPHERAL_MAP)
#define pDMA10_CURR_X_COUNT 		((volatile unsigned short *)DMA10_CURR_X_COUNT)
#define pDMA10_CURR_Y_COUNT 		((volatile unsigned short *)DMA10_CURR_Y_COUNT)

#define pDMA11_NEXT_DESC_PTR 		((void * volatile *)DMA11_NEXT_DESC_PTR)
#define pDMA11_START_ADDR 			((void * volatile *)DMA11_START_ADDR)
#define pDMA11_CONFIG 				((volatile unsigned short *)DMA11_CONFIG)
#define pDMA11_X_COUNT 				((volatile unsigned short *)DMA11_X_COUNT)
#define pDMA11_X_MODIFY 			((volatile signed   short *)DMA11_X_MODIFY)
#define pDMA11_Y_COUNT 				((volatile unsigned short *)DMA11_Y_COUNT)
#define pDMA11_Y_MODIFY 			((volatile signed   short *)DMA11_Y_MODIFY)
#define pDMA11_CURR_DESC_PTR 		((void * volatile *)DMA11_CURR_DESC_PTR)
#define pDMA11_CURR_ADDR 			((void * volatile *)DMA11_CURR_ADDR)
#define pDMA11_IRQ_STATUS 			((volatile unsigned short *)DMA11_IRQ_STATUS)
#define pDMA11_PERIPHERAL_MAP 		((volatile unsigned short *)DMA11_PERIPHERAL_MAP)
#define pDMA11_CURR_X_COUNT 		((volatile unsigned short *)DMA11_CURR_X_COUNT)
#define pDMA11_CURR_Y_COUNT 		((volatile unsigned short *)DMA11_CURR_Y_COUNT)

#define pDMA12_NEXT_DESC_PTR 		((void * volatile *)DMA12_NEXT_DESC_PTR)
#define pDMA12_START_ADDR 			((void * volatile *)DMA12_START_ADDR)
#define pDMA12_CONFIG 				((volatile unsigned short *)DMA12_CONFIG)
#define pDMA12_X_COUNT 				((volatile unsigned short *)DMA12_X_COUNT)
#define pDMA12_X_MODIFY 			((volatile signed   short *)DMA12_X_MODIFY)
#define pDMA12_Y_COUNT 				((volatile unsigned short *)DMA12_Y_COUNT)
#define pDMA12_Y_MODIFY 			((volatile signed   short *)DMA12_Y_MODIFY)
#define pDMA12_CURR_DESC_PTR 		((void * volatile *)DMA12_CURR_DESC_PTR)
#define pDMA12_CURR_ADDR 			((void * volatile *)DMA12_CURR_ADDR)
#define pDMA12_IRQ_STATUS 			((volatile unsigned short *)DMA12_IRQ_STATUS)
#define pDMA12_PERIPHERAL_MAP 		((volatile unsigned short *)DMA12_PERIPHERAL_MAP)
#define pDMA12_CURR_X_COUNT 		((volatile unsigned short *)DMA12_CURR_X_COUNT)
#define pDMA12_CURR_Y_COUNT 		((volatile unsigned short *)DMA12_CURR_Y_COUNT)

#define pDMA13_NEXT_DESC_PTR 		((void * volatile *)DMA13_NEXT_DESC_PTR)
#define pDMA13_START_ADDR 			((void * volatile *)DMA13_START_ADDR)
#define pDMA13_CONFIG 				((volatile unsigned short *)DMA13_CONFIG)
#define pDMA13_X_COUNT 				((volatile unsigned short *)DMA13_X_COUNT)
#define pDMA13_X_MODIFY 			((volatile signed   short *)DMA13_X_MODIFY)
#define pDMA13_Y_COUNT 				((volatile unsigned short *)DMA13_Y_COUNT)
#define pDMA13_Y_MODIFY 			((volatile signed   short *)DMA13_Y_MODIFY)
#define pDMA13_CURR_DESC_PTR 		((void * volatile *)DMA13_CURR_DESC_PTR)
#define pDMA13_CURR_ADDR 			((void * volatile *)DMA13_CURR_ADDR)
#define pDMA13_IRQ_STATUS 			((volatile unsigned short *)DMA13_IRQ_STATUS)
#define pDMA13_PERIPHERAL_MAP 		((volatile unsigned short *)DMA13_PERIPHERAL_MAP)
#define pDMA13_CURR_X_COUNT 		((volatile unsigned short *)DMA13_CURR_X_COUNT)
#define pDMA13_CURR_Y_COUNT 		((volatile unsigned short *)DMA13_CURR_Y_COUNT)

#define pDMA14_NEXT_DESC_PTR 		((void * volatile *)DMA14_NEXT_DESC_PTR)
#define pDMA14_START_ADDR 			((void * volatile *)DMA14_START_ADDR)
#define pDMA14_CONFIG 				((volatile unsigned short *)DMA14_CONFIG)
#define pDMA14_X_COUNT 				((volatile unsigned short *)DMA14_X_COUNT)
#define pDMA14_X_MODIFY 			((volatile signed   short *)DMA14_X_MODIFY)
#define pDMA14_Y_COUNT 				((volatile unsigned short *)DMA14_Y_COUNT)
#define pDMA14_Y_MODIFY 			((volatile signed   short *)DMA14_Y_MODIFY)
#define pDMA14_CURR_DESC_PTR 		((void * volatile *)DMA14_CURR_DESC_PTR)
#define pDMA14_CURR_ADDR 			((void * volatile *)DMA14_CURR_ADDR)
#define pDMA14_IRQ_STATUS 			((volatile unsigned short *)DMA14_IRQ_STATUS)
#define pDMA14_PERIPHERAL_MAP 		((volatile unsigned short *)DMA14_PERIPHERAL_MAP)
#define pDMA14_CURR_X_COUNT 		((volatile unsigned short *)DMA14_CURR_X_COUNT)
#define pDMA14_CURR_Y_COUNT 		((volatile unsigned short *)DMA14_CURR_Y_COUNT)

#define pDMA15_NEXT_DESC_PTR 		((void * volatile *)DMA15_NEXT_DESC_PTR)
#define pDMA15_START_ADDR 			((void * volatile *)DMA15_START_ADDR)
#define pDMA15_CONFIG 				((volatile unsigned short *)DMA15_CONFIG)
#define pDMA15_X_COUNT 				((volatile unsigned short *)DMA15_X_COUNT)
#define pDMA15_X_MODIFY 			((volatile signed   short *)DMA15_X_MODIFY)
#define pDMA15_Y_COUNT 				((volatile unsigned short *)DMA15_Y_COUNT)
#define pDMA15_Y_MODIFY 			((volatile signed   short *)DMA15_Y_MODIFY)
#define pDMA15_CURR_DESC_PTR 		((void * volatile *)DMA15_CURR_DESC_PTR)
#define pDMA15_CURR_ADDR 			((void * volatile *)DMA15_CURR_ADDR)
#define pDMA15_IRQ_STATUS 			((volatile unsigned short *)DMA15_IRQ_STATUS)
#define pDMA15_PERIPHERAL_MAP 		((volatile unsigned short *)DMA15_PERIPHERAL_MAP)
#define pDMA15_CURR_X_COUNT 		((volatile unsigned short *)DMA15_CURR_X_COUNT)
#define pDMA15_CURR_Y_COUNT 		((volatile unsigned short *)DMA15_CURR_Y_COUNT)

#define pDMA16_NEXT_DESC_PTR 		((void * volatile *)DMA16_NEXT_DESC_PTR)
#define pDMA16_START_ADDR 			((void * volatile *)DMA16_START_ADDR)
#define pDMA16_CONFIG 				((volatile unsigned short *)DMA16_CONFIG)
#define pDMA16_X_COUNT 				((volatile unsigned short *)DMA16_X_COUNT)
#define pDMA16_X_MODIFY 			((volatile signed   short *)DMA16_X_MODIFY)
#define pDMA16_Y_COUNT 				((volatile unsigned short *)DMA16_Y_COUNT)
#define pDMA16_Y_MODIFY 			((volatile signed   short *)DMA16_Y_MODIFY)
#define pDMA16_CURR_DESC_PTR 		((void * volatile *)DMA16_CURR_DESC_PTR)
#define pDMA16_CURR_ADDR 			((void * volatile *)DMA16_CURR_ADDR)
#define pDMA16_IRQ_STATUS 			((volatile unsigned short *)DMA16_IRQ_STATUS)
#define pDMA16_PERIPHERAL_MAP 		((volatile unsigned short *)DMA16_PERIPHERAL_MAP)
#define pDMA16_CURR_X_COUNT 		((volatile unsigned short *)DMA16_CURR_X_COUNT)
#define pDMA16_CURR_Y_COUNT 		((volatile unsigned short *)DMA16_CURR_Y_COUNT)

#define pDMA17_NEXT_DESC_PTR 		((void * volatile *)DMA17_NEXT_DESC_PTR)
#define pDMA17_START_ADDR 			((void * volatile *)DMA17_START_ADDR)
#define pDMA17_CONFIG 				((volatile unsigned short *)DMA17_CONFIG)
#define pDMA17_X_COUNT 				((volatile unsigned short *)DMA17_X_COUNT)
#define pDMA17_X_MODIFY 			((volatile signed   short *)DMA17_X_MODIFY)
#define pDMA17_Y_COUNT 				((volatile unsigned short *)DMA17_Y_COUNT)
#define pDMA17_Y_MODIFY 			((volatile signed   short *)DMA17_Y_MODIFY)
#define pDMA17_CURR_DESC_PTR 		((void * volatile *)DMA17_CURR_DESC_PTR)
#define pDMA17_CURR_ADDR 			((void * volatile *)DMA17_CURR_ADDR)
#define pDMA17_IRQ_STATUS 			((volatile unsigned short *)DMA17_IRQ_STATUS)
#define pDMA17_PERIPHERAL_MAP 		((volatile unsigned short *)DMA17_PERIPHERAL_MAP)
#define pDMA17_CURR_X_COUNT 		((volatile unsigned short *)DMA17_CURR_X_COUNT)
#define pDMA17_CURR_Y_COUNT 		((volatile unsigned short *)DMA17_CURR_Y_COUNT)

#define pDMA18_NEXT_DESC_PTR 		((void * volatile *)DMA18_NEXT_DESC_PTR)
#define pDMA18_START_ADDR 			((void * volatile *)DMA18_START_ADDR)
#define pDMA18_CONFIG 				((volatile unsigned short *)DMA18_CONFIG)
#define pDMA18_X_COUNT 				((volatile unsigned short *)DMA18_X_COUNT)
#define pDMA18_X_MODIFY 			((volatile signed   short *)DMA18_X_MODIFY)
#define pDMA18_Y_COUNT 				((volatile unsigned short *)DMA18_Y_COUNT)
#define pDMA18_Y_MODIFY 			((volatile signed   short *)DMA18_Y_MODIFY)
#define pDMA18_CURR_DESC_PTR 		((void * volatile *)DMA18_CURR_DESC_PTR)
#define pDMA18_CURR_ADDR 			((void * volatile *)DMA18_CURR_ADDR)
#define pDMA18_IRQ_STATUS 			((volatile unsigned short *)DMA18_IRQ_STATUS)
#define pDMA18_PERIPHERAL_MAP 		((volatile unsigned short *)DMA18_PERIPHERAL_MAP)
#define pDMA18_CURR_X_COUNT 		((volatile unsigned short *)DMA18_CURR_X_COUNT)
#define pDMA18_CURR_Y_COUNT 		((volatile unsigned short *)DMA18_CURR_Y_COUNT)

#define pDMA19_NEXT_DESC_PTR 		((void * volatile *)DMA19_NEXT_DESC_PTR)
#define pDMA19_START_ADDR 			((void * volatile *)DMA19_START_ADDR)
#define pDMA19_CONFIG 				((volatile unsigned short *)DMA19_CONFIG)
#define pDMA19_X_COUNT 				((volatile unsigned short *)DMA19_X_COUNT)
#define pDMA19_X_MODIFY 			((volatile signed   short *)DMA19_X_MODIFY)
#define pDMA19_Y_COUNT 				((volatile unsigned short *)DMA19_Y_COUNT)
#define pDMA19_Y_MODIFY 			((volatile signed   short *)DMA19_Y_MODIFY)
#define pDMA19_CURR_DESC_PTR 		((void * volatile *)DMA19_CURR_DESC_PTR)
#define pDMA19_CURR_ADDR 			((void * volatile *)DMA19_CURR_ADDR)
#define pDMA19_IRQ_STATUS 			((volatile unsigned short *)DMA19_IRQ_STATUS)
#define pDMA19_PERIPHERAL_MAP 		((volatile unsigned short *)DMA19_PERIPHERAL_MAP)
#define pDMA19_CURR_X_COUNT 		((volatile unsigned short *)DMA19_CURR_X_COUNT)
#define pDMA19_CURR_Y_COUNT 		((volatile unsigned short *)DMA19_CURR_Y_COUNT)

#define pMDMA1_D0_NEXT_DESC_PTR 	((void * volatile *)MDMA1_D0_NEXT_DESC_PTR)
#define pMDMA1_D0_START_ADDR 		((void * volatile *)MDMA1_D0_START_ADDR)
#define pMDMA1_D0_CONFIG 			((volatile unsigned short *)MDMA1_D0_CONFIG)
#define pMDMA1_D0_X_COUNT 			((volatile unsigned short *)MDMA1_D0_X_COUNT)
#define pMDMA1_D0_X_MODIFY 			((volatile signed   short *)MDMA1_D0_X_MODIFY)
#define pMDMA1_D0_Y_COUNT 			((volatile unsigned short *)MDMA1_D0_Y_COUNT)
#define pMDMA1_D0_Y_MODIFY 			((volatile signed   short *)MDMA1_D0_Y_MODIFY)
#define pMDMA1_D0_CURR_DESC_PTR 	((void * volatile *)MDMA1_D0_CURR_DESC_PTR)
#define pMDMA1_D0_CURR_ADDR 		((void * volatile *)MDMA1_D0_CURR_ADDR)
#define pMDMA1_D0_IRQ_STATUS 		((volatile unsigned short *)MDMA1_D0_IRQ_STATUS)
#define pMDMA1_D0_PERIPHERAL_MAP	((volatile unsigned short *)MDMA1_D0_PERIPHERAL_MAP)
#define pMDMA1_D0_CURR_X_COUNT 		((volatile unsigned short *)MDMA1_D0_CURR_X_COUNT)
#define pMDMA1_D0_CURR_Y_COUNT 		((volatile unsigned short *)MDMA1_D0_CURR_Y_COUNT)

#define pMDMA1_S0_NEXT_DESC_PTR 	((void * volatile *)MDMA1_S0_NEXT_DESC_PTR)
#define pMDMA1_S0_START_ADDR 		((void * volatile *)MDMA1_S0_START_ADDR)
#define pMDMA1_S0_CONFIG 			((volatile unsigned short *)MDMA1_S0_CONFIG)
#define pMDMA1_S0_X_COUNT 			((volatile unsigned short *)MDMA1_S0_X_COUNT)
#define pMDMA1_S0_X_MODIFY 			((volatile signed   short *)MDMA1_S0_X_MODIFY)
#define pMDMA1_S0_Y_COUNT 			((volatile unsigned short *)MDMA1_S0_Y_COUNT)
#define pMDMA1_S0_Y_MODIFY 			((volatile signed   short *)MDMA1_S0_Y_MODIFY)
#define pMDMA1_S0_CURR_DESC_PTR 	((void * volatile *)MDMA1_S0_CURR_DESC_PTR)
#define pMDMA1_S0_CURR_ADDR 		((void * volatile *)MDMA1_S0_CURR_ADDR)
#define pMDMA1_S0_IRQ_STATUS 		((volatile unsigned short *)MDMA1_S0_IRQ_STATUS)
#define pMDMA1_S0_PERIPHERAL_MAP	((volatile unsigned short *)MDMA1_S0_PERIPHERAL_MAP)
#define pMDMA1_S0_CURR_X_COUNT		((volatile unsigned short *)MDMA1_S0_CURR_X_COUNT)
#define pMDMA1_S0_CURR_Y_COUNT		((volatile unsigned short *)MDMA1_S0_CURR_Y_COUNT)

#define pMDMA1_D1_NEXT_DESC_PTR 	((void * volatile *)MDMA1_D1_NEXT_DESC_PTR)
#define pMDMA1_D1_START_ADDR 		((void * volatile *)MDMA1_D1_START_ADDR)
#define pMDMA1_D1_CONFIG 			((volatile unsigned short *)MDMA1_D1_CONFIG)
#define pMDMA1_D1_X_COUNT 			((volatile unsigned short *)MDMA1_D1_X_COUNT)
#define pMDMA1_D1_X_MODIFY 			((volatile signed   short *)MDMA1_D1_X_MODIFY)
#define pMDMA1_D1_Y_COUNT 			((volatile unsigned short *)MDMA1_D1_Y_COUNT)
#define pMDMA1_D1_Y_MODIFY 			((volatile signed   short *)MDMA1_D1_Y_MODIFY)
#define pMDMA1_D1_CURR_DESC_PTR 	((void * volatile *)MDMA1_D1_CURR_DESC_PTR)
#define pMDMA1_D1_CURR_ADDR 		((void * volatile *)MDMA1_D1_CURR_ADDR)
#define pMDMA1_D1_IRQ_STATUS 		((volatile unsigned short *)MDMA1_D1_IRQ_STATUS)
#define pMDMA1_D1_PERIPHERAL_MAP	((volatile unsigned short *)MDMA1_D1_PERIPHERAL_MAP)
#define pMDMA1_D1_CURR_X_COUNT 		((volatile unsigned short *)MDMA1_D1_CURR_X_COUNT)
#define pMDMA1_D1_CURR_Y_COUNT 		((volatile unsigned short *)MDMA1_D1_CURR_Y_COUNT)

#define pMDMA1_S1_NEXT_DESC_PTR 	((void * volatile *)MDMA1_S1_NEXT_DESC_PTR)
#define pMDMA1_S1_START_ADDR 		((void * volatile *)MDMA1_S1_START_ADDR)
#define pMDMA1_S1_CONFIG 			((volatile unsigned short *)MDMA1_S1_CONFIG)
#define pMDMA1_S1_X_COUNT 			((volatile unsigned short *)MDMA1_S1_X_COUNT)
#define pMDMA1_S1_X_MODIFY 			((volatile signed   short *)MDMA1_S1_X_MODIFY)
#define pMDMA1_S1_Y_COUNT 			((volatile unsigned short *)MDMA1_S1_Y_COUNT)
#define pMDMA1_S1_Y_MODIFY 			((volatile signed   short *)MDMA1_S1_Y_MODIFY)
#define pMDMA1_S1_CURR_DESC_PTR 	((void * volatile *)MDMA1_S1_CURR_DESC_PTR)
#define pMDMA1_S1_CURR_ADDR 		((void * volatile *)MDMA1_S1_CURR_ADDR)
#define pMDMA1_S1_IRQ_STATUS 		((volatile unsigned short *)MDMA1_S1_IRQ_STATUS)
#define pMDMA1_S1_PERIPHERAL_MAP	((volatile unsigned short *)MDMA1_S1_PERIPHERAL_MAP)
#define pMDMA1_S1_CURR_X_COUNT 		((volatile unsigned short *)MDMA1_S1_CURR_X_COUNT)
#define pMDMA1_S1_CURR_Y_COUNT 		((volatile unsigned short *)MDMA1_S1_CURR_Y_COUNT)


/* Parallel Peripheral Interface (PPI) */
#define pPPI_CONTROL 	((volatile unsigned short *)PPI_CONTROL)
#define pPPI_STATUS 	((volatile unsigned short *)PPI_STATUS)
#define pPPI_COUNT 		((volatile unsigned short *)PPI_COUNT)
#define pPPI_DELAY 		((volatile unsigned short *)PPI_DELAY)
#define pPPI_FRAME 		((volatile unsigned short *)PPI_FRAME)


/* Media Transceiver (MXVR)		(0xFFC02700 - 0xFFC028FF) */
#define pMXVR_CONFIG			((volatile unsigned short *)MXVR_CONFIG)
#define pMXVR_PLL_CTL_0			((volatile unsigned long  *)MXVR_PLL_CTL_0)

#define pMXVR_STATE_0			((volatile unsigned long  *)MXVR_STATE_0)
#define pMXVR_STATE_1			((volatile unsigned long  *)MXVR_STATE_1)

#define pMXVR_INT_STAT_0		((volatile unsigned long  *)MXVR_INT_STAT_0)
#define pMXVR_INT_STAT_1		((volatile unsigned long  *)MXVR_INT_STAT_1)

#define pMXVR_INT_EN_0			((volatile unsigned long  *)MXVR_INT_EN_0)
#define pMXVR_INT_EN_1			((volatile unsigned long  *)MXVR_INT_EN_1)

#define pMXVR_POSITION			((volatile unsigned short *)MXVR_POSITION)
#define pMXVR_MAX_POSITION		((volatile unsigned short *)MXVR_MAX_POSITION)

#define pMXVR_DELAY				((volatile unsigned short *)MXVR_DELAY)
#define pMXVR_MAX_DELAY			((volatile unsigned short *)MXVR_MAX_DELAY)

#define pMXVR_LADDR	 			((volatile unsigned long  *)MXVR_LADDR)
#define pMXVR_GADDR				((volatile unsigned short *)MXVR_GADDR)
#define pMXVR_AADDR				((volatile unsigned long  *)MXVR_AADDR)

#define pMXVR_ALLOC_0			((volatile unsigned long  *)MXVR_ALLOC_0)
#define pMXVR_ALLOC_1			((volatile unsigned long  *)MXVR_ALLOC_1)
#define pMXVR_ALLOC_2			((volatile unsigned long  *)MXVR_ALLOC_2)
#define pMXVR_ALLOC_3			((volatile unsigned long  *)MXVR_ALLOC_3)
#define pMXVR_ALLOC_4			((volatile unsigned long  *)MXVR_ALLOC_4)
#define pMXVR_ALLOC_5			((volatile unsigned long  *)MXVR_ALLOC_5)
#define pMXVR_ALLOC_6			((volatile unsigned long  *)MXVR_ALLOC_6)
#define pMXVR_ALLOC_7			((volatile unsigned long  *)MXVR_ALLOC_7)
#define pMXVR_ALLOC_8			((volatile unsigned long  *)MXVR_ALLOC_8)
#define pMXVR_ALLOC_9			((volatile unsigned long  *)MXVR_ALLOC_9)
#define pMXVR_ALLOC_10			((volatile unsigned long  *)MXVR_ALLOC_10)
#define pMXVR_ALLOC_11			((volatile unsigned long  *)MXVR_ALLOC_11)
#define pMXVR_ALLOC_12			((volatile unsigned long  *)MXVR_ALLOC_12)
#define pMXVR_ALLOC_13			((volatile unsigned long  *)MXVR_ALLOC_13)
#define pMXVR_ALLOC_14			((volatile unsigned long  *)MXVR_ALLOC_14)

#define pMXVR_SYNC_LCHAN_0		((volatile unsigned long  *)MXVR_SYNC_LCHAN_0)
#define pMXVR_SYNC_LCHAN_1		((volatile unsigned long  *)MXVR_SYNC_LCHAN_1)
#define pMXVR_SYNC_LCHAN_2		((volatile unsigned long  *)MXVR_SYNC_LCHAN_2)
#define pMXVR_SYNC_LCHAN_3		((volatile unsigned long  *)MXVR_SYNC_LCHAN_3)
#define pMXVR_SYNC_LCHAN_4		((volatile unsigned long  *)MXVR_SYNC_LCHAN_4)
#define pMXVR_SYNC_LCHAN_5		((volatile unsigned long  *)MXVR_SYNC_LCHAN_5)
#define pMXVR_SYNC_LCHAN_6		((volatile unsigned long  *)MXVR_SYNC_LCHAN_6)
#define pMXVR_SYNC_LCHAN_7		((volatile unsigned long  *)MXVR_SYNC_LCHAN_7)

#define pMXVR_DMA0_CONFIG		((volatile unsigned long  *)MXVR_DMA0_CONFIG)
#define pMXVR_DMA0_START_ADDR	((void * volatile *)MXVR_DMA0_START_ADDR)
#define pMXVR_DMA0_COUNT		((volatile unsigned short *)MXVR_DMA0_COUNT)
#define pMXVR_DMA0_CURR_ADDR	((void * volatile *)MXVR_DMA0_CURR_ADDR)
#define pMXVR_DMA0_CURR_COUNT	((volatile unsigned short *)MXVR_DMA0_CURR_COUNT)

#define pMXVR_DMA1_CONFIG		((volatile unsigned long  *)MXVR_DMA1_CONFIG)
#define pMXVR_DMA1_START_ADDR	((void * volatile *)MXVR_DMA1_START_ADDR)
#define pMXVR_DMA1_COUNT		((volatile unsigned short *)MXVR_DMA1_COUNT)
#define pMXVR_DMA1_CURR_ADDR	((void * volatile *)MXVR_DMA1_CURR_ADDR)
#define pMXVR_DMA1_CURR_COUNT	((volatile unsigned short *)MXVR_DMA1_CURR_COUNT)

#define pMXVR_DMA2_CONFIG		((volatile unsigned long  *)MXVR_DMA2_CONFIG)
#define pMXVR_DMA2_START_ADDR	((void * volatile *)MXVR_DMA2_START_ADDR)
#define pMXVR_DMA2_COUNT		((volatile unsigned short *)MXVR_DMA2_COUNT)
#define pMXVR_DMA2_CURR_ADDR	((void * volatile *)MXVR_DMA2_CURR_ADDR)
#define pMXVR_DMA2_CURR_COUNT	((volatile unsigned short *)MXVR_DMA2_CURR_COUNT)

#define pMXVR_DMA3_CONFIG		((volatile unsigned long  *)MXVR_DMA3_CONFIG)
#define pMXVR_DMA3_START_ADDR	((void * volatile *)MXVR_DMA3_START_ADDR)
#define pMXVR_DMA3_COUNT		((volatile unsigned short *)MXVR_DMA3_COUNT)
#define pMXVR_DMA3_CURR_ADDR	((void * volatile *)MXVR_DMA3_CURR_ADDR)
#define pMXVR_DMA3_CURR_COUNT	((volatile unsigned short *)MXVR_DMA3_CURR_COUNT)

#define pMXVR_DMA4_CONFIG		((volatile unsigned long  *)MXVR_DMA4_CONFIG)
#define pMXVR_DMA4_START_ADDR	((void * volatile *)MXVR_DMA4_START_ADDR)
#define pMXVR_DMA4_COUNT		((volatile unsigned short *)MXVR_DMA4_COUNT)
#define pMXVR_DMA4_CURR_ADDR	((void * volatile *)MXVR_DMA4_CURR_ADDR)
#define pMXVR_DMA4_CURR_COUNT	((volatile unsigned short *)MXVR_DMA4_CURR_COUNT)

#define pMXVR_DMA5_CONFIG		((volatile unsigned long  *)MXVR_DMA5_CONFIG)
#define pMXVR_DMA5_START_ADDR	((void * volatile *)MXVR_DMA5_START_ADDR)
#define pMXVR_DMA5_COUNT		((volatile unsigned short *)MXVR_DMA5_COUNT)
#define pMXVR_DMA5_CURR_ADDR	((void * volatile *)MXVR_DMA5_CURR_ADDR)
#define pMXVR_DMA5_CURR_COUNT	((volatile unsigned short *)MXVR_DMA5_CURR_COUNT)

#define pMXVR_DMA6_CONFIG		((volatile unsigned long  *)MXVR_DMA6_CONFIG)
#define pMXVR_DMA6_START_ADDR	((void * volatile *)MXVR_DMA6_START_ADDR)
#define pMXVR_DMA6_COUNT		((volatile unsigned short *)MXVR_DMA6_COUNT)
#define pMXVR_DMA6_CURR_ADDR	((void * volatile *)MXVR_DMA6_CURR_ADDR)
#define pMXVR_DMA6_CURR_COUNT	((volatile unsigned short *)MXVR_DMA6_CURR_COUNT)

#define pMXVR_DMA7_CONFIG		((volatile unsigned long  *)MXVR_DMA7_CONFIG)
#define pMXVR_DMA7_START_ADDR	((void * volatile *)MXVR_DMA7_START_ADDR)
#define pMXVR_DMA7_COUNT		((volatile unsigned short *)MXVR_DMA7_COUNT)
#define pMXVR_DMA7_CURR_ADDR	((void * volatile *)MXVR_DMA7_CURR_ADDR)
#define pMXVR_DMA7_CURR_COUNT	((volatile unsigned short *)MXVR_DMA7_CURR_COUNT)

#define pMXVR_AP_CTL			((volatile unsigned short *)MXVR_AP_CTL)
#define pMXVR_APRB_START_ADDR	((void * volatile *)MXVR_APRB_START_ADDR)
#define pMXVR_APRB_CURR_ADDR	((void * volatile *)MXVR_APRB_CURR_ADDR)
#define pMXVR_APTB_START_ADDR	((void * volatile *)MXVR_APTB_START_ADDR)
#define pMXVR_APTB_CURR_ADDR	((void * volatile *)MXVR_APTB_CURR_ADDR)

#define pMXVR_CM_CTL			((volatile unsigned long  *)MXVR_CM_CTL)
#define pMXVR_CMRB_START_ADDR	((void * volatile *)MXVR_CMRB_START_ADDR)
#define pMXVR_CMRB_CURR_ADDR	((void * volatile *)MXVR_CMRB_CURR_ADDR)
#define pMXVR_CMTB_START_ADDR	((void * volatile *)MXVR_CMTB_START_ADDR)
#define pMXVR_CMTB_CURR_ADDR	((void * volatile *)MXVR_CMTB_CURR_ADDR)

#define pMXVR_RRDB_START_ADDR	((void * volatile *)MXVR_RRDB_START_ADDR)
#define pMXVR_RRDB_CURR_ADDR	((void * volatile *)MXVR_RRDB_CURR_ADDR)

#define pMXVR_PAT_DATA_0		((volatile unsigned long  *)MXVR_PAT_DATA_0)
#define pMXVR_PAT_EN_0			((volatile unsigned long  *)MXVR_PAT_EN_0)
#define pMXVR_PAT_DATA_1		((volatile unsigned long  *)MXVR_PAT_DATA_1)
#define pMXVR_PAT_EN_1			((volatile unsigned long  *)MXVR_PAT_EN_1)

#define pMXVR_FRAME_CNT_0		((volatile unsigned short *)MXVR_FRAME_CNT_0)
#define pMXVR_FRAME_CNT_1		((volatile unsigned short *)MXVR_FRAME_CNT_1)

#define pMXVR_ROUTING_0			((volatile unsigned long  *)MXVR_ROUTING_0)
#define pMXVR_ROUTING_1			((volatile unsigned long  *)MXVR_ROUTING_1)
#define pMXVR_ROUTING_2			((volatile unsigned long  *)MXVR_ROUTING_2)
#define pMXVR_ROUTING_3			((volatile unsigned long  *)MXVR_ROUTING_3)
#define pMXVR_ROUTING_4			((volatile unsigned long  *)MXVR_ROUTING_4)
#define pMXVR_ROUTING_5			((volatile unsigned long  *)MXVR_ROUTING_5)
#define pMXVR_ROUTING_6			((volatile unsigned long  *)MXVR_ROUTING_6)
#define pMXVR_ROUTING_7			((volatile unsigned long  *)MXVR_ROUTING_7)
#define pMXVR_ROUTING_8			((volatile unsigned long  *)MXVR_ROUTING_8)
#define pMXVR_ROUTING_9			((volatile unsigned long  *)MXVR_ROUTING_9)
#define pMXVR_ROUTING_10		((volatile unsigned long  *)MXVR_ROUTING_10)
#define pMXVR_ROUTING_11		((volatile unsigned long  *)MXVR_ROUTING_11)
#define pMXVR_ROUTING_12		((volatile unsigned long  *)MXVR_ROUTING_12)
#define pMXVR_ROUTING_13		((volatile unsigned long  *)MXVR_ROUTING_13)
#define pMXVR_ROUTING_14		((volatile unsigned long  *)MXVR_ROUTING_14)

#define pMXVR_PLL_CTL_1			((volatile unsigned long  *)MXVR_PLL_CTL_1)
#define pMXVR_PLL_CTL_2			((volatile unsigned short *)MXVR_PLL_CTL_2)

#define pMXVR_BLOCK_CNT			((volatile unsigned short *)MXVR_BLOCK_CNT)


/* CAN Controller						*/
/* For Mailboxes 0-15													*/
#define pCAN_MC1			((volatile unsigned short *)CAN_MC1)
#define pCAN_MD1			((volatile unsigned short *)CAN_MD1)
#define pCAN_TRS1			((volatile unsigned short *)CAN_TRS1)
#define pCAN_TRR1			((volatile unsigned short *)CAN_TRR1)
#define pCAN_TA1			((volatile unsigned short *)CAN_TA1)
#define pCAN_AA1			((volatile unsigned short *)CAN_AA1)
#define pCAN_RMP1			((volatile unsigned short *)CAN_RMP1)
#define pCAN_RML1			((volatile unsigned short *)CAN_RML1)
#define pCAN_MBTIF1			((volatile unsigned short *)CAN_MBTIF1)
#define pCAN_MBRIF1			((volatile unsigned short *)CAN_MBRIF1)
#define pCAN_MBIM1			((volatile unsigned short *)CAN_MBIM1)
#define pCAN_RFH1			((volatile unsigned short *)CAN_RFH1)
#define pCAN_OPSS1			((volatile unsigned short *)CAN_OPSS1)

/* For Mailboxes 16-31   												*/
#define pCAN_MC2			((volatile unsigned short *)CAN_MC2)
#define pCAN_MD2			((volatile unsigned short *)CAN_MD2)
#define pCAN_TRS2			((volatile unsigned short *)CAN_TRS2)
#define pCAN_TRR2			((volatile unsigned short *)CAN_TRR2)
#define pCAN_TA2			((volatile unsigned short *)CAN_TA2)
#define pCAN_AA2			((volatile unsigned short *)CAN_AA2)
#define pCAN_RMP2			((volatile unsigned short *)CAN_RMP2)
#define pCAN_RML2			((volatile unsigned short *)CAN_RML2)
#define pCAN_MBTIF2			((volatile unsigned short *)CAN_MBTIF2)
#define pCAN_MBRIF2			((volatile unsigned short *)CAN_MBRIF2)
#define pCAN_MBIM2			((volatile unsigned short *)CAN_MBIM2)
#define pCAN_RFH2			((volatile unsigned short *)CAN_RFH2)
#define pCAN_OPSS2			((volatile unsigned short *)CAN_OPSS2)

#define pCAN_CLOCK			((volatile unsigned short *)CAN_CLOCK)
#define pCAN_TIMING			((volatile unsigned short *)CAN_TIMING)
#define pCAN_DEBUG			((volatile unsigned short *)CAN_DEBUG)
#define pCAN_STATUS			((volatile unsigned short *)CAN_STATUS)
#define pCAN_CEC			((volatile unsigned short *)CAN_CEC)
#define pCAN_GIS			((volatile unsigned short *)CAN_GIS)
#define pCAN_GIM			((volatile unsigned short *)CAN_GIM)
#define pCAN_GIF			((volatile unsigned short *)CAN_GIF)
#define pCAN_CONTROL		((volatile unsigned short *)CAN_CONTROL)
#define pCAN_INTR			((volatile unsigned short *)CAN_INTR)
#define pCAN_MBTD			((volatile unsigned short *)CAN_MBTD)
#define pCAN_EWR			((volatile unsigned short *)CAN_EWR)
#define pCAN_ESR			((volatile unsigned short *)CAN_ESR)
#define pCAN_UCREG			((volatile unsigned short *)CAN_UCREG)
#define pCAN_UCCNT			((volatile unsigned short *)CAN_UCCNT)
#define pCAN_UCRC			((volatile unsigned short *)CAN_UCRC)
#define pCAN_UCCNF			((volatile unsigned short *)CAN_UCCNF)

/* Mailbox Acceptance Masks 											*/
#define pCAN_AM00L			((volatile unsigned short *)CAN_AM00L)
#define pCAN_AM00H			((volatile unsigned short *)CAN_AM00H)
#define pCAN_AM01L			((volatile unsigned short *)CAN_AM01L)
#define pCAN_AM01H			((volatile unsigned short *)CAN_AM01H)
#define pCAN_AM02L			((volatile unsigned short *)CAN_AM02L)
#define pCAN_AM02H			((volatile unsigned short *)CAN_AM02H)
#define pCAN_AM03L			((volatile unsigned short *)CAN_AM03L)
#define pCAN_AM03H			((volatile unsigned short *)CAN_AM03H)
#define pCAN_AM04L			((volatile unsigned short *)CAN_AM04L)
#define pCAN_AM04H			((volatile unsigned short *)CAN_AM04H)
#define pCAN_AM05L			((volatile unsigned short *)CAN_AM05L)
#define pCAN_AM05H			((volatile unsigned short *)CAN_AM05H)
#define pCAN_AM06L			((volatile unsigned short *)CAN_AM06L)
#define pCAN_AM06H			((volatile unsigned short *)CAN_AM06H)
#define pCAN_AM07L			((volatile unsigned short *)CAN_AM07L)
#define pCAN_AM07H			((volatile unsigned short *)CAN_AM07H)
#define pCAN_AM08L			((volatile unsigned short *)CAN_AM08L)
#define pCAN_AM08H			((volatile unsigned short *)CAN_AM08H)
#define pCAN_AM09L			((volatile unsigned short *)CAN_AM09L)
#define pCAN_AM09H			((volatile unsigned short *)CAN_AM09H)
#define pCAN_AM10L			((volatile unsigned short *)CAN_AM10L)
#define pCAN_AM10H			((volatile unsigned short *)CAN_AM10H)
#define pCAN_AM11L			((volatile unsigned short *)CAN_AM11L)
#define pCAN_AM11H			((volatile unsigned short *)CAN_AM11H)
#define pCAN_AM12L			((volatile unsigned short *)CAN_AM12L)
#define pCAN_AM12H			((volatile unsigned short *)CAN_AM12H)
#define pCAN_AM13L			((volatile unsigned short *)CAN_AM13L)
#define pCAN_AM13H			((volatile unsigned short *)CAN_AM13H)
#define pCAN_AM14L			((volatile unsigned short *)CAN_AM14L)
#define pCAN_AM14H			((volatile unsigned short *)CAN_AM14H)
#define pCAN_AM15L			((volatile unsigned short *)CAN_AM15L)
#define pCAN_AM15H			((volatile unsigned short *)CAN_AM15H)

#define pCAN_AM16L			((volatile unsigned short *)CAN_AM16L)
#define pCAN_AM16H			((volatile unsigned short *)CAN_AM16H)
#define pCAN_AM17L			((volatile unsigned short *)CAN_AM17L)
#define pCAN_AM17H			((volatile unsigned short *)CAN_AM17H)
#define pCAN_AM18L			((volatile unsigned short *)CAN_AM18L)
#define pCAN_AM18H			((volatile unsigned short *)CAN_AM18H)
#define pCAN_AM19L			((volatile unsigned short *)CAN_AM19L)
#define pCAN_AM19H			((volatile unsigned short *)CAN_AM19H)
#define pCAN_AM20L			((volatile unsigned short *)CAN_AM20L)
#define pCAN_AM20H			((volatile unsigned short *)CAN_AM20H)
#define pCAN_AM21L			((volatile unsigned short *)CAN_AM21L)
#define pCAN_AM21H			((volatile unsigned short *)CAN_AM21H)
#define pCAN_AM22L			((volatile unsigned short *)CAN_AM22L)
#define pCAN_AM22H			((volatile unsigned short *)CAN_AM22H)
#define pCAN_AM23L			((volatile unsigned short *)CAN_AM23L)
#define pCAN_AM23H			((volatile unsigned short *)CAN_AM23H)
#define pCAN_AM24L			((volatile unsigned short *)CAN_AM24L)
#define pCAN_AM24H			((volatile unsigned short *)CAN_AM24H)
#define pCAN_AM25L			((volatile unsigned short *)CAN_AM25L)
#define pCAN_AM25H			((volatile unsigned short *)CAN_AM25H)
#define pCAN_AM26L			((volatile unsigned short *)CAN_AM26L)
#define pCAN_AM26H			((volatile unsigned short *)CAN_AM26H)
#define pCAN_AM27L			((volatile unsigned short *)CAN_AM27L)
#define pCAN_AM27H			((volatile unsigned short *)CAN_AM27H)
#define pCAN_AM28L			((volatile unsigned short *)CAN_AM28L)
#define pCAN_AM28H			((volatile unsigned short *)CAN_AM28H)
#define pCAN_AM29L			((volatile unsigned short *)CAN_AM29L)
#define pCAN_AM29H			((volatile unsigned short *)CAN_AM29H)
#define pCAN_AM30L			((volatile unsigned short *)CAN_AM30L)
#define pCAN_AM30H			((volatile unsigned short *)CAN_AM30H)
#define pCAN_AM31L			((volatile unsigned short *)CAN_AM31L)
#define pCAN_AM31H			((volatile unsigned short *)CAN_AM31H)

/* CAN Acceptance Mask Area Macros	*/
#define pCAN_AM_L(x)		((volatile unsigned short *)CAN_AM_L(x))
#define pCAN_AM_H(x)		((volatile unsigned short *)CAN_AM_H(x))

/* Mailbox Registers														*/
#define pCAN_MB00_DATA0		((volatile unsigned short *)CAN_MB00_DATA0)
#define pCAN_MB00_DATA1		((volatile unsigned short *)CAN_MB00_DATA1)
#define pCAN_MB00_DATA2		((volatile unsigned short *)CAN_MB00_DATA2)
#define pCAN_MB00_DATA3		((volatile unsigned short *)CAN_MB00_DATA3)
#define pCAN_MB00_LENGTH	((volatile unsigned short *)CAN_MB00_LENGTH)
#define pCAN_MB00_TIMESTAMP	((volatile unsigned short *)CAN_MB00_TIMESTAMP)
#define pCAN_MB00_ID0		((volatile unsigned short *)CAN_MB00_ID0)
#define pCAN_MB00_ID1		((volatile unsigned short *)CAN_MB00_ID1)

#define pCAN_MB01_DATA0		((volatile unsigned short *)CAN_MB01_DATA0)
#define pCAN_MB01_DATA1		((volatile unsigned short *)CAN_MB01_DATA1)
#define pCAN_MB01_DATA2		((volatile unsigned short *)CAN_MB01_DATA2)
#define pCAN_MB01_DATA3		((volatile unsigned short *)CAN_MB01_DATA3)
#define pCAN_MB01_LENGTH	((volatile unsigned short *)CAN_MB01_LENGTH)
#define pCAN_MB01_TIMESTAMP	((volatile unsigned short *)CAN_MB01_TIMESTAMP)
#define pCAN_MB01_ID0		((volatile unsigned short *)CAN_MB01_ID0)
#define pCAN_MB01_ID1		((volatile unsigned short *)CAN_MB01_ID1)

#define pCAN_MB02_DATA0		((volatile unsigned short *)CAN_MB02_DATA0)
#define pCAN_MB02_DATA1		((volatile unsigned short *)CAN_MB02_DATA1)
#define pCAN_MB02_DATA2		((volatile unsigned short *)CAN_MB02_DATA2)
#define pCAN_MB02_DATA3		((volatile unsigned short *)CAN_MB02_DATA3)
#define pCAN_MB02_LENGTH	((volatile unsigned short *)CAN_MB02_LENGTH)
#define pCAN_MB02_TIMESTAMP	((volatile unsigned short *)CAN_MB02_TIMESTAMP)
#define pCAN_MB02_ID0		((volatile unsigned short *)CAN_MB02_ID0)
#define pCAN_MB02_ID1		((volatile unsigned short *)CAN_MB02_ID1)

#define pCAN_MB03_DATA0		((volatile unsigned short *)CAN_MB03_DATA0)
#define pCAN_MB03_DATA1		((volatile unsigned short *)CAN_MB03_DATA1)
#define pCAN_MB03_DATA2		((volatile unsigned short *)CAN_MB03_DATA2)
#define pCAN_MB03_DATA3		((volatile unsigned short *)CAN_MB03_DATA3)
#define pCAN_MB03_LENGTH	((volatile unsigned short *)CAN_MB03_LENGTH)
#define pCAN_MB03_TIMESTAMP	((volatile unsigned short *)CAN_MB03_TIMESTAMP)
#define pCAN_MB03_ID0		((volatile unsigned short *)CAN_MB03_ID0)
#define pCAN_MB03_ID1		((volatile unsigned short *)CAN_MB03_ID1)

#define pCAN_MB04_DATA0		((volatile unsigned short *)CAN_MB04_DATA0)
#define pCAN_MB04_DATA1		((volatile unsigned short *)CAN_MB04_DATA1)
#define pCAN_MB04_DATA2		((volatile unsigned short *)CAN_MB04_DATA2)
#define pCAN_MB04_DATA3		((volatile unsigned short *)CAN_MB04_DATA3)
#define pCAN_MB04_LENGTH	((volatile unsigned short *)CAN_MB04_LENGTH)
#define pCAN_MB04_TIMESTAMP	((volatile unsigned short *)CAN_MB04_TIMESTAMP)
#define pCAN_MB04_ID0		((volatile unsigned short *)CAN_MB04_ID0)
#define pCAN_MB04_ID1		((volatile unsigned short *)CAN_MB04_ID1)

#define pCAN_MB05_DATA0		((volatile unsigned short *)CAN_MB05_DATA0)
#define pCAN_MB05_DATA1		((volatile unsigned short *)CAN_MB05_DATA1)
#define pCAN_MB05_DATA2		((volatile unsigned short *)CAN_MB05_DATA2)
#define pCAN_MB05_DATA3		((volatile unsigned short *)CAN_MB05_DATA3)
#define pCAN_MB05_LENGTH	((volatile unsigned short *)CAN_MB05_LENGTH)
#define pCAN_MB05_TIMESTAMP	((volatile unsigned short *)CAN_MB05_TIMESTAMP)
#define pCAN_MB05_ID0		((volatile unsigned short *)CAN_MB05_ID0)
#define pCAN_MB05_ID1		((volatile unsigned short *)CAN_MB05_ID1)

#define pCAN_MB06_DATA0		((volatile unsigned short *)CAN_MB06_DATA0)
#define pCAN_MB06_DATA1		((volatile unsigned short *)CAN_MB06_DATA1)
#define pCAN_MB06_DATA2		((volatile unsigned short *)CAN_MB06_DATA2)
#define pCAN_MB06_DATA3		((volatile unsigned short *)CAN_MB06_DATA3)
#define pCAN_MB06_LENGTH	((volatile unsigned short *)CAN_MB06_LENGTH)
#define pCAN_MB06_TIMESTAMP	((volatile unsigned short *)CAN_MB06_TIMESTAMP)
#define pCAN_MB06_ID0		((volatile unsigned short *)CAN_MB06_ID0)
#define pCAN_MB06_ID1		((volatile unsigned short *)CAN_MB06_ID1)

#define pCAN_MB07_DATA0		((volatile unsigned short *)CAN_MB07_DATA0)
#define pCAN_MB07_DATA1		((volatile unsigned short *)CAN_MB07_DATA1)
#define pCAN_MB07_DATA2		((volatile unsigned short *)CAN_MB07_DATA2)
#define pCAN_MB07_DATA3		((volatile unsigned short *)CAN_MB07_DATA3)
#define pCAN_MB07_LENGTH	((volatile unsigned short *)CAN_MB07_LENGTH)
#define pCAN_MB07_TIMESTAMP	((volatile unsigned short *)CAN_MB07_TIMESTAMP)
#define pCAN_MB07_ID0		((volatile unsigned short *)CAN_MB07_ID0)
#define pCAN_MB07_ID1		((volatile unsigned short *)CAN_MB07_ID1)

#define pCAN_MB08_DATA0		((volatile unsigned short *)CAN_MB08_DATA0)
#define pCAN_MB08_DATA1		((volatile unsigned short *)CAN_MB08_DATA1)
#define pCAN_MB08_DATA2		((volatile unsigned short *)CAN_MB08_DATA2)
#define pCAN_MB08_DATA3		((volatile unsigned short *)CAN_MB08_DATA3)
#define pCAN_MB08_LENGTH	((volatile unsigned short *)CAN_MB08_LENGTH)
#define pCAN_MB08_TIMESTAMP	((volatile unsigned short *)CAN_MB08_TIMESTAMP)
#define pCAN_MB08_ID0		((volatile unsigned short *)CAN_MB08_ID0)
#define pCAN_MB08_ID1		((volatile unsigned short *)CAN_MB08_ID1)

#define pCAN_MB09_DATA0		((volatile unsigned short *)CAN_MB09_DATA0)
#define pCAN_MB09_DATA1		((volatile unsigned short *)CAN_MB09_DATA1)
#define pCAN_MB09_DATA2		((volatile unsigned short *)CAN_MB09_DATA2)
#define pCAN_MB09_DATA3		((volatile unsigned short *)CAN_MB09_DATA3)
#define pCAN_MB09_LENGTH	((volatile unsigned short *)CAN_MB09_LENGTH)
#define pCAN_MB09_TIMESTAMP	((volatile unsigned short *)CAN_MB09_TIMESTAMP)
#define pCAN_MB09_ID0		((volatile unsigned short *)CAN_MB09_ID0)
#define pCAN_MB09_ID1		((volatile unsigned short *)CAN_MB09_ID1)

#define pCAN_MB10_DATA0		((volatile unsigned short *)CAN_MB10_DATA0)
#define pCAN_MB10_DATA1		((volatile unsigned short *)CAN_MB10_DATA1)
#define pCAN_MB10_DATA2		((volatile unsigned short *)CAN_MB10_DATA2)
#define pCAN_MB10_DATA3		((volatile unsigned short *)CAN_MB10_DATA3)
#define pCAN_MB10_LENGTH	((volatile unsigned short *)CAN_MB10_LENGTH)
#define pCAN_MB10_TIMESTAMP	((volatile unsigned short *)CAN_MB10_TIMESTAMP)
#define pCAN_MB10_ID0		((volatile unsigned short *)CAN_MB10_ID0)
#define pCAN_MB10_ID1		((volatile unsigned short *)CAN_MB10_ID1)

#define pCAN_MB11_DATA0		((volatile unsigned short *)CAN_MB11_DATA0)
#define pCAN_MB11_DATA1		((volatile unsigned short *)CAN_MB11_DATA1)
#define pCAN_MB11_DATA2		((volatile unsigned short *)CAN_MB11_DATA2)
#define pCAN_MB11_DATA3		((volatile unsigned short *)CAN_MB11_DATA3)
#define pCAN_MB11_LENGTH	((volatile unsigned short *)CAN_MB11_LENGTH)
#define pCAN_MB11_TIMESTAMP	((volatile unsigned short *)CAN_MB11_TIMESTAMP)
#define pCAN_MB11_ID0		((volatile unsigned short *)CAN_MB11_ID0)
#define pCAN_MB11_ID1		((volatile unsigned short *)CAN_MB11_ID1)

#define pCAN_MB12_DATA0		((volatile unsigned short *)CAN_MB12_DATA0)
#define pCAN_MB12_DATA1		((volatile unsigned short *)CAN_MB12_DATA1)
#define pCAN_MB12_DATA2		((volatile unsigned short *)CAN_MB12_DATA2)
#define pCAN_MB12_DATA3		((volatile unsigned short *)CAN_MB12_DATA3)
#define pCAN_MB12_LENGTH	((volatile unsigned short *)CAN_MB12_LENGTH)
#define pCAN_MB12_TIMESTAMP	((volatile unsigned short *)CAN_MB12_TIMESTAMP)
#define pCAN_MB12_ID0		((volatile unsigned short *)CAN_MB12_ID0)
#define pCAN_MB12_ID1		((volatile unsigned short *)CAN_MB12_ID1)

#define pCAN_MB13_DATA0		((volatile unsigned short *)CAN_MB13_DATA0)
#define pCAN_MB13_DATA1		((volatile unsigned short *)CAN_MB13_DATA1)
#define pCAN_MB13_DATA2		((volatile unsigned short *)CAN_MB13_DATA2)
#define pCAN_MB13_DATA3		((volatile unsigned short *)CAN_MB13_DATA3)
#define pCAN_MB13_LENGTH	((volatile unsigned short *)CAN_MB13_LENGTH)
#define pCAN_MB13_TIMESTAMP	((volatile unsigned short *)CAN_MB13_TIMESTAMP)
#define pCAN_MB13_ID0		((volatile unsigned short *)CAN_MB13_ID0)
#define pCAN_MB13_ID1		((volatile unsigned short *)CAN_MB13_ID1)

#define pCAN_MB14_DATA0		((volatile unsigned short *)CAN_MB14_DATA0)
#define pCAN_MB14_DATA1		((volatile unsigned short *)CAN_MB14_DATA1)
#define pCAN_MB14_DATA2		((volatile unsigned short *)CAN_MB14_DATA2)
#define pCAN_MB14_DATA3		((volatile unsigned short *)CAN_MB14_DATA3)
#define pCAN_MB14_LENGTH	((volatile unsigned short *)CAN_MB14_LENGTH)
#define pCAN_MB14_TIMESTAMP	((volatile unsigned short *)CAN_MB14_TIMESTAMP)
#define pCAN_MB14_ID0		((volatile unsigned short *)CAN_MB14_ID0)
#define pCAN_MB14_ID1		((volatile unsigned short *)CAN_MB14_ID1)

#define pCAN_MB15_DATA0		((volatile unsigned short *)CAN_MB15_DATA0)
#define pCAN_MB15_DATA1		((volatile unsigned short *)CAN_MB15_DATA1)
#define pCAN_MB15_DATA2		((volatile unsigned short *)CAN_MB15_DATA2)
#define pCAN_MB15_DATA3		((volatile unsigned short *)CAN_MB15_DATA3)
#define pCAN_MB15_LENGTH	((volatile unsigned short *)CAN_MB15_LENGTH)
#define pCAN_MB15_TIMESTAMP	((volatile unsigned short *)CAN_MB15_TIMESTAMP)
#define pCAN_MB15_ID0		((volatile unsigned short *)CAN_MB15_ID0)
#define pCAN_MB15_ID1		((volatile unsigned short *)CAN_MB15_ID1)

#define pCAN_MB16_DATA0		((volatile unsigned short *)CAN_MB16_DATA0)
#define pCAN_MB16_DATA1		((volatile unsigned short *)CAN_MB16_DATA1)
#define pCAN_MB16_DATA2		((volatile unsigned short *)CAN_MB16_DATA2)
#define pCAN_MB16_DATA3		((volatile unsigned short *)CAN_MB16_DATA3)
#define pCAN_MB16_LENGTH	((volatile unsigned short *)CAN_MB16_LENGTH)
#define pCAN_MB16_TIMESTAMP	((volatile unsigned short *)CAN_MB16_TIMESTAMP)
#define pCAN_MB16_ID0		((volatile unsigned short *)CAN_MB16_ID0)
#define pCAN_MB16_ID1		((volatile unsigned short *)CAN_MB16_ID1)

#define pCAN_MB17_DATA0		((volatile unsigned short *)CAN_MB17_DATA0)
#define pCAN_MB17_DATA1		((volatile unsigned short *)CAN_MB17_DATA1)
#define pCAN_MB17_DATA2		((volatile unsigned short *)CAN_MB17_DATA2)
#define pCAN_MB17_DATA3		((volatile unsigned short *)CAN_MB17_DATA3)
#define pCAN_MB17_LENGTH	((volatile unsigned short *)CAN_MB17_LENGTH)
#define pCAN_MB17_TIMESTAMP	((volatile unsigned short *)CAN_MB17_TIMESTAMP)
#define pCAN_MB17_ID0		((volatile unsigned short *)CAN_MB17_ID0)
#define pCAN_MB17_ID1		((volatile unsigned short *)CAN_MB17_ID1)

#define pCAN_MB18_DATA0		((volatile unsigned short *)CAN_MB18_DATA0)
#define pCAN_MB18_DATA1		((volatile unsigned short *)CAN_MB18_DATA1)
#define pCAN_MB18_DATA2		((volatile unsigned short *)CAN_MB18_DATA2)
#define pCAN_MB18_DATA3		((volatile unsigned short *)CAN_MB18_DATA3)
#define pCAN_MB18_LENGTH	((volatile unsigned short *)CAN_MB18_LENGTH)
#define pCAN_MB18_TIMESTAMP	((volatile unsigned short *)CAN_MB18_TIMESTAMP)
#define pCAN_MB18_ID0		((volatile unsigned short *)CAN_MB18_ID0)
#define pCAN_MB18_ID1		((volatile unsigned short *)CAN_MB18_ID1)

#define pCAN_MB19_DATA0		((volatile unsigned short *)CAN_MB19_DATA0)
#define pCAN_MB19_DATA1		((volatile unsigned short *)CAN_MB19_DATA1)
#define pCAN_MB19_DATA2		((volatile unsigned short *)CAN_MB19_DATA2)
#define pCAN_MB19_DATA3		((volatile unsigned short *)CAN_MB19_DATA3)
#define pCAN_MB19_LENGTH	((volatile unsigned short *)CAN_MB19_LENGTH)
#define pCAN_MB19_TIMESTAMP	((volatile unsigned short *)CAN_MB19_TIMESTAMP)
#define pCAN_MB19_ID0		((volatile unsigned short *)CAN_MB19_ID0)
#define pCAN_MB19_ID1		((volatile unsigned short *)CAN_MB19_ID1)

#define pCAN_MB20_DATA0		((volatile unsigned short *)CAN_MB20_DATA0)
#define pCAN_MB20_DATA1		((volatile unsigned short *)CAN_MB20_DATA1)
#define pCAN_MB20_DATA2		((volatile unsigned short *)CAN_MB20_DATA2)
#define pCAN_MB20_DATA3		((volatile unsigned short *)CAN_MB20_DATA3)
#define pCAN_MB20_LENGTH	((volatile unsigned short *)CAN_MB20_LENGTH)
#define pCAN_MB20_TIMESTAMP	((volatile unsigned short *)CAN_MB20_TIMESTAMP)
#define pCAN_MB20_ID0		((volatile unsigned short *)CAN_MB20_ID0)
#define pCAN_MB20_ID1		((volatile unsigned short *)CAN_MB20_ID1)

#define pCAN_MB21_DATA0		((volatile unsigned short *)CAN_MB21_DATA0)
#define pCAN_MB21_DATA1		((volatile unsigned short *)CAN_MB21_DATA1)
#define pCAN_MB21_DATA2		((volatile unsigned short *)CAN_MB21_DATA2)
#define pCAN_MB21_DATA3		((volatile unsigned short *)CAN_MB21_DATA3)
#define pCAN_MB21_LENGTH	((volatile unsigned short *)CAN_MB21_LENGTH)
#define pCAN_MB21_TIMESTAMP	((volatile unsigned short *)CAN_MB21_TIMESTAMP)
#define pCAN_MB21_ID0		((volatile unsigned short *)CAN_MB21_ID0)
#define pCAN_MB21_ID1		((volatile unsigned short *)CAN_MB21_ID1)

#define pCAN_MB22_DATA0		((volatile unsigned short *)CAN_MB22_DATA0)
#define pCAN_MB22_DATA1		((volatile unsigned short *)CAN_MB22_DATA1)
#define pCAN_MB22_DATA2		((volatile unsigned short *)CAN_MB22_DATA2)
#define pCAN_MB22_DATA3		((volatile unsigned short *)CAN_MB22_DATA3)
#define pCAN_MB22_LENGTH	((volatile unsigned short *)CAN_MB22_LENGTH)
#define pCAN_MB22_TIMESTAMP	((volatile unsigned short *)CAN_MB22_TIMESTAMP)
#define pCAN_MB22_ID0		((volatile unsigned short *)CAN_MB22_ID0)
#define pCAN_MB22_ID1		((volatile unsigned short *)CAN_MB22_ID1)

#define pCAN_MB23_DATA0		((volatile unsigned short *)CAN_MB23_DATA0)
#define pCAN_MB23_DATA1		((volatile unsigned short *)CAN_MB23_DATA1)
#define pCAN_MB23_DATA2		((volatile unsigned short *)CAN_MB23_DATA2)
#define pCAN_MB23_DATA3		((volatile unsigned short *)CAN_MB23_DATA3)
#define pCAN_MB23_LENGTH	((volatile unsigned short *)CAN_MB23_LENGTH)
#define pCAN_MB23_TIMESTAMP	((volatile unsigned short *)CAN_MB23_TIMESTAMP)
#define pCAN_MB23_ID0		((volatile unsigned short *)CAN_MB23_ID0)
#define pCAN_MB23_ID1		((volatile unsigned short *)CAN_MB23_ID1)

#define pCAN_MB24_DATA0		((volatile unsigned short *)CAN_MB24_DATA0)
#define pCAN_MB24_DATA1		((volatile unsigned short *)CAN_MB24_DATA1)
#define pCAN_MB24_DATA2		((volatile unsigned short *)CAN_MB24_DATA2)
#define pCAN_MB24_DATA3		((volatile unsigned short *)CAN_MB24_DATA3)
#define pCAN_MB24_LENGTH	((volatile unsigned short *)CAN_MB24_LENGTH)
#define pCAN_MB24_TIMESTAMP	((volatile unsigned short *)CAN_MB24_TIMESTAMP)
#define pCAN_MB24_ID0		((volatile unsigned short *)CAN_MB24_ID0)
#define pCAN_MB24_ID1		((volatile unsigned short *)CAN_MB24_ID1)

#define pCAN_MB25_DATA0		((volatile unsigned short *)CAN_MB25_DATA0)
#define pCAN_MB25_DATA1		((volatile unsigned short *)CAN_MB25_DATA1)
#define pCAN_MB25_DATA2		((volatile unsigned short *)CAN_MB25_DATA2)
#define pCAN_MB25_DATA3		((volatile unsigned short *)CAN_MB25_DATA3)
#define pCAN_MB25_LENGTH	((volatile unsigned short *)CAN_MB25_LENGTH)
#define pCAN_MB25_TIMESTAMP	((volatile unsigned short *)CAN_MB25_TIMESTAMP)
#define pCAN_MB25_ID0		((volatile unsigned short *)CAN_MB25_ID0)
#define pCAN_MB25_ID1		((volatile unsigned short *)CAN_MB25_ID1)

#define pCAN_MB26_DATA0		((volatile unsigned short *)CAN_MB26_DATA0)
#define pCAN_MB26_DATA1		((volatile unsigned short *)CAN_MB26_DATA1)
#define pCAN_MB26_DATA2		((volatile unsigned short *)CAN_MB26_DATA2)
#define pCAN_MB26_DATA3		((volatile unsigned short *)CAN_MB26_DATA3)
#define pCAN_MB26_LENGTH	((volatile unsigned short *)CAN_MB26_LENGTH)
#define pCAN_MB26_TIMESTAMP	((volatile unsigned short *)CAN_MB26_TIMESTAMP)
#define pCAN_MB26_ID0		((volatile unsigned short *)CAN_MB26_ID0)
#define pCAN_MB26_ID1		((volatile unsigned short *)CAN_MB26_ID1)

#define pCAN_MB27_DATA0		((volatile unsigned short *)CAN_MB27_DATA0)
#define pCAN_MB27_DATA1		((volatile unsigned short *)CAN_MB27_DATA1)
#define pCAN_MB27_DATA2		((volatile unsigned short *)CAN_MB27_DATA2)
#define pCAN_MB27_DATA3		((volatile unsigned short *)CAN_MB27_DATA3)
#define pCAN_MB27_LENGTH	((volatile unsigned short *)CAN_MB27_LENGTH)
#define pCAN_MB27_TIMESTAMP	((volatile unsigned short *)CAN_MB27_TIMESTAMP)
#define pCAN_MB27_ID0		((volatile unsigned short *)CAN_MB27_ID0)
#define pCAN_MB27_ID1		((volatile unsigned short *)CAN_MB27_ID1)

#define pCAN_MB28_DATA0		((volatile unsigned short *)CAN_MB28_DATA0)
#define pCAN_MB28_DATA1		((volatile unsigned short *)CAN_MB28_DATA1)
#define pCAN_MB28_DATA2		((volatile unsigned short *)CAN_MB28_DATA2)
#define pCAN_MB28_DATA3		((volatile unsigned short *)CAN_MB28_DATA3)
#define pCAN_MB28_LENGTH	((volatile unsigned short *)CAN_MB28_LENGTH)
#define pCAN_MB28_TIMESTAMP	((volatile unsigned short *)CAN_MB28_TIMESTAMP)
#define pCAN_MB28_ID0		((volatile unsigned short *)CAN_MB28_ID0)
#define pCAN_MB28_ID1		((volatile unsigned short *)CAN_MB28_ID1)

#define pCAN_MB29_DATA0		((volatile unsigned short *)CAN_MB29_DATA0)
#define pCAN_MB29_DATA1		((volatile unsigned short *)CAN_MB29_DATA1)
#define pCAN_MB29_DATA2		((volatile unsigned short *)CAN_MB29_DATA2)
#define pCAN_MB29_DATA3		((volatile unsigned short *)CAN_MB29_DATA3)
#define pCAN_MB29_LENGTH	((volatile unsigned short *)CAN_MB29_LENGTH)
#define pCAN_MB29_TIMESTAMP	((volatile unsigned short *)CAN_MB29_TIMESTAMP)
#define pCAN_MB29_ID0		((volatile unsigned short *)CAN_MB29_ID0)
#define pCAN_MB29_ID1		((volatile unsigned short *)CAN_MB29_ID1)

#define pCAN_MB30_DATA0		((volatile unsigned short *)CAN_MB30_DATA0)
#define pCAN_MB30_DATA1		((volatile unsigned short *)CAN_MB30_DATA1)
#define pCAN_MB30_DATA2		((volatile unsigned short *)CAN_MB30_DATA2)
#define pCAN_MB30_DATA3		((volatile unsigned short *)CAN_MB30_DATA3)
#define pCAN_MB30_LENGTH	((volatile unsigned short *)CAN_MB30_LENGTH)
#define pCAN_MB30_TIMESTAMP	((volatile unsigned short *)CAN_MB30_TIMESTAMP)
#define pCAN_MB30_ID0		((volatile unsigned short *)CAN_MB30_ID0)
#define pCAN_MB30_ID1		((volatile unsigned short *)CAN_MB30_ID1)

#define pCAN_MB31_DATA0		((volatile unsigned short *)CAN_MB31_DATA0)
#define pCAN_MB31_DATA1		((volatile unsigned short *)CAN_MB31_DATA1)
#define pCAN_MB31_DATA2		((volatile unsigned short *)CAN_MB31_DATA2)
#define pCAN_MB31_DATA3		((volatile unsigned short *)CAN_MB31_DATA3)
#define pCAN_MB31_LENGTH	((volatile unsigned short *)CAN_MB31_LENGTH)
#define pCAN_MB31_TIMESTAMP	((volatile unsigned short *)CAN_MB31_TIMESTAMP)
#define pCAN_MB31_ID0		((volatile unsigned short *)CAN_MB31_ID0)
#define pCAN_MB31_ID1		((volatile unsigned short *)CAN_MB31_ID1)


/* CAN Mailbox Area Macros		*/
#define pCAN_MB_ID1(x)			((volatile unsigned short *)CAN_MB_ID1(x))
#define pCAN_MB_ID0(x)			((volatile unsigned short *)CAN_MB_ID0(x))
#define pCAN_MB_TIMESTAMP(x)	((volatile unsigned short *)CAN_MB_TIMESTAMP(x))
#define pCAN_MB_LENGTH(x)		((volatile unsigned short *)CAN_MB_LENGTH(x))
#define pCAN_MB_DATA3(x)		((volatile unsigned short *)CAN_MB_DATA3(x))
#define pCAN_MB_DATA2(x)		((volatile unsigned short *)CAN_MB_DATA2(x))
#define pCAN_MB_DATA1(x)		((volatile unsigned short *)CAN_MB_DATA1(x))
#define pCAN_MB_DATA0(x)		((volatile unsigned short *)CAN_MB_DATA0(x))


/* Alternate Deprecated Macros Provided For Backwards Code Compatibility */
#define pCAN_CNF         	pCAN_DEBUG
#define pTWI0_PRESCALE   	pTWI0_CONTROL
#define pTWI0_INT_SRC	 	pTWI0_INT_STAT
#define pTWI0_INT_ENABLE 	pTWI0_INT_MASK
#define pTWI1_PRESCALE		pTWI1_CONTROL
#define pTWI1_INT_SRC		pTWI1_INT_STAT
#define pTWI1_INT_ENABLE	pTWI1_INT_MASK

#endif /* _CDEF_BF539_H */

