/*
 * $Id: Parameters.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
  namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::Parameters"
  Parameters::Parameters (uint32_t              nb_context          ,
                          uint32_t              nb_inst_decod       ,
                          uint32_t              size_queue          ,
                          Tdecod_queue_scheme_t queue_scheme        ,
                          uint32_t              size_general_data   ,
                          uint32_t            * nb_branch_speculated,
                          bool                  is_toplevel)
  {
    log_begin(Decod_queue,FUNCTION);

    _nb_context              = nb_context              ;
    _nb_inst_decod           = nb_inst_decod           ;
    _size_queue              = size_queue/nb_inst_decod;
    _queue_scheme            = queue_scheme            ;
//  _size_general_data       = size_general_data       ;
    _nb_branch_speculated    = nb_branch_speculated    ;
    _nb_instruction_in_queue = size_queue              ;

    _nb_bank                 = nb_inst_decod           ;

    test();

    if (is_toplevel)
      {
        _size_context_id          = log2(nb_context);
        _size_nb_inst_decod       = log2(_size_queue)+1;
        _size_depth               = log2(max<uint32_t>(_nb_branch_speculated,_nb_context));
        _size_general_data        = size_general_data;
        _size_instruction_address = size_general_data-2;

        _have_port_context_id     = _size_context_id > 0;
        _have_port_depth          = _size_depth > 0;

        copy ();
      }

    log_end(Decod_queue,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Decod_queue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Decod_queue,FUNCTION);
//     test();
//     log_end(Decod_queue,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Decod_queue::~Parameters"
  Parameters::~Parameters () 
  {
    log_begin(Decod_queue,FUNCTION);

    log_end(Decod_queue,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Decod_queue::copy"
  void Parameters::copy (void) 
  {
    log_begin(Decod_queue,FUNCTION);

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
