#ifdef SYSTEMC
/*
 * $Id: Issue_queue_function_in_order_genMealy_issue_out.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Issue_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::function_in_order_genMealy_issue_out"
  void Issue_queue::function_in_order_genMealy_issue_out (void)
  {
    log_begin(Issue_queue,FUNCTION);
    log_function(Issue_queue,FUNCTION,_name.c_str());

    // ===================================================================
    // =====[ ISSUE_OUT ]=================================================
    // ===================================================================
    {
      Tcontrol_t val [_param->_nb_inst_issue];

      for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
        val [i] = 0;

      // From Reexecute_queue

//       uint32_t num_reexecute_entry = 0;
      for (std::list<entry_t*>::iterator it=_reexecute_queue.begin();
           it!=_reexecute_queue.end();
           ++it)
        {
          entry_t* entry = (*it);

          for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
            // test if no previous transaction and can accept this type
            if ((val[i] == 0) and _param->_table_issue_type [i][entry->_type])
              {
                // find a issue port
                val [i] = 1;
	    
                if (_param->_have_port_context_id)
	        PORT_WRITE(out_ISSUE_OUT_CONTEXT_ID            [i], entry->_context_id           );
	        if (_param->_have_port_front_end_id)
	        PORT_WRITE(out_ISSUE_OUT_FRONT_END_ID          [i], entry->_front_end_id         );
	        if (_param->_have_port_rob_ptr  )
	        PORT_WRITE(out_ISSUE_OUT_PACKET_ID             [i], entry->_packet_id            );
	        PORT_WRITE(out_ISSUE_OUT_OPERATION             [i], entry->_operation            );
	        PORT_WRITE(out_ISSUE_OUT_TYPE                  [i], entry->_type                 );
	        PORT_WRITE(out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE [i], entry->_store_queue_ptr_write);
	        if (_param->_have_port_load_queue_ptr)
	        PORT_WRITE(out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE  [i], entry->_load_queue_ptr_write );
	        PORT_WRITE(out_ISSUE_OUT_HAS_IMMEDIAT          [i], entry->_has_immediat         );
	        PORT_WRITE(out_ISSUE_OUT_IMMEDIAT              [i], entry->_immediat             );
	        PORT_WRITE(out_ISSUE_OUT_READ_RA               [i], entry->_read_ra              );
	        PORT_WRITE(out_ISSUE_OUT_NUM_REG_RA            [i], entry->_num_reg_ra           );
	        PORT_WRITE(out_ISSUE_OUT_READ_RB               [i], entry->_read_rb              );
	        PORT_WRITE(out_ISSUE_OUT_NUM_REG_RB            [i], entry->_num_reg_rb           );
	        PORT_WRITE(out_ISSUE_OUT_READ_RC               [i], entry->_read_rc              );
	        PORT_WRITE(out_ISSUE_OUT_NUM_REG_RC            [i], entry->_num_reg_rc           );
	        PORT_WRITE(out_ISSUE_OUT_WRITE_RD              [i], entry->_write_rd             );
	        PORT_WRITE(out_ISSUE_OUT_NUM_REG_RD            [i], entry->_num_reg_rd           );
	        PORT_WRITE(out_ISSUE_OUT_WRITE_RE              [i], entry->_write_re             );
	        PORT_WRITE(out_ISSUE_OUT_NUM_REG_RE            [i], entry->_num_reg_re           );

                internal_ISSUE_OUT_FROM_REEXECUTE [i] = true;
//              internal_ISSUE_OUT_NUM_BANK       [i] = num_reexecute_entry;
                internal_ISSUE_OUT_ENTRY          [i] = entry;

                break; // stop scan
              }
//           num_reexecute_entry ++;
        }

      // From Issue_queue
      for (uint32_t i=0; i<_param->_nb_bank; ++i)
        {
          uint32_t num_bank=(reg_NUM_BANK_HEAD+i)%_param->_nb_bank;
          
          log_printf(TRACE,Issue_queue,FUNCTION,"    * Bank [%d]",num_bank);
          
          bool find = false;
          
          // Have instruction ?
          if (not _issue_queue [num_bank].empty())
            {
 	      log_printf(TRACE,Issue_queue,FUNCTION,"      * Not Empty !!!");

              entry_t* entry = _issue_queue [num_bank].front();
              
              for (uint32_t j=0; j<_param->_nb_inst_issue; j++)
                {
                  log_printf(TRACE,Issue_queue,FUNCTION,"    * Issue [%d]",j);
                  log_printf(TRACE,Issue_queue,FUNCTION,"      * issue_ack            : %d",PORT_READ(in_ISSUE_OUT_ACK [j]));
                  log_printf(TRACE,Issue_queue,FUNCTION,"      * previous transaction : %d",val[j]);
                  log_printf(TRACE,Issue_queue,FUNCTION,"      * can issue type       : %d",_param->_table_issue_type [j][entry->_type]);

                  // test if no previous transaction and can accept this type
                  if ((val[j] == 0) and 
                      _param->_table_issue_type [j][entry->_type] and
                      PORT_READ(in_ISSUE_OUT_ACK [j]))
                    {
                      log_printf(TRACE,Issue_queue,FUNCTION,"    * find : %d",j);
                      
                      // find a issue port
                      val [j] = 1;
                      
                      if (_param->_have_port_context_id)
	              PORT_WRITE(out_ISSUE_OUT_CONTEXT_ID            [j], entry->_context_id           );
	              if (_param->_have_port_front_end_id)
	              PORT_WRITE(out_ISSUE_OUT_FRONT_END_ID          [j], entry->_front_end_id         );
	              if (_param->_have_port_rob_ptr  )
	              PORT_WRITE(out_ISSUE_OUT_PACKET_ID             [j], entry->_packet_id            );
	              PORT_WRITE(out_ISSUE_OUT_OPERATION             [j], entry->_operation            );
	              PORT_WRITE(out_ISSUE_OUT_TYPE                  [j], entry->_type                 );
	              PORT_WRITE(out_ISSUE_OUT_STORE_QUEUE_PTR_WRITE [j], entry->_store_queue_ptr_write);
	              if (_param->_have_port_load_queue_ptr)
	              PORT_WRITE(out_ISSUE_OUT_LOAD_QUEUE_PTR_WRITE  [j], entry->_load_queue_ptr_write );
	              PORT_WRITE(out_ISSUE_OUT_HAS_IMMEDIAT          [j], entry->_has_immediat         );
	              PORT_WRITE(out_ISSUE_OUT_IMMEDIAT              [j], entry->_immediat             );
	              PORT_WRITE(out_ISSUE_OUT_READ_RA               [j], entry->_read_ra              );
	              PORT_WRITE(out_ISSUE_OUT_NUM_REG_RA            [j], entry->_num_reg_ra           );
	              PORT_WRITE(out_ISSUE_OUT_READ_RB               [j], entry->_read_rb              );
	              PORT_WRITE(out_ISSUE_OUT_NUM_REG_RB            [j], entry->_num_reg_rb           );
	              PORT_WRITE(out_ISSUE_OUT_READ_RC               [j], entry->_read_rc              );
	              PORT_WRITE(out_ISSUE_OUT_NUM_REG_RC            [j], entry->_num_reg_rc           );
	              PORT_WRITE(out_ISSUE_OUT_WRITE_RD              [j], entry->_write_rd             );
	              PORT_WRITE(out_ISSUE_OUT_NUM_REG_RD            [j], entry->_num_reg_rd           );
	              PORT_WRITE(out_ISSUE_OUT_WRITE_RE              [j], entry->_write_re             );
	              PORT_WRITE(out_ISSUE_OUT_NUM_REG_RE            [j], entry->_num_reg_re           );
                      
                      internal_ISSUE_OUT_FROM_REEXECUTE [j] = false;
                      internal_ISSUE_OUT_NUM_BANK       [j] = num_bank;
                      internal_ISSUE_OUT_ENTRY          [j] = entry;
                      
                      find = true;
                      break; // find : stop scan
                    }
                }
            }

          if (not find)
            break; // stop scan (in order)
        }

      for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
        {
          internal_ISSUE_OUT_VAL [i] = val [i];
          PORT_WRITE(out_ISSUE_OUT_VAL [i], internal_ISSUE_OUT_VAL [i]);
        }
    }

    log_end(Issue_queue,FUNCTION);
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
