/*
 * $Id: test.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  1
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_unit_glue::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

  Ifetch_unit_Glue * _Ifetch_unit_Glue = new Ifetch_unit_Glue 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_VAL        ,"out_ICACHE_REQ_VAL        ",Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_ICACHE_REQ_ADDRESS_VAL," in_ICACHE_REQ_ADDRESS_VAL",Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_QUEUE_VAL  ,"out_ICACHE_REQ_QUEUE_VAL  ",Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_ICACHE_REQ_ACK        ," in_ICACHE_REQ_ACK        ",Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_ADDRESS_ACK,"out_ICACHE_REQ_ADDRESS_ACK",Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_ICACHE_REQ_QUEUE_ACK  ," in_ICACHE_REQ_QUEUE_ACK  ",Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_TYPE       ,"out_ICACHE_REQ_TYPE       ",Ticache_type_t);
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_ADDRESS        ,"out_ICACHE_REQ_ADDRESS        ",Taddress_t);
  ALLOC0_SC_SIGNAL( in_ICACHE_REQ_ADDRESS_ADDRESS," in_ICACHE_REQ_ADDRESS_ADDRESS",Taddress_t);
  ALLOC0_SC_SIGNAL(out_ICACHE_REQ_QUEUE_ADDRESS  ,"out_ICACHE_REQ_QUEUE_ADDRESS  ",Taddress_t);
  ALLOC0_SC_SIGNAL( in_EVENT_VAL             ," in_EVENT_VAL             ",Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_EVENT_ADDRESS_VAL     ,"out_EVENT_ADDRESS_VAL     ",Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_EVENT_QUEUE_VAL       ,"out_EVENT_QUEUE_VAL       ",Tcontrol_t);
  ALLOC0_SC_SIGNAL(out_EVENT_ACK             ,"out_EVENT_ACK             ",Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_EVENT_ADDRESS_ACK     ," in_EVENT_ADDRESS_ACK     ",Tcontrol_t);
  ALLOC0_SC_SIGNAL( in_EVENT_QUEUE_ACK       ," in_EVENT_QUEUE_ACK       ",Tcontrol_t);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Ifetch_unit_Glue.\n"),name.c_str());

  (*(_Ifetch_unit_Glue->in_CLOCK))        (*(in_CLOCK));
  (*(_Ifetch_unit_Glue->in_NRESET))       (*(in_NRESET));

  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_VAL        );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_ADDRESS_VAL);
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_QUEUE_VAL  );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_ACK        );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_ADDRESS_ACK);
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_QUEUE_ACK  );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_ADDRESS        );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_ICACHE_REQ_ADDRESS_ADDRESS);
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_QUEUE_ADDRESS  );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_ICACHE_REQ_TYPE       );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_EVENT_VAL             );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_EVENT_ADDRESS_VAL     );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_EVENT_QUEUE_VAL       );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue,out_EVENT_ACK             );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_EVENT_ADDRESS_ACK     );
  INSTANCE0_SC_SIGNAL(_Ifetch_unit_Glue, in_EVENT_QUEUE_ACK       );

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete out_ICACHE_REQ_VAL        ;
  delete  in_ICACHE_REQ_ADDRESS_VAL;
  delete out_ICACHE_REQ_QUEUE_VAL  ;
  delete  in_ICACHE_REQ_ACK        ;
  delete out_ICACHE_REQ_ADDRESS_ACK;
  delete  in_ICACHE_REQ_QUEUE_ACK  ;
  delete out_ICACHE_REQ_ADDRESS        ;
  delete  in_ICACHE_REQ_ADDRESS_ADDRESS;
  delete out_ICACHE_REQ_QUEUE_ADDRESS  ;
  delete out_ICACHE_REQ_TYPE       ;
  delete  in_EVENT_VAL             ;
  delete out_EVENT_ADDRESS_VAL     ;
  delete out_EVENT_QUEUE_VAL       ;
  delete out_EVENT_ACK             ;
  delete  in_EVENT_ADDRESS_ACK     ;
  delete  in_EVENT_QUEUE_ACK       ;
#endif

  delete _Ifetch_unit_Glue;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
