/*
 * $Id: Direction_Glue_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Direction_Glue/include/Direction_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace direction_glue {



#undef  FUNCTION
#define FUNCTION "Direction_Glue::allocation"
  void Direction_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Direction_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Direction_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("predict", IN, SOUTH, _("predict's interface"), _param->_nb_inst_predict);

      ALLOC1_SIGNAL_IN ( in_PREDICT_VAL                  ,"val"                  ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_PREDICT_ACK                  ,"ack"                  ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_ADDRESS_SRC          ,"address_src"          ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_PREDICT_STATIC               ,"static"               ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_LAST_TAKE            ,"last_take"            ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_PREDICT_HISTORY              ,"history"              ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_OUT(out_PREDICT_DIRECTION            ,"direction"            ,Tcontrol_t,1);

      if (_param->_have_component_meta_predictor)                                
	{                                                                        
      ALLOC1_SIGNAL_OUT(out_PREDICT_PREDICTOR_VAL        ,"predictor_val"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_PREDICT_PREDICTOR_ACK        ,"predictor_ack"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_PREDICT_PREDICTOR_ADDRESS_SRC,"predictor_address_src",Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_PREDICT_PREDICTOR_HISTORY    ,"predictor_history"    ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_IN ( in_PREDICT_PREDICTOR_DIRECTION  ,"predictor_direction"  ,Tcontrol_t,1);
	}

      ALLOC1_INTERFACE_END(_param->_nb_inst_predict);
    }

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("update", IN, SOUTH, _("update's interface"), _param->_nb_inst_update);

      ALLOC1_SIGNAL_IN ( in_UPDATE_VAL                        ,"val"                        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_ACK                        ,"ack"                        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_ADDRESS                    ,"address"                    ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_IN ( in_UPDATE_HISTORY                    ,"history"                    ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_IN ( in_UPDATE_DIRECTION                  ,"direction"                  ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_PREDICTION_IFETCH          ,"prediction_ifetch"          ,Tcontrol_t,1);

      if (_param->_have_component_meta_predictor)
	{
      ALLOC1_SIGNAL_OUT(out_UPDATE_PREDICTOR_VAL              ,"predictor_val"              ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_UPDATE_PREDICTOR_ACK              ,"predictor_ack"              ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_PREDICTOR_ADDRESS          ,"predictor_address"          ,Taddress_t,_param->_size_instruction_address);
      ALLOC1_SIGNAL_OUT(out_UPDATE_PREDICTOR_HISTORY          ,"predictor_history"          ,Thistory_t,_param->_size_history);
      ALLOC1_SIGNAL_OUT(out_UPDATE_PREDICTOR_DIRECTION        ,"predictor_direction"        ,Tcontrol_t,1);
      ALLOC1_SIGNAL_OUT(out_UPDATE_PREDICTOR_PREDICTION_IFETCH,"predictor_prediction_ifetch",Tcontrol_t,1);
	}

      ALLOC1_INTERFACE_END(_param->_nb_inst_update);
    }
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Direction_Glue,FUNCTION,"End");
  };

}; // end namespace direction_glue
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
