/*
 * $Id: OOO_Engine_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/include/OOO_Engine.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {

#undef  FUNCTION
#define FUNCTION "OOO_Engine::allocation"
  void OOO_Engine::allocation 
  (
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
   void
#endif
   )
  {
    log_begin(OOO_Engine,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"OOO_Engine"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();
    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("rename",IN,WEST,_("Instruction from front_end."),_param->_nb_front_end,_param->_nb_inst_decod[it1]);

      _ALLOC2_VALACK_IN ( in_RENAME_VAL                       , VAL                                                                                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_VALACK_OUT(out_RENAME_ACK                       , ACK                                                                                 ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_FRONT_END_ID              ,"FRONT_END_ID"              ,Tcontext_t        ,_param->_size_front_end_id           ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_CONTEXT_ID                ,"CONTEXT_ID"                ,Tcontext_t        ,_param->_size_context_id             ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_DEPTH                     ,"DEPTH"                     ,Tdepth_t          ,_param->_size_depth                  ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_TYPE                      ,"TYPE"                      ,Ttype_t           ,_param->_size_type                   ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_OPERATION                 ,"OPERATION"                 ,Toperation_t      ,_param->_size_operation              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_NO_EXECUTE                ,"NO_EXECUTE"                ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IS_DELAY_SLOT             ,"IS_DELAY_SLOT"             ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
#ifdef DEBUG
      _ALLOC2_SIGNAL_IN ( in_RENAME_ADDRESS                   ,"ADDRESS"                   ,Taddress_t        ,_param->_size_instruction_address    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
#endif
      _ALLOC2_SIGNAL_IN ( in_RENAME_ADDRESS_NEXT              ,"ADDRESS_NEXT"              ,Taddress_t        ,_param->_size_instruction_address    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_HAS_IMMEDIAT              ,"HAS_IMMEDIAT"              ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_IMMEDIAT                  ,"IMMEDIAT"                  ,Tgeneral_data_t   ,_param->_size_general_data           ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_READ_RA                   ,"READ_RA"                   ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_NUM_REG_RA                ,"NUM_REG_RA"                ,Tgeneral_address_t,_param->_size_general_register_logic ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_READ_RB                   ,"READ_RB"                   ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_NUM_REG_RB                ,"NUM_REG_RB"                ,Tgeneral_address_t,_param->_size_general_register_logic ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_READ_RC                   ,"READ_RC"                   ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_NUM_REG_RC                ,"NUM_REG_RC"                ,Tspecial_address_t,_param->_size_special_register_logic ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_WRITE_RD                  ,"WRITE_RD"                  ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_NUM_REG_RD                ,"NUM_REG_RD"                ,Tgeneral_address_t,_param->_size_general_register_logic ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_WRITE_RE                  ,"WRITE_RE"                  ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_NUM_REG_RE                ,"NUM_REG_RE"                ,Tspecial_address_t,_param->_size_special_register_logic ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_EXCEPTION_USE             ,"EXCEPTION_USE"             ,Texception_t      ,_param->_size_exception_use          ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_IN ( in_RENAME_EXCEPTION                 ,"EXCEPTION"                 ,Texception_t      ,_param->_size_exception              ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_inst_decod[it1]);
    }

    // ~~~~~[ Interface : "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("issue",OUT,EAST,_("Instruction to execute_loop"),_param->_nb_inst_issue);

      ALLOC1_VALACK_OUT (out_ISSUE_VAL                        , VAL                                                                                 );
      ALLOC1_VALACK_IN  ( in_ISSUE_ACK                        , ACK                                                                                 );
      ALLOC1_SIGNAL_OUT (out_ISSUE_FRONT_END_ID               ,"FRONT_END_ID"              ,Tcontext_t        ,_param->_size_front_end_id           );
      ALLOC1_SIGNAL_OUT (out_ISSUE_CONTEXT_ID                 ,"CONTEXT_ID"                ,Tcontext_t        ,_param->_size_context_id             );
      ALLOC1_SIGNAL_OUT (out_ISSUE_PACKET_ID                  ,"PACKET_ID"                 ,Tpacket_t         ,_param->_size_rob_ptr                );
      ALLOC1_SIGNAL_OUT (out_ISSUE_TYPE                       ,"TYPE"                      ,Ttype_t           ,_param->_size_type                   );
      ALLOC1_SIGNAL_OUT (out_ISSUE_OPERATION                  ,"OPERATION"                 ,Toperation_t      ,_param->_size_operation              );
      ALLOC1_SIGNAL_OUT (out_ISSUE_STORE_QUEUE_PTR_WRITE      ,"STORE_QUEUE_PTR_WRITE"     ,Tlsq_ptr_t        ,_param->_size_store_queue_ptr        );
      ALLOC1_SIGNAL_OUT (out_ISSUE_LOAD_QUEUE_PTR_WRITE       ,"LOAD_QUEUE_PTR_WRITE"      ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr         );
      ALLOC1_SIGNAL_OUT (out_ISSUE_HAS_IMMEDIAT               ,"HAS_IMMEDIAT"              ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_ISSUE_IMMEDIAT                   ,"IMMEDIAT"                  ,Tgeneral_data_t   ,_param->_size_general_data           );
      ALLOC1_SIGNAL_OUT (out_ISSUE_READ_RA                    ,"READ_RA"                   ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_ISSUE_NUM_REG_RA                 ,"NUM_REG_RA"                ,Tgeneral_address_t,_param->_size_general_register       );
      ALLOC1_SIGNAL_OUT (out_ISSUE_READ_RB                    ,"READ_RB"                   ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_ISSUE_NUM_REG_RB                 ,"NUM_REG_RB"                ,Tgeneral_address_t,_param->_size_general_register       );
      ALLOC1_SIGNAL_OUT (out_ISSUE_READ_RC                    ,"READ_RC"                   ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_ISSUE_NUM_REG_RC                 ,"NUM_REG_RC"                ,Tspecial_address_t,_param->_size_special_register       );
      ALLOC1_SIGNAL_OUT (out_ISSUE_WRITE_RD                   ,"WRITE_RD"                  ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_ISSUE_NUM_REG_RD                 ,"NUM_REG_RD"                ,Tgeneral_address_t,_param->_size_general_register       );
      ALLOC1_SIGNAL_OUT (out_ISSUE_WRITE_RE                   ,"WRITE_RE"                  ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_ISSUE_NUM_REG_RE                 ,"NUM_REG_RE"                ,Tspecial_address_t,_param->_size_special_register       );

      ALLOC1_INTERFACE_END(_param->_nb_inst_issue);
    }

    // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("execute_loop",IN,EAST,_("Instruction executed, from execute_loop."),_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

      _ALLOC2_VALACK_IN ( in_EXECUTE_LOOP_VAL                 , VAL                                                                                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_VALACK_OUT(out_EXECUTE_LOOP_ACK                 , ACK                                                                                 ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_FRONT_END_ID        ,"FRONT_END_ID"              ,Tcontext_t        ,_param->_size_front_end_id           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_CONTEXT_ID          ,"CONTEXT_ID"                ,Tcontext_t        ,_param->_size_context_id             ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_PACKET_ID           ,"PACKET_ID"                 ,Tpacket_t         ,_param->_size_rob_ptr                ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//    _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_TYPE                ,"TYPE"                      ,Ttype_t           ,_param->_size_type                   ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
//    _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_OPERATION           ,"OPERATION"                 ,Toperation_t      ,_param->_size_operation              ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_FLAGS               ,"FLAGS"                     ,Tspecial_data_t   ,_param->_size_special_data           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_EXCEPTION           ,"EXCEPTION"                 ,Texception_t      ,_param->_size_exception              ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_NO_SEQUENCE         ,"NO_SEQUENCE"               ,Tcontrol_t        ,1                                    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_ADDRESS             ,"ADDRESS"                   ,Taddress_t        ,_param->_size_instruction_address    ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
      _ALLOC2_SIGNAL_IN ( in_EXECUTE_LOOP_DATA                ,"DATA"                      ,Tgeneral_data_t   ,_param->_size_general_data           ,_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_execute_loop,_param->_nb_inst_execute[it1]);
    }

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("insert",OUT,EAST,_("Interface with RegisterFile's stat-list (insert Re-Order-Buffer)."),_param->_sum_inst_insert);

      ALLOC1_VALACK_OUT (out_INSERT_VAL                       , VAL);
      ALLOC1_VALACK_IN  ( in_INSERT_ACK                       , ACK);
      ALLOC1_SIGNAL_OUT (out_INSERT_RD_USE                    ,"RD_USE"                    ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_INSERT_RD_NUM_REG                ,"RD_NUM_REG"                ,Tgeneral_address_t,_param->_size_general_register       );
      ALLOC1_SIGNAL_OUT (out_INSERT_RE_USE                    ,"RE_USE"                    ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_OUT (out_INSERT_RE_NUM_REG                ,"RE_NUM_REG"                ,Tspecial_address_t,_param->_size_special_register       );

      ALLOC1_INTERFACE_END(_param->_sum_inst_insert);
    }

//     // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//     {
//       ALLOC1_INTERFACE_BEGIN("retire",OUT,EAST,_("Interface with RegisterFile's stat-list (retire Re-Order-Buffer)."),_param->_sum_inst_retire);

//       ALLOC1_VALACK_OUT (out_RETIRE_VAL                       , VAL);
//       ALLOC1_VALACK_IN  ( in_RETIRE_ACK                       , ACK);
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_OLD_USE                ,"RD_OLD_USE"                ,Tcontrol_t        ,1                                    );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_OLD_NUM_REG            ,"RD_OLD_NUM_REG"            ,Tgeneral_address_t,_param->_size_general_register       );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_NEW_USE                ,"RD_NEW_USE"                ,Tcontrol_t        ,1                                    );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_NEW_NUM_REG            ,"RD_NEW_NUM_REG"            ,Tgeneral_address_t,_param->_size_general_register       );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_OLD_USE                ,"RE_OLD_USE"                ,Tcontrol_t        ,1                                    );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_OLD_NUM_REG            ,"RE_OLD_NUM_REG"            ,Tspecial_address_t,_param->_size_special_register       );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_NEW_USE                ,"RE_NEW_USE"                ,Tcontrol_t        ,1                                    );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_NEW_NUM_REG            ,"RE_NEW_NUM_REG"            ,Tspecial_address_t,_param->_size_special_register       );

//       ALLOC1_INTERFACE_END(_param->_sum_inst_retire);
//     }

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
    {
      ALLOC1_INTERFACE_BEGIN("branch_complete",OUT,WEST,_("Instruction to execute_loop"),_param->_nb_inst_branch_complete);

      ALLOC1_VALACK_OUT (out_BRANCH_COMPLETE_VAL              , VAL);
      ALLOC1_VALACK_IN  ( in_BRANCH_COMPLETE_ACK              , ACK);
      ALLOC1_SIGNAL_OUT (out_BRANCH_COMPLETE_FRONT_END_ID     ,"FRONT_END_ID"              ,Tcontext_t        ,_param->_size_front_end_id           );
      ALLOC1_SIGNAL_OUT (out_BRANCH_COMPLETE_CONTEXT_ID       ,"CONTEXT_ID"                ,Tcontext_t        ,_param->_size_context_id             );
      ALLOC1_SIGNAL_OUT (out_BRANCH_COMPLETE_DEPTH            ,"DEPTH"                     ,Tdepth_t          ,_param->_size_depth                  );
      ALLOC1_SIGNAL_OUT (out_BRANCH_COMPLETE_ADDRESS          ,"ADDRESS"                   ,Taddress_t        ,_param->_size_instruction_address    );
      ALLOC1_SIGNAL_OUT (out_BRANCH_COMPLETE_NO_SEQUENCE      ,"NO_SEQUENCE"               ,Tcontrol_t        ,1                                    );
      ALLOC1_SIGNAL_IN  ( in_BRANCH_COMPLETE_MISS_PREDICTION  ,"MISS_PREDICTION"           ,Tcontrol_t        ,1                                    );

      ALLOC1_INTERFACE_END(_param->_nb_inst_branch_complete);
    }
                                                                             
    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("commit_event",OUT,WEST,_("Commit an event (exception)."));

      ALLOC0_VALACK_OUT(out_COMMIT_EVENT_VAL                 , VAL);
      ALLOC0_VALACK_IN ( in_COMMIT_EVENT_ACK                 , ACK);
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_FRONT_END_ID        ,"FRONT_END_ID"              ,Tcontext_t        ,_param->_size_front_end_id           );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_CONTEXT_ID          ,"CONTEXT_ID"                ,Tcontext_t        ,_param->_size_context_id             );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_DEPTH               ,"DEPTH"                     ,Tdepth_t          ,_param->_size_depth                  );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_TYPE                ,"TYPE"                      ,Tevent_type_t     ,_param->_size_event_type             );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_IS_DELAY_SLOT       ,"IS_DELAY_SLOT"             ,Tcontrol_t        ,1                                    );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_ADDRESS             ,"ADDRESS"                   ,Taddress_t        ,_param->_size_instruction_address    );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_ADDRESS_EPCR_VAL    ,"ADDRESS_EPCR_VAL"          ,Tcontrol_t        ,1                                    );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_ADDRESS_EPCR        ,"ADDRESS_EPCR"              ,Taddress_t        ,_param->_size_instruction_address    );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_ADDRESS_EEAR_VAL    ,"ADDRESS_EEAR_VAL"          ,Tcontrol_t        ,1                                    );
      ALLOC0_SIGNAL_OUT(out_COMMIT_EVENT_ADDRESS_EEAR        ,"ADDRESS_EEAR"              ,Tgeneral_data_t   ,_param->_size_general_data           );

      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("event",IN,WEST,_("Event from context_state."),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_VALACK_IN ( in_EVENT_VAL                        , VAL                                                                                 ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_VALACK_OUT(out_EVENT_ACK                        , ACK                                                                                 ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_EVENT_ADDRESS                    ,"ADDRESS"                   ,Taddress_t        ,_param->_size_instruction_address    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_EVENT_ADDRESS_NEXT               ,"ADDRESS_NEXT"              ,Taddress_t        ,_param->_size_instruction_address    ,_param->_nb_front_end,_param->_nb_context[it1]); 
      _ALLOC2_SIGNAL_IN ( in_EVENT_ADDRESS_NEXT_VAL           ,"ADDRESS_NEXT_VAL"          ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_EVENT_IS_DS_TAKE                 ,"IS_DS_TAKE"                ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr_event",IN,WEST,_("Exception : save spr and set a lot of special register."),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_VALACK_IN ( in_SPR_EVENT_VAL                    , VAL                                                                                 ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_VALACK_OUT(out_SPR_EVENT_ACK                    , ACK                                                                                 ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_SPR_EVENT_EPCR                   ,"EPCR"                      ,Tspr_t            ,_param->_size_spr                    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_SPR_EVENT_EEAR_WEN               ,"EEAR_WEN"                  ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_SPR_EVENT_EEAR                   ,"EEAR"                      ,Tspr_t            ,_param->_size_spr                    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_SPR_EVENT_SR_DSX                 ,"SR_DSX"                    ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_SPR_EVENT_SR_TO_ESR              ,"SR_TO_ESR"                 ,Tcontrol_t        ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }
                                                                                  
    // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("nb_inst",OUT,WEST,_("Internal number instruction."),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_SIGNAL_OUT(out_NB_INST_COMMIT_ALL               ,"COMMIT_ALL"                 ,Tcounter_t       ,_param->_size_nb_inst_commit         ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_NB_INST_COMMIT_MEM               ,"COMMIT_MEM"                 ,Tcounter_t       ,_param->_size_nb_inst_commit         ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_NB_INST_DECOD_ALL                ,"DECOD_ALL"                  ,Tcounter_t       ,_param->_size_nb_inst_decod          ,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("depth",IN,WEST,_("Interface with Prediction unit."),_param->_nb_front_end, _param->_nb_context[it1]);

      _ALLOC2_SIGNAL_IN ( in_DEPTH_MIN                        ,"MIN"                        ,Tdepth_t         ,_param->_size_depth                  ,_param->_nb_front_end, _param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_DEPTH_MAX                        ,"MAX"                        ,Tdepth_t         ,_param->_size_depth                  ,_param->_nb_front_end, _param->_nb_context[it1]); 
      _ALLOC2_SIGNAL_IN ( in_DEPTH_FULL                       ,"FULL"                       ,Tcontrol_t       ,1                                    ,_param->_nb_front_end, _param->_nb_context[it1]); 

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr",OUT,WEST,_("SPR"),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_SIGNAL_OUT(out_SPR_SR_IEE                       ,"SR_IEE"                     ,Tcontrol_t       ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_SR_EPH                       ,"SR_EPH"                     ,Tcontrol_t       ,1                                    ,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string name;

    _component_rename_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Rename_unit * [_param->_nb_rename_unit];
    for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
      {
        name = _name+"_rename_unit_"+toString(i);
        log_printf(TRACE,OOO_Engine,FUNCTION,_("Create   : %s"),name.c_str());
        
        _component_rename_unit [i] = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::Rename_unit
          (name.c_str()
#ifdef STATISTICS
           ,param_statistics
#endif
           ,_param->_param_rename_unit [i]
           ,_usage);

        _component->set_component (_component_rename_unit [i]->_component
#ifdef POSITION
                                   , 50, 50, 10, 10
#endif
                                   );
      }

    {
      name = _name+"_commit_unit";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_commit_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Commit_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_commit_unit
	 ,_usage);
      
      _component->set_component (_component_commit_unit->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_issue_queue";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_issue_queue = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Issue_queue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_issue_queue
	 ,_usage);
      
      _component->set_component (_component_issue_queue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_reexecute_unit";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_reexecute_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Reexecute_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_reexecute_unit
	 ,_usage);
      
      _component->set_component (_component_reexecute_unit->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_special_register_unit";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_special_register_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Special_Register_unit
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_special_register_unit
	 ,_usage);
      
      _component->set_component (_component_special_register_unit->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }

    {
      name = _name+"_glue";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Create   : %s"),name.c_str());
      
      _component_glue = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::ooo_engine_glue::OOO_Engine_Glue
	(name.c_str()
#ifdef STATISTICS
	 ,param_statistics
#endif
	 ,_param->_param_glue
	 ,_usage);
      
      _component->set_component (_component_glue->_component
#ifdef POSITION
				 , 50, 50, 10, 10
#endif
				 );
    }
        
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    std::string src,dest;

    // ===================================================================
    // =====[ rename_unit ]===============================================
    // ===================================================================
    for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
      {
        src = _name+"_rename_unit_"+toString(i);
        log_printf(TRACE,OOO_Engine,FUNCTION,_("Instance : %s"),name.c_str());
        
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"",
                                     dest,"");
#endif
          PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
          PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
        }

        // ~~~~~[ Interface : "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          std::vector<uint32_t>::iterator it = _param->_link_front_end_with_rename_unit[i].begin();
          uint32_t x = 0;
          for (uint32_t j=0; j<_param->_nb_front_end; j++)
            if (i == *it)
              {
                // this front end is link with this rename_unit
                for (uint32_t k=0; k<_param->_nb_inst_decod [j]; k++)
                  {
                    dest = _name;

#ifdef POSITION
                    _component->interface_map (src ,"rename_in_"+toString(x)+"_"+toString(k),
                                               dest,"rename_"   +toString(j)+"_"+toString(k));
#endif

                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_VAL"          ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_VAL"          );
                    PORT_MAP(_component,src ,"out_RENAME_IN_"+toString(x)+"_"+toString(k)+"_ACK"          ,
                                        dest,"out_RENAME_"   +toString(j)+"_"+toString(k)+"_ACK"          );
                    if (_param->_have_port_context_id)
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_CONTEXT_ID"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_CONTEXT_ID"   );
                    if (_param->_have_port_depth)
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_DEPTH"        ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_DEPTH"        );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_TYPE"         ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_TYPE"         );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_OPERATION"    ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_OPERATION"    );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_NO_EXECUTE"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_NO_EXECUTE"   );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_IS_DELAY_SLOT",
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_IS_DELAY_SLOT");
#ifdef DEBUG
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_ADDRESS"      ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_ADDRESS"      );
#endif
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_ADDRESS_NEXT" ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_ADDRESS_NEXT" );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_HAS_IMMEDIAT" ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_HAS_IMMEDIAT" );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_IMMEDIAT"     ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_IMMEDIAT"     );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_READ_RA"      ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_READ_RA"      );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_NUM_REG_RA"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_NUM_REG_RA"   );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_READ_RB"      ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_READ_RB"      );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_NUM_REG_RB"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_NUM_REG_RB"   );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_READ_RC"      ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_READ_RC"      );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_NUM_REG_RC"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_NUM_REG_RC"   );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_WRITE_RD"     ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_WRITE_RD"     );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_NUM_REG_RD"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_NUM_REG_RD"   );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_WRITE_RE"     ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_WRITE_RE"     );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_NUM_REG_RE"   ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_NUM_REG_RE"   );
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_EXCEPTION_USE",
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_EXCEPTION_USE");
                    PORT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+"_EXCEPTION"    ,
                                        dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_EXCEPTION"    );

                    // glue
                    dest = _name+"_glue";

#ifdef POSITION
                    _component->interface_map (src ,"rename_in_"+toString(x)+"_"+toString(k),
                                               dest,"rename_"   +toString(j)+"_"+toString(k));
#endif

                    if (_param->_have_port_front_end_id)
                    COMPONENT_MAP(_component,src , "in_RENAME_IN_"+toString(x)+"_"+toString(k)+            "_FRONT_END_ID" ,
                                             dest, "in_RENAME_"   +toString(j)+"_"+toString(k)+"_RENAME_UNIT_FRONT_END_ID" );
                  }

                x ++; 
                it++;
              }
        }
        
        // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
          {
            dest = _name+"_commit_unit";
            
#ifdef POSITION
            _component->interface_map (src ,"insert_"+toString(j),
                                       dest,"insert_"+toString(i)+"_"+toString(j));
#endif

            if (_param->_have_port_depth)
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_DEPTH"         ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_DEPTH"         );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_IS_DELAY_SLOT" ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_IS_DELAY_SLOT" );
#ifdef DEBUG
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_ADDRESS"       ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_ADDRESS"       );
#endif
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_ADDRESS_NEXT"  ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT"  );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_EXCEPTION_USE" ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_EXCEPTION_USE" );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_EXCEPTION"     ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_EXCEPTION"     );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_NUM_REG_RA_LOG",
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_NUM_REG_RA_LOG");
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_NUM_REG_RB_LOG",
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_NUM_REG_RB_LOG");
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_NUM_REG_RC_LOG",
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_NUM_REG_RC_LOG");
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_NUM_REG_RD_LOG",
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD_LOG");
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)                +"_NUM_REG_RE_LOG",
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE_LOG");

            dest = _name+"_glue";
            
#ifdef POSITION
            _component->interface_map (src ,"insert_"+toString(j),
                                       dest,"insert_"+toString(i)+"_"+toString(j));
#endif
            
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_VAL"                  ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_VAL"                  );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(j)+                            "_ACK"                  ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_ACK"                  );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_FRONT_END_ID"         ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_FRONT_END_ID"         );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_CONTEXT_ID"           ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_CONTEXT_ID"           );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_TYPE"                 ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_TYPE"                 );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_OPERATION"            ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_OPERATION"            );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NO_EXECUTE"           ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NO_EXECUTE"           );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_HAS_IMMEDIAT"         ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_HAS_IMMEDIAT"         );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_IMMEDIAT"             ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_IMMEDIAT"             );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_STORE_QUEUE_PTR_WRITE",
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_STORE_QUEUE_PTR_WRITE");
            if (_param->_have_port_load_queue_ptr)
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_LOAD_QUEUE_PTR_WRITE" ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE" );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_READ_RA"              ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_READ_RA"              );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RA_PHY"       ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RA_PHY"       );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_READ_RB"              ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_READ_RB"              );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RB_PHY"       ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RB_PHY"       );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_READ_RC"              ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_READ_RC"              );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RC_PHY"       ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RC_PHY"       );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_WRITE_RD"             ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_WRITE_RD"             );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RD_PHY_OLD"   ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RD_PHY_OLD"   );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RD_PHY_NEW"   ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RD_PHY_NEW"   );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_WRITE_RE"             ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_WRITE_RE"             );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RE_PHY_OLD"   ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RE_PHY_OLD"   );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(j)+                            "_NUM_REG_RE_PHY_NEW"   ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_RENAME_UNIT_NUM_REG_RE_PHY_NEW"   );
          }

        // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        for (uint32_t j=0; j<_param->_nb_inst_retire[i]; j++)
          {
            dest = _name+"_commit_unit";
            
#ifdef POSITION
            _component->interface_map (src ,"retire_"+toString(j),
                                       dest,"retire_"+toString(i)+"_"+toString(j));
#endif



            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_VAL"               ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_VAL"               );
            COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(j)+                "_ACK"               ,
                                     dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_ACK"               );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_FRONT_END_ID"      ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID"      );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_WRITE_RD"          ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_WRITE_RD"          );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RD_PHY_OLD",
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD_PHY_OLD");
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RD_PHY_NEW",
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD_PHY_NEW");
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_WRITE_RE"          ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_WRITE_RE"          );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RE_PHY_OLD",
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE_PHY_OLD");
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RE_PHY_NEW",
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE_PHY_NEW");
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_CONTEXT_ID"           ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"           );
//          COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_TYPE"                 ,
//                                   dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_TYPE"                 );
//          COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_OPERATION"            ,
//                                   dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_OPERATION"            );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_USE_STORE_QUEUE"      ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_USE_STORE_QUEUE"      );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_USE_LOAD_QUEUE"       ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_USE_LOAD_QUEUE"       );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_STORE_QUEUE_PTR_WRITE",
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_STORE_QUEUE_PTR_WRITE");
            if (_param->_have_port_load_queue_ptr)
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_LOAD_QUEUE_PTR_WRITE" ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_LOAD_QUEUE_PTR_WRITE" );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_READ_RA"              ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_READ_RA"              );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RA_PHY"       ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RA_PHY"       );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_READ_RB"              ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_READ_RB"              );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RB_PHY"       ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RB_PHY"       );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_READ_RC"              ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_READ_RC"              );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RC_PHY"       ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RC_PHY"       );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RD_LOG"       ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RD_LOG"       );
            COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(j)+                "_NUM_REG_RE_LOG"       ,
                                     dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_NUM_REG_RE_LOG"       );
          }

        // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          std::vector<uint32_t>::iterator it = _param->_link_front_end_with_rename_unit[i].begin();
          uint32_t x = 0;
          for (uint32_t j=0; j<_param->_nb_front_end; j++)
            if (i == (*it))
              {
                for (uint32_t k=0; k<_param->_nb_context[i]; k++)
                  {
                    dest = _name+"_commit_unit";
                    
#ifdef POSITION
                    _component->interface_map (src ,"retire_event_"+toString(x)+"_"+toString(k),
                                               dest,"retire_event_"+toString(j)+"_"+toString(k));
#endif
                    COMPONENT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(x)+"_"+toString(k)+"_VAL",
                                             dest,"out_RETIRE_EVENT_"+toString(j)+"_"+toString(k)+"_VAL");
                    COMPONENT_MAP(_component,src ,"out_RETIRE_EVENT_"+toString(x)+"_"+toString(k)+"_ACK",
                                             dest, "in_RETIRE_EVENT_"+toString(j)+"_"+toString(k)+"_ACK");
                    COMPONENT_MAP(_component,src , "in_RETIRE_EVENT_"+toString(x)+"_"+toString(k)+"_STATE",
                                             dest,"out_RETIRE_EVENT_"+toString(j)+"_"+toString(k)+"_STATE");
                    x++;
                    ++it;
                  }
              }
        }

        // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        {
          std::vector<uint32_t>::iterator it = _param->_link_front_end_with_rename_unit[i].begin();
          uint32_t x = 0;
          for (uint32_t j=0; j<_param->_nb_front_end; j++)
            if (i == *it)
              {
                for (uint32_t k=0; k<_param->_nb_context[j]; k++)
                  {
                    dest = _name+"_glue";
                    
#ifdef POSITION
                    _component->interface_map (src ,"spr_read_"+toString(x)+"_"+toString(k),
                                               dest,"spr_"     +toString(j)+"_"+toString(k));
#endif

                    COMPONENT_MAP(_component,src , "in_SPR_READ_"+toString(x)+"_"+toString(k)+            "_SR",
                                             dest,"out_SPR_"     +toString(j)+"_"+toString(k)+"_RENAME_UNIT_SR");
                  }
                x++;
                ++it;
              }
        }
      }

    // ===================================================================
    // =====[ commit_unit ]===============================================
    // ===================================================================
    {
      src = _name+"_commit_unit";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
        for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"insert_"+toString(i)+"_"+toString(j),
                                       dest,"insert_"+toString(i)+"_"+toString(j));
#endif
            
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_VAL"                  ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_VAL"                  );
            COMPONENT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_"+toString(j)+            "_ACK"                  ,
                                     dest, "in_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_ACK"                  );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_FRONT_END_ID"         ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_FRONT_END_ID"         );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_CONTEXT_ID"           ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_CONTEXT_ID"           );
//          COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_RENAME_UNIT_ID"       ,
//                                   dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_RENAME_UNIT_ID"       );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_TYPE"                 ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_TYPE"                 );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_OPERATION"            ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_OPERATION"            );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NO_EXECUTE"           ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NO_EXECUTE"           );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_STORE_QUEUE_PTR_WRITE",
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE");
            if (_param->_have_port_load_queue_ptr)
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_LOAD_QUEUE_PTR_WRITE" ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE" );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_READ_RA"              ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_READ_RA"              );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RA_PHY"       ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RA_PHY"       );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_READ_RB"              ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_READ_RB"              );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RB_PHY"       ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RB_PHY"       );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_READ_RC"              ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_READ_RC"              );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RC_PHY"       ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RC_PHY"       );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_WRITE_RD"             ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_WRITE_RD"             );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RD_PHY_OLD"   ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RD_PHY_OLD"   );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RD_PHY_NEW"   ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RD_PHY_NEW"   );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_WRITE_RE"             ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_WRITE_RE"             );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RE_PHY_OLD"   ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RE_PHY_OLD"   );
            COMPONENT_MAP(_component,src , "in_INSERT_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RE_PHY_NEW"   ,
                                     dest,"out_INSERT_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RE_PHY_NEW"   );
            
            dest = _name+"_issue_queue";
#ifdef POSITION
            _component->interface_map (src ,"insert_"  +toString(i)+"_"+toString(j),
                                       dest,"issue_in_"+toString(i)+"_"+toString(j));
#endif
            
            if (_param->_have_port_rob_ptr)
            COMPONENT_MAP(_component,src ,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_PACKET_ID",
                                     dest, "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+"_PACKET_ID");

            //    in_INSERT_DEPTH          - component_rename_unit
            //    in_INSERT_ADDRESS        - component_rename_unit
            //    in_INSERT_ADDRESS_NEXT   - component_rename_unit
            //    in_INSERT_EXCEPTION_USE  - component_rename_unit
            //    in_INSERT_EXCEPTION      - component_rename_unit
            //    in_INSERT_NUM_REG_RA_LOG - component_rename_unit
            //    in_INSERT_NUM_REG_RB_LOG - component_rename_unit
            //    in_INSERT_NUM_REG_RC_LOG - component_rename_unit
            //    in_INSERT_NUM_REG_RD_LOG - component_rename_unit
            //    in_INSERT_NUM_REG_RE_LOG - component_rename_unit
            //    in_INSERT_IS_DELAY_SLOT  - component_rename_unit
          }
										   
      // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
      for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
        for (uint32_t j=0; j<_param->_nb_inst_retire [i]; j++)
          {
//             dest = _name+"_glue";
            
// #ifdef POSITION
//             _component->interface_map (src ,"retire_"+toString(i)+"_"+toString(j),
//                                        dest,"retire_"+toString(i)+"_"+toString(j));
// #endif

//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_VAL"               ,
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_VAL"               );
//             COMPONENT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_"+toString(j)+            "_ACK"               ,
//                                      dest,"out_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_ACK"               );
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_WRITE_RD"          ,
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_WRITE_RD"          );
//             if (_param->_have_port_front_end_id)
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_FRONT_END_ID"      ,
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_FRONT_END_ID"      );
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RD_PHY_OLD",
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RD_PHY_OLD");
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RD_PHY_NEW",
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RD_PHY_NEW");
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_WRITE_RE"          ,
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_WRITE_RE"          );
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RE_PHY_OLD",
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RE_PHY_OLD");
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RE_PHY_NEW",
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_NUM_REG_RE_PHY_NEW");
//             COMPONENT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_"+toString(j)+            "_EVENT_STATE"       ,
//                                      dest, "in_RETIRE_"+toString(i)+"_"+toString(j)+"_COMMIT_UNIT_EVENT_STATE"       );


            //  out_RETIRE_VAL                       - component_rename_unit
            //   in_RETIRE_ACK                       - component_rename_unit
            //  out_RETIRE_WRITE_RD                  - component_rename_unit
            //  out_RETIRE_FRONT_END_ID              - component_rename_unit
            //  out_RETIRE_NUM_REG_RD_PHY_OLD        - component_rename_unit
            //  out_RETIRE_NUM_REG_RD_PHY_NEW        - component_rename_unit
            //  out_RETIRE_WRITE_RE                  - component_rename_unit
            //  out_RETIRE_NUM_REG_RE_PHY_OLD        - component_rename_unit
            //  out_RETIRE_NUM_REG_RE_PHY_NEW        - component_rename_unit
            //  out_RETIRE_EVENT_STATE               - component_rename_unit
    
            //  out_RETIRE_CONTEXT_ID                - component_rename_unit
            ////out_RETIRE_RENAME_UNIT_ID            - component_rename_unit
            //  out_RETIRE_USE_STORE_QUEUE           - component_rename_unit
            //  out_RETIRE_USE_LOAD_QUEUE            - component_rename_unit
            //  out_RETIRE_STORE_QUEUE_PTR_WRITE     - component_rename_unit
            //  out_RETIRE_LOAD_QUEUE_PTR_WRITE      - component_rename_unit
            //  out_RETIRE_READ_RA                   - component_rename_unit
            //  out_RETIRE_NUM_REG_RA_PHY            - component_rename_unit
            //  out_RETIRE_READ_RB                   - component_rename_unit
            //  out_RETIRE_NUM_REG_RB_PHY            - component_rename_unit
            //  out_RETIRE_READ_RC                   - component_rename_unit
            //  out_RETIRE_NUM_REG_RC_PHY            - component_rename_unit
            //  out_RETIRE_NUM_REG_RD_LOG            - component_rename_unit
            //  out_RETIRE_NUM_REG_RE_LOG            - component_rename_unit
          }
      
      // ~~~~~[ Interface "retire_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
        // out_RETIRE_VAL         - rename_unit.out_RETIRE_VAL        
        //  in_RETIRE_ACK         - rename_unit. in_RETIRE_ACK        
        // out_RETIRE_EVENT_STATE - rename_unit.out_RETIRE_EVENT_STATE
  

      // ~~~~~[ Interface : "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
      for (uint32_t i=0; i<_param->_nb_inst_commit; i++)
        {
          dest = _name+"_reexecute_unit";
#ifdef POSITION
          _component->interface_map (src ,"commit_"+toString(i),
                                     dest,"commit_"+toString(i));
#endif
        
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_VAL"        ,
                                   dest,"out_COMMIT_"+toString(i)+"_VAL"        );
          COMPONENT_MAP(_component,src ,"out_COMMIT_"+toString(i)+"_ACK"        ,
                                   dest, "in_COMMIT_"+toString(i)+"_ACK"        );
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_WEN"        ,
                                   dest,"out_COMMIT_"+toString(i)+"_WEN"        );
          if (_param->_have_port_rob_ptr)
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_PACKET_ID"  ,
                                   dest,"out_COMMIT_"+toString(i)+"_PACKET_ID"  );
//        COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_OPERATION"  ,
//                                 dest,"out_COMMIT_"+toString(i)+"_OPERATION"  );
//        COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_TYPE"       ,
//                                 dest,"out_COMMIT_"+toString(i)+"_TYPE"       );
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_FLAGS"      ,
                                   dest,"out_COMMIT_"+toString(i)+"_FLAGS"      );
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_EXCEPTION"  ,
                                   dest,"out_COMMIT_"+toString(i)+"_EXCEPTION"  );
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_NO_SEQUENCE",
                                   dest,"out_COMMIT_"+toString(i)+"_NO_SEQUENCE");
          COMPONENT_MAP(_component,src , "in_COMMIT_"+toString(i)+"_ADDRESS"    ,
                                   dest,"out_COMMIT_"+toString(i)+"_ADDRESS"    );
          COMPONENT_MAP(_component,src ,"out_COMMIT_"+toString(i)+"_NUM_REG_RD" ,
                                   dest, "in_COMMIT_"+toString(i)+"_NUM_REG_RD" );
          //@@@@@@@@@@
	}
      
      // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
      for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
        {
          dest = _name+"_reexecute_unit";
#ifdef POSITION
          _component->interface_map (src ,"reexecute_"    +toString(i),
                                     dest,"reexecute_rob_"+toString(i));
#endif

          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_VAL"                  ,
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_VAL"                  );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"    +toString(i)+"_ACK"                  ,
                                   dest,"out_REEXECUTE_ROB_"+toString(i)+"_ACK"                  );
          if (_param->_have_port_front_end_id)
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_FRONT_END_ID"         ,
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_FRONT_END_ID"         );
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_CONTEXT_ID"           ,
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_CONTEXT_ID"           );
          if (_param->_have_port_rob_ptr)
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_PACKET_ID"            ,
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_PACKET_ID"            );
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_OPERATION"            ,
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_OPERATION"            );
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_TYPE"                 ,
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_TYPE"                 );
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"    +toString(i)+"_STORE_QUEUE_PTR_WRITE",
                                   dest, "in_REEXECUTE_ROB_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
    	}
									   
      // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
      for (uint32_t i=0; i<_param->_nb_inst_branch_complete; i++)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"branch_complete_"+toString(i),
                                     dest,"branch_complete_"+toString(i));
#endif

          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_VAL"            ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_VAL"            );
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_ACK"            ,
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_ACK"            );
          if (_param->_have_port_front_end_id)
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_FRONT_END_ID"   ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_FRONT_END_ID"   );
          if (_param->_have_port_context_id)
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID"     ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_CONTEXT_ID"     );
          if (_param->_have_port_depth)
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"          ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_DEPTH"          );
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"        ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_ADDRESS"        );
          PORT_MAP(_component,src ,"out_BRANCH_COMPLETE_"+toString(i)+"_NO_SEQUENCE"    ,
                              dest,"out_BRANCH_COMPLETE_"+toString(i)+"_NO_SEQUENCE"    );
          PORT_MAP(_component,src , "in_BRANCH_COMPLETE_"+toString(i)+"_MISS_PREDICTION",
                              dest, "in_BRANCH_COMPLETE_"+toString(i)+"_MISS_PREDICTION");
        }
										   
      // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      {
        dest = _name;
#ifdef POSITION
        _component->interface_map (src ,"update",
                                   dest,"commit_event");
#endif

        PORT_MAP(_component,src ,"out_UPDATE_VAL"             ,dest,"out_COMMIT_EVENT_VAL"             );
        PORT_MAP(_component,src , "in_UPDATE_ACK"             ,dest, "in_COMMIT_EVENT_ACK"             );
        if (_param->_have_port_front_end_id)
        PORT_MAP(_component,src ,"out_UPDATE_FRONT_END_ID"    ,dest,"out_COMMIT_EVENT_FRONT_END_ID"    );
        if (_param->_have_port_context_id)
        PORT_MAP(_component,src ,"out_UPDATE_CONTEXT_ID"      ,dest,"out_COMMIT_EVENT_CONTEXT_ID"      );
        if (_param->_have_port_depth)
        PORT_MAP(_component,src ,"out_UPDATE_DEPTH"           ,dest,"out_COMMIT_EVENT_DEPTH"           );
        PORT_MAP(_component,src ,"out_UPDATE_TYPE"            ,dest,"out_COMMIT_EVENT_TYPE"            );
        PORT_MAP(_component,src ,"out_UPDATE_IS_DELAY_SLOT"   ,dest,"out_COMMIT_EVENT_IS_DELAY_SLOT"   );
        PORT_MAP(_component,src ,"out_UPDATE_ADDRESS"         ,dest,"out_COMMIT_EVENT_ADDRESS"         );
        PORT_MAP(_component,src ,"out_UPDATE_ADDRESS_EPCR_VAL",dest,"out_COMMIT_EVENT_ADDRESS_EPCR_VAL");
        PORT_MAP(_component,src ,"out_UPDATE_ADDRESS_EPCR"    ,dest,"out_COMMIT_EVENT_ADDRESS_EPCR"    );
        PORT_MAP(_component,src ,"out_UPDATE_ADDRESS_EEAR_VAL",dest,"out_COMMIT_EVENT_ADDRESS_EEAR_VAL");
        PORT_MAP(_component,src ,"out_UPDATE_ADDRESS_EEAR"    ,dest,"out_COMMIT_EVENT_ADDRESS_EEAR"    );
      }

      // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"event_"+toString(i)+"_"+toString(j),
                                       dest,"event_"+toString(i)+"_"+toString(j));
#endif
            
            PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_"+toString(j)+"_VAL"             ,
                                dest, "in_EVENT_"+toString(i)+"_"+toString(j)+"_VAL"             );
            PORT_MAP(_component,src ,"out_EVENT_"+toString(i)+"_"+toString(j)+"_ACK"             ,
                                dest,"out_EVENT_"+toString(i)+"_"+toString(j)+"_ACK"             );
            PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_"+toString(j)+"_ADDRESS"         ,
                                dest, "in_EVENT_"+toString(i)+"_"+toString(j)+"_ADDRESS"         );
            PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT"    ,
                                dest, "in_EVENT_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT"    ); 
            PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT_VAL",
                                dest, "in_EVENT_"+toString(i)+"_"+toString(j)+"_ADDRESS_NEXT_VAL");
            PORT_MAP(_component,src , "in_EVENT_"+toString(i)+"_"+toString(j)+"_IS_DS_TAKE"      ,
                                dest, "in_EVENT_"+toString(i)+"_"+toString(j)+"_IS_DS_TAKE"      );
          }
										   
      // ~~~~~[ Interface : "nb_inst" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"nb_inst_"+toString(i)+"_"+toString(j),
                                       dest,"nb_inst_"+toString(i)+"_"+toString(j));
#endif

            PORT_MAP(_component,src ,"out_NB_INST_"+toString(i)+"_"+toString(j)+"_COMMIT_ALL",
                                dest,"out_NB_INST_"+toString(i)+"_"+toString(j)+"_COMMIT_ALL");
            PORT_MAP(_component,src ,"out_NB_INST_"+toString(i)+"_"+toString(j)+"_COMMIT_MEM",
                                dest,"out_NB_INST_"+toString(i)+"_"+toString(j)+"_COMMIT_MEM");
            PORT_MAP(_component,src , "in_NB_INST_"+toString(i)+"_"+toString(j)+"_DECOD_ALL" ,
                                dest, "in_NB_INST_"+toString(i)+"_"+toString(j)+"_DECOD_ALL" );
          }

      // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~	   
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"depth_"+toString(i)+"_"+toString(j),
                                       dest,"depth_"+toString(i)+"_"+toString(j));
#endif

            if (_param->_have_port_depth)
              {
            PORT_MAP(_component,src , "in_DEPTH_"+toString(i)+"_"+toString(j)+"_MIN",
                                dest, "in_DEPTH_"+toString(i)+"_"+toString(j)+"_MIN");
            PORT_MAP(_component,src , "in_DEPTH_"+toString(i)+"_"+toString(j)+"_MAX",
                                dest, "in_DEPTH_"+toString(i)+"_"+toString(j)+"_MAX");
              }
            PORT_MAP(_component,src , "in_DEPTH_"+toString(i)+"_"+toString(j)+"_FULL",
                                dest, "in_DEPTH_"+toString(i)+"_"+toString(j)+"_FULL");
          }

      // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name+"_glue";
            
#ifdef POSITION
            _component->interface_map (src ,"spr_read_"+toString(i)+"_"+toString(j),
                                       dest,"spr_"     +toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src , "in_SPR_READ_"+toString(i)+"_"+toString(j)+            "_SR_OVE",
                                     dest,"out_SPR_"     +toString(i)+"_"+toString(j)+"_COMMIT_UNIT_SR_OVE");
          }

      // ~~~~~[ Interface : "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name+"_special_register_unit";
#ifdef POSITION
            _component->interface_map (src ,"spr_write_" +toString(i)+"_"+toString(j),
                                       dest,"spr_commit_"+toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_VAL"      ,
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_VAL"      );
            COMPONENT_MAP(_component,src , "in_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_ACK"      ,
                                     dest,"out_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_ACK"      );
            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_SR_F_VAL" ,
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_SR_F_VAL" );
            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_SR_F"     ,
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_SR_F"     );
            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_SR_CY_VAL",
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_SR_CY_VAL");
            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_SR_CY"    ,
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_SR_CY"    );
            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_SR_OV_VAL",
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_SR_OV_VAL");
            COMPONENT_MAP(_component,src ,"out_SPR_WRITE_" +toString(i)+"_"+toString(j)+"_SR_OV"    ,
                                     dest, "in_SPR_COMMIT_"+toString(i)+"_"+toString(j)+"_SR_OV"    );
          }
    }

    // ===================================================================
    // =====[ issue_queue ]===============================================
    // ===================================================================
    {
      src = _name+"_issue_queue";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "issue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_rename_unit; ++i)
        for (uint32_t j=0; j<_param->_nb_inst_insert[i]; j++)
          {
            dest = _name+"_glue";
#ifdef POSITION
            _component->interface_map (src ,"issue_in_"+toString(i)+"_"+toString(j),
                                       dest,"insert_"  +toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_VAL"                  ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_VAL"                  );
            COMPONENT_MAP(_component,src ,"out_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_ACK"                  ,
                                     dest, "in_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_ACK"                  );
            if (_param->_have_port_context_id)
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_CONTEXT_ID"           ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_CONTEXT_ID"           );
            if (_param->_have_port_front_end_id)
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_FRONT_END_ID"         ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_FRONT_END_ID"         );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_OPERATION"            ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_OPERATION"            );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_TYPE"                 ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_TYPE"                 );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_STORE_QUEUE_PTR_WRITE",
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE");
            if (_param->_have_port_load_queue_ptr)
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_LOAD_QUEUE_PTR_WRITE" ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE" );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_HAS_IMMEDIAT"         ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_HAS_IMMEDIAT"         );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_IMMEDIAT"             ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_IMMEDIAT"             );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_READ_RA"              ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_READ_RA"              );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RA"           ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_NUM_REG_RA"           );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_READ_RB"              ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_READ_RB"              );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RB"           ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_NUM_REG_RB"           );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_READ_RC"              ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_READ_RC"              );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RC"           ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_NUM_REG_RC"           );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_WRITE_RD"             ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_WRITE_RD"             );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RD"           ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_NUM_REG_RD"           );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_WRITE_RE"             ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_WRITE_RE"             );
            COMPONENT_MAP(_component,src , "in_ISSUE_IN_"+toString(i)+"_"+toString(j)+            "_NUM_REG_RE"           ,
                                     dest,"out_INSERT_"  +toString(i)+"_"+toString(j)+"_ISSUE_QUEUE_NUM_REG_RE"           );


            
            //   in_ISSUE_IN_PACKET_ID - component_commit_unit
          }

      // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
        {
          dest = _name+"_reexecute_unit";
#ifdef POSITION
          _component->interface_map (src ,"reexecute_"+toString(i),
                                     dest,"reexecute_"+toString(i));
#endif
       
          
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_VAL"                  ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_VAL"                  );
          COMPONENT_MAP(_component,src ,"out_REEXECUTE_"+toString(i)+"_ACK"                  ,
                                   dest, "in_REEXECUTE_"+toString(i)+"_ACK"                  );
          if (_param->_have_port_front_end_id)
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_FRONT_END_ID"         ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_FRONT_END_ID"         );
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_CONTEXT_ID"           ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_CONTEXT_ID"           );
          if (_param->_have_port_rob_ptr)
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_PACKET_ID"            ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_PACKET_ID"            );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_TYPE"                 ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_TYPE"                 );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_OPERATION"            ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_OPERATION"            );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",
                                   dest,"out_REEXECUTE_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
          if (_param->_have_port_load_queue_ptr)
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_HAS_IMMEDIAT"         ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_HAS_IMMEDIAT"         );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_IMMEDIAT"             ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_IMMEDIAT"             );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_READ_RA"              ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_READ_RA"              );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_NUM_REG_RA"           ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_NUM_REG_RA"           );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_READ_RB"              ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_READ_RB"              );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_NUM_REG_RB"           ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_NUM_REG_RB"           );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_READ_RC"              ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_READ_RC"              );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_NUM_REG_RC"           ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_NUM_REG_RC"           );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_WRITE_RD"             ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_WRITE_RD"             );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_NUM_REG_RD"           ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_NUM_REG_RD"           );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_WRITE_RE"             ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_WRITE_RE"             );
          COMPONENT_MAP(_component,src , "in_REEXECUTE_"+toString(i)+"_NUM_REG_RE"           ,
                                   dest,"out_REEXECUTE_"+toString(i)+"_NUM_REG_RE"           );
        }

      // ~~~~~[ Interface : "issue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_issue; i++)
        {
          dest = _name;
          
#ifdef POSITION
          _component->interface_map (src ,"issue_out_"+toString(i),
                                     dest,"issue_"    +toString(i));
#endif

          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_VAL"                  ,
                              dest,"out_ISSUE_"    +toString(i)+"_VAL"                  );
          PORT_MAP(_component,src , "in_ISSUE_OUT_"+toString(i)+"_ACK"                  ,
                              dest, "in_ISSUE_"    +toString(i)+"_ACK"                  );
          if (_param->_have_port_front_end_id)
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_FRONT_END_ID"         ,
                              dest,"out_ISSUE_"    +toString(i)+"_FRONT_END_ID"         );
          if (_param->_have_port_context_id)
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_CONTEXT_ID"           ,
                              dest,"out_ISSUE_"    +toString(i)+"_CONTEXT_ID"           );
          if (_param->_have_port_rob_ptr)
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_PACKET_ID"            ,
                              dest,"out_ISSUE_"    +toString(i)+"_PACKET_ID"            );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_TYPE"                 ,
                              dest,"out_ISSUE_"    +toString(i)+"_TYPE"                 );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_OPERATION"            ,
                              dest,"out_ISSUE_"    +toString(i)+"_OPERATION"            );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",
                              dest,"out_ISSUE_"    +toString(i)+"_STORE_QUEUE_PTR_WRITE");
          if (_param->_have_port_load_queue_ptr)
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,
                              dest,"out_ISSUE_"    +toString(i)+"_LOAD_QUEUE_PTR_WRITE" );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_HAS_IMMEDIAT"         ,
                              dest,"out_ISSUE_"    +toString(i)+"_HAS_IMMEDIAT"         );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_IMMEDIAT"             ,
                              dest,"out_ISSUE_"    +toString(i)+"_IMMEDIAT"             );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_READ_RA"              ,
                              dest,"out_ISSUE_"    +toString(i)+"_READ_RA"              );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_NUM_REG_RA"           ,
                              dest,"out_ISSUE_"    +toString(i)+"_NUM_REG_RA"           );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_READ_RB"              ,
                              dest,"out_ISSUE_"    +toString(i)+"_READ_RB"              );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_NUM_REG_RB"           ,
                              dest,"out_ISSUE_"    +toString(i)+"_NUM_REG_RB"           );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_READ_RC"              ,
                              dest,"out_ISSUE_"    +toString(i)+"_READ_RC"              );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_NUM_REG_RC"           ,
                              dest,"out_ISSUE_"    +toString(i)+"_NUM_REG_RC"           );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_WRITE_RD"             ,
                              dest,"out_ISSUE_"    +toString(i)+"_WRITE_RD"             );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_NUM_REG_RD"           ,
                              dest,"out_ISSUE_"    +toString(i)+"_NUM_REG_RD"           );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_WRITE_RE"             ,
                              dest,"out_ISSUE_"    +toString(i)+"_WRITE_RE"             );
          PORT_MAP(_component,src ,"out_ISSUE_OUT_"+toString(i)+"_NUM_REG_RE"           ,
                              dest,"out_ISSUE_"    +toString(i)+"_NUM_REG_RE"           );
        }
    }

    // ===================================================================
    // =====[ reexecute_unit ]============================================
    // ===================================================================
    {
      src = _name+"_reexecute_unit";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_execute_loop; i++)
        for (uint32_t j=0; j<_param->_nb_inst_execute[i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"execute_loop_"+toString(i)+"_"+toString(j),
                                       dest,"execute_loop_"+toString(i)+"_"+toString(j));
#endif

            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_VAL"         ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_VAL"         );
            PORT_MAP(_component,src ,"out_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ACK"         ,
                                dest,"out_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ACK"         );
            if (_param->_have_port_front_end_id)
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID",
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID");
            if (_param->_have_port_context_id)
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"  ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_CONTEXT_ID"  );
            if (_param->_have_port_rob_ptr)
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_PACKET_ID"   ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_PACKET_ID"   );
//          PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_TYPE"        ,
//                              dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_TYPE"        );
//          PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_OPERATION"   ,
//                              dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_OPERATION"   );
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FLAGS"       ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_FLAGS"       );
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_EXCEPTION"   ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_EXCEPTION"   );
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NO_SEQUENCE" ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_NO_SEQUENCE" );
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ADDRESS"     ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_ADDRESS"     );
            PORT_MAP(_component,src , "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_DATA"        ,
                                dest, "in_EXECUTE_LOOP_"+toString(i)+"_"+toString(j)+"_DATA"        );
          }

      // ~~~~~[ Interface "commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //  out_COMMIT_VAL                           - component_commit_unit
      //   in_COMMIT_ACK                           - component_commit_unit
      //  out_COMMIT_WEN                           - component_commit_unit
      //  out_COMMIT_FRONT_END_ID                  - component_commit_unit
      //  out_COMMIT_CONTEXT_ID                    - component_commit_unit
      //  out_COMMIT_PACKET_ID                     - component_commit_unit
      ////out_COMMIT_OPERATION                     - component_commit_unit
      ////out_COMMIT_TYPE                          - component_commit_unit
      //  out_COMMIT_FLAGS                         - component_commit_unit
      //  out_COMMIT_EXCEPTION                     - component_commit_unit
      //  out_COMMIT_NO_SEQUENCE                   - component_commit_unit
      //  out_COMMIT_ADDRESS                       - component_commit_unit
      //   in_COMMIT_NUM_REG_RD                    - component_commit_unit
      
      // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
        {
          dest = _name+"_special_register_unit";
#ifdef POSITION
          _component->interface_map (src ,"spr_"+toString(i),
                                     dest,"spr_"+toString(i));
#endif
      
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_VAL"         ,
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_VAL"         );
          COMPONENT_MAP(_component,src , "in_SPR_"       +toString(i)+"_ACK"         ,
                                   dest,"out_SPR_ACCESS_"+toString(i)+"_ACK"         );
          if (_param->_have_port_front_end_id)
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_FRONT_END_ID",
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_FRONT_END_ID");
          if (_param->_have_port_context_id)
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_CONTEXT_ID"  ,
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_CONTEXT_ID"  );
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_WEN"         ,
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_WEN"         );
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_NUM_GROUP"   ,
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_NUM_GROUP"   );
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_NUM_REG"     ,
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_NUM_REG"     );
          COMPONENT_MAP(_component,src ,"out_SPR_"       +toString(i)+"_WDATA"       ,
                                   dest, "in_SPR_ACCESS_"+toString(i)+"_WDATA"       );
          COMPONENT_MAP(_component,src , "in_SPR_"       +toString(i)+"_RDATA"       ,
                                   dest,"out_SPR_ACCESS_"+toString(i)+"_RDATA"       );
          COMPONENT_MAP(_component,src , "in_SPR_"       +toString(i)+"_INVALID"     ,
                                   dest,"out_SPR_ACCESS_"+toString(i)+"_INVALID"     );
        }

      // ~~~~~[ Interface : "reexecute_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_REEXECUTE_ROB_VAL                    - component_commit_unit
      //  out_REEXECUTE_ROB_ACK                    - component_commit_unit
      //   in_REEXECUTE_ROB_FRONT_END_ID           - component_commit_unit
      //   in_REEXECUTE_ROB_CONTEXT_ID             - component_commit_unit
      //   in_REEXECUTE_ROB_PACKET_ID              - component_commit_unit
      //   in_REEXECUTE_ROB_OPERATION              - component_commit_unit
      //   in_REEXECUTE_ROB_TYPE                   - component_commit_unit
      //   in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE  - component_commit_unit

      // ~~~~~[ Interface : "reexecute" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //  out_REEXECUTE_VAL                        - component_issue_queue
      //   in_REEXECUTE_ACK                        - component_issue_queue
      //  out_REEXECUTE_CONTEXT_ID                 - component_issue_queue
      //  out_REEXECUTE_FRONT_END_ID               - component_issue_queue
      //  out_REEXECUTE_PACKET_ID                  - component_issue_queue
      //  out_REEXECUTE_OPERATION                  - component_issue_queue
      //  out_REEXECUTE_TYPE                       - component_issue_queue
      //  out_REEXECUTE_STORE_QUEUE_PTR_WRITE      - component_issue_queue
      //  out_REEXECUTE_LOAD_QUEUE_PTR_WRITE       - component_issue_queue
      //  out_REEXECUTE_HAS_IMMEDIAT               - component_issue_queue
      //  out_REEXECUTE_IMMEDIAT                   - component_issue_queue
      //  out_REEXECUTE_READ_RA                    - component_issue_queue
      //  out_REEXECUTE_NUM_REG_RA                 - component_issue_queue
      //  out_REEXECUTE_READ_RB                    - component_issue_queue
      //  out_REEXECUTE_NUM_REG_RB                 - component_issue_queue
      //  out_REEXECUTE_READ_RC                    - component_issue_queue
      //  out_REEXECUTE_NUM_REG_RC                 - component_issue_queue
      //  out_REEXECUTE_WRITE_RD                   - component_issue_queue
      //  out_REEXECUTE_NUM_REG_RD                 - component_issue_queue
      //  out_REEXECUTE_WRITE_RE                   - component_issue_queue
      //  out_REEXECUTE_NUM_REG_RE                 - component_issue_queue
    }

    // ===================================================================
    // =====[ special_register_unit ]=====================================
    // ===================================================================
    {
      src = _name+"_special_register_unit";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "spr_access" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_SPR_ACCESS_VAL          - component_reexecute_unit
      //  out_SPR_ACCESS_ACK          - component_reexecute_unit
      //   in_SPR_ACCESS_FRONT_END_ID - component_reexecute_unit
      //   in_SPR_ACCESS_CONTEXT_ID   - component_reexecute_unit
      //   in_SPR_ACCESS_WEN          - component_reexecute_unit
      //   in_SPR_ACCESS_NUM_GROUP    - component_reexecute_unit
      //   in_SPR_ACCESS_NUM_REG      - component_reexecute_unit
      //   in_SPR_ACCESS_WDATA        - component_reexecute_unit
      //  out_SPR_ACCESS_RDATA        - component_reexecute_unit
      //  out_SPR_ACCESS_INVALID      - component_reexecute_unit
      
      // ~~~~~[ Interface : "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name+"_glue";
            
#ifdef POSITION
            _component->interface_map (src ,"spr_read_"+toString(i)+"_"+toString(j),
                                       dest,"spr_"     +toString(i)+"_"+toString(j));
#endif

            COMPONENT_MAP(_component,src ,"out_SPR_READ_"+toString(i)+"_"+toString(j)+                      "_SR",
                                     dest, "in_SPR_"     +toString(i)+"_"+toString(j)+"_SPECIAL_REGISTER_UNIT_SR");
          }

      // ~~~~~[ Interface : "spr_commit" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      //   in_SPR_COMMIT_VAL          - component_commit_unit
      //  out_SPR_COMMIT_ACK          - component_commit_unit
      //   in_SPR_COMMIT_SR_F_VAL     - component_commit_unit
      //   in_SPR_COMMIT_SR_F         - component_commit_unit
      //   in_SPR_COMMIT_SR_CY_VAL    - component_commit_unit
      //   in_SPR_COMMIT_SR_CY        - component_commit_unit
      //   in_SPR_COMMIT_SR_OV_VAL    - component_commit_unit
      //   in_SPR_COMMIT_SR_OV        - component_commit_unit

      // ~~~~~[ Interface "spr_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context[i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"spr_event_"+toString(i)+"_"+toString(j),
                                       dest,"spr_event_"+toString(i)+"_"+toString(j));
#endif

            PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_VAL"      ,
                                dest, "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_VAL"      );
            PORT_MAP(_component,src ,"out_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_ACK"      ,
                                dest,"out_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_ACK"      );
            PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_EPCR"     ,
                                dest, "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_EPCR"     );
            PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_EEAR_WEN" ,
                                dest, "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_EEAR_WEN" );
            PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_EEAR"     ,
                                dest, "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_EEAR"     );
            PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_SR_DSX"   ,
                                dest, "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_SR_DSX"   );
            PORT_MAP(_component,src , "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_SR_TO_ESR",
                                dest, "in_SPR_EVENT_"+toString(i)+"_"+toString(j)+"_SR_TO_ESR");
          }
    }

    // ===================================================================
    // =====[ glue ]======================================================
    // ===================================================================
    {
      src = _name+"_glue";
      log_printf(TRACE,OOO_Engine,FUNCTION,_("Instance : %s"),name.c_str());
	   
      {
	dest = _name;
#ifdef POSITION
	_component->interface_map (src ,"",
				   dest,"");
#endif
	PORT_MAP(_component,src , "in_CLOCK" ,dest, "in_CLOCK");
	PORT_MAP(_component,src , "in_NRESET",dest, "in_NRESET");
      }

      // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_inst_decod [i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"rename_"+toString(i)+"_"+toString(j),
                                       dest,"rename_"+toString(i)+"_"+toString(j));
#endif
            
            if (_param->_have_port_front_end_id)
            PORT_MAP(_component,src , "in_RENAME_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID",
                                dest, "in_RENAME_"+toString(i)+"_"+toString(j)+"_FRONT_END_ID");

            //  out_RENAME_RENAME_UNIT_FRONT_END_ID              - component_rename_unit
          }

      // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_sum_inst_insert; i++)
        {
          dest = _name;
#ifdef POSITION
          _component->interface_map (src ,"insert_"+toString(i),
                                     dest,"insert_"+toString(i));
#endif
          PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_VAL"       ,
                              dest,"out_INSERT_"+toString(i)+"_VAL"       );
          PORT_MAP(_component,src , "in_INSERT_"+toString(i)+"_ACK"       ,
                              dest, "in_INSERT_"+toString(i)+"_ACK"       );
          PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_RD_USE"    ,
                              dest,"out_INSERT_"+toString(i)+"_RD_USE"    );
          PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_RD_NUM_REG",
                              dest,"out_INSERT_"+toString(i)+"_RD_NUM_REG");
          PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_RE_USE"    ,
                              dest,"out_INSERT_"+toString(i)+"_RE_USE"    );
          PORT_MAP(_component,src ,"out_INSERT_"+toString(i)+"_RE_NUM_REG",
                              dest,"out_INSERT_"+toString(i)+"_RE_NUM_REG");
        }

      //   in_INSERT_RENAME_UNIT_VAL                       - component_rename_unit
      //  out_INSERT_RENAME_UNIT_ACK                       - component_rename_unit
      //   in_INSERT_RENAME_UNIT_FRONT_END_ID              - component_rename_unit
      //   in_INSERT_RENAME_UNIT_CONTEXT_ID                - component_rename_unit
      //   in_INSERT_RENAME_UNIT_TYPE                      - component_rename_unit
      //   in_INSERT_RENAME_UNIT_OPERATION                 - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NO_EXECUTE                - component_rename_unit
      //   in_INSERT_RENAME_UNIT_HAS_IMMEDIAT              - component_rename_unit
      //   in_INSERT_RENAME_UNIT_IMMEDIAT                  - component_rename_unit
      //   in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE     - component_rename_unit
      //   in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE      - component_rename_unit
      //   in_INSERT_RENAME_UNIT_READ_RA                   - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY            - component_rename_unit
      //   in_INSERT_RENAME_UNIT_READ_RB                   - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY            - component_rename_unit
      //   in_INSERT_RENAME_UNIT_READ_RC                   - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY            - component_rename_unit
      //   in_INSERT_RENAME_UNIT_WRITE_RD                  - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD        - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW        - component_rename_unit
      //   in_INSERT_RENAME_UNIT_WRITE_RE                  - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD        - component_rename_unit
      //   in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW        - component_rename_unit
      //  
      //  out_INSERT_COMMIT_UNIT_VAL                       - component_commit_unit
      //   in_INSERT_COMMIT_UNIT_ACK                       - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_FRONT_END_ID              - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_CONTEXT_ID                - component_commit_unit
      ////out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID            - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_TYPE                      - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_OPERATION                 - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NO_EXECUTE                - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE     - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE      - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_READ_RA                   - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY            - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_READ_RB                   - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY            - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_READ_RC                   - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY            - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_WRITE_RD                  - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_WRITE_RE                  - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        - component_commit_unit
      //  out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        - component_commit_unit
      //  
      //  out_INSERT_ISSUE_QUEUE_VAL                       - component_issue_queue
      //   in_INSERT_ISSUE_QUEUE_ACK                       - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_CONTEXT_ID                - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_FRONT_END_ID              - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_OPERATION                 - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_TYPE                      - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE     - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE      - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT              - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_IMMEDIAT                  - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_READ_RA                   - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_NUM_REG_RA                - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_READ_RB                   - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_NUM_REG_RB                - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_READ_RC                   - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_NUM_REG_RC                - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_WRITE_RD                  - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_NUM_REG_RD                - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_WRITE_RE                  - component_issue_queue
      //  out_INSERT_ISSUE_QUEUE_NUM_REG_RE                - component_issue_queue

//       // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//       for (uint32_t i=0; i<_param->_sum_inst_retire; i++)
//         {
//           dest = _name;
// #ifdef POSITION
//           _component->interface_map (src ,"retire_"+toString(i),
//                                      dest,"retire_"+toString(i));
// #endif

//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_VAL"           ,
//                               dest,"out_RETIRE_"+toString(i)+"_VAL"           );
//           PORT_MAP(_component,src , "in_RETIRE_"+toString(i)+"_ACK"           ,
//                               dest, "in_RETIRE_"+toString(i)+"_ACK"           );
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RD_OLD_USE"    ,
//                               dest,"out_RETIRE_"+toString(i)+"_RD_OLD_USE"    ); 
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RD_OLD_NUM_REG",
//                               dest,"out_RETIRE_"+toString(i)+"_RD_OLD_NUM_REG");
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RD_NEW_USE"    ,
//                               dest,"out_RETIRE_"+toString(i)+"_RD_NEW_USE"    );
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RD_NEW_NUM_REG",
//                               dest,"out_RETIRE_"+toString(i)+"_RD_NEW_NUM_REG");
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RE_OLD_USE"    ,
//                               dest,"out_RETIRE_"+toString(i)+"_RE_OLD_USE"    ); 
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RE_OLD_NUM_REG",
//                               dest,"out_RETIRE_"+toString(i)+"_RE_OLD_NUM_REG");
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RE_NEW_USE"    ,
//                               dest,"out_RETIRE_"+toString(i)+"_RE_NEW_USE"    );
//           PORT_MAP(_component,src ,"out_RETIRE_"+toString(i)+"_RE_NEW_NUM_REG",
//                               dest,"out_RETIRE_"+toString(i)+"_RE_NEW_NUM_REG");
//         }

      //  out_RETIRE_RENAME_UNIT_VAL                       - component_rename_unit
      //   in_RETIRE_RENAME_UNIT_ACK                       - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_FRONT_END_ID              - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_WRITE_RD                  - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD        - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW        - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_WRITE_RE                  - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD        - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW        - component_rename_unit
      //  out_RETIRE_RENAME_UNIT_EVENT_STATE               - component_rename_unit

      //   in_RETIRE_COMMIT_UNIT_VAL                       - component_commit_unit
      //  out_RETIRE_COMMIT_UNIT_ACK                       - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_FRONT_END_ID              - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_WRITE_RD                  - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_WRITE_RE                  - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        - component_commit_unit
      //   in_RETIRE_COMMIT_UNIT_EVENT_STATE               - component_commit_unit

      // ~~~~~[ Interface : "spr_sr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      for (uint32_t i=0; i<_param->_nb_front_end; i++)
        for (uint32_t j=0; j<_param->_nb_context [i]; j++)
          {
            dest = _name;
#ifdef POSITION
            _component->interface_map (src ,"spr_"+toString(i)+"_"+toString(j),
                                       dest,"spr_"+toString(i)+"_"+toString(j));
#endif

            PORT_MAP(_component,src ,"out_SPR_"+toString(i)+"_"+toString(j)+"_SR_IEE",
                                dest,"out_SPR_"+toString(i)+"_"+toString(j)+"_SR_IEE");
            PORT_MAP(_component,src ,"out_SPR_"+toString(i)+"_"+toString(j)+"_SR_EPH",
                                dest,"out_SPR_"+toString(i)+"_"+toString(j)+"_SR_EPH");

            //  out_SPR_RENAME_UNIT_SR                           - component_rename_unit
            //  out_SPR_COMMIT_UNIT_SR_OVE                       - component_commit_unit
            //   in_SPR_SPECIAL_REGISTER_UNIT_SR                 - component_special_register_unit
          }


    }

    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
#if DEBUG_OOO_Engine == true
       _component->test_map();
#endif

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

     log_end(OOO_Engine,FUNCTION);
    };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
