/*
 * $Id: Select_Priority_Fixed_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Select/Select_Priority_Fixed/include/Select_Priority_Fixed.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo{
namespace behavioural {
namespace generic {
namespace select {
namespace select_priority_fixed {

  void Select_Priority_Fixed::allocation (void)
  {
    log_printf(FUNC,Select_Priority_Fixed,"allocation","Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name                 
					     ,"Select_Priority_Fixed"
#ifdef POSITION
					     ,COMBINATORY            
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Interface_fifo * interface = _interfaces->set_interface(""
#ifdef POSITION
							    ,IN  
							    ,WEST
							    ,_("Generalist interface")
#endif
							    );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_NO);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_NO);
     
     {
       ALLOC1_INTERFACE_BEGIN("",IN,SOUTH,_("select interface"),_param->_nb_entity);

       ALLOC1_SIGNAL_IN ( in_VAL       ,"val"       ,Tcontrol_t,1);
       if (_param->_encoding_one_hot)
       ALLOC1_SIGNAL_OUT(out_ACK       ,"ack"       ,Tcontrol_t,1);

       ALLOC1_INTERFACE_END(_param->_nb_entity);
     }

     if (_param->_encoding_compact)
     {
       ALLOC0_INTERFACE_BEGIN("",OUT,SOUTH,_("select interface"));

       ALLOC0_SIGNAL_OUT(out_ENTITY    ,"entity"    ,Tentity_t ,_param->_size_entity);
       ALLOC0_SIGNAL_OUT(out_ENTITY_ACK,"entity_ack",Tcontrol_t,1);

       ALLOC0_INTERFACE_END();
     }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Select_Priority_Fixed,"allocation","End");
  };

}; // end namespace select_priority_fixed
}; // end namespace select
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
