/*
 * $Id: Sort_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Sort/include/Sort.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace sort {


#undef  FUNCTION
#define FUNCTION "Sort::deallocation"
  void Sort::deallocation (void)
  {
    log_printf(FUNC,Sort,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete     in_CLOCK ;
	delete     in_NRESET;

        DELETE1_SIGNAL(in_INPUT_VAL ,_param->_nb_input, 1);
        DELETE1_SIGNAL(in_INPUT_DATA,_param->_nb_input, _param->_size_data);
        
        DELETE1_SIGNAL(out_OUTPUT_VAL  ,_param->_nb_output,1);
        if (_param->_have_port_index_out)
        DELETE1_SIGNAL(out_OUTPUT_INDEX,_param->_nb_output,_param->_size_address);
        if (_param->_have_port_data_out)
        DELETE1_SIGNAL(out_OUTPUT_DATA ,_param->_nb_output,_param->_size_data   );
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Sort,FUNCTION,"End");
  };

}; // end namespace sort
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
