/*
 * $Id: Decod_queue_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::deallocation"
  void Decod_queue::deallocation (void)
  {
    log_begin(Decod_queue,FUNCTION);

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

	DELETE1_SIGNAL( in_DECOD_IN_VAL            ,_param->_nb_inst_decod,1);
	DELETE1_SIGNAL(out_DECOD_IN_ACK            ,_param->_nb_inst_decod,1);
	DELETE1_SIGNAL( in_DECOD_IN_CONTEXT_ID     ,_param->_nb_inst_decod,_param->_size_context_id            );
	DELETE1_SIGNAL( in_DECOD_IN_DEPTH          ,_param->_nb_inst_decod,_param->_size_depth                 );
	DELETE1_SIGNAL( in_DECOD_IN_TYPE           ,_param->_nb_inst_decod,_param->_size_type                  );
	DELETE1_SIGNAL( in_DECOD_IN_OPERATION      ,_param->_nb_inst_decod,_param->_size_operation             );
	DELETE1_SIGNAL( in_DECOD_IN_NO_EXECUTE     ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_IS_DELAY_SLOT  ,_param->_nb_inst_decod,1                                   );
#ifdef DEBUG
	DELETE1_SIGNAL( in_DECOD_IN_ADDRESS        ,_param->_nb_inst_decod,_param->_size_instruction_address   );
#endif
	DELETE1_SIGNAL( in_DECOD_IN_ADDRESS_NEXT   ,_param->_nb_inst_decod,_param->_size_instruction_address   );
	DELETE1_SIGNAL( in_DECOD_IN_HAS_IMMEDIAT   ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_IMMEDIAT       ,_param->_nb_inst_decod,_param->_size_general_data          );
	DELETE1_SIGNAL( in_DECOD_IN_READ_RA        ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_NUM_REG_RA     ,_param->_nb_inst_decod,_param->_size_general_register_logic);
	DELETE1_SIGNAL( in_DECOD_IN_READ_RB        ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_NUM_REG_RB     ,_param->_nb_inst_decod,_param->_size_general_register_logic);
	DELETE1_SIGNAL( in_DECOD_IN_READ_RC        ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_NUM_REG_RC     ,_param->_nb_inst_decod,_param->_size_special_register_logic);
	DELETE1_SIGNAL( in_DECOD_IN_WRITE_RD       ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_NUM_REG_RD     ,_param->_nb_inst_decod,_param->_size_general_register_logic);
	DELETE1_SIGNAL( in_DECOD_IN_WRITE_RE       ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL( in_DECOD_IN_NUM_REG_RE     ,_param->_nb_inst_decod,_param->_size_special_register_logic);
	DELETE1_SIGNAL( in_DECOD_IN_EXCEPTION_USE  ,_param->_nb_inst_decod,_param->_size_exception_use         );
	DELETE1_SIGNAL( in_DECOD_IN_EXCEPTION      ,_param->_nb_inst_decod,_param->_size_exception             );
	
	DELETE1_SIGNAL(out_DECOD_OUT_VAL           ,_param->_nb_inst_decod,1);
	DELETE1_SIGNAL( in_DECOD_OUT_ACK           ,_param->_nb_inst_decod,1);
	DELETE1_SIGNAL(out_DECOD_OUT_CONTEXT_ID    ,_param->_nb_inst_decod,_param->_size_context_id            );
	DELETE1_SIGNAL(out_DECOD_OUT_DEPTH         ,_param->_nb_inst_decod,_param->_size_depth                 );
	DELETE1_SIGNAL(out_DECOD_OUT_TYPE          ,_param->_nb_inst_decod,_param->_size_type                  );
	DELETE1_SIGNAL(out_DECOD_OUT_OPERATION     ,_param->_nb_inst_decod,_param->_size_operation             );
	DELETE1_SIGNAL(out_DECOD_OUT_NO_EXECUTE    ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_IS_DELAY_SLOT ,_param->_nb_inst_decod,1                                   );
#ifdef DEBUG
	DELETE1_SIGNAL(out_DECOD_OUT_ADDRESS       ,_param->_nb_inst_decod,_param->_size_instruction_address   );
#endif
	DELETE1_SIGNAL(out_DECOD_OUT_ADDRESS_NEXT  ,_param->_nb_inst_decod,_param->_size_instruction_address   );
	DELETE1_SIGNAL(out_DECOD_OUT_HAS_IMMEDIAT  ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_IMMEDIAT      ,_param->_nb_inst_decod,_param->_size_general_data          );
	DELETE1_SIGNAL(out_DECOD_OUT_READ_RA       ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_NUM_REG_RA    ,_param->_nb_inst_decod,_param->_size_general_register_logic);
	DELETE1_SIGNAL(out_DECOD_OUT_READ_RB       ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_NUM_REG_RB    ,_param->_nb_inst_decod,_param->_size_general_register_logic);
	DELETE1_SIGNAL(out_DECOD_OUT_READ_RC       ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_NUM_REG_RC    ,_param->_nb_inst_decod,_param->_size_special_register_logic);
	DELETE1_SIGNAL(out_DECOD_OUT_WRITE_RD      ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_NUM_REG_RD    ,_param->_nb_inst_decod,_param->_size_general_register_logic);
	DELETE1_SIGNAL(out_DECOD_OUT_WRITE_RE      ,_param->_nb_inst_decod,1                                   );
	DELETE1_SIGNAL(out_DECOD_OUT_NUM_REG_RE    ,_param->_nb_inst_decod,_param->_size_special_register_logic);
	DELETE1_SIGNAL(out_DECOD_OUT_EXCEPTION_USE ,_param->_nb_inst_decod,_param->_size_exception_use         );
	DELETE1_SIGNAL(out_DECOD_OUT_EXCEPTION     ,_param->_nb_inst_decod,_param->_size_exception             );
	
	DELETE1_SIGNAL( in_DEPTH_MIN               ,_param->_nb_context,_param->_size_depth);
	DELETE1_SIGNAL( in_DEPTH_MAX               ,_param->_nb_context,_param->_size_depth);
	DELETE1_SIGNAL( in_DEPTH_FULL              ,_param->_nb_context,1);

	DELETE1_SIGNAL(out_NB_INST_ALL             ,_param->_nb_context,_param->_size_nb_inst_decod);

        // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
        switch (_param->_queue_scheme)
          {
          case DECOD_QUEUE_SCHEME_ONE_FIFO   :
            {
              while (not reg_QUEUE->empty())
                {
                  delete reg_QUEUE->front();
                  reg_QUEUE->pop_front();
                }

              DELETE0(reg_QUEUE);
              break;
            }
          case DECOD_QUEUE_SCHEME_MULTI_FIFO :
            {
              for (uint32_t i=0; i<_param->_nb_bank; ++i)
                while (not reg_QUEUE[i].empty())
                  {
                    delete reg_QUEUE[i].front();
                    reg_QUEUE[i].pop_front();
                  }

              DELETE1(reg_QUEUE,_param->_nb_bank); break;
            } 
          }

        DELETE1(reg_NB_INST ,_param->_nb_context);
        
        // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        DELETE1(internal_DECOD_IN_ACK ,_param->_nb_inst_decod);
        DELETE1(internal_DECOD_OUT_VAL,_param->_nb_inst_decod);
        DELETE1(internal_DECOD_OUT_ACK,_param->_nb_inst_decod);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
