/*
 * $Id: Branch_Target_Buffer_Glue_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Branch_Target_Buffer_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::deallocation"
  void Branch_Target_Buffer_Glue::deallocation (void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete     in_CLOCK ;
	delete     in_NRESET;

	DELETE1_SIGNAL( in_PREDICT_VAL           ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_ACK           ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_HIT           ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_ADDRESS_SRC   ,_param->_nb_inst_predict, _param->_size_instruction_address);
	DELETE1_SIGNAL(out_PREDICT_ADDRESS_DEST  ,_param->_nb_inst_predict, _param->_size_instruction_address);
	DELETE1_SIGNAL(out_PREDICT_CONDITION     ,_param->_nb_inst_predict, _param->_size_branch_condition);
	DELETE1_SIGNAL(out_PREDICT_LAST_TAKE     ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_IS_ACCURATE   ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_REGISTER_VAL  ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL( in_PREDICT_REGISTER_ACK  ,_param->_nb_inst_predict, 1);
	if (_param->_have_port_victim)
	  {
	DELETE1_SIGNAL( in_PREDICT_SORT_VAL      ,_param->_nb_inst_predict,1);
	DELETE1_SIGNAL( in_PREDICT_SORT_INDEX    ,_param->_nb_inst_predict,_param->_size_victim);

	DELETE1_SIGNAL(out_PREDICT_VICTIM_VAL    ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL( in_PREDICT_VICTIM_ACK    ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_VICTIM_HIT    ,_param->_nb_inst_predict, 1);
	DELETE1_SIGNAL(out_PREDICT_VICTIM_ADDRESS,_param->_nb_inst_predict, _param->_size_victim_address);
	DELETE1_SIGNAL(out_PREDICT_VICTIM_INDEX  ,_param->_nb_inst_predict, _param->_size_victim);
	DELETE1_SIGNAL( in_PREDICT_VICTIM_VICTIM ,_param->_nb_inst_predict, _param->_size_victim);
	  }

	DELETE2_SIGNAL( in_PREDICT_REGISTER_HIT         ,_param->_nb_inst_predict, _param->_associativity,1);
	DELETE2_SIGNAL( in_PREDICT_REGISTER_ADDRESS_SRC ,_param->_nb_inst_predict, _param->_associativity,_param->_size_instruction_address);
	DELETE2_SIGNAL( in_PREDICT_REGISTER_ADDRESS_DEST,_param->_nb_inst_predict, _param->_associativity,_param->_size_instruction_address);
	DELETE2_SIGNAL( in_PREDICT_REGISTER_CONDITION   ,_param->_nb_inst_predict, _param->_associativity,_param->_size_branch_condition);
	DELETE2_SIGNAL( in_PREDICT_REGISTER_LAST_TAKE   ,_param->_nb_inst_predict, _param->_associativity,1);
	DELETE2_SIGNAL( in_PREDICT_REGISTER_IS_ACCURATE ,_param->_nb_inst_predict, _param->_associativity,1);

        DELETE1_SIGNAL( in_DECOD_VAL           ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_ACK           ,_param->_nb_inst_decod,1);
        if (not _param->_is_full_associative)
        DELETE1_SIGNAL( in_DECOD_ADDRESS_SRC   ,_param->_nb_inst_decod,_param->_size_instruction_address);
      
        DELETE1_SIGNAL(out_DECOD_REGISTER_VAL  ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_REGISTER_ACK  ,_param->_nb_inst_decod,1);
        if (_param->_have_port_victim)
          {
        DELETE1_SIGNAL(out_DECOD_VICTIM_VAL    ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL( in_DECOD_VICTIM_ACK    ,_param->_nb_inst_decod,1);
        DELETE1_SIGNAL(out_DECOD_VICTIM_ADDRESS,_param->_nb_inst_decod,_param->_size_victim_address);
          }

        DELETE1_SIGNAL( in_UPDATE_VAL           ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_ACK           ,_param->_nb_inst_update,1);
        if (not _param->_is_full_associative)
        DELETE1_SIGNAL( in_UPDATE_ADDRESS_SRC   ,_param->_nb_inst_update,_param->_size_instruction_address);
        DELETE1_SIGNAL(out_UPDATE_REGISTER_VAL  ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_REGISTER_ACK  ,_param->_nb_inst_update,1);
        if (_param->_have_port_victim)
          {
        DELETE1_SIGNAL(out_UPDATE_VICTIM_VAL    ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_VICTIM_ACK    ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_VICTIM_ADDRESS,_param->_nb_inst_update,_param->_size_victim_address);
          }

      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    delete _component;

    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
