/*
 * $Id: Parameters.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {


#undef  FUNCTION
#define FUNCTION "Rename_unit::Parameters"
  Parameters::Parameters (uint32_t             nb_front_end                     ,
			  uint32_t           * nb_context                       ,
			  uint32_t           * nb_inst_decod                    ,
			  uint32_t             nb_inst_insert                   ,
			  uint32_t             nb_inst_retire                   ,
			  uint32_t             nb_load_store_queue              ,
			  uint32_t           * size_store_queue                 ,
			  uint32_t           * size_load_queue                  ,
			  uint32_t           * nb_inst_memory                   ,
			  uint32_t          ** link_load_store_unit_with_thread ,
			  Tpriority_t          rename_select_priority           ,
			  Tload_balancing_t    rename_select_load_balancing     ,
			  uint32_t             rename_select_nb_front_end_select,
			  uint32_t             max_branch_speculated            ,
			  uint32_t             size_general_data                ,
			  uint32_t             nb_general_register              ,
			  uint32_t             nb_special_register              ,
			  uint32_t             nb_reg_free                      ,
			  uint32_t             nb_bank                          ,
// 			  uint32_t             size_read_counter                ,
                          bool                 is_toplevel)
  {
    log_begin(Rename_unit,FUNCTION);

    _nb_front_end                      = nb_front_end                     ;
    _nb_context                        = nb_context                       ;
    _nb_inst_decod                     = nb_inst_decod                    ;
    _nb_inst_insert                    = nb_inst_insert                   ;
    _nb_inst_retire                    = nb_inst_retire                   ;
    _nb_load_store_queue               = nb_load_store_queue              ;
    _size_store_queue                  = size_store_queue                 ;
    _size_load_queue                   = size_load_queue                  ;
    _nb_inst_memory                    = nb_inst_memory                   ;
    _link_load_store_unit_with_thread  = link_load_store_unit_with_thread ;
    _rename_select_priority            = rename_select_priority           ;
    _rename_select_load_balancing      = rename_select_load_balancing     ;
    _rename_select_nb_front_end_select = rename_select_nb_front_end_select;
    _max_branch_speculated             = max_branch_speculated            ;
    _nb_general_register               = nb_general_register              ;
    _nb_special_register               = nb_special_register              ;
    _nb_reg_free                       = nb_reg_free                      ;
    _nb_bank                           = nb_bank                          ;
//     _size_read_counter                 = size_read_counter                ;
    
    uint32_t size_special_register     = log2(_nb_special_register);

    test();

    log_printf(TRACE,Rename_unit,FUNCTION,_("Creation : _param_rename_select."));
    _param_rename_select = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_select::Parameters 
      (
       _nb_front_end         ,
       _nb_context           ,
       _max_branch_speculated,
       _size_general_data    ,
       _nb_inst_insert       ,
       _nb_inst_decod        ,
       _rename_select_nb_front_end_select  ,
       _rename_select_priority             ,
       _rename_select_load_balancing       
       );

    log_printf(TRACE,Rename_unit,FUNCTION,_("Creation : _param_register_translation_unit."));
    _param_register_translation_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::Parameters
      (
       _nb_front_end          ,
       _nb_context            ,
       _nb_general_register   ,
       _nb_special_register   ,
       _nb_inst_insert        ,
       _nb_inst_retire        ,
       _nb_reg_free           ,
       _nb_bank               // ,
//        _size_read_counter     
       );

    log_printf(TRACE,Rename_unit,FUNCTION,_("Creation : _param_load_store_pointer_unit."));
    _param_load_store_pointer_unit = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::load_store_pointer_unit::Parameters
      (
       _nb_front_end                    ,
       _nb_context                      ,
       _nb_load_store_queue             ,
       _size_store_queue                ,
       _size_load_queue                 ,
       _nb_inst_memory                  ,
       _link_load_store_unit_with_thread,
       _nb_inst_insert                  ,
       _nb_inst_retire                  
       );

    log_printf(TRACE,Rename_unit,FUNCTION,_("Creation : _param_glue."));
    _param_glue = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::rename_unit_glue::Parameters
      (
       _nb_front_end         ,
       _nb_context           ,
       _nb_inst_insert       ,
       _nb_inst_retire       ,
       _size_general_data    ,
       _size_special_register
       );

    if (is_toplevel)
      {
        _size_instruction_address          = size_general_data-2;
        _size_front_end_id                 = log2(_nb_front_end);
        _size_context_id                   = log2(max<uint32_t>(_nb_context,_nb_front_end));
        _size_store_queue_ptr              = log2(max<uint32_t>(_size_store_queue,nb_load_store_queue));
        _size_load_queue_ptr               = log2(max<uint32_t>(_size_load_queue ,nb_load_store_queue));
        _size_general_register             = log2(_nb_general_register);
        _size_special_register             = size_special_register;
        _size_depth                        = log2(_max_branch_speculated);
        _size_general_data                 = size_general_data                ;
        
        _have_port_front_end_id            = _size_front_end_id   > 0;
        _have_port_context_id              = _size_context_id     > 0;
        _have_port_load_queue_ptr          = _size_load_queue_ptr > 0;
        _have_port_depth                   = _size_depth          > 0;
        
        copy();
      }

    log_end(Rename_unit,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Rename_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Rename_unit,FUNCTION);
//     test();
//     log_end(Rename_unit,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Rename_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Rename_unit,FUNCTION);

    delete _param_rename_select            ;
    delete _param_register_translation_unit;
    delete _param_load_store_pointer_unit  ;
    delete _param_glue                     ;

    log_end(Rename_unit,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Rename_unit::copy"
  void Parameters::copy (void) 
  {
    log_begin(Rename_unit,FUNCTION);

    COPY(_param_rename_select            );
    COPY(_param_register_translation_unit);
    COPY(_param_load_store_pointer_unit  );
    COPY(_param_glue                     );

    log_end(Rename_unit,FUNCTION);
  };

}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
