/*
 * $Id: Victim_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Victim/include/Victim.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace victim {



#undef  FUNCTION
#define FUNCTION "Victim::allocation"
  void Victim::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Victim,FUNCTION,"Begin");

    
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      __ALLOC0_SIGNAL(in_CLOCK ,"in_CLOCK" ,SC_CLOCK          );
      __ALLOC0_SIGNAL(in_NRESET,"in_NRESET",SC_IN (Tcontrol_t));
    }

    // ~~~~~[ Interface : "Access" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      __ALLOC1_INTERFACE_BEGIN("ACCESS",_param->_nb_access);

      __ALLOC1_SIGNAL_IN ( in_ACCESS_VAL    ,"VAL"    ,Tcontrol_t);
      __ALLOC1_SIGNAL_OUT(out_ACCESS_ACK    ,"ACK"    ,Tcontrol_t);
      if (_param->_have_port_address)
      __ALLOC1_SIGNAL_IN ( in_ACCESS_ADDRESS,"ADDRESS",Taddress_t);
      __ALLOC1_SIGNAL_IN ( in_ACCESS_HIT    ,"HIT"    ,Tcontrol_t);
      __ALLOC1_SIGNAL_IN ( in_ACCESS_ENTITY ,"ENTITY" ,Tentity_t );
      __ALLOC1_SIGNAL_OUT(out_ACCESS_VICTIM ,"VICTIM" ,Tentity_t );

      __ALLOC1_INTERFACE_END(_param->_nb_access);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    std::string name;

    switch (_param->_victim_scheme)
      {
//       case VICTIM_RANDOM      :
//       case VICTIM_ROUND_ROBIN :
//       case VICTIM_NLU         :
      case VICTIM_PSEUDO_LRU  :
	{
	  std::cout << "Create   : " << _name << std::endl;

	  _component_victim_pseudo_lru = new morpheo::behavioural::generic::victim::victim_pseudo_lru::Victim_Pseudo_LRU
	    (_name.c_str()
#ifdef STATISTICS
	     ,param_statistics
#endif
	     ,_param->_param_victim_pseudo_lru
	     ,_usage);
	  break;
	}
//       case VICTIM_LRU         :
//       case VICTIM_FIFO        :
      default : break;
      }
    
    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    std::cout << "Instance : " << _name << std::endl;

    switch (_param->_victim_scheme)
      {

//       case VICTIM_RANDOM      :
//       case VICTIM_ROUND_ROBIN :
//       case VICTIM_NLU         :
      case VICTIM_PSEUDO_LRU  :
	{
	  {
	    (*(_component_victim_pseudo_lru-> in_CLOCK )) (*( in_CLOCK));
	    (*(_component_victim_pseudo_lru-> in_NRESET)) (*( in_NRESET));
	  }
	  
	  for (uint32_t i=0; i<_param->_nb_access; i++)
	    {
	      (*(_component_victim_pseudo_lru-> in_ACCESS_VAL     [i])) (*( in_ACCESS_VAL     [i]));
	      (*(_component_victim_pseudo_lru->out_ACCESS_ACK     [i])) (*(out_ACCESS_ACK     [i]));
	      if (_param->_have_port_address)
	      (*(_component_victim_pseudo_lru-> in_ACCESS_ADDRESS [i])) (*( in_ACCESS_ADDRESS [i]));
	      (*(_component_victim_pseudo_lru-> in_ACCESS_HIT     [i])) (*( in_ACCESS_HIT     [i]));
	      (*(_component_victim_pseudo_lru-> in_ACCESS_ENTITY  [i])) (*( in_ACCESS_ENTITY  [i]));
	      (*(_component_victim_pseudo_lru->out_ACCESS_VICTIM  [i])) (*(out_ACCESS_VICTIM  [i]));
	    }

	  break;
	}
//       case VICTIM_LRU         :
//       case VICTIM_FIFO        :
      default : break;
      }

   
    // ~~~~~[ Others ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
    switch (_param->_victim_scheme)
      {
//    case VICTIM_RANDOM      : _component = _component_victim_random     ->_component; break;
//    case VICTIM_ROUND_ROBIN : _component = _component_victim_round_robin->_component; break;
//    case VICTIM_NLU         : _component = _component_victim_nlu        ->_component; break;
      case VICTIM_PSEUDO_LRU  : _component = _component_victim_pseudo_lru ->_component; break;
//    case VICTIM_LRU         : _component = _component_victim_lru        ->_component; break;
//    case VICTIM_FIFO        : _component = _component_victim_fifo       ->_component; break;
      default : break;
      }

    log_printf(FUNC,Victim,FUNCTION,"End");
  };

}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
