/*
 * $Id: top.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test "Queue"
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#define NB_ITERATION  1
#define CYCLE_MAX     (2048*NB_ITERATION)

#include "Common/include/Test.h"
#include "Common/include/Time.h"
#include "Behavioural/Generic/Queue/include/Queue.h"

using namespace std;
using namespace morpheo;
using namespace morpheo::behavioural;
using namespace morpheo::behavioural::generic;

using namespace morpheo::behavioural::generic::queue;

void test    (string name,
	      morpheo::behavioural::generic::queue::Parameters * param);

SC_MODULE(top)
{
#ifdef SYSTEMC
 private: sc_clock               *  in_CLOCK ;
 private: sc_signal<Tcontrol_t>  *  in_NRESET;

 private: sc_signal<Tcontrol_t>  *  in_INSERT_VAL;
 private: sc_signal<Tcontrol_t>  * out_INSERT_ACK;
 private: sc_signal<Tdata_t   >  *  in_INSERT_DATA;

 private: sc_signal<Tcontrol_t>  * out_RETIRE_VAL;
 private: sc_signal<Tcontrol_t>  *  in_RETIRE_ACK;
 private: sc_signal<Tdata_t   >  * out_RETIRE_DATA;

 private: sc_signal<Tcontrol_t> ** out_SLOT_VAL ; //[nb_port_slot]
 private: sc_signal<Tdata_t   > ** out_SLOT_DATA; //[nb_port_slot]

 private: sc_signal<Tptr_t    >  * out_PTR_WRITE;
 private: sc_signal<Tptr_t    >  * out_PTR_READ ;
#endif

 private: std::string name;
 private: Tusage_t _usage;
 private: morpheo::behavioural::generic::queue::Parameters * _param;
#ifdef STATISTICS
 private: morpheo::behavioural::Parameters_Statistics * _param_stat;
#endif
 private: Queue * component;

 private: void usage
    (
#ifdef MTI_SYSTEMC
     int argc, const char * const * argv
#else
     int argc, char * argv[]
#endif
     );
 private: void allocation   (void);
 private: void deallocation (void);
 public : void test         (void);

#ifdef MTI_SYSTEMC
  SC_CTOR(top::top);
#else
 public : top (sc_module_name module_name,int argc, char * argv[]);
#endif
 public : ~top(void);
};
