/*
 * $Id: Parameters.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Parameters.h"
#include "Common/include/Log2.h"
namespace morpheo {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::Parameters"
  Parameters::Parameters (uint32_t size_queue         ,
                          uint32_t size_data          ,
                          uint32_t nb_port_slot       ,
                          bool     have_port_ptr_write,
                          bool     have_port_ptr_read ):
    behavioural::Parameters("Queue"),
    _size_queue          (size_queue),
    _size_data           (size_data ),
    _nb_port_slot        (nb_port_slot),
    _have_port_ptr_write (have_port_ptr_write and (log2(size_queue)>0)),
    _have_port_ptr_read  (have_port_ptr_read  and (log2(size_queue)>0)),
    _size_ptr            (log2(size_queue)),
    _have_port_ptr       (have_port_ptr_write or have_port_ptr_read)
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");
    test();
    log_printf(FUNC,Queue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Queue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param):
//     _size_queue (param._size_queue),
//     _size_data  (param._size_data )
//   {
//     log_printf(FUNC,Queue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Queue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Queue::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");
    log_printf(FUNC,Queue,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Queue::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Queue,FUNCTION,"Begin");
    log_printf(FUNC,Queue,FUNCTION,"End");
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
