/*
 * $Id: Queue.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Queue/include/Queue.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace queue {


#undef  FUNCTION
#define FUNCTION "Queue::Queue"
  Queue::Queue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::generic::queue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Queue,FUNCTION);
    
// #if DEBUG_Core == true
//     log_printf(INFO,Core,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Queue,FUNCTION,_("<%s> Allocation"),_name.c_str());
    allocation ();

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Queue,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());
	
	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Queue,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Queue,FUNCTION,_("<%s> Method - transition"),_name.c_str());
	
	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
	log_printf(INFO,Queue,FUNCTION,_("<%s> Method - genMoore"),_name.c_str());
	
	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
	
#endif
      }
    log_end(Queue,FUNCTION);
  };
  
#undef  FUNCTION
#define FUNCTION "Queue::~Queue"
  Queue::~Queue (void)
  {
    log_begin(Queue,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Queue,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
	
	delete _stat;
      }
#endif

    log_printf(INFO,Queue,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_end(Queue,FUNCTION);
  };

}; // end namespace queue
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
