#ifdef VHDL

/*
 * $Id: Vhdl_get_header.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Behavioural/include/Version.h"
#include <time.h>
#include <sstream>
#include <fstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_header"
  std::string Vhdl::get_header(uint32_t depth,
			       std::string   filename)
  {
    log_begin(Behavioural,FUNCTION);

    std::string text;

    time_t current_time;
    time (&current_time);

    text += "-------------------------------------------------------------------------------\n";
    text += "-- "+toString(_("File    : ")) + filename  +"\n";
    text += "-- "+toString(_("Date    : ")) + ctime (&current_time );
    text += "-- "+toString(_("Version : ")) + MORPHEO_HEADER +"\n";
    text += "-- "+toString(_("Id      : ")) + _id +"  \n";
    text += "-- "+toString(_("Comment : ")) + _("it's a autogenerated file, don't modify") +"\n";
    text += "-------------------------------------------------------------------------------\n";
    
    log_end(Behavioural,FUNCTION);

    return text;
  };

#undef  FUNCTION
#define FUNCTION "vhdl_get_id"
  std::string vhdl_get_id(std::string model_name)
  {
    log_begin(Behavioural,FUNCTION);

    std::string id="";

    directory();

    std::string filename = MORPHEO_VHDL + "/" + model_name + VHDL_EXTENSION;
    std::ifstream file;

    file.open(filename.c_str(),std::ios::in);

    // open file
    if (!file)
      {
        log_printf(INFO,Behavioural,FUNCTION,_("Can't open file : \"%s\""),filename.c_str());
      }
    else
      {
        // get line with Id
        do
          {
            std::getline(file,id,'\n'); // comment
          } while ((id.find("Id      :") == std::string::npos) and
                   (not file.eof()));

        if (file.eof())
          log_printf(INFO,Behavioural,FUNCTION,_("\"Id\" not find in file : \"%s\""),filename.c_str());
        else
          {
            // get id
            id = id.substr(id.find_first_of(':',0)+1,std::string::npos);

            // Erase all ' '
            size_t i=id.find_first_of(' ',0);
            while (i!=std::string::npos)
              {
                id.erase(i,i+1);
                i=id.find_first_of(' ',i);
              }
          }
      }

    log_end(Behavioural,FUNCTION);

    return id;
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
