/*
 * $Id: top.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/SelfTest/include/top.h"
#include "Behavioural/include/Selftest.h"

#define NB_PARAMS 10

#ifdef MTI_SYSTEMC
SC_MODULE_EXPORT(top);
#endif

#ifdef MTI_SYSTEMC
SC_CTOR(top::top)
#else
top::top (sc_module_name module_name, int argc, char * argv[])
#endif
{
#ifdef MTI_SYSTEMC
  // accessing command-line arguments with modelsim
  int argc;
  const char * const * argv;

  argc = sc_argc ();
  argv = sc_argv ();
#endif

  if (argc != 2+NB_PARAMS)
    usage (argc, argv);

  uint32_t size_queue         ;
  uint32_t nb_context         ;
  uint32_t nb_front_end       ;
  uint32_t nb_ooo_engine      ;
  uint32_t nb_packet          ;
  uint32_t size_general_data  ;
  uint32_t nb_general_register;
  uint32_t size_special_data  ;
  uint32_t nb_special_register;
  uint32_t nb_bypass_write    ;

  uint32_t x=1;
  SELFTEST0(name               ,string  ,argv,x);
  SELFTEST0(size_queue         ,uint32_t,argv,x);
  SELFTEST0(nb_context         ,uint32_t,argv,x);
  SELFTEST0(nb_front_end       ,uint32_t,argv,x);
  SELFTEST0(nb_ooo_engine      ,uint32_t,argv,x);
  SELFTEST0(nb_packet          ,uint32_t,argv,x);
  SELFTEST0(size_general_data  ,uint32_t,argv,x);
  SELFTEST0(nb_general_register,uint32_t,argv,x);
  SELFTEST0(size_special_data  ,uint32_t,argv,x);
  SELFTEST0(nb_special_register,uint32_t,argv,x);
  SELFTEST0(nb_bypass_write    ,uint32_t,argv,x);

  _param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Parameters
    (size_queue         ,
     nb_context         ,
     nb_front_end       ,
     nb_ooo_engine      ,
     nb_packet          ,
     size_general_data  ,
     nb_general_register,
     size_special_data  ,
     nb_special_register,
     nb_bypass_write    ,
     true
     );
  
  // msg(_("%s"),_param.print(0).c_str());
  
  // Allocation component
  allocation ();
  
#ifdef MTI_SYSTEMC
  SC_THREAD(test);
#endif
}

top::~top (void)
{
  deallocation ();
  delete _param;
}
