/*
 * $Id: main.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Comparator/SelfTest/include/test.h"
#include "Behavioural/include/Selftest.h"

#define NB_PARAMS 3

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_data (uint32_t            )\n"));
  err (_(" * is_signed (bool                )\n"));
  err (_(" * type      (Tcomparator_scheme_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t             _size_data;
  bool                 _is_signed;
  Tcomparator_scheme_t _type;

  SELFTEST0(_size_data,uint32_t            ,argv,x);
  SELFTEST0(_is_signed,bool                ,argv,x);
  SELFTEST0(_type     ,Tcomparator_scheme_t,argv,x);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::generic::comparator::Parameters * param = new morpheo::behavioural::generic::comparator::Parameters
	(
         _size_data,
         _is_signed,
         _type     ,
         true //is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Comparator : no error");
      else
	TEST_KO("Comparator : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
