#ifdef VHDL_TESTBENCH
#ifdef VHDL_TESTBENCH_ASSERT
/*
 * $Id: Interface_fifo_testbench_assert.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Interface_fifo.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Interface_fifo::testbench_assert"
  void Interface_fifo::testbench_assert (Vhdl * & vhdl,
                                         std::string counter_name)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    
    if (not _test_exhaustive)
      if (_list_cycle->empty()== false)
        {
          std::string test_name = Interface::testbench_test_name(vhdl);

          vhdl->set_body("");
          vhdl->set_body("-- Interface \""+_name+"\"");
          vhdl->set_body("");
          
          uint32_t j = 0;
          std::list<uint32_t>::iterator i = _list_cycle->begin();
          
          while (i != _list_cycle->end())
            {
              vhdl->set_body("assert not (("+counter_name+" = "+toString(*i)+" and "+test_name+" = '1')) report \"***** <"+_name+"> Test number "+toString(j)+" is OK     *****\" severity "+toString(VHDL_SEVERITY_NOTE)+";");
              vhdl->set_body("assert not (("+counter_name+" = "+toString(*i)+" and "+test_name+" = '0')) report \"@@@@@ <"+_name+"> Test number "+toString(j)+" is KO !!! @@@@@\" severity "+toString(VHDL_SEVERITY_NOTE)+";");
              j++;
              ++i;
            }
        }
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
#endif
