#ifdef VHDL

/*
 * $Id: Vhdl_set_library.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_library"
  void Vhdl::set_library (std::string library_name,
                          std::string package_name,
                          std::string declarative_unit)
  {
    log_begin(Behavioural,FUNCTION);

    std::string library = "library "+library_name;

    std::list<std::string>::iterator it = _list_library.begin();
    while ((it != _list_library.end()) and
           (*it != library))
      ++it;
    if (it == _list_library.end())
      set_list(_list_library, library);

    set_list(_list_library, "use "+library_name+"."+ package_name + "."+declarative_unit);

    log_end(Behavioural,FUNCTION);
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
