/*
 * $Id: Comparator_allocation.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Comparator/include/Comparator.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace comparator {



#undef  FUNCTION
#define FUNCTION "Comparator::allocation"
  void Comparator::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(Comparator,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Comparator"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "compare" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC0_INTERFACE_BEGIN("compare",IN,SOUTH,_("Compare interface"));

      ALLOC0_SIGNAL_IN ( in_COMPARE_DATA_0,"DATA_0",Tdata_t   ,_param->_size_data);
      ALLOC0_SIGNAL_IN ( in_COMPARE_DATA_1,"DATA_1",Tdata_t   ,_param->_size_data);
      ALLOC0_SIGNAL_OUT(out_COMPARE_TEST  ,"TEST"  ,Tcontrol_t,1);

      ALLOC0_INTERFACE_END();
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
	_component->generate_file();
#endif

    log_end(Comparator,FUNCTION);
  };

}; // end namespace comparator
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
