/*
 * $Id: top.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test "Counter"
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#define NB_ITERATION  1024
#define CYCLE_MAX     (1024*NB_ITERATION)

#include "Common/include/Test.h"
#include "Common/include/Time.h"
#include "Behavioural/Generic/Counter/include/Counter.h"

using namespace std;
using namespace morpheo;
using namespace morpheo::behavioural;
using namespace morpheo::behavioural::generic;
using namespace morpheo::behavioural::generic::counter;

SC_MODULE(top)
{
#ifdef SYSTEMC
 private: sc_clock               *  in_CLOCK ;
 private: sc_signal<Tcontrol_t>  *  in_NRESET;
 private: sc_signal<Tdata_t>    **  in_COUNTER_DATA  ;// [param->_nb_port]
 private: sc_signal<Tcontrol_t> **  in_COUNTER_ADDSUB;// [param->_nb_port]
 private: sc_signal<Tdata_t>    ** out_COUNTER_DATA  ;// [param->_nb_port]
#endif

 private: std::string                                          name ;
 private: morpheo::behavioural::generic::counter::Parameters * param;
#ifdef STATISTICS
 private: morpheo::behavioural::Parameters_Statistics        * param_stat;
#endif
 private: Counter                                            * component;

 private: void usage        (string exec);
 private: void allocation   (void);
 private: void deallocation (void);
 public : void test         (void);

#ifdef MTI_SYSTEMC
  SC_CTOR(top::top);
#else
 public : top (sc_module_name module_name,int argc, char * argv[]);
#endif
 public : ~top(void);
};
