/*
 * $Id$
 *
 * [ Description ]
 * 
 * Test "@COMPONENT"
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#define NB_ITERATION  1
#define CYCLE_MAX     (1024*NB_ITERATION)

#include "Common/include/Test.h"
#include "Common/include/Time.h"
#include "Behavioural/@DIRECTORY/include/@COMPONENT.h"

using namespace std;
using namespace morpheo;
using namespace morpheo::behavioural;
@NAMESPACE_USING
using namespace morpheo::behavioural::@NAMESPACE_USE;

SC_MODULE(top)
{
#ifdef SYSTEMC
 private: sc_clock               *  in_CLOCK ;
 private: sc_signal<Tcontrol_t>  *  in_NRESET;
#endif

 private: std::string name;
 private: Tusage_t _usage;
 private: morpheo::behavioural::@NAMESPACE_USE::Parameters * _param;
#ifdef STATISTICS
 private: morpheo::behavioural::Parameters_Statistics * _param_stat;
#endif
 private: @COMPONENT * component;

 private: void usage
    (
#ifdef MTI_SYSTEMC
     int argc, const char * const * argv
#else
     int argc, char * argv[]
#endif
     );
 private: void allocation   (void);
 private: void deallocation (void);
 public : void test         (void);

#ifdef MTI_SYSTEMC
  SC_CTOR(top::top);
#else
 public : top (sc_module_name module_name,int argc, char * argv[]);
#endif
 public : ~top(void);
};
