#ifdef SYSTEMC
/*
 * $Id: Comparator_genMealy.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Comparator/include/Comparator.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace comparator {


#undef  FUNCTION
#define FUNCTION "Comparator::genMealy"
  void Comparator::genMealy (void)
  {
    log_begin(Comparator,FUNCTION);

    Tcontrol_t test;
    Tdata_t data_0 = PORT_READ(in_COMPARE_DATA_0);
    Tdata_t data_1 = PORT_READ(in_COMPARE_DATA_1);
    
    if (_param->_is_signed)
      {
        int64_t data0 = static_cast<int64_t>(data_0);
        int64_t data1 = static_cast<int64_t>(data_1);

        data0 = ((data0 & _param->_mask_sign) != 0)?(_param->_extends|data0):(~_param->_extends & data0);
        data1 = ((data1 & _param->_mask_sign) != 0)?(_param->_extends|data1):(~_param->_extends & data1);

        switch (_param->_type)
          {
          case COMPARATOR_EQUAL            : test = (data0 == data1); break;
          case COMPARATOR_NOT_EQUAL        : test = (data0 != data1); break;
          case COMPARATOR_GREATER          : test = (data0 >  data1); break;
          case COMPARATOR_GREATER_OR_EQUAL : test = (data0 >= data1); break;
          case COMPARATOR_LESS             : test = (data0 <  data1); break;
          case COMPARATOR_LESS_OR_EQUAL    : test = (data0 <= data1); break;
          }
      }
    else
      {
        uint64_t data0 = ~_param->_extends & static_cast<uint64_t>(data_0);
        uint64_t data1 = ~_param->_extends & static_cast<uint64_t>(data_1);

        switch (_param->_type)
          {
          case COMPARATOR_EQUAL            : test = (data0 == data1); break;
          case COMPARATOR_NOT_EQUAL        : test = (data0 != data1); break;
          case COMPARATOR_GREATER          : test = (data0 >  data1); break;
          case COMPARATOR_GREATER_OR_EQUAL : test = (data0 >= data1); break;
          case COMPARATOR_LESS             : test = (data0 <  data1); break;
          case COMPARATOR_LESS_OR_EQUAL    : test = (data0 <= data1); break;
          }
      }

    log_printf(TRACE,Comparator,FUNCTION,"  * size_data : %d",_param->_size_data);
    log_printf(TRACE,Comparator,FUNCTION,"  * extends   : %llx",_param->_extends  );


    log_printf(TRACE,Comparator,FUNCTION,"  * %.x %s (%d) %x = %d"
               ,data_0
               ,toString(_param->_type).c_str()
               ,_param->_is_signed
               ,data_1
               ,test);

    PORT_WRITE(out_COMPARE_TEST,test);

    log_end(Comparator,FUNCTION);
  };

}; // end namespace comparator
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
