#ifdef VHDL
/*
 * $Id: Comparator_vhdl.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Comparator/include/Comparator.h"
#include "Behavioural/include/Vhdl.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace comparator {


#undef  FUNCTION
#define FUNCTION "Comparator::vhdl"
  void Comparator::vhdl (void)
  {
    log_begin(Comparator,FUNCTION);

    Vhdl * vhdl = new Vhdl (_name);

    _interfaces->set_port(vhdl);
    _component->vhdl_instance(vhdl);

    // default architecture
    vhdl_declaration (vhdl);
    vhdl_body        (vhdl);

    // Xilinx architecture
    vhdl->set_architecture("xilinx");
    vhdl_xilinx_declaration (vhdl);
    vhdl_xilinx_body        (vhdl);

    vhdl->generate_file();

    delete vhdl;

    log_end(Comparator,FUNCTION);
  };

}; // end namespace comparator
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
