/*
 * $Id: Component_get_sc_signal.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Component.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::get_sc_signal"
  void * Component::get_sc_signal (std::string component,
                                   std::string port     )
  {
    log_begin(Behavioural,FUNCTION);

    std::string name_entity = _entity->get_name();

    Entity * entity = find_entity(component);

    if (entity == NULL)
      throw (ERRORMORPHEO (FUNCTION,"In component \""+name_entity+"\", the component \""+component+"\" is unknow.\n"));

    Signal * signal = entity->find_signal (port);

    if (signal == NULL)
      throw (ERRORMORPHEO (FUNCTION,"In component \""+name_entity+"\", the component \""+component+"\" have not the signal \""+port+"\".\n"));

    void * _return = signal->get_sc_signal();

    log_end(Behavioural,FUNCTION);

    return _return;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
