#ifdef VHDL

/*
 * $Id: Vhdl_set_body.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"
#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_body"
  void Vhdl::set_body (std::string text)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");
    set_body(0, text);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Vhdl::set_body"
  void Vhdl::set_body (uint32_t depth,
                       std::string text)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    test_architecture();

    set_list(_architecture[_name_architecture]._list_body, morpheo::tab(depth)+text);
    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
#undef  FUNCTION
#define FUNCTION "Vhdl::set_body"
  void Vhdl::set_body (uint32_t depth,
                       Vhdl * vhdl)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    test_architecture();
    
    std::string tab=morpheo::tab(depth);

    for (std::list<std::string>::iterator it=vhdl->_architecture[_name_architecture]._list_body.begin();
         it!=vhdl->_architecture[_name_architecture]._list_body.end();
         ++it)
      set_list(_architecture[_name_architecture]._list_body,tab+*it);

    log_printf(FUNC,Behavioural,FUNCTION,"End");
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
