#ifndef Morpheo_Message_h
#define Morpheo_Message_h
/*
 * $Id: Message.h 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Routine of Test
 */

#include <stdio.h>
#include <string.h>
#include "Translation.h"

namespace morpheo {

  // Color
  // 31 : rouge
  // 32 : vert
  // 33 : jaune
  // 34 : bleu
  // 35 : rose
  // 36 : cyan
  // 37 : blanc
  // 38 : noir souligne
  // 39 : noir

#  define MSG_NONE          _("             ")
#ifdef PRINT_COLOR
#  define MSG_DEBUG         _("[1;34m[   DEBUG   ][0m")
#  define MSG_ERROR         _("[1;31m[   ERROR   ][0m")
#  define MSG_WARNING       _("[1;35m[  WARNING  ][0m")
#  define MSG_INFORMATION   _("[1;32m[INFORMATION][0m")
#  define MSG_BREAKPOINT    _("[1;38m[   BREAK   ][0m")
#  define MSG_VHDL          _("[1;34m[   VHDL    ][0m")
#else
#  define MSG_DEBUG         _("[   DEBUG   ]")
#  define MSG_ERROR         _("[   ERROR   ]")
#  define MSG_WARNING       _("[  WARNING  ]")
#  define MSG_INFORMATION   _("[INFORMATION]")
#  define MSG_BREAKPOINT    _("[   BREAK   ]")
#  define MSG_VHDL          _("[   VHDL    ]")
#endif

extern FILE * log_stream;
FILE * log      (FILE * stream);
void   log_init (bool        have_file,
                 std::string directory,
                 std::string file="");

#define fmsg(stream,arg...)			\
  do						\
    {						\
      FILE * _stream = log(stream);             \
      fprintf(_stream,arg);			\
      fflush(_stream);                          \
    } while (0)

#define fmsgDebug(stream,arg...)		\
  do						\
    {						\
      fmsg(stream,"%s ",MSG_DEBUG);             \
      fmsg(stream,arg);			        \
    } while (0) 

#define fmsgError(stream,arg...)		\
  do						\
    {						\
      fmsg(stream,"%s ",MSG_ERROR);             \
      fmsg(stream,arg);			        \
    } while (0) 

#define fmsgWarning(stream,arg...)		\
  do						\
    {						\
      fmsg(stream,"%s ",MSG_WARNING);           \
      fmsg(stream,arg);			        \
    } while (0) 

#define fmsgInformation(stream,arg...)		\
  do						\
    {						\
      fmsg(stream,"%s ",MSG_INFORMATION);       \
      fmsg(stream,arg);			        \
    } while (0) 

#define msg(arg...)		fmsg(stdout,arg)
#define err(arg...)             fmsgError(stderr,arg)

#define msgDebug(arg...)	fmsgDebug(stdout,arg)
#define msgError(arg...)	fmsgError(stdout,arg)
#define msgWarning(arg...)	fmsgWarning(stdout,arg)
#define msgInformation(arg...)	fmsgInformation(stdout,arg)

}; // end namespace morpheo
#endif
