/*
 * $Id: top_test.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 * Test
 */

#include "Behavioural/Generic/Counter/SelfTest/include/top.h"

void top::test (void)
{
#ifdef SYSTEMC
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  cout << "<" << name << "> Start Simulation ............" << endl;
  // Initialisation

  srand(0);
  //srand(TIME(NULL));

  Tdata_t    data_in  [param->_nb_port];
  Tdata_t    data_out [param->_nb_port];
  Tcontrol_t addsub   [param->_nb_port];

  SC_CYCLE(0);

  in_NRESET->write(1);

  LABEL("Initialisation");

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      for (uint32_t i=0; i<param->_nb_port; i++)
	{
	  Tdata_t data = rand()%param->_data_max;
	  data_in  [i] = data;
	  addsub   [i] = (rand()%2)==1; 
	  
          LABEL("in_COUNTER_DATA   [%d] = %d",i,data      );
          LABEL("in_COUNTER_ADDSUB [%d] = %d"  ,i,addsub [i]);

	  in_COUNTER_DATA   [i]->write(data      );
	  in_COUNTER_ADDSUB [i]->write(addsub [i]);

	  data_out [i] = (addsub[i]==1)?((data<param->_data_max)?data+1:data):((data>0)?data-1:data);
	}

      SC_CYCLE(0);

      for (uint32_t i=0; i<param->_nb_port; i++)
	{
          string op = (addsub[i] == 1)?"++":"--";
          LABEL("0x%d %s = 0x%d",i,op.c_str(),out_COUNTER_DATA [i]->read());

	  TEST(Tdata_t,out_COUNTER_DATA [i]->read(),data_out [i]);
	}
      
      SC_CYCLE(1);
    }

  SC_CYCLE(1);

  /********************************************************
   * Simulation - End
   ********************************************************/

  sc_stop();

  delete _time;

  cout << "<" << name << "> ............ Stop Simulation" << endl;
#endif
}
