/*
 * $Id: sc_main.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Platforms : Morpheo + Environment
 */

#include "../include/test.h"

using namespace std;
using namespace morpheo;

void usage (int argc
#ifdef MTI_SYSTEMC
            ,const char * const * argv
#else
            ,char * argv[]
#endif
            )
{
  cerr <<  "<Usage> " << argv[0] << endl
       <<  "In input stream : " << endl
       <<  " * filename_simulator   (string  )" << endl
       <<  " * filename_generator   (string  )" << endl
       <<  " * filename_instance    (string  )" << endl
       <<  " * filename_software    (string  )" << endl
       <<  " * nb_cache_dedicated   (uint32_t)" << endl
       <<  " * nb_cache_shared      (uint32_t)" << endl
       <<  " * size cache L1 (byte) (uint32_t)" << endl
       <<  " * ratio cache          (uint32_t)" << endl;
  exit (EXIT_FAILURE);
}

#ifdef MTI_SYSTEMC
SC_MODULE_EXPORT(top);

top::top (sc_module_name name)
#else
int sc_main (int argc, char * argv[])
#endif
{
  cout << "<sc_main> Begin" << endl;

#ifdef MTI_SYSTEMC
  // accessing command-line arguments with modelsim
  int argc;
  const char * const * argv;

  argc = sc_argc ();
  argv = sc_argv ();
#endif

  for (int32_t i=0; i<argc; ++i)
    cout << argv[i] << " ";
  cout << endl;
  
  //==============================================================================
  //===== [ Parameters ]==========================================================
  //==============================================================================
  
  if (argc != 9)
    usage (argc, argv);
  
  uint32_t x = 1;
  string   filename_simulator = argv[x++];
  string   filename_generator = argv[x++];
  string   filename_instance  = argv[x++];
  string   filename_software  = argv[x++];
  uint32_t nb_cache_dedicated = fromString<uint32_t>(argv[x++]);
  uint32_t nb_cache_shared    = fromString<uint32_t>(argv[x++]);
  uint32_t cache_size         = fromString<uint32_t>(argv[x++]);
  uint32_t cache_ratio        = fromString<uint32_t>(argv[x++]);
  
//   string   filename_simulator;
//   string   filename_generator;
//   string   filename_instance ;
//   string   filename_software ;
//   uint32_t nb_cache_dedicated;
//   uint32_t nb_cache_shared   ;
//   uint32_t cache_size        ;
//   uint32_t cache_ratio       ;

//   cout <<  "get filename_simulator   ? " << endl;
//   cin >> filename_simulator ;

//   cout <<  "get filename_generator   ? " << endl;
//   cin >> filename_generator ;

//   cout <<  "get filename_instance    ? " << endl;
//   cin >> filename_instance  ;

//   cout <<  "get filename_software    ? " << endl;
//   cin >> filename_software  ;

//   cout <<  "get nb_cache_dedicated   ? " << endl;
//   cin >> nb_cache_dedicated ;

//   cout <<  "get nb_cache_shared      ? " << endl;
//   cin >> nb_cache_shared    ;

//   cout <<  "get size cache L1 (byte) ? " << endl;
//   cin >> cache_size         ;

//   cout <<  "get ratio cache          ? " << endl;
//   cin >> cache_ratio        ;

  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (void) = NULL;

  int _return = test (filename_simulator ,
                      filename_generator ,
                      filename_instance  ,
                      filename_software  ,
                      nb_cache_dedicated ,
                      nb_cache_shared    ,
                      cache_size         ,
                      cache_ratio        ,
                      get_custom_information);

  cout << "  * return : " << _return << endl;  
  cout << "<sc_main> End" << endl;  

#ifndef MTI_SYSTEMC
  return _return;
#endif
}
