#ifdef VHDL_TESTBENCH
/*
 * $Id: Signal_testbench.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Signal.h"

namespace morpheo              {
namespace behavioural          {

  //  optimis -> pointeur de fonction afin d'viter le test et le switch
  void Signal::testbench (void)
  {
    log_printf(FUNC,Behavioural,"testbench","Begin");

    if ((_presence_port == PORT_VHDL_YES_TESTBENCH_YES) or
	(_presence_port == PORT_VHDL_NO_TESTBENCH_YES ) or
	(_presence_port == RESET_VHDL_YES             ) or
	(_presence_port == RESET_VHDL_NO              ) )
      {
	std::string str;

	switch (_type_info)
	  {
	  case BOOL     : 
	    {
	      bool value = read <bool> ();

	      switch (_direction)
		{
		case IN    : {str =             toBase2 (value); break;}
		case OUT   : {str =             toBase2 (value); break;}
		default    : {break;}
		}
	      break;
	    }
	  case UINT8_T  :
	    {
	      uint8_t value = read <uint8_t> ();

	      switch (_direction)
		{
		case IN    : {str =             toBase2 (value,get_size()); break;}
		case OUT   : {str =             toBase2 (value,get_size()); break;}
   		default    : {break;}
		}
	      break;
	    }
	  case UINT16_T :
	    {
	      uint16_t value = read <uint16_t> ();

	      switch (_direction)
		{
		case IN    : {str =             toBase2 (value,get_size()); break;}
		case OUT   : {str =             toBase2 (value,get_size()); break;}
   		default    : {break;}		
		}
	      break;
	    }
	  case UINT32_T :
	    {
	      uint32_t value = read <uint32_t> ();

	      switch (_direction)
		{
		case IN    : {str =             toBase2 (value,get_size()); break;}
		case OUT   : {str =             toBase2 (value,get_size()); break;}
   		default    : {break;}
		}
	      break;
	    }
	  case UINT64_T :
	    {
	      uint64_t value = read <uint64_t> ();

	      switch (_direction)
		{
		case IN    : {str =             toBase2 (value,get_size()); break;}
		case OUT   : {str =             toBase2 (value,get_size()); break;}
   		default    : {break;}
		}
	      break;
	    }
	  default       :
	    throw (ErrorMorpheo ("Signal \""+_name+"\" : type unknow."));
	  }

	_list_value->push_back(str);
      }

    log_printf(FUNC,Behavioural,"testbench","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
#endif
