#ifdef VHDL

/*
 * $Id: Vhdl_get_architecture.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"
#include "Common/include/Tabulation.h"

namespace morpheo              {
namespace behavioural          {
  
#undef  FUNCTION
#define FUNCTION "Vhdl::get_architecture"
  std::string Vhdl::get_architecture (uint32_t    depth      ,
                                      std::string entity_name)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::ostringstream text;
    std::string name_architecture_old = _name_architecture;
    std::string tab=morpheo::tab(depth);

    for (std::map<std::string,vhdl_architecture_t>::iterator it = _architecture.begin();
         it!=_architecture.end();
         ++it)
      {
        std::string name = it->first;
        set_architecture(name);

        text << tab << "architecture " << name << " of " << entity_name << " is" << std::endl
             << tab << get_type     (depth+1)                                    << std::endl
             << tab << get_signal   (depth+1)                                    << std::endl
             << tab << get_alias    (depth+1)                                    << std::endl
             << tab << "begin"                                                   << std::endl
             << tab << get_body     (depth+1)                                    << std::endl
             << tab << "end " << name << ";"                                     << std::endl;
      }

    set_architecture (name_architecture_old);

    log_printf(FUNC,Behavioural,FUNCTION,"End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
