#!/bin/bash

#-----------------------------------------------------------
# $Id: instruction_flow.sh 114 2009-04-16 22:35:37Z rosiere $
#-----------------------------------------------------------

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage     : ${0} file1 file2";
    echo "Arguments : ";
    echo " * file1 : instruction flow file";
    echo " * file2 : symbol file";
    echo "format for file1 : xxx address xxx. address is in hexadecimal without 0x or additionnal 0";
    exit;
}

#-----[ test_usage ]----------------------------------------
function test_usage ()
{
    if test ${#} -ne 2; then
        usage ${*};
    fi;
}

#-----[ main ]----------------------------------------------
function main ()
{
    test_usage ${*};

    # Read symbol file and take function address and function name
    local -ai array_address_begin;
    local -ai array_address_end;
    local -a array_name;

    # first slot
    array_address_begin[0]=0;
    array_name[0]="???";

    local -i cpt=1;
    while read line; do
        local type=$(echo ${line} | cut -d' ' -f2);

        # Test if the symbol is in text section
        if test "${type}" = "T"; then
            local address_begin=$(echo ${line} | cut -d' ' -f1);
            local name=$(   echo ${line} | cut -d' ' -f3);

            # erase additionnal 0
            declare str=$(expr match "${address_begin}" '.*\(^[0]*\)');
            address_begin=$(printf %d 0x${address_begin#${str}});

            local address_end=$((${address_begin}-1));

            array_address_begin[${cpt}]=${address_begin};
            array_address_end[$((${cpt}-1))]=${address_end};
            array_name[${cpt}]="${name}";

            #echo "${address_begin} ${name}";

            cpt=$((${cpt}+1));
        fi;
    done < ${2};

    # last slot
    array_address_end[$((${cpt}-1))]=$(printf %d 0xffffffff);

#    cpt=0;
#    while test ${cpt} -ne ${#array_address_begin[*]}; do
#        address_begin=${array_address_begin[${cpt}]};
#        address_end=${array_address_end[${cpt}]};
#        name=${array_name[${cpt}]};
#
#        echo "${address_begin} ${address_end} ${name}";
#
#        cpt=$((${cpt}+1));
#    done;

     # Read instruction flow file
    while read line; do
         # extract address
        
        local name="";
        local -i address_current=$(printf %d 0x$(echo ${line} | cut -d' ' -f2));
        
         # search in address file if match
        cpt=0;
        while test ${cpt} -ne ${#array_address_begin[*]}; do
            local -i address_begin=${array_address_begin[${cpt}]};
            local -i address_end=${array_address_end[${cpt}]};
            
             # test if address_curent match with a address in symbol file
            if test ${address_current} -ge ${address_begin} -a ${address_current} -lt ${address_end}; then
                name=${array_name[${cpt}]};
                break;
            fi;
            
            cpt=$((${cpt}+1));
        done;
        
        echo "${line} ${name}";
        
    done < ${1};

}

#-----[ Corps ]---------------------------------------------
main ${*};
