/*
 * $Id: main.cpp 115 2009-04-20 21:29:17Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/SelfTest/include/test.h"

#define NB_PARAMS 2

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_front_end                     (uint32_t)\n"));
  err (_(" * nb_context        [nb_front_end] (uint32_t)\n"));
  err (_(" * nb_inst_reexecute                (uint32_t)\n"));
  
  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t     _nb_front_end          = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+_nb_front_end))
    usage (argc, argv);

  uint32_t   * _nb_context            = new uint32_t [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    _nb_context [i] = fromString<uint32_t>(argv[x++]);

  uint32_t     _nb_inst_reexecute     = fromString<uint32_t>(argv[x++]);

  bool     *** _implement_group       = new bool ** [_nb_front_end];
  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      _implement_group [i] = new bool * [_nb_context[i]];
      for (uint32_t j=0; j<_nb_context[i]; j++)
	{
	  _implement_group [i][j] = new bool [NB_GROUP];

	  for (uint32_t k=0; k<NB_GROUP; k++)
	    _implement_group [i][j][k] = false;

	  _implement_group [i][j][GROUP_SYSTEM_AND_CONTROL] = true;
	  _implement_group [i][j][GROUP_DCACHE            ] = true;
	}
    }

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Parameters * param = new morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Parameters
	(
	 _nb_front_end      ,
	 _nb_context        ,
	 _nb_inst_reexecute ,
	 _implement_group   ,
         true //is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);

      delete param;
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Special_Register_unit : no error");
      else
	TEST_KO("Special_Register_unit : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  for (uint32_t i=0; i<_nb_front_end; i++)
    {
      for (uint32_t j=0; j<_nb_context[i]; j++)
	delete [] _implement_group [i][j];
      delete [] _implement_group [i];
    }
  delete [] _implement_group;

  delete [] _nb_context;

  return (_return);
}
