#ifdef SYSTEMC
/*
 * $Id: Write_queue_genMealy.cpp 115 2009-04-20 21:29:17Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Write_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::genMealy"
  void Write_queue::genMealy (void)
  {
    log_begin(Write_queue,FUNCTION);
    log_function(Write_queue,FUNCTION,_name.c_str());
    
    // -----[ Interface "bypass_write" ]----------------------------------
    // in genMoore
    // -----[ Interface "Write_queue_in" ]--------------------------------
    // in genMoore

    bool       val      = not _queue->empty();
    Tcontrol_t write_rd = val and _queue->front()->_write_rd;
    Tcontrol_t write_re = val and _queue->front()->_write_re;

    // -----[ Interface "gpr_write" ]-------------------------------------
    // -----[ Interface "spr_write" ]-------------------------------------
    {
      internal_GPR_WRITE_VAL = val and write_rd;
      internal_SPR_WRITE_VAL = val and write_re;
      
      PORT_WRITE(out_GPR_WRITE_VAL [0], internal_GPR_WRITE_VAL);
      PORT_WRITE(out_SPR_WRITE_VAL [0], internal_SPR_WRITE_VAL);

      write_rd = (write_rd)?(not PORT_READ(in_GPR_WRITE_ACK [0])):0;
      write_re = (write_re)?(not PORT_READ(in_SPR_WRITE_ACK [0])):0;

      if (val)
	{
	  if (_param->_have_port_ooo_engine_id)
	  {
	  PORT_WRITE(out_GPR_WRITE_OOO_ENGINE_ID [0], _queue->front()->_ooo_engine_id);
	  PORT_WRITE(out_SPR_WRITE_OOO_ENGINE_ID [0], _queue->front()->_ooo_engine_id);
	  }
	  PORT_WRITE(out_GPR_WRITE_NUM_REG       [0], _queue->front()->_num_reg_rd);
	  PORT_WRITE(out_GPR_WRITE_DATA          [0], _queue->front()->_data_rd   );
	  PORT_WRITE(out_SPR_WRITE_NUM_REG       [0], _queue->front()->_num_reg_re);
	  PORT_WRITE(out_SPR_WRITE_DATA          [0], _queue->front()->_data_re   );
	}
    }

    // -----[ Interface "Write_queue_out" ]--------------------------------
    {
      Texception_t load_speculative = (_queue->front()->_exception == EXCEPTION_MEMORY_LOAD_SPECULATIVE);

      internal_WRITE_QUEUE_OUT_VAL = ((val                 ) and
				      (not load_speculative) and
				      (not write_rd        ) and
				      (not write_re        ));
      
      PORT_WRITE(out_WRITE_QUEUE_OUT_VAL, internal_WRITE_QUEUE_OUT_VAL);

      if (internal_WRITE_QUEUE_OUT_VAL)
	{
	  if (_param->_have_port_context_id)
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_CONTEXT_ID   , _queue->front()->_context_id   );
	  if (_param->_have_port_front_end_id)
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_FRONT_END_ID , _queue->front()->_front_end_id );
	  if (_param->_have_port_ooo_engine_id)
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_OOO_ENGINE_ID, _queue->front()->_ooo_engine_id);
	  if (_param->_have_port_rob_ptr  )
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_PACKET_ID    , _queue->front()->_packet_id    );
//    	  PORT_WRITE(out_WRITE_QUEUE_OUT_OPERATION    , _queue->front()->_operation    );
//    	  PORT_WRITE(out_WRITE_QUEUE_OUT_TYPE         , _queue->front()->_type         );
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_FLAGS        , _queue->front()->_data_re      );
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_EXCEPTION    , _queue->front()->_exception    );
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_NO_SEQUENCE  , _queue->front()->_no_sequence  );
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_ADDRESS      , _queue->front()->_address      );
      	  PORT_WRITE(out_WRITE_QUEUE_OUT_DATA         , _queue->front()->_data_rd      );
	}
    }

    log_end(Write_queue,FUNCTION);
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
