/*
 * $Id: main.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Multiplier/SelfTest/include/test.h"
#include "Behavioural/include/Selftest.h"

#define NB_PARAMS 4

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_data (uint32_t)\n"));
  err (_(" * sign      (bool    )\n"));
  err (_(" * latency   (uint32_t)\n"));
  err (_(" * delay     (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  uint32_t             _size_data;
  bool                 _sign     ;
  uint32_t             _latency  ;
  uint32_t             _delay    ;
  
  string name = argv[x++];

  SELFTEST0(_size_data,uint32_t,argv,x);
  SELFTEST0(_sign     ,bool    ,argv,x);
  SELFTEST0(_latency  ,uint32_t,argv,x);
  SELFTEST0(_delay    ,uint32_t,argv,x);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::generic::multiplier::Parameters * param = new morpheo::behavioural::generic::multiplier::Parameters
	(
         _size_data,
         _sign     ,
         _latency  ,
         _delay    ,
         true //is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  
  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Multiplier : no error");
      else
	TEST_KO("Multiplier : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
