#ifndef ENVIRONMENT_COMMON_DEBUG_H
#define ENVIRONMENT_COMMON_DEBUG_H

#define DEBUG_true        true
#define DEBUG_ENVIRONMENT true
#define DEBUG_CACHE       true
#define DEBUG_DATA        true
#define DEBUG_ENDIANNESS  true
#define DEBUG_QUEUE       true
#define DEBUG_RAMLOCK     true
#define DEBUG_SIM2OS      true
#define DEBUG_TTY         true

#define MSG_ENVIRONMENT "[ENVIRONMENT]"

#define __cout(component,str...)                                        \
  do									\
    {									\
      fprintf(stdout,str);						\
    } 								        \
  while(0)

#define __cerr(str...)                                                  \
  do									\
    {									\
      fprintf(stderr,str);						\
    } 								        \
  while(0)

#define cout(str...)                                                    \
  do									\
    {									\
      fprintf(stdout,"%s ",MSG_ENVIRONMENT);                            \
      __cout(true,str);                                                 \
      fflush (stdout);                                                  \
    } 								        \
  while(0)

#define cerr(str...)                                                    \
  do									\
    {									\
      fprintf(stderr,"%s ",MSG_ENVIRONMENT);                            \
      __cerr(str);                                                      \
      fflush (stderr);                                                  \
    } 								        \
  while(0)

#define _cout(component, str...)					\
  do									\
    {									\
      if (DEBUG_ ## component == true )                                 \
	{								\
          cout(str);                                                    \
	}								\
    } 								        \
  while(0)

#define _cerr(str...) cerr(str)

#endif
