/*
 * $Id: Parameters_msg_error.cpp 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace issue_queue {


#undef  FUNCTION
#define FUNCTION "Issue_queue::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Issue_queue,FUNCTION);

    Parameters_test test ("Issue_queue");

    switch (_queue_scheme)
      {
      case ISSUE_QUEUE_SCHEME_IN_ORDER        :
      case ISSUE_QUEUE_SCHEME_OUT_OF_ORDER    :
	{
          // supported
	  break;
	}
      default :
	{
	  test.error(toString(_("Issue queue scheme '%s' is not supported. Please wait a next revision.\n"),toString(_queue_scheme).c_str()));
	  break;
	}
      }

    if (// (_queue_scheme == ISSUE_QUEUE_SCHEME_IN_BUNDLE_ORDER) or
        (_queue_scheme == ISSUE_QUEUE_SCHEME_OUT_OF_ORDER   ))
      test.warning(toString(_("Can have deadlock with the queue scheme \"%s\".\n"),toString(_queue_scheme).c_str()));

    if (not is_multiple(_size_queue, _nb_bank))
      test.error(toString(_("nb_bank (%d) must be a multiple of size_queue (%d).\n"),_nb_bank,_size_queue));
    
//     if (not is_multiple(_nb_bank, _nb_inst_issue))
//       test.error(toString(_("nb_inst_issue (%d) must be a multiple of nb_bank (%d) .\n"),_nb_inst_issue,_nb_bank));

    if (_nb_rename_unit_select > _nb_rename_unit)
      test.error(toString(_("nb_rename_unit_select must be <= nb_rename_unit.\n")));

    if (_size_bank == 1)
      test.warning(_("For better performance, the bank's size (size_queue/nb_bank) must be > 1.\n"));

//     for (uint32_t i=0; i<_nb_rename_unit; i++)
//       {
// 	bool type_present [_nb_type];
	
// 	for (uint32_t j=0; j<_nb_type; j++)
// 	  type_present [j] = not is_type_valid(j);

// 	bool find = false;
// 	for (uint32_t j=0; j<_nb_inst_issue; j++)
// 	  if (_table_routing [i][j])
// 	  {
// 	    find = true;

// 	    for (uint32_t k=0; k<_nb_type; k++)
// 	      type_present [k] |= _table_issue_type [j][k];
// 	  }

// 	if (not find)
// 	  test.error(toString(_("Rename_unit [%d] is not connected with a issue slot.\n"),i));
// 	else
// 	  for (uint32_t j=0; j<_nb_type; j++)
// 	    if (not type_present [j] and not is_type_optionnal(j))
// 	      test.error(toString(_("Rename_unit [%d] can't issue instruction's type \"%s\".\n"),i,toString(j).c_str()));
//       }
    
    if ((_priority != PRIORITY_ROUND_ROBIN))
      test.error(toString(_("Unsupported priority scheme (Coming Soon). Supported scheme are : %s.\n"),toString(PRIORITY_ROUND_ROBIN).c_str()));
    
    if ((_load_balancing != LOAD_BALANCING_MAXIMUM_FOR_PRIORITY))
      test.error(toString(_("Unsupported load_balancing scheme (Coming Soon). Supported scheme are : %s.\n"),toString(LOAD_BALANCING_MAXIMUM_FOR_PRIORITY).c_str()));

    log_end(Issue_queue,FUNCTION);

    return test;
  };

}; // end namespace issue_queue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
