#ifdef SYSTEMC
/*
 * $Id: Read_unit_to_Execution_unit_genMealy.cpp 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Read_unit_to_Execution_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::genMealy"
  void Read_unit_to_Execution_unit::genMealy (void)
  {
    log_begin(Read_unit_to_Execution_unit,FUNCTION);
    log_function(Read_unit_to_Execution_unit,FUNCTION,_name.c_str());

    bool execute_unit_use [_param->_nb_execute_unit][_param->_max_nb_execute_unit_port];

    for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
      for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	execute_unit_use[i][j] = false;

    for (uint32_t i=0; i<_param->_nb_read_unit; i++)
      for (uint32_t j=0; j<_param->_nb_read_unit_port[i]; j++)
	{
	  bool       ack = false;
	  
	  log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"  * Test Read_unit[%d][%d]",i,j);
	  
	  if (PORT_READ(in_READ_UNIT_OUT_VAL [i][j]) == true)
	    {
              log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"    * have a valid entry.");
	      
	      Tcontext_t context_id    = (_param->_have_port_context_id   )?PORT_READ(in_READ_UNIT_OUT_CONTEXT_ID    [i][j]):0;
	      Tcontext_t front_end_id  = (_param->_have_port_front_end_id )?PORT_READ(in_READ_UNIT_OUT_FRONT_END_ID  [i][j]):0;
	      Tcontext_t ooo_engine_id = (_param->_have_port_ooo_engine_id)?PORT_READ(in_READ_UNIT_OUT_OOO_ENGINE_ID [i][j]):0;
	      Tcontext_t num_thread    = get_num_thread(context_id   , _param->_size_context_id   ,
							front_end_id , _param->_size_front_end_id ,
							ooo_engine_id, _param->_size_ooo_engine_id);
	      Ttype_t    type          = PORT_READ(in_READ_UNIT_OUT_TYPE [i][j]);
	      
#ifdef DEBUG_TEST
	      if (_destination[i][num_thread][type].empty())
                throw ERRORMORPHEO(FUNCTION,toString(_("Invalid Operation : They have no execute_unit to receive a operation from the read_unit [%d], thread [%d] and a operation's type [%s]."),i,num_thread,toString(type).c_str()));
#endif
	      
	      // find a free execute_unit
	      for (std::list<destination_t>::iterator it=_destination[i][num_thread][type].begin();
		   (it != _destination[i][num_thread][type].end()) and (ack == false);
		   it++)
		{
		  uint32_t dest = (*it).grp;
		  uint32_t port = (*it).elt;
		  
		  log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"      * Test destination [%d][%d].",dest,port);
		  
		  if (execute_unit_use [dest][port] == false)
		    {
                      log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"        * Is ok! Link.");
		      
		      // have find !!!
		      ack                           = PORT_READ(in_EXECUTE_UNIT_IN_ACK [dest][port]);
		      execute_unit_use [dest][port] = true;

		      if (_param->_have_port_context_id)
		      PORT_WRITE(out_EXECUTE_UNIT_IN_CONTEXT_ID            [dest][port], PORT_READ(in_READ_UNIT_OUT_CONTEXT_ID            [i][j]));
		      if (_param->_have_port_front_end_id)
		      PORT_WRITE(out_EXECUTE_UNIT_IN_FRONT_END_ID          [dest][port], PORT_READ(in_READ_UNIT_OUT_FRONT_END_ID          [i][j]));
		      if (_param->_have_port_ooo_engine_id)
		      PORT_WRITE(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID         [dest][port], PORT_READ(in_READ_UNIT_OUT_OOO_ENGINE_ID         [i][j]));
		      if (_param->_have_port_rob_ptr  )
		      PORT_WRITE(out_EXECUTE_UNIT_IN_PACKET_ID             [dest][port], PORT_READ(in_READ_UNIT_OUT_PACKET_ID             [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_OPERATION             [dest][port], PORT_READ(in_READ_UNIT_OUT_OPERATION             [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_TYPE                  [dest][port], PORT_READ(in_READ_UNIT_OUT_TYPE                  [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT          [dest][port], PORT_READ(in_READ_UNIT_OUT_HAS_IMMEDIAT          [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_DATA_RC               [dest][port], PORT_READ(in_READ_UNIT_OUT_DATA_RC               [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_WRITE_RD              [dest][port], PORT_READ(in_READ_UNIT_OUT_WRITE_RD              [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_WRITE_RE              [dest][port], PORT_READ(in_READ_UNIT_OUT_WRITE_RE              [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_NUM_REG_RE            [dest][port], PORT_READ(in_READ_UNIT_OUT_NUM_REG_RE            [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [dest][port], PORT_READ(in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE [i][j]));
		      if (_param->_have_port_load_queue_ptr)
		      PORT_WRITE(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE  [dest][port], PORT_READ(in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE  [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_IMMEDIAT              [dest][port], PORT_READ(in_READ_UNIT_OUT_IMMEDIAT              [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_DATA_RA               [dest][port], PORT_READ(in_READ_UNIT_OUT_DATA_RA               [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_DATA_RB               [dest][port], PORT_READ(in_READ_UNIT_OUT_DATA_RB               [i][j]));
		      PORT_WRITE(out_EXECUTE_UNIT_IN_NUM_REG_RD            [dest][port], PORT_READ(in_READ_UNIT_OUT_NUM_REG_RD            [i][j]));
		    }
		}
	    }
	  PORT_WRITE(out_READ_UNIT_OUT_ACK [i][j], ack);
	}

    for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
      for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	PORT_WRITE(out_EXECUTE_UNIT_IN_VAL[i][j], execute_unit_use[i][j]);

    log_end(Read_unit_to_Execution_unit,FUNCTION);
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
