/*
 * $Id: Parameters.cpp 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace special_register_unit {


#undef  FUNCTION
#define FUNCTION "Special_Register_unit::Parameters"
  Parameters::Parameters (uint32_t     nb_front_end          ,
			  uint32_t   * nb_context            ,
			  uint32_t     nb_inst_reexecute     ,
			  bool     *** implement_group       ,
                          uint32_t  ** translate_num_context_to_num_thread, //[nb_front_end][nb_context]
                          bool         is_toplevel
			  )
  {
    log_begin(Special_Register_unit,FUNCTION);
    
    _nb_front_end           = nb_front_end     ;
    _nb_context             = nb_context       ;
    _nb_inst_reexecute      = nb_inst_reexecute;
    _implement_group        = implement_group  ;
    _translate_num_context_to_num_thread = translate_num_context_to_num_thread;

    _max_nb_context         = max<uint32_t>(_nb_context,_nb_front_end);
//  _size_front_end_id      = log2(_nb_front_end);
//  _size_context_id        = log2(_max_nb_context  );
//  
//  _have_port_front_end_id = _size_front_end_id > 0;
//  _have_port_context_id   = _size_context_id   > 0;
	
    test();

    if (is_toplevel)
      {
        _size_front_end_id      = log2(_nb_front_end);
        _size_context_id        = log2(_max_nb_context  );
        
        _have_port_front_end_id = _size_front_end_id > 0;
        _have_port_context_id   = _size_context_id   > 0;

        copy();
      }


    log_end(Special_Register_unit,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Special_Register_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Special_Register_unit,FUNCTION);
//     test();
//     log_end(Special_Register_unit,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Special_Register_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Special_Register_unit,FUNCTION);
    log_end(Special_Register_unit,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Special_Register_unit::copy"
  void Parameters::copy (void) 
  {
    log_begin(Special_Register_unit,FUNCTION);
    log_end(Special_Register_unit,FUNCTION);
  };

}; // end namespace special_register_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
