/*
 * $Id: Parameters_print.cpp 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {


#undef  FUNCTION
#define FUNCTION "Core::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Core,FUNCTION);

//     XML xml ("core");

//     xml.balise_open("core");
// //  xml.singleton_begin(""); xml.attribut("value",toString(_)); xml.singleton_end();
//     xml.balise_close();

//     return xml.get_body(depth);

    std::string str = "";

    str+= toString(MSG_INFORMATION)+" -----[ Common ]-----------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * size_general_data                             : "+toString<uint32_t>(_size_general_data)+"\n";
    str+= toString(MSG_INFORMATION)+"   * size_special_data                             : "+toString<uint32_t>(_size_special_data)+"\n";
    
    str+= toString(MSG_INFORMATION)+" -----[ Thread ]-----------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_thread                                     : "+toString<uint32_t>(_nb_thread)+"\n";
    for (uint32_t i=0; i<_nb_thread; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * THREAD ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * size_ifetch_queue                           : "+toString<uint32_t>(_size_ifetch_queue [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_fetch                               : "+toString<uint32_t>(_nb_inst_fetch     [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * ras_size_queue                              : "+toString<uint32_t>(_ras_size_queue    [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * upt_size_queue                              : "+toString<uint32_t>(_upt_size_queue    [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * ufpt_size_queue                             : "+toString<uint32_t>(_ufpt_size_queue   [i])+"\n";
    
    for (uint32_t j=0; j<NB_GROUP; ++j)
      {
    str+= toString(MSG_INFORMATION)+"     * GROUP["+toString(j)+"]\n";
    str+= toString(MSG_INFORMATION)+"       * implement_group                           : "+toString<uint32_t>(_implement_group [i][j])+"\n";
      }
      }

    str+= toString(MSG_INFORMATION)+" -----[ Decod bloc ]-------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_decod_bloc                                 : "+toString<uint32_t>(_nb_decod_bloc)+"\n";
    for (uint32_t i=0; i<_nb_decod_bloc; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * DECOD_BLOC ["+toString<uint32_t>(i)+"]\n";

    str+= toString(MSG_INFORMATION)+"     * size_decod_queue                            : "+toString<uint32_t         >(_size_decod_queue             [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * decod_queue_scheme                          : "+toString<multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t>
                                                                                                                       (_decod_queue_scheme           [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_decod                               : "+toString<uint32_t         >(_nb_inst_decod                [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_context_select                           : "+toString<uint32_t         >(_nb_context_select            [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * context_select_priority                     : "+toString<Tpriority_t      >(_context_select_priority      [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * context_select_load_balancing               : "+toString<Tload_balancing_t>(_context_select_load_balancing[i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Rename bloc ]------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_rename_bloc                                : "+toString<uint32_t>(_nb_rename_bloc)+"\n";
    for (uint32_t i=0; i<_nb_rename_bloc; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * RENAME_BLOC ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_insert                              : "+toString<uint32_t         >(_nb_inst_insert                   [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_retire                              : "+toString<uint32_t         >(_nb_inst_retire                   [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * rename_select_priority                      : "+toString<Tpriority_t      >(_rename_select_priority           [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * rename_select_load_balancing                : "+toString<Tload_balancing_t>(_rename_select_load_balancing     [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * rename_select_nb_front_end_select           : "+toString<uint32_t         >(_rename_select_nb_front_end_select[i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_general_register                         : "+toString<uint32_t         >(_nb_general_register              [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_special_register                         : "+toString<uint32_t         >(_nb_special_register              [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_reg_free                                 : "+toString<uint32_t         >(_nb_reg_free                      [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_rename_unit_bank                         : "+toString<uint32_t         >(_nb_rename_unit_bank              [i])+"\n";
//     str+= toString(MSG_INFORMATION)+"     * size_read_counter                           : "+toString<uint32_t         >(_size_read_counter                [i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Read bloc ]--------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_read_bloc                                  : "+toString<uint32_t>(_nb_read_bloc                         )+"\n";
    for (uint32_t i=0; i<_nb_read_bloc; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * READ_BLOC ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * size_read_queue                             : "+toString<uint32_t>(_size_read_queue                   [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_reservation_station                    : "+toString<uint32_t>(_size_reservation_station          [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_retire_reservation_station          : "+toString<uint32_t>(_nb_inst_retire_reservation_station[i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Write bloc ]-------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_write_bloc                                 : "+toString<uint32_t>(_nb_write_bloc        )+"\n";
    for (uint32_t i=0; i<_nb_write_bloc; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * WRITE_BLOC ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * size_write_queue                            : "+toString<uint32_t>(_size_write_queue  [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_execute_queue                          : "+toString<uint32_t>(_size_execute_queue[i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_bypass_write                             : "+toString<uint32_t>(_nb_bypass_write   [i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Load_store_unit ]--------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_load_store_unit                            : "+toString<uint32_t>(_nb_load_store_unit              )+"\n";
    for (uint32_t i=0; i<_nb_load_store_unit; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * LOAD_STORE_UNIT ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * size_store_queue                            : "+toString<uint32_t>(_size_store_queue             [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_load_queue                             : "+toString<uint32_t>(_size_load_queue              [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_speculative_access_queue               : "+toString<uint32_t>(_size_speculative_access_queue[i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_port_check                               : "+toString<uint32_t>(_nb_port_check                [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * speculative_load                            : "+toString<multi_execute_loop::execute_loop::Tspeculative_load_t>(_speculative_load             [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_bypass_memory                            : "+toString<uint32_t>(_nb_bypass_memory             [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_cache_port                               : "+toString<uint32_t>(_nb_cache_port                [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_memory                              : "+toString<uint32_t>(_nb_inst_memory               [i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Functionnal_unit ]-------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_functionnal_unit                           : "+toString<uint32_t>(_nb_functionnal_unit         )+"\n";
    for (uint32_t i=0; i<_nb_functionnal_unit; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * FUNCTIONNAL_UNIT ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"   * nb_inst_functionnal_unit                      : "+toString<uint32_t>(_nb_inst_functionnal_unit [i])+"\n";
      }

//multi_execute_loop::execute_loop::execute_timing_t *** timing; //[nb_functionnal_unit][nb_type][nb_operation]

    str+= toString(MSG_INFORMATION)+" -----[ Icache_Access ]----------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_icache_port                                : "+toString<uint32_t         >(_nb_icache_port            )+"\n";
    str+= toString(MSG_INFORMATION)+"   * icache_port_priority                          : "+toString<Tpriority_t      >(_icache_port_priority      )+"\n";
    str+= toString(MSG_INFORMATION)+"   * icache_port_load_balancing                    : "+toString<Tload_balancing_t>(_icache_port_load_balancing)+"\n";

    str+= toString(MSG_INFORMATION)+" -----[ Dcache_Access ]----------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_dcache_port                                : "+toString<uint32_t         >(_nb_dcache_port            )+"\n";
    str+= toString(MSG_INFORMATION)+"   * dcache_port_priority                          : "+toString<Tpriority_t      >(_dcache_port_priority      )+"\n";
    str+= toString(MSG_INFORMATION)+"   * dcache_port_load_balancing                    : "+toString<Tload_balancing_t>(_dcache_port_load_balancing)+"\n";

    str+= toString(MSG_INFORMATION)+" -----[ Front_end ]--------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_front_end                                  : "+toString<uint32_t    >(_nb_front_end                    )+"\n";
    for (uint32_t i=0; i<_nb_front_end; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * FRONT_END ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * nb_context                                  : "+toString<uint32_t    >(_nb_context                [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_decod_unit                               : "+toString<uint32_t    >(_nb_decod_unit             [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_branch_predict                      : "+toString<uint32_t    >(_nb_inst_branch_predict    [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_branch_decod                        : "+toString<uint32_t    >(_nb_inst_branch_decod      [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_branch_update                       : "+toString<uint32_t    >(_nb_inst_branch_update     [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * btb_size_queue                              : "+toString<uint32_t    >(_btb_size_queue            [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * btb_associativity                           : "+toString<uint32_t    >(_btb_associativity         [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * btb_size_counter                            : "+toString<uint32_t    >(_btb_size_counter          [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * btb_victim_scheme                           : "+toString<Tvictim_t   >(_btb_victim_scheme         [i]   )+"\n";
    str+= toString(MSG_INFORMATION)+"     * dir_predictor_scheme                        : "+toString<Tpredictor_t>(_dir_predictor_scheme      [i]   )+"\n";
    for (uint32_t j=0; j<3; ++j)
      {
    str+= toString(MSG_INFORMATION)+"     * PREDICTOR ["+toString<uint32_t>(i)+"]["+toString<uint32_t>(j)+"]\n";
    str+= toString(MSG_INFORMATION)+"       * dir_have_bht                              : "+toString<bool        >(_dir_have_bht              [i][j])+"\n";
    str+= toString(MSG_INFORMATION)+"       * dir_bht_size_shifter                      : "+toString<uint32_t    >(_dir_bht_size_shifter      [i][j])+"\n";
    str+= toString(MSG_INFORMATION)+"       * dir_bht_nb_shifter                        : "+toString<uint32_t    >(_dir_bht_nb_shifter        [i][j])+"\n";
    str+= toString(MSG_INFORMATION)+"       * dir_have_pht                              : "+toString<bool        >(_dir_have_pht              [i][j])+"\n";
    str+= toString(MSG_INFORMATION)+"       * dir_pht_size_counter                      : "+toString<uint32_t    >(_dir_pht_size_counter      [i][j])+"\n";
    str+= toString(MSG_INFORMATION)+"       * dir_pht_nb_counter                        : "+toString<uint32_t    >(_dir_pht_nb_counter        [i][j])+"\n";
    str+= toString(MSG_INFORMATION)+"       * dir_pht_size_address_share                : "+toString<uint32_t    >(_dir_pht_size_address_share[i][j])+"\n";
      }
      }

    str+= toString(MSG_INFORMATION)+" -----[ OOO_Engine ]-------------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_ooo_engine                                 : "+toString<uint32_t         >(_nb_ooo_engine              )+"\n";
    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * OOO_ENGINE ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * nb_rename_unit                              : "+toString<uint32_t         >(_nb_rename_unit          [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_issue_queue                         : "+toString<uint32_t         >(_nb_inst_issue_queue     [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_issue_slot                          : "+toString<uint32_t         >(_nb_inst_issue_slot      [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_reexecute                           : "+toString<uint32_t         >(_nb_inst_reexecute       [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_commit                              : "+toString<uint32_t         >(_nb_inst_commit          [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_inst_branch_complete                     : "+toString<uint32_t         >(_nb_inst_branch_complete [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_rename_unit_select                       : "+toString<uint32_t         >(_nb_rename_unit_select   [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_execute_loop_select                      : "+toString<uint32_t         >(_nb_execute_loop_select  [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_re_order_buffer                        : "+toString<uint32_t         >(_size_re_order_buffer    [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_re_order_buffer_bank                     : "+toString<uint32_t         >(_nb_re_order_buffer_bank [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * commit_priority                             : "+toString<Tpriority_t      >(_commit_priority         [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * commit_load_balancing                       : "+toString<Tload_balancing_t>(_commit_load_balancing   [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_issue_queue                            : "+toString<uint32_t         >(_size_issue_queue        [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * issue_queue_scheme                          : "+toString<multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t>
                                                                                                                       (_issue_queue_scheme      [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_issue_queue_bank                         : "+toString<uint32_t         >(_nb_issue_queue_bank     [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * issue_priority                              : "+toString<Tpriority_t      >(_issue_priority          [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * issue_load_balancing                        : "+toString<Tload_balancing_t>(_issue_load_balancing    [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * size_reexecute_queue                        : "+toString<uint32_t         >(_size_reexecute_queue    [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * reexecute_priority                          : "+toString<Tpriority_t      >(_reexecute_priority      [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * reexecute_load_balancing                    : "+toString<Tload_balancing_t>(_reexecute_load_balancing[i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Execute_loop ]-----------------------------\n";
    str+= toString(MSG_INFORMATION)+"   * nb_execute_loop                               : "+toString<uint32_t   >(_nb_execute_loop                         )+"\n";
    for (uint32_t i=0; i<_nb_execute_loop; ++i)
      {
    str+= toString(MSG_INFORMATION)+"   * EXECUTE_LOOP ["+toString<uint32_t>(i)+"]\n";
    str+= toString(MSG_INFORMATION)+"     * nb_read_unit                                : "+toString<uint32_t   >(_nb_read_unit                         [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_execute_unit                             : "+toString<uint32_t   >(_nb_execute_unit                      [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_write_unit                               : "+toString<uint32_t   >(_nb_write_unit                        [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_gpr_bank                                 : "+toString<uint32_t   >(_nb_gpr_bank                          [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_gpr_port_read_by_bank                    : "+toString<uint32_t   >(_nb_gpr_port_read_by_bank             [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_gpr_port_write_by_bank                   : "+toString<uint32_t   >(_nb_gpr_port_write_by_bank            [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_spr_bank                                 : "+toString<uint32_t   >(_nb_spr_bank                          [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_spr_port_read_by_bank                    : "+toString<uint32_t   >(_nb_spr_port_read_by_bank             [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * nb_spr_port_write_by_bank                   : "+toString<uint32_t   >(_nb_spr_port_write_by_bank            [i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * execution_unit_to_write_unit_priority       : "+toString<Tpriority_t>(_execution_unit_to_write_unit_priority[i])+"\n";
    str+= toString(MSG_INFORMATION)+"     * read_unit_to_execution_unit_priority        : "+toString<Tpriority_t>(_read_unit_to_execution_unit_priority [i])+"\n";
      }

    str+= toString(MSG_INFORMATION)+" -----[ Link ]-------------------------------------\n";

    for (uint32_t i=0; i<_nb_thread; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_context_with_thread                        ["+toString(i)+"] -> ["+toString(_link_context_with_thread               [i].first)+"]["+toString(_link_context_with_thread               [i].second)+"]\n";//[nb_thread]
    for (uint32_t i=0; i<_nb_decod_bloc; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_decod_unit_with_decod_bloc                 ["+toString(i)+"] -> ["+toString(_link_decod_unit_with_decod_bloc        [i].first)+"]["+toString(_link_decod_unit_with_decod_bloc        [i].second)+"]\n";//[nb_decod_bloc]
    for (uint32_t i=0; i<_nb_rename_bloc; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_rename_unit_with_rename_bloc               ["+toString(i)+"] -> ["+toString(_link_rename_unit_with_rename_bloc      [i].first)+"]["+toString(_link_rename_unit_with_rename_bloc      [i].second)+"]\n";//[nb_rename_bloc]
    for (uint32_t i=0; i<_nb_read_bloc; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_read_unit_with_read_bloc                   ["+toString(i)+"] -> ["+toString(_link_read_unit_with_read_bloc          [i].first)+"]["+toString(_link_read_unit_with_read_bloc          [i].second)+"]\n";//[nb_read_bloc]
    for (uint32_t i=0; i<_nb_write_bloc; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_write_unit_with_write_bloc                 ["+toString(i)+"] -> ["+toString(_link_write_unit_with_write_bloc        [i].first)+"]["+toString(_link_write_unit_with_write_bloc        [i].second)+"]\n";//[nb_write_bloc]
    for (uint32_t i=0; i<_nb_functionnal_unit; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_execute_unit_with_functionnal_unit         ["+toString(i)+"] -> ["+toString(_link_execute_unit_with_functionnal_unit[i].first)+"]["+toString(_link_execute_unit_with_functionnal_unit[i].second)+"]\n";//[nb_functionnal_unit]
    for (uint32_t i=0; i<_nb_load_store_unit;++i)
    str+= toString(MSG_INFORMATION)+"   * link_execute_unit_with_load_store_unit          ["+toString(i)+"] -> ["+toString(_link_execute_unit_with_load_store_unit [i].first)+"]["+toString(_link_execute_unit_with_load_store_unit [i].second)+"]\n";//[nb_load_store_unit]

    for (uint32_t i=0; i<_nb_thread; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_decod_bloc_with_thread                     ["+toString(i)+"] -> ["+toString(_link_decod_bloc_with_thread            [i])+"]\n";//[nb_thread]
    for (uint32_t i=0; i<_nb_front_end; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_rename_bloc_with_front_end                 ["+toString(i)+"] -> ["+toString(_link_rename_bloc_with_front_end        [i])+"]\n";//[nb_front_end]
    for (uint32_t i=0; i<_nb_thread; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_load_store_unit_with_thread                ["+toString(i)+"] -> ["+toString(_link_load_store_unit_with_thread       [i])+"]\n";//[nb_thread]
    for (uint32_t i=0; i<_nb_thread; ++i)
    str+= toString(MSG_INFORMATION)+"   * link_icache_port_with_thread                    ["+toString(i)+"] -> ["+toString(_link_icache_port_with_thread           [i])+"]\n";//[nb_thread]
    for (uint32_t i=0; i<_nb_load_store_unit; ++i)
      for (uint32_t j=0; j<_nb_cache_port[i]; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_dcache_port_with_load_store_unit           ["+toString(i)+"]["+toString(j)+"] -> ["+toString(_link_dcache_port_with_load_store_unit  [i][j])+"]\n";//[nb_load_store_unit][nb_cache_port]

    
    for (uint32_t i=0; i<_nb_read_bloc; ++i)
      for (uint32_t j=0; j<_nb_load_store_unit; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_read_bloc_and_load_store_unit              ["+toString(i)+"]["+toString(j)+"] : "+toString(_link_read_bloc_and_load_store_unit  [i][j])+"\n";//[nb_read_bloc][nb_load_store_unit]
    for (uint32_t i=0; i<_nb_read_bloc; ++i)
      for (uint32_t j=0; j<_nb_functionnal_unit; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_read_bloc_and_functionnal_unit             ["+toString(i)+"]["+toString(j)+"] : "+toString(_link_read_bloc_and_functionnal_unit [i][j])+"\n";//[nb_read_bloc][nb_functionnal_unit]
    for (uint32_t i=0; i<_nb_write_bloc; ++i)
      for (uint32_t j=0; j<_nb_load_store_unit; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_write_bloc_and_load_store_unit             ["+toString(i)+"]["+toString(j)+"] : "+toString(_link_write_bloc_and_load_store_unit [i][j])+"\n";//[nb_write_bloc][nb_load_store_unit]
    for (uint32_t i=0; i<_nb_write_bloc; ++i)
      for (uint32_t j=0; j<_nb_functionnal_unit; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_write_bloc_and_functionnal_unit            ["+toString(i)+"]["+toString(j)+"] : "+toString(_link_write_bloc_and_functionnal_unit[i][j])+"\n";//[nb_write_bloc][nb_functionnal_unit]
    for (uint32_t i=0; i<_nb_thread; ++i)
      for (uint32_t j=0; j<_nb_functionnal_unit; ++j)
    str+= toString(MSG_INFORMATION)+"   * link_thread_and_functionnal_unit                ["+toString(i)+"]["+toString(j)+"] : "+toString(_link_thread_and_functionnal_unit    [i][j])+"\n";//[nb_thread][nb_functionnal_unit]

    str+= toString(MSG_INFORMATION)+" -----[ Dispatch ]---------------------------------\n";

    for (uint32_t i=0; i<_nb_ooo_engine; ++i)
      for (uint32_t j=0; j<_nb_inst_issue_slot[i]; ++j)
        for (uint32_t k=0; k<_nb_read_bloc; ++k)
    str+= toString(MSG_INFORMATION)+"   * table_dispatch                                  ["+toString(i)+"]["+toString(j)+"]["+toString(k)+"] : "+toString(_table_dispatch                      [i][j][k])+"\n";//[nb_ooo_engine][nb_inst_issue][nb_read_bloc]

    str+= toString(MSG_INFORMATION)+"   * dispatch_priority                             : "+toString<Tpriority_t      >(_dispatch_priority      )+"\n";
    str+= toString(MSG_INFORMATION)+"   * dispatch_load_balancing                       : "+toString<Tload_balancing_t>(_dispatch_load_balancing);

    log_end(Core,FUNCTION);
    
    return str;
  };

#undef  FUNCTION
#define FUNCTION "Core::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::Parameters & x)
  {
    log_begin(Core,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Core,FUNCTION);

    return output_stream;
  };

}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
