// $Id: benchmark.c 117 2009-05-16 14:42:39Z rosiere $

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#ifndef SPECINT2000_PATH
# error "SPECINT2000_PATH must be defined"
#endif

//#define SPEC_DATA "ref"
  #define SPEC_DATA "test"
//#define SPEC_DATA "train"

//=======================================================================================
//                                                                      [ run_none ]     
//=======================================================================================
void run_none ()
{
  printf("***** none *****\n");
  return;
}

//=======================================================================================
//                                                                  [ run_164_gzip ]
//=======================================================================================
void run_164_gzip ()
{								                                          
  printf("***** 164.gzip - Begin *****\n");

  int     argc = 4;
  char ** argv;

  char  * execname        = "./gzip";
  char  *_filename        = "/164.gzip/data/test/input/input.compressed";
  char  * filename        = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_filename));
  strcpy(filename,SPECINT2000_PATH); strcat(filename,_filename);
  char  * input_size      = "1";
  char  * compressed_size = "1";

 // Create the arguments
  if ((argc < 1) || (argc > 4) )
    {
      printf("Usage : gzip [filename] [intput_size] [compressed_size]\n");
      return;
    }
    
  argv    = (char **)malloc (argc * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));

  if (argc > 1)
    {
  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename        ,strlen(filename       ));
    }
  
  if (argc > 2)
    {
  argv[2] = (char *) malloc (strlen(input_size     ));
  argv[2] = memcpy(argv[2],input_size      ,strlen(input_size     ));
    }

  if (argc > 3)
    {  
  argv[3] = (char *) malloc (strlen(compressed_size));
  argv[3] = memcpy(argv[3],compressed_size ,strlen(compressed_size));
    }

  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_164_gzip (argc,argv);

  free(filename);
  
  printf("***** 164.gzip - End   *****\n");
}								                                          

//=======================================================================================
//                                                                   [ run_175_vpr ]
//=======================================================================================
void run_175_vpr ()
{
  printf("***** 175.vpr - Begin *****\n");

#define   nb_option_175_vpr 12
  int     argc      = 5 + nb_option_175_vpr;
  char ** argv;

  char  * execname        = "./vpr";
       
  char  *_circuit_net     = "/175.vpr/data/test/input/net.in";
  char  *_fpga_arch       = "/175.vpr/data/test/input/arch.in";
  char  *_placed_out      = "/175.vpr/data/test/input/place.in";
  char  *_routed_out      = "/175.vpr/data/test/input/route.out";
       
  char  * circuit_net     = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_circuit_net));
  char  * fpga_arch       = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_fpga_arch  ));
  char  * placed_out      = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_placed_out ));
  char  * routed_out      = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_routed_out ));

  strcpy(circuit_net,SPECINT2000_PATH); strcat(circuit_net,_circuit_net);
  strcpy(fpga_arch  ,SPECINT2000_PATH); strcat(fpga_arch  ,_fpga_arch  );
  strcpy(placed_out ,SPECINT2000_PATH); strcat(placed_out ,_placed_out );
  strcpy(routed_out ,SPECINT2000_PATH); strcat(routed_out ,_routed_out );

  /*
  General Options:  
  [-nodisp]
  [-auto <int>]
  [-route_only]
  [-place_only]
  [-aspect_ratio <float>]
  [-nx <int>]
  [-ny <int>]
  [-full_stats]
  [-fast]
  [-timing_analysis on | off]

  Placer Options:
  [-init_t <float>]
  [-exit_t <float>]
  [-alpha_t <float>]
  [-inner_num <float>]
  [-seed <int>]
  [-place_cost_exp <float>]
  [-place_cost_type linear | nonlinear]
  [-place_chan_width <int>]
  [-num_regions <int>]
  [-fix_pins random | <file.pads>]
  
  Router Options:  
  [-max_router_iterations <int>]
  [-bb_factor <int>]
  [-initial_pres_fac <float>]
  [-pres_fac_mult <float>]
  [-acc_fac <float>]
  [-first_iter_pres_fac <float>]
  [-bend_cost <float>]
  [-route_type global | detailed]
  [-verify_binary_search]
  [-route_chan_width <int>]
  */

  char * option [nb_option_175_vpr] = 
    {
      "-nodisp"              ,
      "-route_only"          , 
      "-route_chan_width"    , "15",
      "-pres_fac_mult"       , "2" ,
      "-acc_fac"             , "1" ,
      "-first_iter_pres_fac" , "4" ,
      "-initial_pres_fac"    , "8" 
    };
  
  // Create the arguments
  if (argc < 5)
    {
      printf("Usage : vpr circuit.net fpga.arch placed.out routed.out [Options ...]\n");
      return;
    }
    
  argv    = (char **)malloc (argc * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(circuit_net    ));
  argv[1] = memcpy(argv[1],circuit_net     ,strlen(circuit_net    ));

  argv[2] = (char *) malloc (strlen(fpga_arch      ));
  argv[2] = memcpy(argv[2],fpga_arch       ,strlen(fpga_arch      ));

  argv[3] = (char *) malloc (strlen(placed_out     ));
  argv[3] = memcpy(argv[3],placed_out      ,strlen(placed_out     ));

  argv[4] = (char *) malloc (strlen(routed_out     ));
  argv[4] = memcpy(argv[4],routed_out      ,strlen(routed_out     ));
  
  {
    unsigned int i;
    
    for (i = 0; i < nb_option_175_vpr; i ++)
      {
	argv[5+i] = (char *) malloc (strlen(option[i]      ));
	argv[5+i] = memcpy(argv[5+i],option[i]       ,strlen(option[i]      ));
      }// end i
  }
  
  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_175_vpr (argc,argv);

  free(circuit_net);
  free(fpga_arch  );
  free(placed_out );
  free(routed_out );

  printf("***** 175.vpr - End   *****\n");
}								                                          

//=======================================================================================
//                                                                   [ run_176_gcc ]
//=======================================================================================
void run_176_gcc ()
{
  printf("***** 176.gcc - Begin *****\n");

#define   nb_option_176_gcc 2
  int     argc      = 2 + nb_option_176_gcc;
  char ** argv;

  char  * execname        = "./gcc";
  char  *_filename        = "/176.gcc/data/test/input/cccp.i";
  char  * filename        = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_filename));
  strcpy(filename,SPECINT2000_PATH); strcat(filename,_filename);

  /*
    -O
    -fdefer-pop
    -fomit-frame-pointer
    -fcse-follow-jumps
    -fcse-skip-blocks
    -fexpensive-optimizations
    -fthread-jumps
    -fstrength-reduce
    -funroll-loops
    -fwritable-strings
    -fpeephole
    -fforce-mem
    -ffunction-cse
    -finline-functions
    -finline
    -freg-struct-return
    -fdelayed-branch
    -frerun-cse-after-loop
    -fschedule-insns
    -fschedule-insns2
    -fcommon
    -fgnu-linker
    -m88110
    -m88100
    -m88000
    -mno-ocs-debug-info
    -mno-ocs-frame-position
    -mcheck-zero-division
  */

  char * option [nb_option_176_gcc] = 
    {
      "-o"                   , "cccp.s"
    };
  
  // Create the arguments
  if (argc < 2)
    {
      printf("Usage : gcc filename [Options ...]\n");
      return;
    }
    
  argv    = (char **)malloc (argc * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));
  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename        ,strlen(filename       ));
  
  {
    unsigned int i;
    
    for (i = 0; i < nb_option_176_gcc; i ++)
      {
	argv[2+i] = (char *) malloc (strlen(option[i]      ));
	argv[2+i] = memcpy(argv[2+i],option[i]       ,strlen(option[i]      ));
      }// end i
  }
  
  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_176_gcc (argc,argv);

  free(filename);
  
  printf("***** 176.gcc - End   *****\n");
}								                                          

//=======================================================================================
//                                                                   [ run_181_mcf ]
//=======================================================================================
void run_181_mcf ()
{								                                          
  printf("***** 181.mcf - Begin *****\n");
  
  int     argc = 2;
  char ** argv;

  char  * execname        = "./mcf";
  char  *_filename        = "/181.mcf/data/test/input/inp.in";
  char  * filename        = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_filename));
  strcpy(filename,SPECINT2000_PATH); strcat(filename,_filename);

  // Create the arguments
  if (argc != 2)
    {
      printf("Usage : mcf filename\n");
      return;
    }
    
  argv    = (char **)malloc (argc * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename        ,strlen(filename       ));
  
  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_181_mcf (argc,argv);

  free(filename);
  
  printf("***** 181.mcf - End   *****\n");
}								                                          

//=======================================================================================
//                                                                [ run_255_vortex ]
//=======================================================================================
void run_255_vortex ()
{								                                          
  printf("***** 255.vortex - Begin *****\n");
  
  int     argc = 2;
  char ** argv;

  char  * execname        = "./vortex";
  char  *_filename        = "/255.vortex/data/test/input/bendian.raw";
  char  * filename        = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_filename));
  strcpy(filename,SPECINT2000_PATH); strcat(filename,_filename);
  
  // Create the arguments
  if (argc != 2)
    {
      printf("Usage : vortex filename\n");
      return;
    }
    
  argv    = (char **)malloc (argc * sizeof(char *));

  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));
  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename        ,strlen(filename       ));

  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_255_vortex (argc,argv);

  free(filename);
  
  printf("***** 255.vortex - End   *****\n");
}								                                          
 
//=======================================================================================
//                                                                 [ run_256_bzip2 ]
//=======================================================================================
void run_256_bzip2 ()
{								                                          
  printf("***** 256.bzip2 - Begin *****\n");

  int     argc = 4;
  char ** argv;

  char  * execname        = "./bzip2";
  char  *_filename        = "/256.bzip2/data/test/input/input.random";
  char  * filename        = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_filename));
  strcpy(filename,SPECINT2000_PATH); strcat(filename,_filename);
  char  * input_size      = "1";
  char  * compressed_size = "1";

  // Create the arguments
  if ((argc < 1) || (argc > 4) )
    {
      printf("Usage : bzip2 [filename] [intput_size] [compressed_size]\n");
      return;
    }
  
  argv    = (char **)malloc (argc * sizeof(char *));
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));

  if (argc > 1)
    {
  argv[1] = (char *) malloc (strlen(filename       ));
  argv[1] = memcpy(argv[1],filename        ,strlen(filename       ));
    }
  
  if (argc > 2)
    {
  argv[2] = (char *) malloc (strlen(input_size     ));
  argv[2] = memcpy(argv[2],input_size      ,strlen(input_size     ));
    }

  if (argc > 3)
    {  
  argv[3] = (char *) malloc (strlen(compressed_size));
  argv[3] = memcpy(argv[3],compressed_size ,strlen(compressed_size));
    }
  
  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_256_bzip2 (argc,argv);

  free(filename);
  
  printf("***** 256.bzip2 - End   *****\n");
}

//=======================================================================================
//                                                                 [ run_300_twolf ]
//=======================================================================================
void run_300_twolf ()
{								                                          
  printf("***** 300.twolf - Begin *****\n");

  int     argc = 2;
  char ** argv;

  char  * execname        = "./twolf";
  char  *_circuitName        = "/300.twolf/data/test/input/test";
  char  * circuitName        = (char *) malloc(strlen(SPECINT2000_PATH)+strlen(_circuitName));
  strcpy(circuitName,SPECINT2000_PATH); strcat(circuitName,_circuitName);

  // Create the arguments
  if ((argc < 1) || (argc > 2) )
    {
      printf("Usage : twolf circuitName\n");
      return;
    }
  
  argv    = (char **)malloc (argc * sizeof(char *));
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));

  argv[1] = (char *) malloc (strlen(circuitName       ));
  argv[1] = memcpy(argv[1],circuitName     ,strlen(circuitName    ));
  
  // +-------------------+
  // | Run the benchmark |
  // +-------------------+
  main_300_twolf (2,argv);

  free(circuitName);
  
  printf("***** 300.twolf - End   *****\n");
}

/*
//=======================================================================================
//                                                                    [ run_dhry21 ]
//=======================================================================================
void run_dhry21 ()
{								                                          
  printf("***** dhry2.1 - Begin *****\n");

  int     argc = 2;
  char ** argv;

  char * execname        = "./dhry21";
  char * numberOfRuns    = "2000";

  // Create the arguments
  if (argc != 2)
    {
      printf("Usage : dhry21 numberOfRuns\n");
      return;
    }
    
  argv    = (char **)malloc (argc * sizeof(char *));
  
  argv[0] = (char *) malloc (strlen(execname       ));
  argv[0] = memcpy(argv[0],execname        ,strlen(execname       ));
  argv[1] = (char *) malloc (strlen(numberOfRuns   ));
  argv[1] = memcpy(argv[1],numberOfRuns    ,strlen(numberOfRuns   ));
  
  // Run the benchmark
  main_dhry21 (argc,argv);

  printf("***** dhry2.1 - End   *****\n");
}
*/
