#!/bin/sh

declare OS_FOUND=`uname -s`-`uname -m | sed -e 's/i[0-9]/iX/' -e 's/sun4./sun4X/'`

case ${OS_FOUND} in
#    "SunOS-sun4X")
#	export TARGET_ARCH=gccsparcOS5
#	export EXE_SUFFIX=
#	;;
    "Linux-iX86")
	export TARGET_ARCH=linux
	export EXE_SUFFIX=
	;;
#    "FreeBSD-iX86")
#	export TARGET_ARCH=freebsd
#	export EXE_SUFFIX=
#	;;
#    "CYGWIN_NT-5.1-iX86")
#	export TARGET_ARCH=cygwin
#	export EXE_SUFFIX=.exe
#    	;;	
    *) 
     echo "Unknown OS found"
esac

# Export environement
export MORPHEO_TOPLEVEL=${PWD}
export MORPHEO_SCRIPT=${MORPHEO_TOPLEVEL}/IPs/systemC/processor/Morpheo/Script
export MORPHEO_HOME=${HOME}/.Morpheo
export MORPHEO_TMP=/dsk/l1/misc/Morpheo
       MORPHEO_XTTY=${MORPHEO_TOPLEVEL}/IPs/systemC/Environment/TTY/xtty

echo ""
echo "OS found : ${OS_FOUND}"
echo ""
echo "Modification of environement's variable :"
echo " - MORPHEO_TOPLEVEL is set to ${MORPHEO_TOPLEVEL}"
echo " - MORPHEO_SCRIPT   is set to ${MORPHEO_SCRIPT}"
echo " - MORPHEO_HOME     is set to ${MORPHEO_HOME}"
echo " - MORPHEO_TMP      is set to ${MORPHEO_TMP}"

#----------
# Path : add xtty and script directory.
#        test if already in path : no multiple addition
#----------

echo ${PATH} |grep -q ${MORPHEO_SCRIPT};
if test $? -eq 1; then
    export  PATH=${PATH}:${MORPHEO_SCRIPT}
    echo " - PATH             add       ${MORPHEO_SCRIPT}"
fi;

echo ${PATH} |grep -q ${MORPHEO_XTTY};

if test $? -eq 1; then
    export  PATH=${PATH}:${MORPHEO_XTTY}
    echo " - PATH             add       ${MORPHEO_XTTY}"
fi;

echo ""
