/*
 * $Id: Parameters.cpp 118 2009-05-20 22:01:32Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {


#undef  FUNCTION
#define FUNCTION "Write_queue::Parameters"
  Parameters::Parameters (uint32_t              size_queue         ,
			  uint32_t              nb_context         ,
			  uint32_t              nb_front_end       ,
			  uint32_t              nb_ooo_engine      ,
			  uint32_t              nb_packet          ,
			  uint32_t              size_general_data  ,
			  uint32_t              nb_general_register,
			  uint32_t              size_special_data  ,
			  uint32_t              nb_special_register,
			  uint32_t              nb_bypass_write    ,
			  Twrite_queue_scheme_t queue_scheme       ,
			  bool                  is_toplevel        ):
    behavioural::Parameters ("Write_queue")
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

    _size_queue              = size_queue         ;
    _nb_context              = nb_context         ;
    _nb_front_end            = nb_front_end       ;
    _nb_ooo_engine           = nb_ooo_engine      ;
    _nb_packet               = nb_packet          ;
    _nb_general_register     = nb_general_register;
    _nb_special_register     = nb_special_register;
    _nb_bypass_write         = nb_bypass_write    ;
    _queue_scheme            = queue_scheme       ;
    _bypass_write_scheme     = BYPASS_WRITE_FROM_ALU;
//  _bypass_write_scheme     = BYPASS_WRITE_FROM_QUEUE;

    _nb_gpr_write            = 1;
    _nb_spr_write            = 1;

    test();

    if (is_toplevel)
      {
        _size_instruction_address= size_general_data-2;
        _size_context_id         = log2(_nb_context         );
        _size_front_end_id       = log2(_nb_front_end       );
        _size_ooo_engine_id      = log2(_nb_ooo_engine      );
        _size_rob_ptr            = log2(_nb_packet          );
        _size_general_register   = log2(_nb_general_register);
        _size_special_register   = log2(_nb_special_register);
        _size_general_data       = size_general_data  ;
        _size_special_data       = size_special_data  ;
        
        _have_port_context_id    = _size_context_id    > 0;
        _have_port_front_end_id  = _size_front_end_id  > 0;
        _have_port_ooo_engine_id = _size_ooo_engine_id > 0;
        _have_port_rob_ptr       = _size_rob_ptr       > 0;

        copy();
      }

    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Write_queue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param):
//     _size_queue              (param._size_queue             ),
//     _nb_context              (param._nb_context             ),
//     _nb_front_end            (param._nb_front_end           ),
//     _nb_ooo_engine           (param._nb_ooo_engine          ),
//     _nb_packet               (param._nb_packet              ),
//     _size_general_data       (param._size_general_data      ),
//     _nb_general_register     (param._nb_general_register    ),
//     _size_special_data       (param._size_special_data      ),
//     _nb_special_register     (param._nb_special_register    ),
//     _nb_bypass_write         (param._nb_bypass_write        ),

//     _nb_gpr_write            (param._nb_gpr_write           ),
//     _nb_spr_write            (param._nb_spr_write           ),

//     _size_context_id         (param._size_context_id        ),
//     _size_front_end_id       (param._size_front_end_id      ),
//     _size_ooo_engine_id      (param._size_ooo_engine_id     ),
//     _size_packet_id          (param._size_packet_id         ),
//     _size_general_register   (param._size_general_register  ),
//     _size_special_register   (param._size_special_register  ),

//     _have_port_context_id    (param._have_port_context_id   ),
//     _have_port_front_end_id  (param._have_port_front_end_id ),
//     _have_port_ooo_engine_id (param._have_port_ooo_engine_id),
//     _have_port_packet_id     (param._have_port_packet_id    )
//   {
//     log_printf(FUNC,Write_queue,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Write_queue,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Write_queue::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");
    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Write_queue::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Write_queue,FUNCTION,"Begin");

    _size_internal_queue = 
      ( _size_context_id          +  
        _size_front_end_id        +  
        _size_ooo_engine_id       +  
        _size_rob_ptr             + 
        1                         +
        _size_general_register    +
        _size_general_data        +
        1                         +
        _size_special_register    +
        _size_special_data        +
        _size_exception           +
        1                         +
        _size_instruction_address
       );

    log_printf(FUNC,Write_queue,FUNCTION,"End");
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
