/*
 * $Id: Functionnal_unit_allocation.cpp 118 2009-05-20 22:01:32Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {

#undef  FUNCTION
#define FUNCTION "Functionnal_unit::allocation"
  void Functionnal_unit::allocation (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Functionnal_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }
    // ~~~~~[ Interface : "execute_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    {
      ALLOC0_INTERFACE_BEGIN("execute_in",IN,WEST,"Input of Functionnal Unit");

      ALLOC0_VALACK_IN ( in_EXECUTE_IN_VAL                   ,VAL);
      ALLOC0_VALACK_OUT(out_EXECUTE_IN_ACK                   ,ACK);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_CONTEXT_ID            ,"context_id"           ,Tcontext_t        , _param->_size_context_id   );
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_FRONT_END_ID          ,"front_end_id"         ,Tcontext_t        , _param->_size_front_end_id );
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_OOO_ENGINE_ID         ,"ooo_engine_id"        ,Tcontext_t        , _param->_size_ooo_engine_id);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_PACKET_ID             ,"packet_id"            ,Tpacket_t         , _param->_size_rob_ptr    );
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_OPERATION             ,"operation"            ,Toperation_t      , _param->_size_operation    );
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_TYPE                  ,"type"                 ,Ttype_t           , _param->_size_type         );
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE ,"store_queue_ptr_write",Tlsq_ptr_t        ,_param->_size_store_queue_ptr);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_LOAD_QUEUE_PTR_WRITE  ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,_param->_size_load_queue_ptr);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_HAS_IMMEDIAT          ,"has_immediat"         ,Tcontrol_t        , 1);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_IMMEDIAT              ,"immediat"             ,Tgeneral_data_t   , _param->_size_general_data);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_DATA_RA               ,"data_ra"              ,Tgeneral_data_t   , _param->_size_general_data);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_DATA_RB               ,"data_rb"              ,Tgeneral_data_t   , _param->_size_general_data);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_DATA_RC               ,"data_rc"              ,Tspecial_data_t   , _param->_size_special_data);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_WRITE_RD              ,"write_rd"             ,Tcontrol_t        , 1);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_NUM_REG_RD            ,"num_reg_rd"           ,Tgeneral_address_t, _param->_size_general_register);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_WRITE_RE              ,"write_re"             ,Tcontrol_t        , 1);
      ALLOC0_SIGNAL_IN ( in_EXECUTE_IN_NUM_REG_RE            ,"num_reg_re"           ,Tspecial_address_t, _param->_size_special_register);

      ALLOC0_INTERFACE_END();
     }
    // ~~~~~[ Interface : "execute_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~     
     {
       ALLOC0_INTERFACE_BEGIN("execute_out",IN,EAST,"Output of Functionnal Unit");

       ALLOC0_VALACK_OUT(out_EXECUTE_OUT_VAL            ,VAL);
       ALLOC0_VALACK_IN ( in_EXECUTE_OUT_ACK            ,ACK);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_CONTEXT_ID     ,"context_id"   ,Tcontext_t        ,_param->_size_context_id   );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_FRONT_END_ID   ,"front_end_id" ,Tcontext_t        ,_param->_size_front_end_id );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_OOO_ENGINE_ID  ,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_PACKET_ID      ,"packet_id"    ,Tpacket_t         ,_param->_size_rob_ptr    );
     //ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_OPERATION      ,"operation"    ,Toperation_t      ,_param->_size_operation    );
     //ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_TYPE           ,"type"         ,Ttype_t           ,_param->_size_type         );
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_WRITE_RD       ,"write_rd"     ,Tcontrol_t        ,1);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_NUM_REG_RD     ,"num_reg_rd"   ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_DATA_RD        ,"data_rd"      ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_WRITE_RE       ,"write_re"     ,Tcontrol_t        ,1);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_NUM_REG_RE     ,"num_reg_re"   ,Tspecial_address_t,_param->_size_special_register);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_DATA_RE        ,"data_re"      ,Tspecial_data_t   ,_param->_size_special_data);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_EXCEPTION      ,"exception"    ,Texception_t      ,_param->_size_exception);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_NO_SEQUENCE    ,"no_sequence"  ,Tcontrol_t        ,1);
       ALLOC0_SIGNAL_OUT(out_EXECUTE_OUT_ADDRESS        ,"address"      ,Taddress_t        ,_param->_size_instruction_address);

       ALLOC0_INTERFACE_END();
     }

     // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     if (usage_is_set(_usage,USE_SYSTEMC))
       {
     if (_param->_have_pipeline_in)
     _execute_operation_in  = new execute_operation_t;
     _execute_operation_out = new execute_operation_t;
     _execute_param         = new execute_param_t(_param->_size_general_data,
						  _param->_timing);

     _execute_register = new execute_register_t *** [_param->_nb_context];

     for (uint32_t i=0; i<_param->_nb_context; i++)
       {
	 _execute_register [i] = new execute_register_t ** [_param->_nb_front_end];
	 
	 for (uint32_t j=0; j<_param->_nb_front_end; j++)
	   {
	     _execute_register [i][j] = new execute_register_t * [_param->_nb_ooo_engine];
	     
	     for (uint32_t k=0; k<_param->_nb_ooo_engine; k++)
	       {
// 		 uint32_t num_thread = get_num_thread(i,_param->_size_context_id,
// 						      j,_param->_size_front_end_id,
// 						      k,_param->_size_ooo_engine_id);

		 _execute_register [i][j][k] = new execute_register_t;
		 
		 if (_param->_have_groupe_MAC)
		   _execute_register[i][j][k]->implement_group(GROUP_MAC);

		 for (uint32_t x=GROUP_CUSTOM_1; x<GROUP_CUSTOM_8; x++)
		   if ((_param->_get_custom_information())._get_valid_group(x) == true)
		     {
		       uint32_t nb_reg = (_param->_get_custom_information())._get_nb_register(x);
		       _execute_register[i][j][k]->implement_group(x,nb_reg);

		       for (uint32_t y=0; y<nb_reg; y++)
			 _execute_register[i][j][k]->_spr_access_mode->change_mode(x,y,(_param->_get_custom_information())._get_access_mode(x,y));
		     }
	       }
	   }
       }

     _function_execute = new function_execute_t ** [_param->_nb_type];
     
     // Initialisation
     for (uint32_t i=0; i<_param->_nb_type; i++)
       {
	 _function_execute [i] = new function_execute_t * [_param->_nb_operation];
	 
	 for (uint32_t j=0; j<_param->_nb_operation; j++)
	   _function_execute [i][j] = &(operation_unimplemented);
       }

     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_ADD         ]._latence > 0)
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_ADD         ] = &(operation_l_add     );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_ADDC        ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_ADDC        ] = &(operation_l_addc    );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_SUB         ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_SUB         ] = &(operation_l_sub     );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_AND         ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_AND         ] = &(operation_l_and     );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_OR          ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_OR          ] = &(operation_l_or      );
     if (_param->_timing[TYPE_ALU    ][OPERATION_ALU_L_XOR         ]._latence > 0) 
       _function_execute[TYPE_ALU    ][OPERATION_ALU_L_XOR         ] = &(operation_l_xor     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_SLL       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_SLL       ] = &(operation_l_sll     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRA       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRA       ] = &(operation_l_sra     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRL       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_SRL       ] = &(operation_l_srl     );
     if (_param->_timing[TYPE_SHIFT  ][OPERATION_SHIFT_L_ROR       ]._latence > 0) 
       _function_execute[TYPE_SHIFT  ][OPERATION_SHIFT_L_ROR       ] = &(operation_l_ror     );
     if (_param->_timing[TYPE_MOVE   ][OPERATION_MOVE_L_MOVHI      ]._latence > 0) 
       _function_execute[TYPE_MOVE   ][OPERATION_MOVE_L_MOVHI      ] = &(operation_l_movhi   );
     if (_param->_timing[TYPE_MOVE   ][OPERATION_MOVE_L_CMOV       ]._latence > 0) 
       _function_execute[TYPE_MOVE   ][OPERATION_MOVE_L_CMOV       ] = &(operation_l_cmov    ); 
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGEU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGEU      ] = &(operation_l_sfgeu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGTU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGTU      ] = &(operation_l_sfgtu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLEU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLEU      ] = &(operation_l_sfleu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLTU      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLTU      ] = &(operation_l_sfltu   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGES      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGES      ] = &(operation_l_sfges   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFGTS      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFGTS      ] = &(operation_l_sfgts   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLES      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLES      ] = &(operation_l_sfles   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFLTS      ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFLTS      ] = &(operation_l_sflts   );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFEQ       ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFEQ       ] = &(operation_l_sfeq    );
     if (_param->_timing[TYPE_TEST   ][OPERATION_TEST_L_SFNE       ]._latence > 0) 
       _function_execute[TYPE_TEST   ][OPERATION_TEST_L_SFNE       ] = &(operation_l_sfne    );
     if (_param->_timing[TYPE_MUL    ][OPERATION_MUL_L_MUL         ]._latence > 0) 
       _function_execute[TYPE_MUL    ][OPERATION_MUL_L_MUL         ] = &(operation_l_mul     );
     if (_param->_timing[TYPE_MUL    ][OPERATION_MUL_L_MULU        ]._latence > 0) 
       _function_execute[TYPE_MUL    ][OPERATION_MUL_L_MULU        ] = &(operation_l_mulu    );
     if (_param->_timing[TYPE_DIV    ][OPERATION_DIV_L_DIV         ]._latence > 0) 
       _function_execute[TYPE_DIV    ][OPERATION_DIV_L_DIV         ] = &(operation_l_div     );
     if (_param->_timing[TYPE_DIV    ][OPERATION_DIV_L_DIVU        ]._latence > 0) 
       _function_execute[TYPE_DIV    ][OPERATION_DIV_L_DIVU        ] = &(operation_l_divu    );
     if (_param->_timing[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_S ]._latence > 0) 
       _function_execute[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_S ] = &(operation_l_extend_s);
     if (_param->_timing[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_Z ]._latence > 0) 
       _function_execute[TYPE_EXTEND ][OPERATION_EXTEND_L_EXTEND_Z ] = &(operation_l_extend_z);
     if (_param->_timing[TYPE_FIND   ][OPERATION_FIND_L_FF1        ]._latence > 0) 
       _function_execute[TYPE_FIND   ][OPERATION_FIND_L_FF1        ] = &(operation_l_ff1     ); 
     if (_param->_timing[TYPE_FIND   ][OPERATION_FIND_L_FL1        ]._latence > 0) 
       _function_execute[TYPE_FIND   ][OPERATION_FIND_L_FL1        ] = &(operation_l_fl1     ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MFSPR   ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MFSPR   ] = &(operation_l_mfspr   ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MTSPR   ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MTSPR   ] = &(operation_l_mtspr   ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MAC     ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MAC     ] = &(operation_l_mac     ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MACRC   ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MACRC   ] = &(operation_l_macrc   ); 
     if (_param->_timing[TYPE_SPECIAL][OPERATION_SPECIAL_L_MSB     ]._latence > 0) 
       _function_execute[TYPE_SPECIAL][OPERATION_SPECIAL_L_MSB     ] = &(operation_l_msb     ); 
     if (_param->_timing[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_F   ]._latence > 0) 
       _function_execute[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_F   ] = &(operation_l_test_f  );
     if (_param->_timing[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_NF  ]._latence > 0) 
       _function_execute[TYPE_BRANCH ][OPERATION_BRANCH_L_TEST_NF  ] = &(operation_l_test_nf );
     if (_param->_timing[TYPE_BRANCH ][OPERATION_BRANCH_L_JALR     ]._latence > 0) 
       _function_execute[TYPE_BRANCH ][OPERATION_BRANCH_L_JALR     ] = &(operation_l_jalr    );
       }

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
