#ifndef morpheo_behavioural_core_core_glue_Core_Glue_h
#define morpheo_behavioural_core_core_glue_Core_Glue_h

/*
 * $Id: Core_Glue.h 118 2009-05-20 22:01:32Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif


#include "Behavioural/Core/Core_Glue/include/Parameters.h"
#include "Behavioural/Core/Core_Glue/include/Types.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

#include "Behavioural/Generic/Priority/include/Priority.h"


namespace morpheo {
namespace behavioural {

namespace core {
namespace core_glue {


  class Core_Glue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_OUT(Tcontext_t        )  *** out_RENAME_FRONT_END_ID                       ;//[nb_front_end][nb_inst_decod]

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~         
  public    : SC_OUT(Tcontrol_t        )  *** out_BRANCH_COMPLETE_FRONT_END_VAL             ;//[nb_front_end][nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t        )  ***  in_BRANCH_COMPLETE_FRONT_END_ACK             ;//[nb_front_end][nb_inst_branch_complete]
  public    : SC_OUT(Tcontext_t        )  *** out_BRANCH_COMPLETE_FRONT_END_CONTEXT_ID      ;//[nb_front_end][nb_inst_branch_complete]
  public    : SC_OUT(Tdepth_t          )  *** out_BRANCH_COMPLETE_FRONT_END_DEPTH           ;//[nb_front_end][nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t        )  *** out_BRANCH_COMPLETE_FRONT_END_ADDRESS         ;//[nb_front_end][nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t        )  *** out_BRANCH_COMPLETE_FRONT_END_NO_SEQUENCE     ;//[nb_front_end][nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t        )  ***  in_BRANCH_COMPLETE_FRONT_END_MISS_PREDICTION ;//[nb_front_end][nb_inst_branch_complete]

  public    : SC_IN (Tcontrol_t        )  ***  in_BRANCH_COMPLETE_OOO_ENGINE_VAL            ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t        )  *** out_BRANCH_COMPLETE_OOO_ENGINE_ACK            ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_IN (Tcontext_t        )  ***  in_BRANCH_COMPLETE_OOO_ENGINE_FRONT_END_ID   ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_IN (Tcontext_t        )  ***  in_BRANCH_COMPLETE_OOO_ENGINE_CONTEXT_ID     ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_IN (Tdepth_t          )  ***  in_BRANCH_COMPLETE_OOO_ENGINE_DEPTH          ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_IN (Taddress_t        )  ***  in_BRANCH_COMPLETE_OOO_ENGINE_ADDRESS        ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t        )  ***  in_BRANCH_COMPLETE_OOO_ENGINE_NO_SEQUENCE    ;//[nb_ooo_engine][nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t        )  *** out_BRANCH_COMPLETE_OOO_ENGINE_MISS_PREDICTION;//[nb_ooo_engine][nb_inst_branch_complete]
                                                                                   
    // ~~~~~[ Interface : "commit_event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_COMMIT_EVENT_FRONT_END_VAL                ;//[nb_front_end]
  public    : SC_IN (Tcontrol_t        )   **  in_COMMIT_EVENT_FRONT_END_ACK                ;//[nb_front_end]
  public    : SC_OUT(Tcontext_t        )   ** out_COMMIT_EVENT_FRONT_END_CONTEXT_ID         ;//[nb_front_end]
  public    : SC_OUT(Tdepth_t          )   ** out_COMMIT_EVENT_FRONT_END_DEPTH              ;//[nb_front_end]
  public    : SC_OUT(Tevent_type_t     )   ** out_COMMIT_EVENT_FRONT_END_TYPE               ;//[nb_front_end]
  public    : SC_OUT(Tcontrol_t        )   ** out_COMMIT_EVENT_FRONT_END_IS_DELAY_SLOT      ;//[nb_front_end]
  public    : SC_OUT(Taddress_t        )   ** out_COMMIT_EVENT_FRONT_END_ADDRESS            ;//[nb_front_end]
  public    : SC_OUT(Tcontrol_t        )   ** out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR_VAL   ;//[nb_front_end]
  public    : SC_OUT(Taddress_t        )   ** out_COMMIT_EVENT_FRONT_END_ADDRESS_EPCR       ;//[nb_front_end]
  public    : SC_OUT(Tcontrol_t        )   ** out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR_VAL   ;//[nb_front_end]
  public    : SC_OUT(Tgeneral_data_t   )   ** out_COMMIT_EVENT_FRONT_END_ADDRESS_EEAR       ;//[nb_front_end]

  public    : SC_IN (Tcontrol_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_VAL               ;//[nb_ooo_engine]
  public    : SC_OUT(Tcontrol_t        )   ** out_COMMIT_EVENT_OOO_ENGINE_ACK               ;//[nb_ooo_engine]
  public    : SC_IN (Tcontext_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_FRONT_END_ID      ;//[nb_ooo_engine]
  public    : SC_IN (Tcontext_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_CONTEXT_ID        ;//[nb_ooo_engine]
  public    : SC_IN (Tdepth_t          )   **  in_COMMIT_EVENT_OOO_ENGINE_DEPTH             ;//[nb_ooo_engine]
  public    : SC_IN (Tevent_type_t     )   **  in_COMMIT_EVENT_OOO_ENGINE_TYPE              ;//[nb_ooo_engine]
  public    : SC_IN (Tcontrol_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_IS_DELAY_SLOT     ;//[nb_ooo_engine]
  public    : SC_IN (Taddress_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS           ;//[nb_ooo_engine]
  public    : SC_IN (Tcontrol_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR_VAL  ;//[nb_ooo_engine]
  public    : SC_IN (Taddress_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EPCR      ;//[nb_ooo_engine]
  public    : SC_IN (Tcontrol_t        )   **  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR_VAL  ;//[nb_ooo_engine]
  public    : SC_IN (Tgeneral_data_t   )   **  in_COMMIT_EVENT_OOO_ENGINE_ADDRESS_EEAR      ;//[nb_ooo_engine]

    
    // ~~~~~[ Interface : "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_VAL                      ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_OOO_ENGINE_ACK                      ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontext_t        )  ***  in_ISSUE_OOO_ENGINE_FRONT_END_ID             ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontext_t        )  ***  in_ISSUE_OOO_ENGINE_CONTEXT_ID               ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tpacket_t         )  ***  in_ISSUE_OOO_ENGINE_PACKET_ID                ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Ttype_t           )  ***  in_ISSUE_OOO_ENGINE_TYPE                     ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Toperation_t      )  ***  in_ISSUE_OOO_ENGINE_OPERATION                ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tlsq_ptr_t        )  ***  in_ISSUE_OOO_ENGINE_STORE_QUEUE_PTR_WRITE    ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tlsq_ptr_t        )  ***  in_ISSUE_OOO_ENGINE_LOAD_QUEUE_PTR_WRITE     ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_HAS_IMMEDIAT             ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tgeneral_data_t   )  ***  in_ISSUE_OOO_ENGINE_IMMEDIAT                 ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_READ_RA                  ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tgeneral_address_t)  ***  in_ISSUE_OOO_ENGINE_NUM_REG_RA               ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_READ_RB                  ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tgeneral_address_t)  ***  in_ISSUE_OOO_ENGINE_NUM_REG_RB               ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_READ_RC                  ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tspecial_address_t)  ***  in_ISSUE_OOO_ENGINE_NUM_REG_RC               ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_WRITE_RD                 ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tgeneral_address_t)  ***  in_ISSUE_OOO_ENGINE_NUM_REG_RD               ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_OOO_ENGINE_WRITE_RE                 ;//[nb_ooo_engine][nb_inst_issue]
  public    : SC_IN (Tspecial_address_t)  ***  in_ISSUE_OOO_ENGINE_NUM_REG_RE               ;//[nb_ooo_engine][nb_inst_issue]

  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_VAL                    ;//[nb_execute_loop][nb_read_unit]
  public    : SC_IN (Tcontrol_t        )  ***  in_ISSUE_EXECUTE_LOOP_ACK                    ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontext_t        )  *** out_ISSUE_EXECUTE_LOOP_CONTEXT_ID             ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontext_t        )  *** out_ISSUE_EXECUTE_LOOP_FRONT_END_ID           ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontext_t        )  *** out_ISSUE_EXECUTE_LOOP_OOO_ENGINE_ID          ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tpacket_t         )  *** out_ISSUE_EXECUTE_LOOP_PACKET_ID              ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Toperation_t      )  *** out_ISSUE_EXECUTE_LOOP_OPERATION              ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Ttype_t           )  *** out_ISSUE_EXECUTE_LOOP_TYPE                   ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tlsq_ptr_t        )  *** out_ISSUE_EXECUTE_LOOP_STORE_QUEUE_PTR_WRITE  ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tlsq_ptr_t        )  *** out_ISSUE_EXECUTE_LOOP_LOAD_QUEUE_PTR_WRITE   ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_HAS_IMMEDIAT           ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tgeneral_data_t   )  *** out_ISSUE_EXECUTE_LOOP_IMMEDIAT               ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_READ_RA                ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tgeneral_address_t)  *** out_ISSUE_EXECUTE_LOOP_NUM_REG_RA             ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_READ_RB                ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tgeneral_address_t)  *** out_ISSUE_EXECUTE_LOOP_NUM_REG_RB             ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_READ_RC                ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tspecial_address_t)  *** out_ISSUE_EXECUTE_LOOP_NUM_REG_RC             ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_WRITE_RD               ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tgeneral_address_t)  *** out_ISSUE_EXECUTE_LOOP_NUM_REG_RD             ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_ISSUE_EXECUTE_LOOP_WRITE_RE               ;//[nb_execute_loop][nb_read_unit]
  public    : SC_OUT(Tspecial_address_t)  *** out_ISSUE_EXECUTE_LOOP_NUM_REG_RE             ;//[nb_execute_loop][nb_read_unit]


    // ~~~~~[ Interface "execute_loop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        ) **** out_EXECUTE_OOO_ENGINE_VAL                    ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_IN (Tcontrol_t        ) ****  in_EXECUTE_OOO_ENGINE_ACK                    ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tcontext_t        ) **** out_EXECUTE_OOO_ENGINE_FRONT_END_ID           ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tcontext_t        ) **** out_EXECUTE_OOO_ENGINE_CONTEXT_ID             ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tpacket_t         ) **** out_EXECUTE_OOO_ENGINE_PACKET_ID              ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
//public    : SC_OUT(Ttype_t           ) **** out_EXECUTE_OOO_ENGINE_TYPE                   ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
//public    : SC_OUT(Toperation_t      ) **** out_EXECUTE_OOO_ENGINE_OPERATION              ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tspecial_data_t   ) **** out_EXECUTE_OOO_ENGINE_FLAGS                  ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Texception_t      ) **** out_EXECUTE_OOO_ENGINE_EXCEPTION              ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tcontrol_t        ) **** out_EXECUTE_OOO_ENGINE_NO_SEQUENCE            ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Taddress_t        ) **** out_EXECUTE_OOO_ENGINE_ADDRESS                ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]
  public    : SC_OUT(Tgeneral_data_t   ) **** out_EXECUTE_OOO_ENGINE_DATA                   ;//[nb_ooo_engine][ooo_engine_nb_execute_loop][nb_inst_execute]

  public    : SC_IN (Tcontrol_t        )  ***  in_EXECUTE_EXECUTE_LOOP_VAL                  ;//[nb_execute_loop][nb_write_unit]
  public    : SC_OUT(Tcontrol_t        )  *** out_EXECUTE_EXECUTE_LOOP_ACK                  ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tcontext_t        )  ***  in_EXECUTE_EXECUTE_LOOP_CONTEXT_ID           ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tcontext_t        )  ***  in_EXECUTE_EXECUTE_LOOP_FRONT_END_ID         ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tcontext_t        )  ***  in_EXECUTE_EXECUTE_LOOP_OOO_ENGINE_ID        ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tpacket_t         )  ***  in_EXECUTE_EXECUTE_LOOP_PACKET_ID            ;//[nb_execute_loop][nb_write_unit]
//public    : SC_IN (Toperation_t      )  ***  in_EXECUTE_EXECUTE_LOOP_OPERATION            ;//[nb_execute_loop][nb_write_unit]
//public    : SC_IN (Ttype_t           )  ***  in_EXECUTE_EXECUTE_LOOP_TYPE                 ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tspecial_data_t   )  ***  in_EXECUTE_EXECUTE_LOOP_FLAGS                ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Texception_t      )  ***  in_EXECUTE_EXECUTE_LOOP_EXCEPTION            ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tcontrol_t        )  ***  in_EXECUTE_EXECUTE_LOOP_NO_SEQUENCE          ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Taddress_t        )  ***  in_EXECUTE_EXECUTE_LOOP_ADDRESS              ;//[nb_execute_loop][nb_write_unit]
  public    : SC_IN (Tgeneral_data_t   )  ***  in_EXECUTE_EXECUTE_LOOP_DATA                 ;//[nb_execute_loop][nb_write_unit]

    // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_OOO_ENGINE_VAL                     ;//[nb_ooo_engine][nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )  *** out_INSERT_OOO_ENGINE_ACK                     ;//[nb_ooo_engine][nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_OOO_ENGINE_RD_USE                  ;//[nb_ooo_engine][nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)  ***  in_INSERT_OOO_ENGINE_RD_NUM_REG              ;//[nb_ooo_engine][nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_OOO_ENGINE_RE_USE                  ;//[nb_ooo_engine][nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)  ***  in_INSERT_OOO_ENGINE_RE_NUM_REG              ;//[nb_ooo_engine][nb_inst_insert]

  public    : SC_OUT(Tcontrol_t        ) **** out_INSERT_EXECUTE_LOOP_VAL                   ;//[nb_execute_loop][execute_loop_nb_ooo_engine][execute_loop_nb_inst_insert]
  public    : SC_IN (Tcontrol_t        ) ****  in_INSERT_EXECUTE_LOOP_ACK                   ;//[nb_execute_loop][execute_loop_nb_ooo_engine][execute_loop_nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        ) **** out_INSERT_EXECUTE_LOOP_RD_USE                ;//[nb_execute_loop][execute_loop_nb_ooo_engine][execute_loop_nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t) **** out_INSERT_EXECUTE_LOOP_RD_NUM_REG            ;//[nb_execute_loop][execute_loop_nb_ooo_engine][execute_loop_nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        ) **** out_INSERT_EXECUTE_LOOP_RE_USE                ;//[nb_execute_loop][execute_loop_nb_ooo_engine][execute_loop_nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t) **** out_INSERT_EXECUTE_LOOP_RE_NUM_REG            ;//[nb_execute_loop][execute_loop_nb_ooo_engine][execute_loop_nb_inst_insert]


    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
//private   : generic::priority::Priority  ** _priority_ooo_engine;                         //[nb_execute_loop]
  private   : generic::priority::Priority   * _priority_ooo_engine;
  private   : generic::priority::Priority  ** _priority_read_unit ;                         //[nb_execute_loop]

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : uint32_t                        reg_PRIORITY ;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Core_Glue);
#endif
  public  :          Core_Glue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Core_Glue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
//public  : void        genMoore                  (void);
  public  : void        genMealy_branch_complete  (void);
  public  : void        genMealy_commit_event     (void);
  public  : void        genMealy_issue            (void);
  public  : void        genMealy_execute          (void);
  public  : void        genMealy_insert           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace core_glue
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
