/*
 * $Id: Stat_List_unit_allocation.cpp 118 2009-05-20 22:01:32Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Stat_List_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {



#undef  FUNCTION
#define FUNCTION "Stat_List_unit::allocation"
  void Stat_List_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Stat_List_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

     // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("insert",IN,SOUTH,_("Insert a renaming result"),_param->_nb_inst_insert);

       ALLOC1_VALACK_IN ( in_INSERT_VAL               ,VAL);
       ALLOC1_VALACK_OUT(out_INSERT_ACK               ,ACK);
       ALLOC1_SIGNAL_IN ( in_INSERT_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register);
  
       ALLOC1_INTERFACE_END(_param->_nb_inst_insert);
     }
  
     // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("retire",IN,NORTH,_("Retire a renaming result"),_param->_nb_inst_retire);
  
       ALLOC1_VALACK_IN ( in_RETIRE_VAL               ,VAL);
       ALLOC1_VALACK_OUT(out_RETIRE_ACK               ,ACK);
       ALLOC1_SIGNAL_IN ( in_RETIRE_RESTORE           ,"restore"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_RESTORE_RD_PHY_OLD,"restore_rd_phy_old",Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_RESTORE_RE_PHY_OLD,"restore_re_phy_old",Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register);

       ALLOC1_INTERFACE_END(_param->_nb_inst_retire);
     }

     // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("push_gpr",OUT,SOUTH,_("Free a general register"),_param->_nb_reg_free);

       ALLOC1_VALACK_OUT(out_PUSH_GPR_VAL    ,VAL);
       ALLOC1_VALACK_IN ( in_PUSH_GPR_ACK    ,ACK);
       ALLOC1_SIGNAL_OUT(out_PUSH_GPR_NUM_REG,"num_reg",Tgeneral_address_t,_param->_size_general_register);

       ALLOC1_INTERFACE_END(_param->_nb_reg_free);
     }

     // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("push_spr",OUT,SOUTH,_("Free a special register"),_param->_nb_reg_free);

       ALLOC1_VALACK_OUT(out_PUSH_SPR_VAL    ,VAL);
       ALLOC1_VALACK_IN ( in_PUSH_SPR_ACK    ,ACK);
       ALLOC1_SIGNAL_OUT(out_PUSH_SPR_NUM_REG,"num_reg",Tspecial_address_t,_param->_size_special_register);

       ALLOC1_INTERFACE_END(_param->_nb_reg_free);
     }

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
     ALLOC2(gpr_stat_list,stat_list_entry_t,_param->_nb_bank,_param->_nb_general_register_by_bank);
     ALLOC2(spr_stat_list,stat_list_entry_t,_param->_nb_bank,_param->_nb_special_register_by_bank);
     ALLOC1(internal_INSERT_ACK       ,Tcontrol_t,_param->_nb_inst_insert);
     ALLOC1(internal_RETIRE_ACK       ,Tcontrol_t,_param->_nb_inst_retire);
     ALLOC1(internal_PUSH_GPR_VAL     ,Tcontrol_t,_param->_nb_reg_free);
     ALLOC1(internal_PUSH_GPR_NUM_BANK,uint32_t  ,_param->_nb_reg_free);
     ALLOC1(internal_PUSH_GPR_NUM_REG ,uint32_t  ,_param->_nb_reg_free);
     ALLOC1(internal_PUSH_SPR_VAL     ,Tcontrol_t,_param->_nb_reg_free);
     ALLOC1(internal_PUSH_SPR_NUM_BANK,uint32_t  ,_param->_nb_reg_free);
     ALLOC1(internal_PUSH_SPR_NUM_REG ,uint32_t  ,_param->_nb_reg_free);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
